/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api.painter.highlight;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.util.Set;
import org.jvnet.substance.api.ColorSchemeSingleColorQuery;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.api.painter.FractionBasedPainter;
import org.jvnet.substance.painter.highlight.SubstanceHighlightPainter;
import org.jvnet.substance.utils.SubstanceColorUtilities;

public class FractionBasedHighlightPainter
extends FractionBasedPainter
implements SubstanceHighlightPainter {
    public FractionBasedHighlightPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries) {
        super(displayName, fractions, colorQueries);
    }

    @Override
    public void paintHighlight(Graphics2D graphics, Component comp, int width, int height, Set<SubstanceConstants.Side> openSides, SubstanceColorScheme colorScheme1, SubstanceColorScheme colorScheme2, float cyclePos) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        double cycleCoef = 1.0 - (double)cyclePos;
        Color[] fillColors = new Color[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            ColorSchemeSingleColorQuery colorQuery = this.colorQueries[i];
            Color color1 = colorQuery.query(colorScheme1);
            Color color2 = colorQuery.query(colorScheme2);
            fillColors[i] = SubstanceColorUtilities.getInterpolatedColor(color1, color2, cycleCoef);
        }
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, this.fractions, fillColors, MultipleGradientPaint.CycleMethod.REPEAT);
        g2d.setPaint(gradient);
        g2d.fillRect(0, 0, width, height);
        g2d.dispose();
    }
}

