/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.api.painter.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import org.jvnet.substance.api.ColorSchemeSingleColorQuery;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.api.painter.FractionBasedPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.decoration.SubstanceDecorationPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class FractionBasedDecorationPainter
extends FractionBasedPainter
implements SubstanceDecorationPainter {
    public FractionBasedDecorationPainter(String displayName, float[] fractions, ColorSchemeSingleColorQuery[] colorQueries) {
        super(displayName, fractions, colorQueries);
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics, Component comp, DecorationAreaType decorationAreaType, int width, int height, SubstanceSkin skin) {
        switch (decorationAreaType) {
            case PRIMARY_TITLE_PANE: 
            case SECONDARY_TITLE_PANE: {
                this.paintTitleBackground(graphics, comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
                break;
            }
            default: {
                this.paintExtraBackground(graphics, SubstanceCoreUtilities.getHeaderParent(comp), comp, width, height, skin.getBackgroundColorScheme(decorationAreaType));
            }
        }
    }

    private void paintTitleBackground(Graphics2D graphics, Component comp, int width, int height, SubstanceColorScheme scheme) {
        Graphics2D g2d = (Graphics2D)graphics.create();
        Color[] fillColors = new Color[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            ColorSchemeSingleColorQuery colorQuery = this.colorQueries[i];
            fillColors[i] = colorQuery.query(scheme);
        }
        LinearGradientPaint gradient = new LinearGradientPaint(0.0f, 0.0f, 0.0f, height, this.fractions, fillColors, MultipleGradientPaint.CycleMethod.REPEAT);
        g2d.setPaint(gradient);
        g2d.fillRect(0, 0, width, height);
        g2d.dispose();
    }

    private void paintExtraBackground(Graphics2D graphics, Container parent, Component comp, int width, int height, SubstanceColorScheme scheme) {
        graphics.setColor(scheme.getMidColor());
        graphics.fillRect(0, 0, width, height);
    }
}

