/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicTextPaneUI;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTextUtilities;

public class SubstanceTextPaneUI
extends BasicTextPaneUI {
    protected FadeStateListener substanceFadeStateListener;
    protected JTextPane textPane;
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceTextPaneUI(comp);
    }

    public SubstanceTextPaneUI(JComponent c) {
        this.textPane = (JTextPane)c;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.textPane, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int caretPos = SubstanceTextPaneUI.this.textPane.getCaretPosition();
                            SubstanceTextPaneUI.this.textPane.updateUI();
                            SubstanceTextPaneUI.this.textPane.setCaretPosition(caretPos);
                        }
                    });
                }
            }
        };
        this.textPane.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.textPane.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        Color foregr;
        super.installDefaults();
        Border b = this.textPane.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new EmptyBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.textPane))), new BasicBorders.MarginBorder());
            this.textPane.setBorder(newB);
        }
        if ((foregr = this.textPane.getForeground()) == null || foregr instanceof UIResource) {
            this.textPane.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(this.textPane).getMainDefaultColorScheme()));
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        SubstanceTextUtilities.paintTextCompBackground(g, this.textPane);
    }
}

