/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EnumSet;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.api.ColorSchemeAssociationKind;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.painter.border.SimplisticSoftBorderPainter;
import org.jvnet.substance.painter.border.SubstanceBorderPainter;
import org.jvnet.substance.painter.gradient.SimplisticGradientPainter;
import org.jvnet.substance.painter.gradient.SubstanceGradientPainter;
import org.jvnet.substance.painter.utils.BackgroundPaintingUtils;
import org.jvnet.substance.shaper.ClassicButtonShaper;
import org.jvnet.substance.shaper.SubstanceButtonShaper;
import org.jvnet.substance.utils.CompositeButtonModel;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceImageCreator;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.Trackable;
import org.jvnet.substance.utils.icon.ArrowButtonTransitionAwareIcon;
import org.jvnet.substance.utils.scroll.SubstanceScrollButton;

public class SubstanceScrollBarUI
extends BasicScrollBarUI
implements Trackable {
    protected JButton mySecondDecreaseButton;
    protected JButton mySecondIncreaseButton;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private static LazyResettableHashMap<BufferedImage> thumbVerticalMap = new LazyResettableHashMap("SubstanceScrollBarUI.thumbVertical");
    private static LazyResettableHashMap<BufferedImage> thumbHorizontalMap = new LazyResettableHashMap("SubstanceScrollBarUI.thumbHorizontal");
    private static LazyResettableHashMap<BufferedImage> trackFullVerticalMap = new LazyResettableHashMap("SubstanceScrollBarUI.trackFullVertical");
    private static LazyResettableHashMap<BufferedImage> trackFullHorizontalMap = new LazyResettableHashMap("SubstanceScrollBarUI.trackFullHorizontal");
    private MouseListener substanceMouseListener;
    private RolloverControlListener substanceThumbRolloverListener;
    protected FadeStateListener substanceFadeStateListener;
    private PropertyChangeListener substancePropertyListener;
    protected int scrollBarWidth;
    private static LazyResettableHashMap<BufferedImage> trackHorizontalMap = new LazyResettableHashMap("SubstanceScrollBarUI.trackHorizontal");
    private static LazyResettableHashMap<BufferedImage> trackVerticalMap = new LazyResettableHashMap("SubstanceScrollBarUI.trackVertical");
    protected AdjustmentListener substanceAdjustmentListener;
    protected CompositeButtonModel compositeScrollTrackModel;
    protected CompositeButtonModel compositeButtonsModel;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceScrollBarUI(comp);
    }

    protected SubstanceScrollBarUI(JComponent b) {
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        b.setOpaque(false);
    }

    protected JButton createGeneralDecreaseButton(int orientation, boolean isRegular) {
        SubstanceScrollButton result = new SubstanceScrollButton(orientation);
        result.setFont(this.scrollbar.getFont());
        ArrowButtonTransitionAwareIcon icon = new ArrowButtonTransitionAwareIcon(result, orientation);
        result.setIcon(icon);
        result.setFont(this.scrollbar.getFont());
        result.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        EnumSet<SubstanceConstants.Side> openSides = EnumSet.noneOf(SubstanceConstants.Side.class);
        EnumSet<SubstanceConstants.Side> straightSides = EnumSet.noneOf(SubstanceConstants.Side.class);
        switch (orientation) {
            case 1: {
                openSides.add(SubstanceConstants.Side.BOTTOM);
                if (!isRegular) {
                    openSides.add(SubstanceConstants.Side.TOP);
                }
                if (!isRegular) break;
                straightSides.add(SubstanceConstants.Side.TOP);
                break;
            }
            case 3: {
                openSides.add(SubstanceConstants.Side.LEFT);
                if (!isRegular) {
                    openSides.add(SubstanceConstants.Side.RIGHT);
                }
                if (!isRegular) break;
                straightSides.add(SubstanceConstants.Side.RIGHT);
                break;
            }
            case 7: {
                openSides.add(SubstanceConstants.Side.RIGHT);
                if (!isRegular) {
                    openSides.add(SubstanceConstants.Side.LEFT);
                }
                if (!isRegular) break;
                straightSides.add(SubstanceConstants.Side.LEFT);
            }
        }
        result.putClientProperty("substancelaf.buttonopenSide", openSides);
        result.putClientProperty("substancelaf.buttonside", straightSides);
        return result;
    }

    @Override
    protected JButton createDecreaseButton(int orientation) {
        return this.createGeneralDecreaseButton(orientation, true);
    }

    @Override
    protected JButton createIncreaseButton(int orientation) {
        return this.createGeneralIncreaseButton(orientation, true);
    }

    protected JButton createGeneralIncreaseButton(int orientation, boolean isRegular) {
        SubstanceScrollButton result = new SubstanceScrollButton(orientation);
        result.setFont(this.scrollbar.getFont());
        ArrowButtonTransitionAwareIcon icon = new ArrowButtonTransitionAwareIcon(result, orientation);
        result.setIcon(icon);
        result.setFont(this.scrollbar.getFont());
        result.setPreferredSize(new Dimension(this.scrollBarWidth, this.scrollBarWidth));
        EnumSet<SubstanceConstants.Side> openSides = EnumSet.noneOf(SubstanceConstants.Side.class);
        EnumSet<SubstanceConstants.Side> straightSides = EnumSet.noneOf(SubstanceConstants.Side.class);
        switch (orientation) {
            case 5: {
                openSides.add(SubstanceConstants.Side.TOP);
                if (!isRegular) {
                    openSides.add(SubstanceConstants.Side.BOTTOM);
                }
                if (!isRegular) break;
                straightSides.add(SubstanceConstants.Side.BOTTOM);
                break;
            }
            case 3: {
                openSides.add(SubstanceConstants.Side.LEFT);
                if (!isRegular) {
                    openSides.add(SubstanceConstants.Side.RIGHT);
                }
                if (!isRegular) break;
                straightSides.add(SubstanceConstants.Side.RIGHT);
                break;
            }
            case 7: {
                openSides.add(SubstanceConstants.Side.RIGHT);
                if (!isRegular) {
                    openSides.add(SubstanceConstants.Side.LEFT);
                }
                if (!isRegular) break;
                straightSides.add(SubstanceConstants.Side.LEFT);
            }
        }
        result.putClientProperty("substancelaf.buttonopenSide", openSides);
        result.putClientProperty("substancelaf.buttonside", straightSides);
        return result;
    }

    private BufferedImage getTrackHorizontal(Rectangle trackBounds, SubstanceScrollButton leftActiveButton, SubstanceScrollButton rightActiveButton) {
        int width = Math.max(1, trackBounds.width);
        int height = Math.max(1, trackBounds.height);
        ComponentState compLeftState = this.getState(leftActiveButton);
        ComponentState compRightState = this.getState(rightActiveButton);
        Component tracked = SubstanceFadeUtilities.getTracked(FadeKind.ROLLOVER, this.scrollbar, this.decrButton, this.incrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
        if (tracked != null) {
            ComponentState state = tracked == this.scrollbar ? ComponentState.getState(this.thumbModel, null) : ComponentState.getState(((AbstractButton)tracked).getModel(), null);
            float cyclePos = state.getCyclePosition();
            FadeState highest = SubstanceFadeUtilities.getFadeStateWithHighestFadeCycle(FadeKind.ROLLOVER, this.scrollbar, this.decrButton, this.incrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
            if (highest != null) {
                cyclePos = highest.getFadePosition();
                if (!highest.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
            }
            SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(this.scrollbar);
            HashMapKey key = SubstanceCoreUtilities.getHashKey(Float.valueOf(cyclePos), width, height, leftActiveButton == null ? "null" : ComponentState.getState(leftActiveButton.getModel(), leftActiveButton).name(), leftActiveButton == null ? "null" : SubstanceCoreUtilities.getPrevComponentState(leftActiveButton).name(), rightActiveButton == null ? "null" : ComponentState.getState(rightActiveButton.getModel(), rightActiveButton).name(), rightActiveButton == null ? "null" : SubstanceCoreUtilities.getPrevComponentState(rightActiveButton).name(), compLeftState == null ? "null" : compLeftState.name(), compRightState == null ? "null" : compRightState.name(), compLeftState == null ? "null" : SubstanceColorSchemeUtilities.getColorScheme(leftActiveButton, compLeftState).getDisplayName(), compRightState == null ? "null" : SubstanceColorSchemeUtilities.getColorScheme(rightActiveButton, compRightState).getDisplayName(), SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ComponentState.DEFAULT).getDisplayName(), shaper.getDisplayName(), Float.valueOf(SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.scrollbar))));
            if (trackFullHorizontalMap.containsKey(key)) {
                return trackFullHorizontalMap.get(key);
            }
            BufferedImage imageBack = SubstanceScrollBarUI.getTrackBackHorizontal(this.scrollbar, leftActiveButton, rightActiveButton, width, height);
            Graphics2D backGraphics = imageBack.createGraphics();
            BufferedImage imageDefault = SubstanceScrollBarUI.getTrackHorizontal(this.scrollbar, compLeftState, compRightState, width, height);
            backGraphics.drawImage((Image)imageDefault, 0, 0, null);
            BufferedImage imageActive = SubstanceScrollBarUI.getTrackHorizontal(this.scrollbar, compLeftState, compRightState, width, height);
            backGraphics.setComposite(AlphaComposite.SrcOver.derive(cyclePos));
            backGraphics.drawImage((Image)imageActive, 0, 0, null);
            trackFullHorizontalMap.put(key, imageBack);
            return imageBack;
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(this.scrollbar);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, compLeftState == null ? "null" : ComponentState.getState(leftActiveButton.getModel(), leftActiveButton).name(), compLeftState == null ? "null" : SubstanceCoreUtilities.getPrevComponentState(leftActiveButton).name(), compRightState == null ? "null" : ComponentState.getState(rightActiveButton.getModel(), rightActiveButton).name(), compRightState == null ? "null" : SubstanceCoreUtilities.getPrevComponentState(rightActiveButton).name(), compLeftState == null ? "null" : compLeftState.name(), compRightState == null ? "null" : compRightState.name(), compLeftState == null ? "null" : SubstanceColorSchemeUtilities.getColorScheme(leftActiveButton, compLeftState).getDisplayName(), compRightState == null ? "null" : SubstanceColorSchemeUtilities.getColorScheme(rightActiveButton, compRightState).getDisplayName(), SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ComponentState.DEFAULT).getDisplayName(), shaper.getDisplayName(), Float.valueOf(SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.scrollbar))));
        if (trackFullHorizontalMap.containsKey(key)) {
            return trackFullHorizontalMap.get(key);
        }
        BufferedImage trackBack = SubstanceScrollBarUI.getTrackBackHorizontal(this.scrollbar, leftActiveButton, rightActiveButton, width, height);
        Graphics2D backGraphics = trackBack.createGraphics();
        BufferedImage scrollTrackImage = SubstanceScrollBarUI.getTrackHorizontal(this.scrollbar, compLeftState, compRightState, width, height);
        backGraphics.drawImage((Image)scrollTrackImage, 0, 0, null);
        backGraphics.dispose();
        trackFullHorizontalMap.put(key, trackBack);
        return trackBack;
    }

    private static BufferedImage getTrackHorizontal(JScrollBar scrollBar, ComponentState compLeftState, ComponentState compRightState, int width, int height) {
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(scrollBar);
        SubstanceColorScheme mainScheme = SubstanceColorSchemeUtilities.getColorScheme(scrollBar, scrollBar.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme mainBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(scrollBar, ColorSchemeAssociationKind.BORDER, scrollBar.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(mainScheme.getDisplayName(), mainBorderScheme.getDisplayName(), width, height, compLeftState == null ? "null" : compLeftState.name(), compRightState == null ? "null" : compRightState.name(), shaper.getDisplayName());
        float radius = height / 2;
        if (shaper instanceof ClassicButtonShaper) {
            radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(scrollBar));
        }
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(scrollBar)) / 2.0);
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, null, borderDelta);
        BufferedImage result = trackHorizontalMap.get(key);
        if (result == null) {
            result = SubstanceCoreUtilities.getBlankImage(width, height);
            SimplisticGradientPainter.INSTANCE.paintContourBackground(result.createGraphics(), scrollBar, width, height, contour, false, mainScheme, mainScheme, 0.0f, true, false);
            SimplisticSoftBorderPainter borderPainter = new SimplisticSoftBorderPainter();
            borderPainter.paintBorder(result.getGraphics(), scrollBar, width, height, contour, null, mainBorderScheme, mainBorderScheme, 0.0f, false);
            trackHorizontalMap.put(key, result);
        }
        return result;
    }

    private static BufferedImage getTrackBackHorizontal(JScrollBar scrollBar, AbstractButton leftActiveButton, AbstractButton rightActiveButton, int width, int height) {
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(scrollBar);
        int radius = height / 2;
        if (shaper instanceof ClassicButtonShaper) {
            radius = 2;
        }
        BufferedImage opaque = SubstanceImageCreator.getCompositeRoundedBackground(scrollBar, width, height, radius, leftActiveButton, rightActiveButton, false);
        return opaque;
    }

    private BufferedImage getTrackVertical(Rectangle trackBounds, SubstanceScrollButton topActiveButton, SubstanceScrollButton bottomActiveButton) {
        int width = Math.max(1, trackBounds.width);
        int height = Math.max(1, trackBounds.height);
        ComponentState compTopState = this.getState(topActiveButton);
        ComponentState compBottomState = this.getState(bottomActiveButton);
        Component tracked = SubstanceFadeUtilities.getTracked(FadeKind.ROLLOVER, this.scrollbar, this.decrButton, this.incrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
        if (tracked != null) {
            ComponentState state = tracked == this.scrollbar ? ComponentState.getState(this.thumbModel, null) : ComponentState.getState(((AbstractButton)tracked).getModel(), null);
            float cyclePos = state.getCyclePosition();
            FadeState highest = SubstanceFadeUtilities.getFadeStateWithHighestFadeCycle(FadeKind.ROLLOVER, this.scrollbar, this.decrButton, this.incrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
            if (highest != null) {
                cyclePos = highest.getFadePosition();
                if (!highest.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
            }
            SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(this.scrollbar);
            HashMapKey key = SubstanceCoreUtilities.getHashKey(Float.valueOf(cyclePos), width, height, topActiveButton == null ? "null" : ComponentState.getState(topActiveButton.getModel(), topActiveButton).name(), topActiveButton == null ? "null" : SubstanceCoreUtilities.getPrevComponentState(topActiveButton).name(), bottomActiveButton == null ? "null" : ComponentState.getState(bottomActiveButton.getModel(), bottomActiveButton).name(), bottomActiveButton == null ? "null" : SubstanceCoreUtilities.getPrevComponentState(bottomActiveButton).name(), compTopState == null ? "null" : compTopState.name(), compBottomState == null ? "null" : compBottomState.name(), compBottomState == null ? "null" : SubstanceColorSchemeUtilities.getColorScheme(bottomActiveButton, compBottomState).getDisplayName(), compTopState == null ? "null" : SubstanceColorSchemeUtilities.getColorScheme(topActiveButton, compTopState).getDisplayName(), SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ComponentState.DEFAULT).getDisplayName(), shaper.getDisplayName(), Float.valueOf(SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.scrollbar))));
            if (trackFullVerticalMap.containsKey(key)) {
                return trackFullVerticalMap.get(key);
            }
            BufferedImage imageBack = SubstanceScrollBarUI.getTrackBackVertical(this.scrollbar, topActiveButton, bottomActiveButton, width, height);
            Graphics2D backGraphics = imageBack.createGraphics();
            BufferedImage imageDefault = SubstanceScrollBarUI.getTrackVertical(this.scrollbar, compTopState, compBottomState, width, height);
            backGraphics.drawImage((Image)imageDefault, 0, 0, null);
            BufferedImage imageActive = SubstanceScrollBarUI.getTrackVertical(this.scrollbar, compTopState, compBottomState, width, height);
            backGraphics.setComposite(AlphaComposite.SrcOver.derive(cyclePos));
            backGraphics.drawImage((Image)imageActive, 0, 0, null);
            trackFullVerticalMap.put(key, imageBack);
            return imageBack;
        }
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(this.scrollbar);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, compTopState == null ? "null" : ComponentState.getState(topActiveButton.getModel(), topActiveButton).name(), compTopState == null ? "null" : SubstanceCoreUtilities.getPrevComponentState(topActiveButton).name(), compBottomState == null ? "null" : ComponentState.getState(bottomActiveButton.getModel(), bottomActiveButton).name(), compBottomState == null ? "null" : SubstanceCoreUtilities.getPrevComponentState(bottomActiveButton).name(), compTopState == null ? "null" : compTopState.name(), compBottomState == null ? "null" : compBottomState.name(), compBottomState == null ? "null" : SubstanceColorSchemeUtilities.getColorScheme(bottomActiveButton, compBottomState).getDisplayName(), compTopState == null ? "null" : SubstanceColorSchemeUtilities.getColorScheme(topActiveButton, compTopState).getDisplayName(), SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ComponentState.DEFAULT).getDisplayName(), shaper.getDisplayName(), Float.valueOf(SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(this.scrollbar))));
        if (trackFullVerticalMap.containsKey(key)) {
            return trackFullVerticalMap.get(key);
        }
        BufferedImage trackBack = SubstanceScrollBarUI.getTrackBackVertical(this.scrollbar, topActiveButton, bottomActiveButton, width, height);
        Graphics2D backGraphics = trackBack.createGraphics();
        BufferedImage scrollTrackImage = SubstanceScrollBarUI.getTrackVertical(this.scrollbar, compTopState, compBottomState, width, height);
        backGraphics.drawImage((Image)scrollTrackImage, 0, 0, null);
        backGraphics.dispose();
        trackFullVerticalMap.put(key, trackBack);
        return trackBack;
    }

    private static BufferedImage getTrackVertical(JScrollBar scrollBar, ComponentState compTopState, ComponentState compBottomState, int width, int height) {
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(scrollBar);
        SubstanceColorScheme mainScheme = SubstanceColorSchemeUtilities.getColorScheme(scrollBar, scrollBar.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme mainBorderScheme = SubstanceColorSchemeUtilities.getColorScheme(scrollBar, ColorSchemeAssociationKind.BORDER, scrollBar.isEnabled() ? ComponentState.DEFAULT : ComponentState.DISABLED_UNSELECTED);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(mainScheme.getDisplayName(), mainBorderScheme.getDisplayName(), width, height, compTopState == null ? "null" : compTopState.name(), compBottomState == null ? "null" : compBottomState.name(), shaper.getDisplayName());
        BufferedImage result = trackVerticalMap.get(key);
        if (result == null) {
            float radius = width / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(scrollBar));
            }
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(scrollBar)) / 2.0);
            GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(height, width, radius, null, borderDelta);
            result = SubstanceCoreUtilities.getBlankImage(height, width);
            SimplisticGradientPainter.INSTANCE.paintContourBackground(result.createGraphics(), scrollBar, height, width, contour, false, mainScheme, mainScheme, 0.0f, true, false);
            SimplisticSoftBorderPainter borderPainter = new SimplisticSoftBorderPainter();
            borderPainter.paintBorder(result.getGraphics(), scrollBar, height, width, contour, null, mainBorderScheme, mainBorderScheme, 0.0f, false);
            result = SubstanceImageCreator.getRotated(result, 3);
            trackVerticalMap.put(key, result);
        }
        return result;
    }

    private static BufferedImage getTrackBackVertical(JScrollBar scrollBar, AbstractButton topActiveButton, AbstractButton bottomActiveButton, int width, int height) {
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(scrollBar);
        int radius = width / 2;
        if (shaper instanceof ClassicButtonShaper) {
            radius = 2;
        }
        BufferedImage opaque = SubstanceImageCreator.getRotated(SubstanceImageCreator.getCompositeRoundedBackground(scrollBar, height, width, radius, topActiveButton, bottomActiveButton, true), 3);
        return opaque;
    }

    private BufferedImage getThumbVertical(Rectangle thumbBounds) {
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        Component tracked = SubstanceFadeUtilities.getTracked(FadeKind.ROLLOVER, this.scrollbar, this.decrButton, this.incrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
        ComponentState state = ComponentState.getState(this.compositeScrollTrackModel, null);
        if (state.isKindActive(FadeKind.PRESS)) {
            tracked = null;
        }
        if (tracked != null) {
            ComponentState trackedState = tracked == this.scrollbar ? ComponentState.getState(this.thumbModel, null) : ComponentState.getState(((AbstractButton)tracked).getModel(), null);
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.scrollbar);
            if (trackedState == ComponentState.DEFAULT) {
                trackedState = ComponentState.ACTIVE;
            }
            if (prevState == ComponentState.DEFAULT) {
                prevState = ComponentState.ACTIVE;
            }
            float cyclePos = trackedState.getCyclePosition();
            FadeState highest = SubstanceFadeUtilities.getFadeStateWithHighestFadeCycle(FadeKind.ROLLOVER, this.scrollbar, this.decrButton, this.incrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
            if (highest != null) {
                cyclePos = highest.getFadePosition();
                if (!highest.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
            }
            SubstanceColorScheme scheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, trackedState);
            SubstanceColorScheme scheme1 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, prevState);
            SubstanceColorScheme borderScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, trackedState);
            SubstanceColorScheme borderScheme1 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, prevState);
            float borderCyclePos = cyclePos;
            if (scheme1 == scheme2) {
                cyclePos = 0.5f - Math.abs(0.5f - cyclePos);
            }
            if (borderScheme1 == borderScheme2) {
                borderCyclePos = 0.5f - Math.abs(0.5f - cyclePos);
            }
            return SubstanceScrollBarUI.getThumbVertical(this.scrollbar, width, height, cyclePos, scheme1, scheme2, borderCyclePos, borderScheme1, borderScheme2);
        }
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.scrollbar);
        if (state == ComponentState.DEFAULT) {
            state = ComponentState.ACTIVE;
        }
        if (prevState == ComponentState.DEFAULT) {
            prevState = ComponentState.ACTIVE;
        }
        float cyclePos = state.getCyclePosition();
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, state);
        SubstanceColorScheme borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, state);
        SubstanceColorScheme colorScheme2 = colorScheme;
        SubstanceColorScheme borderScheme2 = borderScheme;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        FadeState fadeState = fadeTracker.getFadeState(this.scrollbar, FadeKind.PRESS);
        if (fadeState != null) {
            colorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, prevState);
            borderScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, prevState);
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
        } else {
            cyclePos = 0.0f;
        }
        return SubstanceScrollBarUI.getThumbVertical(this.scrollbar, width, height, cyclePos, colorScheme, colorScheme2, cyclePos, borderScheme, borderScheme2);
    }

    private static BufferedImage getThumbVertical(JScrollBar scrollBar, int width, int height, float cyclePos, SubstanceColorScheme scheme, SubstanceColorScheme scheme2, float borderCyclePos, SubstanceColorScheme borderScheme, SubstanceColorScheme borderScheme2) {
        SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(scrollBar);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(scrollBar);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(scrollBar);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, scheme.getDisplayName(), scheme2.getDisplayName(), borderScheme.getDisplayName(), borderScheme2.getDisplayName(), Float.valueOf(cyclePos), Float.valueOf(borderCyclePos), painter.getDisplayName(), shaper.getDisplayName(), borderPainter.getDisplayName());
        BufferedImage result = thumbVerticalMap.get(key);
        if (result == null) {
            float radius = width / 2;
            if (shaper instanceof ClassicButtonShaper) {
                radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(scrollBar));
            }
            int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(scrollBar)) / 2.0);
            GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(height, width, radius, null, borderDelta);
            result = SubstanceCoreUtilities.getBlankImage(height, width);
            painter.paintContourBackground(result.createGraphics(), scrollBar, height, width, contour, false, scheme, scheme2, cyclePos, true, scheme != scheme2);
            borderPainter.paintBorder(result.getGraphics(), scrollBar, height, width, contour, null, borderScheme, borderScheme2, borderCyclePos, borderScheme != borderScheme2);
            result = SubstanceImageCreator.getRotated(result, 3);
            thumbVerticalMap.put(key, result);
        }
        return result;
    }

    private BufferedImage getThumbHorizontal(Rectangle thumbBounds) {
        SubstanceColorScheme borderScheme;
        SubstanceColorScheme colorScheme;
        int width = Math.max(1, thumbBounds.width);
        int height = Math.max(1, thumbBounds.height);
        Component tracked = SubstanceFadeUtilities.getTracked(FadeKind.ROLLOVER, this.scrollbar, this.decrButton, this.incrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
        ComponentState state = ComponentState.getState(this.compositeScrollTrackModel, null);
        if (state.isKindActive(FadeKind.PRESS)) {
            tracked = null;
        }
        if (tracked != null) {
            ComponentState trackedState = tracked == this.scrollbar ? ComponentState.getState(this.thumbModel, null) : ComponentState.getState(((AbstractButton)tracked).getModel(), null);
            ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.scrollbar);
            if (trackedState == ComponentState.DEFAULT) {
                trackedState = ComponentState.ACTIVE;
            }
            if (prevState == ComponentState.DEFAULT) {
                prevState = ComponentState.ACTIVE;
            }
            float cyclePos = trackedState.getCyclePosition();
            FadeState highest = SubstanceFadeUtilities.getFadeStateWithHighestFadeCycle(FadeKind.ROLLOVER, this.scrollbar, this.decrButton, this.incrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
            if (highest != null) {
                cyclePos = highest.getFadePosition();
                if (!highest.isFadingIn()) {
                    cyclePos = 1.0f - cyclePos;
                }
            }
            SubstanceColorScheme scheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, trackedState);
            SubstanceColorScheme scheme1 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, prevState);
            SubstanceColorScheme borderScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, trackedState);
            SubstanceColorScheme borderScheme1 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, prevState);
            float borderCyclePos = cyclePos;
            if (scheme1 == scheme2) {
                cyclePos = 0.5f - Math.abs(0.5f - cyclePos);
            }
            if (borderScheme1 == borderScheme2) {
                borderCyclePos = 0.5f - Math.abs(0.5f - cyclePos);
            }
            return SubstanceScrollBarUI.getThumbHorizontal(this.scrollbar, width, height, cyclePos, scheme1, scheme2, borderCyclePos, borderScheme1, borderScheme2);
        }
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.scrollbar);
        float cyclePos = state.getCyclePosition();
        if (state == ComponentState.DEFAULT) {
            state = ComponentState.ACTIVE;
        }
        if (prevState == ComponentState.DEFAULT) {
            prevState = ComponentState.ACTIVE;
        }
        SubstanceColorScheme colorScheme2 = colorScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, state);
        SubstanceColorScheme borderScheme2 = borderScheme = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, state);
        FadeTracker fadeTracker = FadeTracker.getInstance();
        FadeState fadeState = fadeTracker.getFadeState(this.scrollbar, FadeKind.PRESS);
        if (fadeState != null) {
            colorScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, prevState);
            borderScheme2 = SubstanceColorSchemeUtilities.getColorScheme(this.scrollbar, ColorSchemeAssociationKind.BORDER, prevState);
            cyclePos = fadeState.getFadePosition();
            if (fadeState.isFadingIn()) {
                cyclePos = 1.0f - cyclePos;
            }
        } else {
            cyclePos = 0.0f;
        }
        return SubstanceScrollBarUI.getThumbHorizontal(this.scrollbar, width, height, cyclePos, colorScheme, colorScheme2, cyclePos, borderScheme, borderScheme2);
    }

    private static BufferedImage getThumbHorizontal(JScrollBar scrollBar, int width, int height, float cyclePos, SubstanceColorScheme scheme, SubstanceColorScheme scheme2, float borderCyclePos, SubstanceColorScheme borderScheme, SubstanceColorScheme borderScheme2) {
        SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(scrollBar);
        SubstanceButtonShaper shaper = SubstanceCoreUtilities.getButtonShaper(scrollBar);
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(scrollBar);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, scheme.getDisplayName(), scheme2.getDisplayName(), borderScheme.getDisplayName(), borderScheme2.getDisplayName(), Float.valueOf(cyclePos), Float.valueOf(borderCyclePos), painter.getDisplayName(), shaper.getDisplayName(), borderPainter.getDisplayName());
        float radius = height / 2;
        if (shaper instanceof ClassicButtonShaper) {
            radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(scrollBar));
        }
        int borderDelta = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(scrollBar)) / 2.0);
        GeneralPath contour = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, null, borderDelta);
        BufferedImage opaque = thumbHorizontalMap.get(key);
        if (opaque == null) {
            opaque = SubstanceCoreUtilities.getBlankImage(width, height);
            painter.paintContourBackground(opaque.createGraphics(), scrollBar, width, height, contour, false, scheme, scheme2, cyclePos, true, scheme != scheme2);
            borderPainter.paintBorder(opaque.getGraphics(), scrollBar, width, height, contour, null, borderScheme, borderScheme2, borderCyclePos, borderScheme != borderScheme2);
            thumbHorizontalMap.put(key, opaque);
        }
        return opaque;
    }

    protected ComponentState getState(JButton scrollButton) {
        if (scrollButton == null) {
            return null;
        }
        ComponentState result = ComponentState.getState(scrollButton);
        if (result == ComponentState.DEFAULT && SubstanceCoreUtilities.hasFlatAppearance(this.scrollbar, false)) {
            result = null;
        }
        if (SubstanceCoreUtilities.isButtonNeverPainted(scrollButton)) {
            result = null;
        }
        return result;
    }

    @Override
    protected void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(this.scrollbar);
        SubstanceScrollButton compTopState = null;
        SubstanceScrollButton compBottomState = null;
        if (this.decrButton.isShowing() && this.incrButton.isShowing() && this.mySecondDecreaseButton.isShowing() && this.mySecondIncreaseButton.isShowing()) {
            switch (buttonPolicy) {
                case OPPOSITE: {
                    compTopState = (SubstanceScrollButton)this.decrButton;
                    compBottomState = (SubstanceScrollButton)this.incrButton;
                    break;
                }
                case ADJACENT: {
                    compBottomState = (SubstanceScrollButton)this.mySecondDecreaseButton;
                    break;
                }
                case MULTIPLE: {
                    compTopState = (SubstanceScrollButton)this.decrButton;
                    compBottomState = (SubstanceScrollButton)this.mySecondDecreaseButton;
                    break;
                }
                case MULTIPLE_BOTH: {
                    compTopState = (SubstanceScrollButton)this.mySecondIncreaseButton;
                    compBottomState = (SubstanceScrollButton)this.mySecondDecreaseButton;
                }
            }
        }
        if (this.scrollbar.getOrientation() == 1) {
            BufferedImage bi = this.getTrackVertical(trackBounds, compTopState, compBottomState);
            graphics.drawImage((Image)bi, trackBounds.x, trackBounds.y, null);
        } else {
            BufferedImage bi = this.scrollbar.getComponentOrientation().isLeftToRight() ? this.getTrackHorizontal(trackBounds, compTopState, compBottomState) : this.getTrackHorizontal(trackBounds, compBottomState, compTopState);
            graphics.drawImage((Image)bi, trackBounds.x, trackBounds.y, null);
        }
        graphics.dispose();
    }

    @Override
    protected void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        boolean isVertical;
        Graphics2D graphics = (Graphics2D)g.create();
        this.thumbModel.setSelected(this.thumbModel.isSelected() || this.isDragging);
        this.thumbModel.setEnabled(c.isEnabled());
        boolean bl = isVertical = this.scrollbar.getOrientation() == 1;
        if (isVertical) {
            Rectangle adjustedBounds = new Rectangle(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
            BufferedImage thumbImage = this.getThumbVertical(adjustedBounds);
            graphics.drawImage((Image)thumbImage, adjustedBounds.x, adjustedBounds.y, null);
        } else {
            Rectangle adjustedBounds = new Rectangle(thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height);
            BufferedImage thumbImage = this.getThumbHorizontal(adjustedBounds);
            graphics.drawImage((Image)thumbImage, adjustedBounds.x, adjustedBounds.y, null);
        }
        graphics.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        BackgroundPaintingUtils.update(graphics, c, false);
        float alpha = SubstanceColorSchemeUtilities.getAlpha(this.scrollbar, ComponentState.getState(this.thumbModel, this.scrollbar));
        graphics.setComposite(TransitionLayout.getAlphaComposite(c, alpha, g));
        super.paint(graphics, c);
        graphics.dispose();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.scrollBarWidth = SubstanceSizeUtils.getScrollBarWidth(SubstanceSizeUtils.getComponentFontSize(this.scrollbar));
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        switch (this.scrollbar.getOrientation()) {
            case 1: {
                this.mySecondDecreaseButton = this.createGeneralDecreaseButton(1, false);
                this.mySecondIncreaseButton = this.createGeneralIncreaseButton(5, false);
                break;
            }
            case 0: {
                if (this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    this.mySecondDecreaseButton = this.createGeneralDecreaseButton(7, false);
                    this.mySecondIncreaseButton = this.createGeneralIncreaseButton(3, false);
                    break;
                }
                this.mySecondDecreaseButton = this.createGeneralDecreaseButton(3, false);
                this.mySecondIncreaseButton = this.createGeneralIncreaseButton(7, false);
            }
        }
        this.scrollbar.add(this.mySecondDecreaseButton);
        this.scrollbar.add(this.mySecondIncreaseButton);
        this.compositeScrollTrackModel = new CompositeButtonModel(this.thumbModel, this.incrButton, this.decrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
        this.compositeButtonsModel = new CompositeButtonModel((ButtonModel)new DefaultButtonModel(), this.incrButton, this.decrButton, this.mySecondDecreaseButton, this.mySecondIncreaseButton);
    }

    @Override
    protected void uninstallComponents() {
        this.scrollbar.remove(this.mySecondDecreaseButton);
        this.scrollbar.remove(this.mySecondIncreaseButton);
        super.uninstallComponents();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SubstanceScrollBarUI.this.scrollbar.repaint();
            }
        };
        this.incrButton.addMouseListener(this.substanceMouseListener);
        this.decrButton.addMouseListener(this.substanceMouseListener);
        this.mySecondDecreaseButton.addMouseListener(this.substanceMouseListener);
        this.mySecondIncreaseButton.addMouseListener(this.substanceMouseListener);
        this.substanceThumbRolloverListener = new RolloverControlListener(this, this.thumbModel);
        this.scrollbar.addMouseListener(this.substanceThumbRolloverListener);
        this.scrollbar.addMouseMotionListener(this.substanceThumbRolloverListener);
        this.substanceFadeStateListener = new FadeStateListener(this.scrollbar, this.thumbModel, SubstanceCoreUtilities.getFadeCallback(this.scrollbar, this.thumbModel, false, false, this.scrollbar));
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Color newBackgr;
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SubstanceScrollBarUI.this.scrollbar.updateUI();
                        }
                    });
                }
                if ("background".equals(evt.getPropertyName()) && !((newBackgr = (Color)evt.getNewValue()) instanceof UIResource)) {
                    if (SubstanceScrollBarUI.this.mySecondDecreaseButton != null && SubstanceScrollBarUI.this.mySecondDecreaseButton.getBackground() instanceof UIResource) {
                        SubstanceScrollBarUI.this.mySecondDecreaseButton.setBackground(newBackgr);
                    }
                    if (SubstanceScrollBarUI.this.mySecondIncreaseButton != null && SubstanceScrollBarUI.this.mySecondIncreaseButton.getBackground() instanceof UIResource) {
                        SubstanceScrollBarUI.this.mySecondIncreaseButton.setBackground(newBackgr);
                    }
                    if (SubstanceScrollBarUI.this.incrButton != null && SubstanceScrollBarUI.this.incrButton.getBackground() instanceof UIResource) {
                        SubstanceScrollBarUI.this.incrButton.setBackground(newBackgr);
                    }
                    if (SubstanceScrollBarUI.this.decrButton != null && SubstanceScrollBarUI.this.decrButton.getBackground() instanceof UIResource) {
                        SubstanceScrollBarUI.this.decrButton.setBackground(newBackgr);
                    }
                }
            }
        };
        this.scrollbar.addPropertyChangeListener(this.substancePropertyListener);
        this.mySecondDecreaseButton.addMouseListener(this.buttonListener);
        this.mySecondIncreaseButton.addMouseListener(this.buttonListener);
        this.substanceAdjustmentListener = new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                SubstanceCoreUtilities.testComponentStateChangeThreadingViolation(SubstanceScrollBarUI.this.scrollbar);
                Container parent = SubstanceScrollBarUI.this.scrollbar.getParent();
                if (parent instanceof JScrollPane) {
                    JScrollPane jsp = (JScrollPane)parent;
                    JScrollBar hor = jsp.getHorizontalScrollBar();
                    JScrollBar ver = jsp.getVerticalScrollBar();
                    JScrollBar other = null;
                    if (SubstanceScrollBarUI.this.scrollbar == hor) {
                        other = ver;
                    }
                    if (SubstanceScrollBarUI.this.scrollbar == ver) {
                        other = hor;
                    }
                    if (other != null && other.isVisible()) {
                        other.repaint();
                    }
                    SubstanceScrollBarUI.this.scrollbar.repaint();
                }
            }
        };
        this.scrollbar.addAdjustmentListener(this.substanceAdjustmentListener);
    }

    @Override
    protected void uninstallListeners() {
        this.incrButton.removeMouseListener(this.substanceMouseListener);
        this.decrButton.removeMouseListener(this.substanceMouseListener);
        this.mySecondDecreaseButton.removeMouseListener(this.substanceMouseListener);
        this.mySecondIncreaseButton.removeMouseListener(this.substanceMouseListener);
        this.substanceMouseListener = null;
        this.scrollbar.removeMouseListener(this.substanceThumbRolloverListener);
        this.scrollbar.removeMouseMotionListener(this.substanceThumbRolloverListener);
        this.substanceThumbRolloverListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.scrollbar.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        this.mySecondDecreaseButton.removeMouseListener(this.buttonListener);
        this.mySecondIncreaseButton.removeMouseListener(this.buttonListener);
        this.scrollbar.removeAdjustmentListener(this.substanceAdjustmentListener);
        this.substanceAdjustmentListener = null;
        super.uninstallListeners();
    }

    @Override
    public boolean isInside(MouseEvent me) {
        Rectangle trackB = this.getTrackBounds();
        if (trackB == null) {
            return false;
        }
        return trackB.contains(me.getX(), me.getY());
    }

    @Override
    public void scrollByBlock(int direction) {
        int oldValue = this.scrollbar.getValue();
        int blockIncrement = this.scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = this.scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = this.scrollbar.getMinimum();
        }
        this.scrollbar.setValue(newValue);
    }

    public void scrollByUnits(int direction, int units) {
        for (int i = 0; i < units; ++i) {
            int delta = direction > 0 ? this.scrollbar.getUnitIncrement(direction) : -this.scrollbar.getUnitIncrement(direction);
            int oldValue = this.scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = this.scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = this.scrollbar.getMinimum();
            }
            if (oldValue == newValue) break;
            this.scrollbar.setValue(newValue);
        }
    }

    @Override
    protected void layoutVScrollbar(JScrollBar sb) {
        SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(this.scrollbar);
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        switch (buttonPolicy) {
            case OPPOSITE: {
                super.layoutVScrollbar(sb);
                break;
            }
            case NONE: {
                this.layoutVScrollbarNone(sb);
                break;
            }
            case ADJACENT: {
                this.layoutVScrollbarAdjacent(sb);
                break;
            }
            case MULTIPLE: {
                this.layoutVScrollbarMultiple(sb);
                break;
            }
            case MULTIPLE_BOTH: {
                this.layoutVScrollbarMultipleBoth(sb);
            }
        }
    }

    @Override
    protected void layoutHScrollbar(JScrollBar sb) {
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(this.scrollbar);
        switch (buttonPolicy) {
            case OPPOSITE: {
                super.layoutHScrollbar(sb);
                break;
            }
            case NONE: {
                this.layoutHScrollbarNone(sb);
                break;
            }
            case ADJACENT: {
                this.layoutHScrollbarAdjacent(sb);
                break;
            }
            case MULTIPLE: {
                this.layoutHScrollbarMultiple(sb);
                break;
            }
            case MULTIPLE_BOTH: {
                this.layoutHScrollbarMultipleBoth(sb);
            }
        }
    }

    protected void layoutVScrollbarAdjacent(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonH = itemW;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButton2H = itemW;
        int decrButton2Y = incrButtonY - decrButton2H;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButton2H + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButton2Y - thumbH;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = decrButton2H = sbAvailButtonH / 2;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondDecreaseButton.setBounds(itemX, incrButtonY - decrButton2H, itemW, decrButton2H);
        this.incrButton.setBounds(itemX, incrButtonY - 1, itemW, incrButtonH + 1);
        int itrackY = 0;
        int itrackH = decrButton2Y - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButton2Y) {
                thumbY = decrButton2Y - thumbH;
            }
            if (thumbY < 0) {
                thumbY = 0;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutVScrollbarNone(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonH = 0;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButton2H = 0;
        int decrButton2Y = incrButtonY - decrButton2H;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButton2H + incrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButton2Y - thumbH;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            incrButtonH = 0;
        }
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        this.incrButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        int itrackY = 0;
        int itrackH = decrButton2Y - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButton2Y) {
                thumbY = decrButton2Y - thumbH;
            }
            if (thumbY < 0) {
                thumbY = 0;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutVScrollbarMultiple(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonH = itemW;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButton2H = itemW;
        int decrButton2Y = incrButtonY - decrButton2H;
        int decrButtonH = itemW;
        int decrButtonY = sbInsets.top;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButton2H + incrButtonH + decrButtonH;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButton2Y - thumbH;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += decrButtonY + decrButtonH;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            decrButton2H = decrButtonH = sbAvailButtonH / 2;
            incrButtonH = decrButtonH;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.mySecondDecreaseButton.setBounds(itemX, incrButtonY - decrButton2H, itemW, decrButton2H);
        this.incrButton.setBounds(itemX, incrButtonY - 1, itemW, incrButtonH + 1);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        int itrackY = decrButtonY + decrButtonH;
        int itrackH = decrButton2Y - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButton2Y) {
                thumbY = decrButton2Y - thumbH;
            }
            if (thumbY < decrButtonY + decrButtonH) {
                thumbY = decrButtonY + decrButtonH + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutVScrollbarMultipleBoth(JScrollBar sb) {
        int sbAvailButtonH;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemW = sbSize.width - (sbInsets.left + sbInsets.right);
        int itemX = sbInsets.left;
        int incrButtonH = itemW;
        int incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        int decrButton2H = itemW;
        int decrButton2Y = incrButtonY - decrButton2H;
        int decrButtonH = itemW;
        int decrButtonY = sbInsets.top;
        int incrButton2H = itemW;
        int incrButton2Y = decrButtonY + decrButtonH;
        int sbInsetsH = sbInsets.top + sbInsets.bottom;
        int sbButtonsH = decrButton2H + incrButtonH + decrButtonH + incrButton2H;
        float trackH = sbSize.height - (sbInsetsH + sbButtonsH);
        float min = sb.getMinimum();
        float extent = sb.getVisibleAmount();
        float range = (float)sb.getMaximum() - min;
        float value = sb.getValue();
        int thumbH = range <= 0.0f ? this.getMaximumThumbSize().height : (int)(trackH * (extent / range));
        thumbH = Math.max(thumbH, this.getMinimumThumbSize().height);
        thumbH = Math.min(thumbH, this.getMaximumThumbSize().height);
        int thumbY = decrButton2Y - thumbH;
        if (value < (float)(sb.getMaximum() - sb.getVisibleAmount())) {
            float thumbRange = trackH - (float)thumbH;
            thumbY = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            thumbY += incrButton2Y + incrButton2H;
        }
        if ((sbAvailButtonH = sbSize.height - sbInsetsH) < sbButtonsH) {
            decrButtonH = incrButton2H = sbAvailButtonH / 4;
            decrButton2H = incrButton2H;
            incrButtonH = incrButton2H;
            incrButtonY = sbSize.height - (sbInsets.bottom + incrButtonH);
        }
        this.decrButton.setBounds(itemX, decrButtonY, itemW, decrButtonH);
        this.mySecondDecreaseButton.setBounds(itemX, incrButtonY - decrButton2H, itemW, decrButton2H);
        this.incrButton.setBounds(itemX, incrButtonY - 1, itemW, incrButtonH + 1);
        this.mySecondIncreaseButton.setBounds(itemX, decrButtonY + decrButtonH - 1, itemW, incrButton2H + 1);
        int itrackY = incrButton2Y + incrButton2H;
        int itrackH = decrButton2Y - itrackY;
        this.trackRect.setBounds(itemX, itrackY, itemW, itrackH);
        if (thumbH >= (int)trackH) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (thumbY + thumbH > decrButton2Y) {
                thumbY = decrButton2Y - thumbH;
            }
            if (thumbY < incrButton2Y + incrButton2H) {
                thumbY = incrButton2Y + incrButton2H + 1;
            }
            this.setThumbBounds(itemX, thumbY, itemW, thumbH);
        }
    }

    protected void layoutHScrollbarAdjacent(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int decrButton2W = itemH;
        int incrButtonW = itemH;
        int incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        int decrButton2X = ltr ? incrButtonX - decrButton2W : incrButtonX + decrButton2W;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButton2W + incrButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? decrButton2X - thumbW : sbInsets.left;
        if (value < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            if (ltr) {
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            } else {
                thumbX = (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
                thumbX += decrButton2X + decrButton2W;
            }
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            incrButtonW = decrButton2W = sbAvailButtonW / 2;
            incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        }
        this.mySecondDecreaseButton.setBounds(decrButton2X + (ltr ? 0 : -1), itemY, decrButton2W + 1, itemH);
        this.incrButton.setBounds(incrButtonX, itemY, incrButtonW, itemH);
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        if (ltr) {
            int itrackX = sbInsets.left;
            int itrackW = decrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = decrButton2X + decrButton2W;
            int itrackW = sbSize.width - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > decrButton2X) {
                    thumbX = decrButton2X - thumbW;
                }
                if (thumbX < 0) {
                    thumbX = 1;
                }
            } else {
                if (thumbX + thumbW > sbSize.width - sbInsets.left) {
                    thumbX = sbSize.width - sbInsets.left - thumbW;
                }
                if (thumbX < decrButton2X + decrButton2W) {
                    thumbX = decrButton2X + decrButton2W + 1;
                }
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected void layoutHScrollbarNone(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int decrButton2W = 0;
        int incrButtonW = 0;
        int incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        int decrButton2X = ltr ? incrButtonX - decrButton2W : incrButtonX + decrButton2W;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButton2W + incrButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? decrButton2X - thumbW : sbInsets.left;
        if (value < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            if (ltr) {
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
            } else {
                thumbX = (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
                thumbX += decrButton2X + decrButton2W;
            }
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            decrButton2W = 0;
            incrButtonW = 0;
        }
        this.incrButton.setBounds(0, 0, 0, 0);
        this.decrButton.setBounds(0, 0, 0, 0);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        this.mySecondDecreaseButton.setBounds(0, 0, 0, 0);
        if (ltr) {
            int itrackX = sbInsets.left;
            int itrackW = decrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = decrButton2X + decrButton2W;
            int itrackW = sbSize.width - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > decrButton2X) {
                    thumbX = decrButton2X - thumbW;
                }
                if (thumbX < 0) {
                    thumbX = 1;
                }
            } else {
                if (thumbX + thumbW > sbSize.width - sbInsets.left) {
                    thumbX = sbSize.width - sbInsets.left - thumbW;
                }
                if (thumbX < decrButton2X + decrButton2W) {
                    thumbX = decrButton2X + decrButton2W + 1;
                }
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected void layoutHScrollbarMultiple(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int decrButton2W = itemH;
        int decrButtonW = itemH;
        int incrButtonW = itemH;
        int incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        int decrButton2X = ltr ? incrButtonX - decrButton2W : incrButtonX + decrButton2W;
        int decrButtonX = ltr ? sbInsets.left : sbSize.width - sbInsets.right - decrButtonW;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButton2W + incrButtonW + decrButtonW;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? decrButton2X - thumbW : sbInsets.left;
        if (value < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            if (ltr) {
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
                thumbX += decrButtonX + decrButtonW;
            } else {
                thumbX = (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
                thumbX += decrButton2X + decrButton2W;
            }
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            decrButton2W = decrButtonW = sbAvailButtonW / 2;
            incrButtonW = decrButtonW;
            incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        }
        this.mySecondDecreaseButton.setBounds(decrButton2X + (ltr ? 0 : -1), itemY, decrButton2W + 1, itemH);
        this.incrButton.setBounds(incrButtonX, itemY, incrButtonW, itemH);
        this.decrButton.setBounds(decrButtonX, itemY, decrButtonW, itemH);
        this.mySecondIncreaseButton.setBounds(0, 0, 0, 0);
        if (ltr) {
            int itrackX = decrButtonX + decrButtonW;
            int itrackW = decrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = decrButton2X + decrButton2W;
            int itrackW = decrButtonX - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > decrButton2X) {
                    thumbX = decrButton2X - thumbW;
                }
                if (thumbX < decrButtonX + decrButtonW) {
                    thumbX = decrButtonX + decrButtonW + 1;
                }
            } else {
                if (thumbX + thumbW > decrButtonX) {
                    thumbX = decrButtonX - thumbW;
                }
                if (thumbX < decrButton2X + decrButton2W) {
                    thumbX = decrButton2X + decrButton2W + 1;
                }
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    protected void layoutHScrollbarMultipleBoth(JScrollBar sb) {
        int sbAvailButtonW;
        int thumbX;
        Dimension sbSize = sb.getSize();
        Insets sbInsets = sb.getInsets();
        int itemH = sbSize.height - (sbInsets.top + sbInsets.bottom);
        int itemY = sbInsets.top;
        boolean ltr = sb.getComponentOrientation().isLeftToRight();
        int decrButton2W = itemH;
        int incrButton2W = itemH;
        int decrButtonW = itemH;
        int incrButtonW = itemH;
        int incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        int decrButton2X = ltr ? incrButtonX - decrButton2W : incrButtonX + decrButton2W;
        int decrButtonX = ltr ? sbInsets.left : sbSize.width - sbInsets.right - decrButtonW;
        int incrButton2X = ltr ? decrButtonX + decrButtonW : decrButtonX - incrButton2W;
        int sbInsetsW = sbInsets.left + sbInsets.right;
        int sbButtonsW = decrButton2W + incrButtonW + decrButtonW + incrButton2W;
        float trackW = sbSize.width - (sbInsetsW + sbButtonsW);
        float min = sb.getMinimum();
        float max = sb.getMaximum();
        float extent = sb.getVisibleAmount();
        float range = max - min;
        float value = sb.getValue();
        int thumbW = range <= 0.0f ? this.getMaximumThumbSize().width : (int)(trackW * (extent / range));
        thumbW = Math.max(thumbW, this.getMinimumThumbSize().width);
        thumbW = Math.min(thumbW, this.getMaximumThumbSize().width);
        int n = thumbX = ltr ? decrButton2X - thumbW : sbInsets.left;
        if (value < max - (float)sb.getVisibleAmount()) {
            float thumbRange = trackW - (float)thumbW;
            if (ltr) {
                thumbX = (int)(0.5f + thumbRange * ((value - min) / (range - extent)));
                thumbX += incrButton2X + incrButton2W;
            } else {
                thumbX = (int)(0.5f + thumbRange * ((max - extent - value) / (range - extent)));
                thumbX += decrButton2X + decrButton2W;
            }
        }
        if ((sbAvailButtonW = sbSize.width - sbInsetsW) < sbButtonsW) {
            decrButtonW = incrButton2W = sbAvailButtonW / 4;
            decrButton2W = incrButton2W;
            incrButtonW = incrButton2W;
            incrButtonX = ltr ? sbSize.width - (sbInsets.right + incrButtonW) : sbInsets.left;
        }
        this.mySecondDecreaseButton.setBounds(decrButton2X + (ltr ? 0 : -1), itemY, decrButton2W + 1, itemH);
        this.mySecondIncreaseButton.setBounds(incrButton2X + (ltr ? -1 : 0), itemY, incrButton2W + 1, itemH);
        this.incrButton.setBounds(incrButtonX, itemY, incrButtonW, itemH);
        this.decrButton.setBounds(decrButtonX, itemY, decrButtonW, itemH);
        if (ltr) {
            int itrackX = incrButton2X + incrButton2W;
            int itrackW = decrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        } else {
            int itrackX = decrButton2X + decrButton2W;
            int itrackW = incrButton2X - itrackX;
            this.trackRect.setBounds(itrackX, itemY, itrackW, itemH);
        }
        if (thumbW >= (int)trackW) {
            this.setThumbBounds(0, 0, 0, 0);
        } else {
            if (ltr) {
                if (thumbX + thumbW > decrButton2X) {
                    thumbX = decrButton2X - thumbW;
                }
                if (thumbX < incrButton2X + incrButton2W) {
                    thumbX = incrButton2X + incrButton2W + 1;
                }
            } else {
                if (thumbX + thumbW > incrButton2X) {
                    thumbX = incrButton2X - thumbW;
                }
                if (thumbX < decrButton2X + decrButton2W) {
                    thumbX = decrButton2X + decrButton2W + 1;
                }
            }
            this.setThumbBounds(thumbX, itemY, thumbW, itemH);
        }
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceScrollBarUI: \n");
        sb.append("\t" + thumbHorizontalMap.size() + " thumb horizontal, " + thumbVerticalMap.size() + " thumb vertical");
        sb.append("\t" + trackHorizontalMap.size() + " track horizontal, " + trackVerticalMap.size() + " track vertical");
        sb.append("\t" + trackFullHorizontalMap.size() + " track full horizontal, " + trackFullVerticalMap.size() + " track full vertical");
        return sb.toString();
    }

    @Override
    protected BasicScrollBarUI.TrackListener createTrackListener() {
        return new SubstanceTrackListener();
    }

    @Override
    protected BasicScrollBarUI.ArrowButtonListener createArrowButtonListener() {
        return new SubstanceArrowButtonListener();
    }

    private void updateThumbState(int x, int y) {
        Rectangle rect = this.getThumbBounds();
        this.setThumbRollover(rect.contains(x, y));
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, Math.max(48, 5 * this.scrollBarWidth));
        }
        return new Dimension(Math.max(48, 5 * this.scrollBarWidth), this.scrollBarWidth);
    }

    protected class SubstanceArrowButtonListener
    extends BasicScrollBarUI.ArrowButtonListener {
        boolean handledEvent;

        protected SubstanceArrowButtonListener() {
            super(SubstanceScrollBarUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            int direction = e.getSource() == SubstanceScrollBarUI.this.incrButton || e.getSource() == SubstanceScrollBarUI.this.mySecondIncreaseButton ? 1 : -1;
            SubstanceScrollBarUI.this.scrollByUnit(direction);
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollListener.setDirection(direction);
            SubstanceScrollBarUI.this.scrollListener.setScrollByBlock(false);
            SubstanceScrollBarUI.this.scrollTimer.start();
            this.handledEvent = true;
            if (!SubstanceScrollBarUI.this.scrollbar.hasFocus() && SubstanceScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SubstanceScrollBarUI.this.scrollbar.requestFocus();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SubstanceScrollBarUI.this.scrollTimer.stop();
            this.handledEvent = false;
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }
    }

    protected class SubstanceTrackListener
    extends BasicScrollBarUI.TrackListener {
        private transient int direction;

        protected SubstanceTrackListener() {
            super(SubstanceScrollBarUI.this);
            this.direction = 1;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.updateThumbState(e.getX(), e.getY());
            }
            if (SwingUtilities.isRightMouseButton(e) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            Rectangle r = SubstanceScrollBarUI.this.getTrackBounds();
            SubstanceScrollBarUI.this.scrollbar.repaint(r.x, r.y, r.width, r.height);
            SubstanceScrollBarUI.this.trackHighlight = 0;
            SubstanceScrollBarUI.this.isDragging = false;
            this.offset = 0;
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled()) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.hasFocus() && SubstanceScrollBarUI.this.scrollbar.isRequestFocusEnabled()) {
                SubstanceScrollBarUI.this.scrollbar.requestFocus();
            }
            SubstanceScrollBarUI.this.scrollbar.setValueIsAdjusting(true);
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (SubstanceScrollBarUI.this.getThumbBounds().contains(this.currentMouseX, this.currentMouseY)) {
                switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x;
                    }
                }
                SubstanceScrollBarUI.this.isDragging = true;
                return;
            }
            if (SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                    case 1: {
                        this.offset = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().height / 2;
                        break;
                    }
                    case 0: {
                        this.offset = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().width / 2;
                    }
                }
                SubstanceScrollBarUI.this.isDragging = true;
                this.setValueFrom(e);
                return;
            }
            SubstanceScrollBarUI.this.isDragging = false;
            Dimension sbSize = SubstanceScrollBarUI.this.scrollbar.getSize();
            this.direction = 1;
            switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.height / 2;
                        this.direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                        break;
                    }
                    int thumbY = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y;
                    this.direction = this.currentMouseY < thumbY ? -1 : 1;
                    break;
                }
                case 0: {
                    if (SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                        int scrollbarCenter = sbSize.width / 2;
                        this.direction = this.currentMouseX < scrollbarCenter ? -1 : 1;
                    } else {
                        int thumbX = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x;
                        int n = this.direction = this.currentMouseX < thumbX ? -1 : 1;
                    }
                    if (SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) break;
                    this.direction = -this.direction;
                }
            }
            SubstanceScrollBarUI.this.scrollByBlock(this.direction);
            SubstanceScrollBarUI.this.scrollTimer.stop();
            SubstanceScrollBarUI.this.scrollListener.setDirection(this.direction);
            SubstanceScrollBarUI.this.scrollListener.setScrollByBlock(true);
            this.startScrollTimerIfNecessary();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || !SubstanceScrollBarUI.this.getSupportsAbsolutePositioning() && SwingUtilities.isMiddleMouseButton(e)) {
                return;
            }
            if (!SubstanceScrollBarUI.this.scrollbar.isEnabled() || SubstanceScrollBarUI.this.getThumbBounds().isEmpty()) {
                return;
            }
            if (SubstanceScrollBarUI.this.isDragging) {
                this.setValueFrom(e);
            } else {
                this.currentMouseX = e.getX();
                this.currentMouseY = e.getY();
                SubstanceScrollBarUI.this.updateThumbState(this.currentMouseX, this.currentMouseY);
                this.startScrollTimerIfNecessary();
            }
        }

        private void setValueFrom(MouseEvent e) {
            int thumbPos;
            boolean active = SubstanceScrollBarUI.this.isThumbRollover();
            BoundedRangeModel model = SubstanceScrollBarUI.this.scrollbar.getModel();
            Rectangle thumbR = SubstanceScrollBarUI.this.getThumbBounds();
            int thumbMin = 0;
            int thumbMax = 0;
            SubstanceConstants.ScrollPaneButtonPolicyKind buttonPolicy = SubstanceCoreUtilities.getScrollPaneButtonsPolicyKind(SubstanceScrollBarUI.this.scrollbar);
            if (SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1) {
                switch (buttonPolicy) {
                    case OPPOSITE: {
                        thumbMin = SubstanceScrollBarUI.this.decrButton.getY() + SubstanceScrollBarUI.this.decrButton.getHeight();
                        thumbMax = SubstanceScrollBarUI.this.incrButton.getY() - thumbR.height;
                        break;
                    }
                    case ADJACENT: {
                        thumbMin = 0;
                        thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getY() - thumbR.height;
                        break;
                    }
                    case NONE: {
                        thumbMin = 0;
                        thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().height - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().bottom - thumbR.height;
                        break;
                    }
                    case MULTIPLE: {
                        thumbMin = SubstanceScrollBarUI.this.decrButton.getY() + SubstanceScrollBarUI.this.decrButton.getHeight();
                        thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getY() - thumbR.height;
                        break;
                    }
                    case MULTIPLE_BOTH: {
                        thumbMin = SubstanceScrollBarUI.this.mySecondIncreaseButton.getY() + SubstanceScrollBarUI.this.mySecondIncreaseButton.getHeight();
                        thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getY() - thumbR.height;
                    }
                }
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getY() - this.offset));
                SubstanceScrollBarUI.this.setThumbBounds(thumbR.x, thumbPos, thumbR.width, thumbR.height);
            } else {
                if (SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    switch (buttonPolicy) {
                        case OPPOSITE: {
                            thumbMin = SubstanceScrollBarUI.this.decrButton.getX() + SubstanceScrollBarUI.this.decrButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.incrButton.getX() - thumbR.width;
                            break;
                        }
                        case ADJACENT: {
                            thumbMin = 0;
                            thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() - thumbR.width;
                            break;
                        }
                        case MULTIPLE: {
                            thumbMin = SubstanceScrollBarUI.this.decrButton.getX() + SubstanceScrollBarUI.this.decrButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() - thumbR.width;
                            break;
                        }
                        case MULTIPLE_BOTH: {
                            thumbMin = SubstanceScrollBarUI.this.mySecondIncreaseButton.getX() + SubstanceScrollBarUI.this.mySecondIncreaseButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() - thumbR.width;
                            break;
                        }
                        case NONE: {
                            thumbMin = 0;
                            thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - thumbR.width;
                        }
                    }
                } else {
                    switch (buttonPolicy) {
                        case OPPOSITE: {
                            thumbMin = SubstanceScrollBarUI.this.incrButton.getX() + SubstanceScrollBarUI.this.incrButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.decrButton.getX() - thumbR.width;
                            break;
                        }
                        case ADJACENT: {
                            thumbMin = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() + SubstanceScrollBarUI.this.mySecondDecreaseButton.getWidth();
                            thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - thumbR.width;
                            break;
                        }
                        case MULTIPLE: {
                            thumbMin = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() + SubstanceScrollBarUI.this.mySecondDecreaseButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.decrButton.getX() - thumbR.width;
                            break;
                        }
                        case MULTIPLE_BOTH: {
                            thumbMin = SubstanceScrollBarUI.this.mySecondDecreaseButton.getX() + SubstanceScrollBarUI.this.mySecondDecreaseButton.getWidth();
                            thumbMax = SubstanceScrollBarUI.this.mySecondIncreaseButton.getX() - thumbR.width;
                            break;
                        }
                        case NONE: {
                            thumbMin = 0;
                            thumbMax = ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getSize().width - ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).scrollbar.getInsets().right - thumbR.width;
                        }
                    }
                }
                thumbPos = Math.min(thumbMax, Math.max(thumbMin, e.getX() - this.offset));
                SubstanceScrollBarUI.this.setThumbBounds(thumbPos, thumbR.y, thumbR.width, thumbR.height);
            }
            if (thumbPos == thumbMax) {
                if (SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1 || SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight()) {
                    SubstanceScrollBarUI.this.scrollbar.setValue(model.getMaximum() - model.getExtent());
                } else {
                    SubstanceScrollBarUI.this.scrollbar.setValue(model.getMinimum());
                }
            } else {
                float valueMax = model.getMaximum() - model.getExtent();
                float valueRange = valueMax - (float)model.getMinimum();
                float thumbValue = thumbPos - thumbMin;
                float thumbRange = thumbMax - thumbMin;
                int value = SubstanceScrollBarUI.this.scrollbar.getOrientation() == 1 || SubstanceScrollBarUI.this.scrollbar.getComponentOrientation().isLeftToRight() ? (int)(0.5 + (double)(thumbValue / thumbRange * valueRange)) : (int)(0.5 + (double)((float)(thumbMax - thumbPos) / thumbRange * valueRange));
                SubstanceScrollBarUI.this.scrollbar.setValue(value + model.getMinimum());
            }
            SubstanceScrollBarUI.this.setThumbRollover(active);
        }

        private void startScrollTimerIfNecessary() {
            if (SubstanceScrollBarUI.this.scrollTimer.isRunning()) {
                return;
            }
            switch (SubstanceScrollBarUI.this.scrollbar.getOrientation()) {
                case 1: {
                    if (this.direction > 0) {
                        if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y + ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().height >= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseY) break;
                        SubstanceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().y <= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseY) break;
                    SubstanceScrollBarUI.this.scrollTimer.start();
                    break;
                }
                case 0: {
                    if (this.direction > 0) {
                        if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x + ((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().width >= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseX) break;
                        SubstanceScrollBarUI.this.scrollTimer.start();
                        break;
                    }
                    if (((SubstanceScrollBarUI)SubstanceScrollBarUI.this).getThumbBounds().x <= ((SubstanceTrackListener)((SubstanceScrollBarUI)SubstanceScrollBarUI.this).trackListener).currentMouseX) break;
                    SubstanceScrollBarUI.this.scrollTimer.start();
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (!SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.updateThumbState(e.getX(), e.getY());
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!SubstanceScrollBarUI.this.isDragging) {
                SubstanceScrollBarUI.this.setThumbRollover(false);
            }
        }
    }
}

