/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Color;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicFormattedTextFieldUI;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.SubstanceTextUtilities;
import org.jvnet.substance.utils.border.SubstanceBorder;

public class SubstanceFormattedTextFieldUI
extends BasicFormattedTextFieldUI {
    protected FadeStateListener substanceFadeStateListener;
    protected JFormattedTextField textField;
    protected PropertyChangeListener substancePropertyChangeListener;

    public static ComponentUI createUI(JComponent comp) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(comp);
        return new SubstanceFormattedTextFieldUI(comp);
    }

    public SubstanceFormattedTextFieldUI(JComponent c) {
        this.textField = (JFormattedTextField)c;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.substanceFadeStateListener = new FadeStateListener(this.textField, null, null);
        this.substanceFadeStateListener.registerListeners(false);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("font".equals(evt.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int caretPos = SubstanceFormattedTextFieldUI.this.textField.getCaretPosition();
                            SubstanceFormattedTextFieldUI.this.textField.updateUI();
                            SubstanceFormattedTextFieldUI.this.textField.setCaretPosition(caretPos);
                        }
                    });
                }
            }
        };
        this.textField.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        this.textField.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        Color foregr;
        super.installDefaults();
        Border b = this.textField.getBorder();
        if (b == null || b instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource newB = new BorderUIResource.CompoundBorderUIResource(new SubstanceBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.textField))), new BasicBorders.MarginBorder());
            this.textField.setBorder(newB);
        }
        if ((foregr = this.textField.getForeground()) == null || foregr instanceof UIResource) {
            this.textField.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(this.textField).getMainDefaultColorScheme()));
        }
    }

    @Override
    protected void paintBackground(Graphics g) {
        SubstanceTextUtilities.paintTextCompBackground(g, this.textField);
    }
}

