unit Unit1;

interface
uses Forms, Paramlst, SysUtils, Buttons, ExtCtrls, StdCtrls, Controls,
     Classes;

type
  TForm1 = class(TForm)
    Pars         : TParameter;
    LB_Par_W     : TListBox;
    LB_Par_SW_W  : TListBox;
    LB_Params    : TListBox;
    LB_Par_SW    : TListBox;
    Edit1        : TEdit;
    LBP_M        : TListBox;
    LBS_M        : TListBox;
    LB_CMD       : TListBox;
    SpeedButton1 : TSpeedButton;
    // _
    Label1       : TLabel;
    Label2       : TLabel;
    Label3       : TLabel;
    Label4       : TLabel;
    Label5       : TLabel;
    Label6       : TLabel;
    Label7       : TLabel;
    LBP_S        : TListBox;
    LBS_S        : TListBox;
    Label8       : TLabel;
    Split        : TListBox;
    Label9       : TLabel;
    Panel1       : TPanel;
    GroupBox1    : TGroupBox;
    GroupBox2    : TGroupBox;
    Label10      : TLabel;
    Label11      : TLabel;
    //_            _
    procedure FormCreate(Sender: TObject);
    procedure ParsParamMatch(Sender: TObject; CaseMatch: Boolean; Param,
      Reference: String);
    procedure ParsSwitchMatch(Sender: TObject; CaseMatch: Boolean;
      ParamSwitch, Reference: String);
    procedure SpeedButton1Click(Sender: TObject);
    procedure LB_CMDClick(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    Procedure Display_Reference( StringList       : TStringList ;
                                 LBX, LBY         : TListBox ;
                                 CaseMatch        : Boolean ;
                                 Param, Reference : String ) ;
    Procedure Display_Line ;
  end;

var

  //_             _             _                   _
  Form1           : TForm1;

implementation

{$R *.DFM}

// _                                                        _
// _                                                        _
// Form related                                             _
// _                                                        _
// _                                                        _
procedure TForm1.FormCreate(Sender: TObject);
begin
   // Parameters                                            .
   LB_Params.Items   := Pars.ParamList ;
   LB_Par_SW.Items   := Pars.SwitchList ;
   LB_Par_W.Items    := Pars.ParamWatch ;
   LB_Par_SW_W.Items := Pars.SwitchWatch ;
   Split.Items       := Pars.ParamString ;
   // END _ Parameters                                      .
   Display_Line ;
end;
// _                                                        _
// _                                                        _
// To DISPLAY THE Sub-Params / Reference Params             _
// _                                                        _
// _                                                        _
Procedure TForm1.Display_Reference( StringList       : TStringList ;
                                    LBX,LBY          : TListBox ;
                                    CaseMatch        : Boolean ;
                                    Param, Reference : String ) ;
VAR
      I          : Integer ;
      XCaseMatch : String ;
BEGIN
   // Prepare the Stringlist is EMPTY                           _
   IF LBX.Items.Count <> StringList.Count THEN
   BEGIN
      LBX.Items.Clear ;
      For I := 0 to StringList.Count - 1 DO LBX.Items.Add('  NO') ;
      LBY.Items.Clear ;
      For I := 0 to StringList.Count - 1 DO LBY.Items.Add('') ;
   END ;
   //                                                           _
   For I := 0 to StringList.Count - 1 DO
   BEGIN
      IF UpperCase(Param) = UpperCase(StringList.Strings[I]) THEN
      BEGIN
         XCaseMatch := 'False' ;
         IF CaseMatch THEN XCaseMatch := 'True' ;
         LBX.Items[I] := XCaseMatch ;
         LBY.Items[I] := Reference ;
      END ;
   END ;
END ;
// _                                                        _
// _                                                        _
// Re-Assemble the Commandline                              _
// _                                                        _
// _                                                        _
Procedure TForm1.Display_Line ;
VAR I        : Integer ;
    CMD_LINE : String ;
BEGIN
   For I := 0 to Pars.ParamString.Count - 1 DO
   BEGIN
      CMD_LINE := CMD_LINE + Pars.ParamString.Strings[I] + ' ' ;
   END ;
   EDIT1.Text := CMD_LINE ;
END ;
// _                                                        _
// _                                                        _
// EXE-Parameters from Params WATCH                         _
// _                                                        _
// _                                                        _
procedure TForm1.ParsParamMatch(Sender: TObject; CaseMatch: Boolean; Param,
  Reference: String);
// VAR   S    : String ;
begin
   Display_Reference( Pars.ParamWatch,LBP_M,LBP_S,CaseMatch,Param,Reference ) ;
end;
// _                                                        _
// _                                                        _
// EXE-Parameters from Switch WATCH                         _
// _                                                        _
// _                                                        _
procedure TForm1.ParsSwitchMatch(Sender: TObject; CaseMatch: Boolean;
  ParamSwitch, Reference: String);
// VAR   S    : String ;
begin
   Display_Reference( Pars.SwitchWatch,LBS_M,LBS_S,CaseMatch,ParamSwitch,Reference ) ;
end;
// _                                                        _
// _                                                        _
// CALLED End of Prog                                       _
// _                                                        _
// _                                                        _
procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
   Application.Terminate ;
end;
// _                                                        _
// _                                                        _
// Start with a NEW PR-Defined Commandline                  _
// _                                                        _
// _                                                        _
procedure TForm1.LB_CMDClick(Sender: TObject);
begin
   LBP_M.Items.Clear ;
   LBS_M.Items.Clear ;
   LBP_S.Items.Clear ;
   LBS_S.Items.Clear ;
   Edit1.Text := LB_CMD.Items[ LB_CMD.ItemIndex ] ;
   Pars.Execute_LINE ( Edit1.Text ) ;
   LB_Params.Items := Pars.ParamList ;
   LB_Par_SW.Items := Pars.SwitchList ;
   Split.Items     := Pars.ParamString ;
end;
// _                                                        _
// _                                                        _
// Start with a CHANGED Commandline                         _
// _                                                        _
// _                                                        _
procedure TForm1.Edit1Change(Sender: TObject);
begin
   LBP_M.Items.Clear ;
   LBS_M.Items.Clear ;
   LBP_S.Items.Clear ;
   LBS_S.Items.Clear ;
   Pars.Execute_Line ( Edit1.Text ) ;
   LB_Params.Items := Pars.ParamList ;
   LB_Par_SW.Items := Pars.SwitchList ;
   Split.Items     := Pars.ParamString ;
end;
// _                                                        _
// _                                                        _
// REAL END OF PROGRAM                                      _
// _                                                        _
// _                                                        _
end.
