unit Paramlst;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;


type
  TParamMatch = procedure(Sender: Tobject; CaseMatch: Boolean; Param: String) of object;
  TSwitchMatch = procedure(Sender: TObject; CaseMatch: Boolean; ParamSwitch: String) of object;
  TParamater = class(TComponent)
  private
    { Private declarations }
    FParamlist: TStringlist;
    FSwitchList: TStringlist;
    FSwitchWatch: TStringlist;
    FParamWatch: TStringlist;
    FParamMatch: TParamMatch;
    FSwitchMatch: TSwitchMatch;
  protected
    { Protected declarations }
    Procedure Loaded; Override;
    Procedure GetParamaterList;
    Procedure NoWrite(value: TStringlist);
    Procedure WriteParamWatch(Value: TStringlist);
    Procedure WriteSwitchWatch(Value: TStringlist);
  public
    { Public declarations }
    Constructor Create(AOwner : TComponent); override;
    property ParamList: TStringlist read FParamlist write nowrite;
    property SwitchList: TStringlist read FSwitchlist write nowrite;
  published
    { Published declarations }
{    property ParamList: TStringlist read FParamlist write nowrite;}
    property ParamWatch: TStringlist read FParamWatch write WriteParamWatch;
    property SwitchWatch: TStringlist read FSwitchwatch write WriteSwitchWatch;
    property OnParamMatch: TParamMatch read FParamMatch write FParamMatch;
    property OnSwitchMatch: TSwitchMatch read FSwitchMatch write FSwitchmatch;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('System', [TParamater]);
end;

Procedure TParamater.GetParamaterList;
var i, c: integer;
    tempstr: string;
    startparm: boolean;
begin
     Fparamlist.clear;
     startparm := False;
     for i := 1 to paramcount do
     begin
          if (copy(paramstr(i), 1, 1) = '"') and
             (not startparm) then
          begin
               startparm := True;
               tempstr := '';
               tempstr := copy(paramstr(i), 2, length(paramstr(i)));
          end
          else if (copy(paramstr(i), length(paramstr(i)), 1) = '"') and
                    (startparm) then
          begin
               if length(paramstr(i)) > 1 then
                 tempstr := tempstr + ' ' +
                   copy(paramstr(i), 1, length(paramstr(i)) - 1)
               else tempstr := tempstr + ' ';
               if (copy(tempstr, 1, 1) = '-') or
                  (copy(tempstr, 1, 1) = '/') then
                    FSwitchlist.add(copy(tempstr, 2, length(tempstr)))
               else
                    Fparamlist.add(tempstr);
               startparm := False;
          end
          else if startparm then
               tempstr := tempstr + paramstr(i)
          else if (copy(Paramstr(i), 1, 1) = '-') or
                  (copy(Paramstr(i), 1, 1) = '/') then
                    FSwitchlist.add(copy(Paramstr(i), 2, length(Paramstr(i))))
          else
                    Fparamlist.add(Paramstr(i));
     end;
     if assigned(FParamMatch) then
     for i := 0 to FParamlist.count - 1 do
        For C := 0 to FParamWatch.count - 1 do
        if FParamWatch.Strings[c] = FParamlist.Strings[i] then
           FParamMatch(Self, True, FParamlist.Strings[i])
        else if ansiuppercase(FParamWatch.Strings[c]) =
           Ansiuppercase(FParamlist.Strings[i]) then
           FParamMatch(Self, False, FParamList.Strings[i]);
     if assigned(FSwitchMatch) then
     for i := 0 to FSwitchlist.count - 1 do
         for C := 0 to FSwitchWatch.count - 1 do
         if FSwitchWatch.Strings[c] = FSwitchList.Strings[i] then
           FSwitchMatch(Self, True, FSwitchLIst.Strings[i])
         else if ansiuppercase(FSwitchWatch.Strings[c]) =
            Ansiuppercase(FSwitchList.Strings[i]) then
            FSwitchMatch(Self, False, FSwitchList.Strings[i]);
end;

Procedure TParamater.Loaded;
begin
 inherited Loaded;
 GeTParamaterlist;
end;

Constructor TParamater.Create(AOwner : TComponent);
Begin
 inherited Create(AOwner);

 FSwitchWatch:=TStringlist.create;
 FSwitchWatch.Sorted := False;
 FSwitchList:=TStringlist.create;
 FSwitchlist.sorted := False;
 fParamList:=TStringlist.Create;
 FSwitchlist:=TStringlist.Create;
 FSwitchlist.Sorted := False;
 FParamlist.sorted := False;
 FParamWatch:=TStringlist.Create;
 FParamWatch.sorted := False;
End;

Procedure TParamater.WriteParamWatch(Value: TStringlist);
begin
     FParamWatch.Clear;
     FParamWatch.AddStrings(Value);
end;

Procedure TParamater.WriteSwitchWatch(Value: TStringlist);
begin
     FSwitchWatch.Clear;
     FSwitchWatch.AddStrings(Value);
end;

procedure TParamater.NoWrite(value: TStringlist);
begin
       raise Exception.Create('Can''t modify a read-only property');
end;

end.
