Summary: Linux Logical Volume Manager utilities.
Name: lvm
Version: 1.0.8
Release: 9.of.2
Vendor: The Openfiler Project
License: GPL
Group: System Environment/Base
URL: http://www.sistina.com/products_lvm.htm
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Source: ftp://sources.redhat.com/pub/lvm/1.0/lvm_1.0.3.tar.gz
Source2: pvscan.8
Patch0: lvm-1.0.3-evilinstall.patch
Patch1: lvm-0.9-paths.patch
Patch2: lvm-0.9-broken.patch
Patch3: lvm-1.0.3-dietlibc.patch
Patch4: lvm-1.0.3-dietllseek.patch
Patch5: lvm-1.0.3-wrapper2.patch
Patch6: lvm-1.0.3-pvmove.patch
Patch7: lvm-1.0.3-fixit.patch
Patch8: lvm-1.0.3-cookie.patch
Patch9: lvm-1.0.3-vgscanfix.patch
Patch10: lvm-1.0.3-signals.patch
Patch11: lvm-1.0.3-nomsdoschecks.patch
Patch12: lvm-1.0.3-viodasd.patch
Patch13: lvm-1.0.3-kdevt.patch
Patch14: lvm-1.0.3-mdcli.patch
Patch15: lvm-1.0.3-i2o_power2.patch
Patch16: lvm-1.0.3-1.0.4.patch
Patch17: lvm-1.0.4-1.0.5.patch
Patch18: lvm-1.0.5-1.0.6.patch
Patch19: lvm-1.0.6-1.0.7.patch
Patch20: lvm-1.0.7-1.0.8.patch
Patch21: lvm-1.0.8-copyright.patch
Patch22: lvm-1.0.8-lvmcreate_initrd.patch
Patch23: lvm-1.0.8-emd.patch
Patch24: lvm-1.0.3-sx8.patch
Patch25: lvm-1.0.8-vpath.patch
Patch26: lvm-1.0.8-power2.patch

# Added by the Openfiler project to make lvdisplay snapshot details properly
Patch27: lvm-1.0.8-openfiler.patch
Patch28: lvm-1.0.8-drbd.patch
Patch29: lvm-1.0.8-filter.patch

%description
LVM includes all of the support for handling read/write operations on
physical volumes (hard disks, RAID-Systems, magneto optical, etc.,
multiple devices (MD), see mdadd(8) or even loop devices, see
losetup(8)), creating volume groups (kind of virtual disks) from one
or more physical volumes and creating one or more logical volumes
(kind of logical partitions) in volume groups.

%prep

%setup -q -n LVM
mv 1.0.3 %{version}
cd %{version}

%patch0 -p2 -b .evilinstall
%patch3 -p2 -b .diet
%patch6 -p2 -b .pvmove
%patch7 -p2
%patch8 -p2
%patch9 -p2 -b .vgscanfix
%patch10 -p2 -b .signals
%patch11 -p2 -b .nomsdos
%patch12 -p2 -b .viodasd
%patch13 -p2 -b .kdevt
%patch14 -p2 -b .mdcli
%patch15 -p2 -b .i2o_power2
%patch16 -p2 -b -1.0.4
%patch17 -p2 -b -1.0.5
%patch18 -p2 -b -1.0.6
%patch19 -p2 -b -1.0.7
%patch20 -p2 -b -1.0.8
%patch22 -p2
%patch23 -p2 -b .emd
%patch24 -p2 -b .sx8
%patch25 -p2 -b .vpath
%patch26 -p2 -b .power2

# Added by the Openfiler project to make lvdisplay snapshot details properly
%patch27 -p2 -b .openfiler
%patch28 -p2 -b .drbd
%patch29 -p2 -b .filter

# ugly hack to build diet-ized vgchange and vgscan
%ifarch i386
patch -p2 -i %{PATCH4}
export CC="diet gcc"
%endif


# make the wrapper
patch -p2 -i %{PATCH5}

%build

cd %{version}
# make static versions of vgchange and vgscan (diet-ized on i386)
%configure --prefix=/usr --sbindir=/sbin --libdir=%{_lib} --enable-static_link

pushd tools/lib
make
cd ..
make vgwrapper
mv vgwrapper vgwrapper.static
make clean
popd


patch -p2 -R -i %{PATCH5}
patch -p2 -i %{PATCH21}

%ifarch i386
patch -p2 -R -i %{PATCH4}
export CC=gcc
%endif

rm -f tools/vgwrapper.c tools/vgwrapper.o
rm config.cache
%configure --prefix=/usr  --sbindir=/sbin --libdir=/%{_lib} 
make

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/%{_lib} $RPM_BUILD_ROOT/sbin \
         $RPM_BUILD_ROOT/%{_mandir}/man8
cd %{version}
make DESTDIR=$RPM_BUILD_ROOT install

# install static versions
install -m 755 tools/vgwrapper.static $RPM_BUILD_ROOT/sbin/vgwrapper
ln $RPM_BUILD_ROOT/sbin/vgwrapper $RPM_BUILD_ROOT/sbin/vgchange.static
ln $RPM_BUILD_ROOT/sbin/vgwrapper $RPM_BUILD_ROOT/sbin/vgscan.static

#
install -m 644 %SOURCE2 $RPM_BUILD_ROOT/%{_mandir}/man8/pvscan.8

# remove unpackaged files from the buildroot
rm -rf $RPM_BUILD_ROOT/usr/lib
rm -f $RPM_BUILD_ROOT/sbin/lvmcreate_initrd* $RPM_BUILD_ROOT/usr/share/man/man8/lvmcreate_initrd*

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig 
%postun -p /sbin/ldconfig 

%files
%defattr(-,root,root)
%doc %{version}/ABSTRACT %{version}/CHANGELOG %{version}/CONTRIBUTORS
%doc %{version}/LVM-HOWTO %{version}/README %{version}/TODO
%doc %{version}/WHATSNEW %{version}/FAQ
/%{_mandir}/man8/*
/%{_lib}/*
/sbin/*

%changelog
* Wed Dec  8 2004 Jeremy Katz <katzj@redhat.com> - 1.0.8-9
- don't do the renaming to .lvm1 names with this branch.  the kernel version 
  of the build machine is not an adequate test for whether or not it should
  be done (#141788)

* Wed Oct 20 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.8-8
- missed ai pice for EMC PowerPath devices (#124647)

* Fri Sep 24 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.8-7
- fix support for EMC PowerPath devices (#124647)

* Fri Sep 24 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.8-6
- add support for IBM vpath devices (#133426)

* Wed Jun 30 2004 Jeremy Katz <katzj@redhat.com> - 1.0.8-5
- add support for emd and sx8 devices

* Wed Jun 07 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.8-3
- fix packaging of binaries

* Tue May 26 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.8-2
- Remove lvmcreate_initrd (#101443)

* Tue May 26 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.8-1
- Sistina LVM 1.0.8 changes (#117816)

* Tue May 25 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.7-1
- Sistina LVM 1.0.7 changes (#117816)

* Tue May 25 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.6-1
- Sistina LVM 1.0.6 changes (#117816)

* Mon May 24 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.5-1
- Sistina LVM 1.0.5 changes (#117816)

* Mon May 24 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.4-1
- Sistina LVM 1.0.4 changes (#117816)
- Change lvm.spec to handle higher version than source tarball is

* Thu Apr 22 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.3-20.2
- Fixed missing install of man pages (conditional rename as with binaries)

* Thu Apr 22 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.3-20.1
- Support for I2O (#117816)
- Support for PowerPath (#113971)

* Thu Apr 22 2004 Heinz Mauelshagen <heinzm@redhat.com> 1.0.3-20
- Fix lvcreate command line support for MD devices.
- Disable .lvm1 binary suffixes on 2.4 based distributions

* Tue Apr 07 2004 Alasdair Kergon <agk@redhat.com> 1.0.3-19
- Add .lvm1 suffix to all binaries; LVM2 is now the default.
  This package is only useful to Fedora users reverting to a 2.4 kernel.

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Sun Dec 14 2003 Jeremy Katz <katzj@redhat.com> 1.0.3-17
- fix build with minimal glibc-kernheaders

* Thu Dec 11 2003 Florian La Roche <Florian.LaRoche@redhat.de> 1.0.3-16
- remove man8 man-pages to not conflict with lvm2 rpm

* Tue Jun 17 2003 Jeremy Katz <katzj@redhat.com> 1.0.3-15
- add patch to work with viodasd
- improve fix for vgscan segfaults to work correctly on big endian platforms

* Thu Jun 12 2003 Jeremy Katz <katzj@redhat.com> 1.0.3-14
- stop making all kinds of silly assumptions and using msdos partition 
  table parsing.  just use BLKGETSIZE and be happy (#97275)

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Feb 19 2003 Bill Nottingham <notting@redhat.com> 1.0.3-12
- don't set SIGCHLD to SIG_IGN and call wait() (#84100)

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Wed Nov 27 2002 Tim Powers <timp@redhat.com> 1.0.3-10
- lib64'ize
- remove unpackaged files from the buildroot

* Mon Sep 02 2002 Michael Fulbright <msf@redhat.com> 1.0.3-9
- Fix vgscan to not segfault from corrupt data on disk (if disk was reformatted
  and some LVM structures still exist, will die trying to parse)

* Thu Jul 11 2002 Trond Eivind Glomsrd <teg@redhat.com> 1.0.3-7
- Fix pvscan.8 - it was the pvcreate one (#66273)

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Mar 27 2002 Trond Eivind Glomsrd <teg@redhat.com> 1.0.3-4
- Have a cookie

* Wed Feb 20 2002 Trond Eivind Glomsrd <teg@redhat.com> 1.0.3-2
- sct's patch updated

* Tue Feb 19 2002 Trond Eivind Glomsrd <teg@redhat.com> 1.0.3-1
- 1.0.3
- Redo most patches. 

* Mon Feb 18 2002 Trond Eivind Glomsrd <teg@redhat.com> 1.0.2-2
- Make it build with new kernel headers
- Hey ho, hey ho, off into the buildsystem we go (with sct's changes)
- Added URL

* Thu Feb 14 2002 Stephen C. Tweedie <sct@redhat.com>
- Add support for new (non-data-corrupting) pvmove kernel ioctl

* Mon Jan 28 2002 Jeremy Katz <katzj@redhat.com>
- update to 1.0.2
- add a static vgwrapper which can run both vgchange and vgscan for
  initrds; uses diet on i386

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Fri Jan 04 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- remove the "mawk" requirement

* Mon Dec 17 2001 Trond Eivind Glomsrd <teg@redhat.com> 1.0.1-1
- 1.0.1
- s/Copyright/License/
- patch away evil use of user/group during installation
- change install procedure

* Wed Jan 24 2001 Than Ngo <than@redhat.com>
- updated to 0.9
- hacked for building on ia64 and sparc

* Mon Dec 11 2000 Bill Nottingham <notting@redhat.com>
- build library code with -fPIC
 
* Wed Nov  1 2000 Matt Wilson <msw@redhat.com>
- initialization of spec file.
