/*
   +----------------------------------------------------------------------+
   | PHP version 4.0                                                      |
   +----------------------------------------------------------------------+
   | Copyright (c) 1997, 1998, 1999, 2000, 2001 The PHP Group             |
   | Copyright (c) 2001-2005 Voluna Software. All rights reserved.        |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.02 of the PHP license,      |
   | that is bundled with this package in the file LICENSE, and is        |
   | available at through the world-wide-web at                           |
   | http://www.php.net/license/2_02.txt.                                 |
   | If you did not receive a copy of the PHP license and are unable to   |
   | obtain it through the world-wide-web, please send a note to          |
   | license@php.net so we can mail you a copy immediately.               |
   +----------------------------------------------------------------------+
   | Authors:                                                             |
   |                                                                      |
   +----------------------------------------------------------------------+
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <grp.h>
#include <pwd.h>
#include <sys/types.h>
#include <netdb.h>

#include "php.h"
#include "php_ini.h"
#include "ext/standard/info.h"
#include "php_openfiler.h"

/* True global resources - no need for thread safety here */
static int le_openfiler;

function_entry openfiler_functions[] =
{
	PHP_FE(getgrent,	NULL)
	PHP_FE(endgrent,	NULL)
	PHP_FE(getpwent,	NULL)
	PHP_FE(endpwent,	NULL)
	PHP_FE(getnetent,	NULL)
	PHP_FE(endnetent,	NULL)
	{NULL, NULL, NULL}	/* Must be the last line in openfiler_functions[] */
};

zend_module_entry openfiler_module_entry =
{
	STANDARD_MODULE_HEADER,
	"openfiler",
	openfiler_functions,
	PHP_MINIT(openfiler),
	PHP_MSHUTDOWN(openfiler),
	PHP_RINIT(openfiler),		/* Replace with NULL if there's nothing to do at request start */
	PHP_RSHUTDOWN(openfiler),	/* Replace with NULL if there's nothing to do at request end */
	PHP_MINFO(openfiler),
    "0.1", /* Replace with version number for your extension */
	STANDARD_MODULE_PROPERTIES
};

#ifdef COMPILE_DL_OPENFILER
ZEND_GET_MODULE(openfiler)
#endif

PHP_MINIT_FUNCTION(openfiler)
{
	return SUCCESS;
}

PHP_MSHUTDOWN_FUNCTION(openfiler)
{
	return SUCCESS;
}

PHP_RINIT_FUNCTION(openfiler)
{
	return SUCCESS;
}

PHP_RSHUTDOWN_FUNCTION(openfiler)
{
	return SUCCESS;
}

PHP_MINFO_FUNCTION(openfiler)
{
	php_info_print_table_start();
	php_info_print_table_row(2, "Openfiler support", "Enabled");
	php_info_print_table_row(2, "Version", "0.1");
	php_info_print_table_end();
}

PHP_FUNCTION(getgrent)
{
	struct group *grent;
	zval *gr_mem;
	char **gm_ptr;
	
	if (ZEND_NUM_ARGS() != 0)
	{
		WRONG_PARAM_COUNT;
	}
	
	if (array_init(return_value) == FAILURE)
	{
		php_error(E_WARNING, "getgrent: unable to allocate memory");
		RETURN_NULL();
	}

	MAKE_STD_ZVAL(gr_mem);

	if (array_init(gr_mem) == FAILURE)
	{
		php_error(E_WARNING, "getgrent: unable to allocate memory");
		RETURN_NULL();
	}

	if ((grent = getgrent()) == NULL)
	{
		RETURN_NULL();
	}

	gm_ptr = grent->gr_mem;
	
	while (*gm_ptr != NULL)
	{
		add_next_index_string(gr_mem, *gm_ptr, 1);
		gm_ptr++;
	}

	add_assoc_string(return_value, "gr_name", grent->gr_name, 1);
	add_assoc_string(return_value, "gr_passwd", grent->gr_passwd, 1);
	add_assoc_long(return_value, "gr_gid", grent->gr_gid);

	if (zend_hash_update(return_value->value.ht, "gr_mem", 7, (void *) &gr_mem, sizeof (zval *), NULL) == FAILURE)
	{
		php_error(E_WARNING, "getgrent: unable to update group members array");
		RETURN_NULL();
	}
}

PHP_FUNCTION(endgrent)
{
	if (ZEND_NUM_ARGS() != 0)
	{
		WRONG_PARAM_COUNT;
	}
	
	endgrent();
}

PHP_FUNCTION(getpwent)
{
	struct passwd *pwent;
	
	if (ZEND_NUM_ARGS() != 0)
	{
		WRONG_PARAM_COUNT;
	}

	if (array_init(return_value) == FAILURE)
	{
		php_error(E_WARNING, "getpwent: unable to allocate memory");
		RETURN_NULL();
	}
	
	if ((pwent = getpwent()) == NULL)
	{
		RETURN_NULL();
	}
	
	add_assoc_string(return_value, "pw_name", pwent->pw_name, 1);
	add_assoc_string(return_value, "pw_passwd", pwent->pw_passwd, 1);
	add_assoc_long(return_value, "pw_uid", pwent->pw_uid);
	add_assoc_long(return_value, "pw_gid", pwent->pw_gid);
	add_assoc_string(return_value, "pw_gecos", pwent->pw_gecos, 1);
	add_assoc_string(return_value, "pw_dir", pwent->pw_dir, 1);
	add_assoc_string(return_value, "pw_shell", pwent->pw_shell, 1);
	
}

PHP_FUNCTION(endpwent)
{
	if (ZEND_NUM_ARGS() != 0) 
	{
		WRONG_PARAM_COUNT;
	}
	
	endpwent();
}

PHP_FUNCTION(getnetent)
{
	struct netent *nent;
	zval *n_aliases;
	char **na_ptr;
	
	if (ZEND_NUM_ARGS() != 0)
	{
		WRONG_PARAM_COUNT;
	}

	if (array_init(return_value) == FAILURE)
	{
		php_error(E_WARNING, "getnetent: unable to allocate memory");
		RETURN_NULL();
	}
	
	MAKE_STD_ZVAL(n_aliases);

	if (array_init(n_aliases) == FAILURE)
	{
		php_error(E_WARNING, "getnetent: unable to allocate memory");
		RETURN_NULL();
	}

	if ((nent = getnetent()) == NULL)
	{
		RETURN_NULL();
	}
	
	na_ptr = nent->n_aliases;
	
	while (*na_ptr != NULL)
	{
		add_next_index_string(n_aliases, *na_ptr, 1);
		na_ptr++;
	}

	add_assoc_string(return_value, "n_name", nent->n_name, 1);
	add_assoc_long(return_value, "n_addrtype", nent->n_addrtype);
	add_assoc_long(return_value, "n_net", nent->n_net);

	if (zend_hash_update(return_value->value.ht, "n_aliases", 10, (void *) &n_aliases, sizeof (zval *), NULL) == FAILURE)
	{
		php_error(E_WARNING, "getnetent: unable to update network aliases array");
		RETURN_NULL();
	}
}

PHP_FUNCTION(endnetent)
{
	if (ZEND_NUM_ARGS() != 0)
	{
		WRONG_PARAM_COUNT;
	}

	endnetent();
}

