<?php
	
	/*
	MGB 0.6 - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2007 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
	*/

        // ========================//
	// functions.inc.php - 1.0 //
	// ========================//
        //
	// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //
	
	
	// checks if email is valid
	if (!function_exists("check_mail"))
		{		
		function check_mail($email)
   			{
			if (eregi("^[a-z0-9]+([-_\.]?[a-z0-9])+@[a-z0-9]+([-_\.]?[a-z0-9])+\.[a-z]{2,4}", $email))
				{
				return TRUE;
				}
			else
				{
				return FALSE;
				}
        		}
        	}
        	
        
        // clean string
	if (!function_exists("cleanstr"))
		{		
		function cleanstr($string)
   			{
			$string = htmlspecialchars(stripslashes(strip_tags(trim($string))), ENT_QUOTES);
			return $string;
			}	
		}
		
	
	// write config file
	//
	// This code is partially taken from phpwcms 1.3.0 released under GNU/GPL. Thanks for that! :)
	if (!function_exists("write_config"))
		{
		function write_config($filename, $text)
			{
			if($fp = fopen($filename, "w"))
				{;
				fwrite($fp, $text);
				fclose($fp);
				return true;	
				}
			else
				{
				return false;
				}
			}
		}
		
	
	// delete quake colorcodes
	//
	// quake colorcodes are no longer supported in 0.6.
	if (!function_exists("delete_quake"))
		{
		function delete_quake($string)
			{
			$string = str_replace("^0", "", $string);
			$string = str_replace("^1", "", $string);
			$string = str_replace("^2", "", $string);
			$string = str_replace("^3", "", $string);
			$string = str_replace("^4", "", $string);
			$string = str_replace("^5", "", $string);
			$string = str_replace("^6", "", $string);
			$string = str_replace("^7", "", $string);
			$string = str_replace("^8", "", $string);
			$string = str_replace("^9", "", $string);
			
			return $string;
			}
		}
		
		
	// turn xhtml breaks to new lines
	if (!function_exists("xhtmlbr2nl"))
		{
		function xhtmlbr2nl($value)
			{			
			$value = preg_replace("/\<br \/>/", "\n", $value);
			return $value;
			}
		}
?>
