<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 *
 * Hub related strings
 *
 * @package   core_hub
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
$string['analyticsactions'] = 'Number of actions taken on generated predictions ({$a})';
$string['analyticsactionsnotuseful'] = 'Number of actions marking a prediction as not useful ({$a})';
$string['analyticsenabledmodels'] = 'Number of enabled prediction models ({$a})';
$string['analyticspredictions'] = 'Number of generated predictions ({$a})';
$string['audience'] = 'Audience';
$string['audience_help'] = 'Select the intended audience for the course.';
$string['audienceeducators'] = 'Educators';
$string['audiencestudents'] = 'Students';
$string['audienceadmins'] = 'Moodle administrators';
$string['badgesnumber'] = 'Number of badges ({$a})';
$string['communityremoved'] = 'That course link has been removed from your list';
$string['confirmregistration'] = 'Confirm registration';
$string['coursename'] = 'Name';
$string['coursepublished'] = 'This course has been shared successfully on \'{$a}\'.';
$string['courseshortname'] = 'Shortname';
$string['courseshortname_help'] = 'Enter a short name for your course. It does not need to be unique.';
$string['coursesnumber'] = 'Number of courses ({$a})';
$string['demourl'] = 'Demo URL';
$string['demourl_help'] = 'Enter the demo URL of your course. By default it is the URL of your course. The demo URL is displayed as a link in a search result.';
$string['downloadable'] = 'Downloadable';
$string['educationallevel'] = 'Educational level';
$string['educationallevel_help'] = 'Select the most appropriate educational level that the course fits into.';
$string['edulevelassociation'] = 'Association';
$string['edulevelcorporate'] = 'Corporate';
$string['edulevelgovernment'] = 'Government';
$string['edulevelother'] = 'Other';
$string['edulevelprimary'] = 'Primary';
$string['edulevelsecondary'] = 'Secondary';
$string['eduleveltertiary'] = 'Tertiary';
$string['emailalert'] = 'Email notifications';
$string['emailalert_help'] = 'If this is enabled the hub administrator will send you emails about security issues and other important news.';
$string['enrollable'] = 'Enrollable';
$string['errorotherhubsnotsupported'] = 'This page can no longer be used for registration with custom sites directories.';
$string['errorws'] = '{$a}';
$string['errorwstokenreset'] = '{$a}. Registration token on this site has been reset. You can now register your site again.';
$string['errorregistrationupdate'] = 'An error occurred during registration update ({$a})';
$string['geolocation'] = 'Geolocation';
$string['geolocation_help'] = 'In future we may provide location-based searching. If you want to specify the location for your course use a latitude/longitude value here (eg: -31.947884,115.871285).  One way to find this is to use Google Maps.';
$string['imageurl'] = 'Image URL';
$string['imageurl_help'] = 'This image will be displayed on the hub. This image must be available from the hub at any moment. The image should have a maximum size of {$a->width} X {$a->height}';
$string['issuedbadgesnumber'] = 'Number of issued badges ({$a})';
$string['language'] = 'Language';
$string['language_help'] = 'The main language of this course.';
$string['lasttimechecked'] = 'Last time checked';
$string['licence'] = 'Licence';
$string['licence_help'] = 'Select the licence you want to distribute your course under.';
$string['licence_link'] = 'licenses';
$string['logourl'] = 'Logo URL';
$string['mobilenotificationsenabled'] = 'Mobile notifications enabled ({$a})';
$string['mobileservicesenabled'] = 'Mobile services enabled ({$a})';
$string['modulenumberaverage'] = 'Average number of course modules ({$a})';
$string['mustselectsubject'] = 'You must select a subject';
$string['name'] = 'Name';
$string['name_help'] = 'This name will be showing in the course listing.';
$string['neverchecked'] = 'Never checked';
$string['next'] = 'Next';
$string['no'] = 'No';
$string['nocheckstatusfromunreghub'] = 'The site is not registered on the hub so the status can not be checked.';
$string['nohubselected'] = 'No hub selected';
$string['none'] = 'None';
$string['operation'] = 'Actions';
$string['participantnumberaverage'] = 'Average number of participants ({$a})';
$string['policyagreed'] = 'Privacy notice and data processing agreement';
$string['policyagreeddesc'] = 'I agree to the <a href="{$a}" target="_blank">Privacy notice and data processing agreement</a>';
$string['postaladdress'] = 'Postal address';
$string['postaladdress_help'] = 'Postal address of this site, or of the entity represented by this site.';
$string['postsnumber'] = 'Number of posts ({$a})';
$string['previousregistrationdeleted'] = 'The previous registration has been deleted from {$a}. You can restart the registration process. Thank you.';
$string['questionsnumber'] = 'Number of questions ({$a})';
$string['registeredcourses'] = 'Registered courses';
$string['registeredsites'] = 'Registered sites';
$string['registrationinfo'] = 'Registration information';
$string['registereduserdevices'] = 'Number of users with registered mobile devices ({$a})';
$string['registeredactiveuserdevices'] = 'Number of active users with registered mobile devices which are receiving notifications ({$a})';
$string['registerwithmoodleorg'] = 'Register your site';
$string['registerwithmoodleorgupdate'] = 'Update your site registration';
$string['registerwithmoodleorgcomplete'] = 'Complete your site registration';
$string['registerwithmoodleorginfo'] = 'We\'d love to stay in touch and provide you with important things for your Moodle site! By registering:

* You can subscribe to receive notifications of new Moodle releases, security alerts and other important news.
* You can access and activate mobile push notifications from your Moodle site through our free Moodle app.
* You are contributing to our Moodle statistics of the worldwide community, which help us improve Moodle and our community sites.
* If you wish, your site can be included in the list of registered Moodle sites in your country.';
$string['registerwithmoodleorginfoapp'] = 'About the Moodle app';
$string['registerwithmoodleorginfostats'] = 'Moodle statistics';
$string['registerwithmoodleorginfosites'] = 'Other sites in my country';
$string['registerwithmoodleorgremove'] = 'You are going to unregister your site. If you continue, you will no longer have access to important notifications and security alerts. Your users will not be able to receive push notifications from your site to their Moodle mobile app. Are you sure you want to unregister your site?';
$string['registrationconfirmed'] = 'Site registration confirmed';
$string['registrationconfirmedon'] = 'Thank you for registering your site. Registration information will be kept up to date by the \'Site registration\' scheduled task.';
$string['renewregistration'] = 'Renew registration';
$string['resourcesnumber'] = 'Number of resources ({$a})';
$string['restartregistration'] = 'Restart registration';
$string['roleassignmentsnumber'] = 'Number of role assignments ({$a})';
$string['search'] = 'Search';
$string['sendingsize'] = 'Please wait the course file is uploading ({$a->total}Mb)...';
$string['sendfollowinginfo'] = 'More information';
$string['sendfollowinginfo_help'] = 'The following information will be sent to Moodle each time your site registration is updated (by default weekly, when the \'Site registration\' scheduled task is run). The information contributes to overall statistics only and will not be made public on any site listing.';
$string['sent'] = '...finished';
$string['siteadmin'] = 'Administrator';
$string['siteadmin_help'] = 'The full name of the site administrator.';
$string['sitecommnews'] = 'Moodle newsletter';
$string['sitecommnews_help'] = 'You have the option of subscribing to our Moodle newsletter. You may unsubscribe at any time.';
$string['sitecommnewsno'] = 'No, I do not wish to receive any emails';
$string['sitecommnewsyes'] = 'Yes, I would like to receive the Moodle newsletter';
$string['sitecountry'] = 'Country';
$string['sitecountry_help'] = 'The country your organisation or institution is located in.';
$string['sitedesc'] = 'Description';
$string['sitedesc_help'] = 'Provide some information about how you are using Moodle.';
$string['sitegeolocation'] = 'Geolocation';
$string['sitegeolocation_help'] = 'In future we may provide location-based searching in the hubs. If you want to specify the location for your site use a latitude/longitude value here (eg: -31.947884,115.871285).  One way to find this is to use Google Maps.';
$string['siteemail'] = 'Admin email address';
$string['siteemail_help'] = 'An email address is necessary so that Moodle HQ can contact you if required.  It may also be used for other purposes as you allow below.    We recommend a generic email address related to a position (eg.: sitemanager@example.com), not a personal address.';
$string['sitelang'] = 'Language';
$string['sitelang_help'] = 'What is the main language used on your Moodle site?';
$string['sitename'] = 'Name';
$string['sitename_help'] = 'The name of the site will be shown on the site listing if the hub allows that.';
$string['sitephone'] = 'Phone';
$string['sitephone_help'] = 'Your phone number will only be seen by the hub administrator.';
$string['siteprivacy'] = 'Site listing';
$string['siteprivacy_help'] = 'You can choose to have your site listed publicly in the list of registered sites, with or without a link to your site.';
$string['siteprivacynotpublished'] = 'Do not list my site';
$string['siteprivacypublished'] = 'Only display my site name';
$string['siteprivacylinked'] = 'Display my site name with the link';
$string['siteregistrationcontact'] = 'Display contact form';
$string['siteregistrationcontact_help'] = 'If you allow it, other people in our Moodle community (who need a login account) can contact you via a form on our Moodle community site. However, they will never be able to see your email address.';
$string['siteregistrationemail'] = 'Notifications of new Moodle releases, security alerts and other important news';
$string['siteregistrationemail_help'] = 'You have the option of subscribing to our low-volume mailing list for notifications of new Moodle releases, security alerts and other important news. You may unsubscribe at any time.';
$string['siteregistrationupdated'] = 'Site registration updated';
$string['siterelease'] = 'Moodle release';
$string['sitereleasenum'] = 'Moodle release ({$a})';
$string['siterelease_help'] = 'Moodle release number of this site.';
$string['siteurl'] = 'Site URL';
$string['siteurl_help'] = 'The URL is the address of this site.  If privacy settings allow people to see site addresses then this is the URL that will be used.';
$string['siteversion'] = 'Moodle version';
$string['siteversion_help'] = 'The Moodle version of this site.';
$string['skipregistration'] = 'Skip';
$string['subject'] = 'Subject';
$string['subject_help'] = 'Select the main subject area which the course covers.';
$string['type'] = 'Shared';
$string['unregister'] = 'Unregister';
$string['unregistrationerror'] = 'An error occurred while attempting to unregister the site: {$a}';
$string['update'] = 'Update';
$string['updatesiteregistration'] = 'Update registration';
$string['usedifferentemail'] = 'Use different email';
$string['urlalreadyregistered'] = 'Your site seems to be already registered, which means something has gone wrong. Please contact the sites directory administrator to reset your registration so you can try again.';
$string['usersnumber'] = 'Number of users ({$a})';
$string['wrongtoken'] = 'The registration failed for some unknown reason (network?). Please try again.';

// Deprecated since Moodle 3.8.
$string['addscreenshots'] = 'Add screenshots';
$string['advertise'] = 'Share this course for people to join';
$string['advertised'] = 'For people to join';
$string['advertiseon'] = 'Share this course on {$a}';
$string['readvertiseon'] = 'Update advertising information on {$a}';
$string['advertisepublication_help'] = 'This course will be listed on Moodle.net as a course that people can enrol in and participate. Email-based self-registration should be enabled on the site and you need to enable self enrolment in this course.';
$string['completeregistration'] = 'Complete registration with Moodle.net';
$string['courseunpublished'] = 'The course {$a->courseshortname} is no longer shared on {$a->hubname}.';
$string['courseurl'] = 'Course URL';
$string['courseurl_help'] = 'It is the URL of your course. This URL is displayed as a link in a search result.';
$string['creatorname'] = 'Creator';
$string['creatorname_help'] = 'The creator is the course creator.';
$string['creatornotes'] = 'Creator notes';
$string['creatornotes_help'] = 'Creator notes are a guide for teachers on how to use the course.';
$string['contributornames'] = 'Other contributors';
$string['contributornames_help'] = 'You can use this field to list the names of anyone else who contributed to this course.';
$string['deletescreenshots'] = 'Delete these screenshots';
$string['deletescreenshots_help'] = 'Delete all the currently uploaded screenshots.';
$string['description'] = 'Description';
$string['description_help'] = 'This description text will be showing in the course listing on Moodle.net.';
$string['detectednotexistingpublication'] = '{$a->hubname} is listing a course that does not exist any more. Alert {$a->hubname} administrator that the publication number {$a->id} should be removed.';
$string['errorcoursepublish'] = 'An error occurred during the course publication ({$a}). Please try again later.';
$string['errorcourseinfo'] = 'An error occurred when retrieving course metadata from {$a}. Please try again to retrieve the course metadata by reloading this page later. Otherwise you can decide to continue the registration process with the following default metadata. ';
$string['errorcoursewronglypublished'] = 'A publication error has been returned by Moodle.net. Please try again later.';
$string['errorbadimageheightwidth'] = 'The image should have a maximum size of {$a->width} X {$a->height}';
$string['errorregistration'] = 'An error occurred during registration, please try again later. ({$a})';
$string['errorunpublishcourses'] = 'Due to an unexpected error, the courses could not be deleted from Moodle.net. Try again later (recommended) or contact Moodle.net administrator.';
$string['existingscreenshotnumber'] = '{$a} existing screenshots. You will be able to see these screenshots on this page, only once the Moodle.net administrator enables your course.';
$string['existingscreenshots'] = 'Existing screenshots';
$string['nosearch'] = 'Don\'t publish hub or courses';
$string['notregisteredonhub'] = 'Your administrator needs to register this site with Moodle.net before you can share a course.';
$string['publicationinfo'] = 'Course publication information';
$string['publish'] = 'Share';
$string['publishcourse'] = 'Share {$a}';
$string['publishcourseon'] = 'Share on {$a}';
$string['publishedon'] = 'Course sharing';
$string['publisheremail'] = 'Publisher email';
$string['publisheremail_help'] = 'The publisher email address allows the hub administrator to alert the publisher about any changes to the status of the published course.';
$string['publishername'] = 'Publisher';
$string['publishername_help'] = 'The publisher is the person or organisation that is the official publisher of the course.  Unless you are publishing it on behalf of someone else, it will usually be you.';
$string['registersite'] = 'Register with {$a}';
$string['removefromhub'] = 'Remove from Moodle.net';
$string['screenshots'] = 'Screenshots';
$string['screenshots_help'] = 'Any screenshots of the course will be displayed in search results.';
$string['sendingcourse'] = 'Sending course';
$string['share'] = 'Share this course for people to download';
$string['shared'] = 'For people to download';
$string['shareon'] = 'Upload this course to {$a}';
$string['sharepublication_help'] = 'A backup of this course will be available on Moodle.net for people to restore and use on their own site.';
$string['status'] = 'Listing status';
$string['statuspublished'] = 'Listed';
$string['statusunpublished'] = 'Not listed';
$string['tags'] = 'Tags';
$string['tags_help'] = 'Tags help to further categorise your course and help it to be found. Please use simple, meaningful words and separate them with a comma. Example: math, algebra, geometry';
$string['unpublish'] = 'Stop sharing';
$string['unpublishalladvertisedcourses'] = 'Remove all courses that were shared on Moodle.net for people to join';
$string['unpublishalluploadedcourses'] = 'Remove all courses that were shared on Moodle.net for people to download';
$string['unpublishconfirmation'] = 'Do you really want to remove the course "{$a->courseshortname}" from "{$a->hubname}"';
$string['unpublishcourse'] = 'Stop sharing {$a}';
$string['updatesite'] = 'Update registration on {$a}';
$string['updatestatus'] = 'Check it now.';
$string['unregisterfrom'] = 'Unregister from {$a}';
$string['unregisterexplained'] = 'If the site with URL {$a} is registered, then its registration will be removed.';