<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   core
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['accessdenied'] = 'Access denied';
$string['accounts'] = 'Accounts';
$string['addcategory'] = 'Add a category';
$string['additionalhtml'] = 'Additional HTML';
$string['additionalhtml_heading'] = 'Additional HTML to be added to every page.';
$string['additionalhtml_desc'] = 'These settings allow you to specify HTML that you want added to every page. You can set HTML that will be added within the HEAD tag for the page, immediately after the BODY tag has been opened, or immediately before the body tag is closed.<br />Doing this allows you to add custom headers or footers on every page, or add support for services like Google Analytics very easily, independent of your chosen theme.';
$string['additionalhtmlhead'] = 'Within HEAD';
$string['additionalhtmlhead_desc'] = 'Content here will be added to the bottom of the HEAD tag for every page.';
$string['additionalhtmltopofbody'] = 'When BODY is opened';
$string['additionalhtmltopofbody_desc'] = 'Content here will be added in to every page immediately after the opening body tag.';
$string['additionalhtmlfooter'] = 'Before BODY is closed';
$string['additionalhtmlfooter_desc'] = 'Content here will be added in to every page right before the body tag is closed.';
$string['admincategory'] = 'Category: {$a}';
$string['adminseesall'] = 'Admins see all';
$string['adminseesallevents'] = 'Administrators see all events';
$string['adminseesownevents'] = 'Administrators are just like other users';
$string['advancedfeatures'] = 'Advanced features';
$string['agedigitalconsentverification'] = 'Digital age of consent verification';
$string['agedigitalconsentverification_desc'] = 'Enables verification of the digital age of consent before displaying the sign-up page for self-registration users. This protects your site from minors signing up without parental/guardian consent. <a target="_blank" href="{$a}">Support contact</a> details are provided to minors for further assistance.';
$string['ageofdigitalconsentmap'] = 'Digital age of consent';
$string['ageofdigitalconsentmap_desc'] = 'The default digital age of consent, and the age in any country where it differs from the default, may be specified here. Enter each age on a new line with format: country code, age (separated by a comma). The default age is indicated by * in place of the country code. Country codes are as specified in ISO 3166-2.';
$string['allcountrycodes'] = 'All country codes';
$string['allowattachments'] = 'Allow attachments';
$string['allowbeforeblock'] = 'Allowed list will be processed first';
$string['allowbeforeblockdesc'] = 'By default, entries in the blocked IPs list are matched first. If this option is enabled, entries in the allowed IPs list are processed before the blocked list.';
$string['allowcategorythemes'] = 'Allow category themes';
$string['allowcohortthemes'] = 'Allow cohort themes';
$string['allowcoursethemes'] = 'Allow course themes';
$string['allowediplist'] = 'Allowed IP list';
$string['allowedemaildomains'] = 'Allowed email domains';
$string['allowemailaddresses'] = 'Allowed email domains';
$string['allowemojipicker'] = 'Emoji picker';
$string['allowindexing'] = 'Allow indexing by search engines';
$string['allowindexing_desc'] = 'This determines whether to allow search engines to index your site. "Everywhere" will allow the search engines to search everywhere including login and signup pages, which means sites with Force Login turned on are still indexed. To avoid the risk of spam involved with the signup page being searchable, use "Everywhere except login and signup pages". "Nowhere" will tell search engines not to index any page. Note this is only a tag in the header of the site. It is up to the search engine to respect the tag.';
$string['allowindexingeverywhere'] = 'Everywhere';
$string['allowindexingexceptlogin'] = 'Everywhere except login and signup pages';
$string['allowindexingnowhere'] = 'Nowhere';
$string['allowusermailcharset'] = 'Allow user to select character set';
$string['allowframembedding'] = 'Allow frame embedding';
$string['allowframembedding_help'] = 'If enabled, this site may be embedded in a frame in a remote system, as recommended when using the \'Publish as LTI tool\' enrolment plugin. Otherwise, it is recommended to leave frame embedding disabled for security reasons. Please note that for the mobile app this setting is ignored and frame embedding is always allowed.';
$string['allowguestmymoodle'] = 'Allow guest access to Dashboard';
$string['allowobjectembed'] = 'Allow EMBED and OBJECT tags';
$string['allowthemechangeonurl'] = 'Allow theme changes in the URL';
$string['allowuserblockhiding'] = 'Allow users to hide blocks';
$string['allowuserswitchrolestheycantassign'] = 'Allow users without the assign roles capability to switch roles';
$string['allowuserthemes'] = 'Allow user themes';
$string['alternativefullnameformat'] = 'Alternative full name format';
$string['alternativefullnameformat_desc'] = 'This defines how names are shown to users with the viewfullnames capability (by default users with the role of manager, teacher or non-editing teacher). Placeholders that can be used are as for the "Full name format" setting.';
$string['always'] = 'Always';
$string['appearance'] = 'Appearance';
$string['aspellpath'] = 'Path to aspell';
$string['authentication'] = 'Authentication';
$string['authpreventaccountcreation'] = 'Prevent account creation when authenticating';
$string['authpreventaccountcreation_help'] = 'When a user authenticates, an account on the site is automatically created if it doesn\'t yet exist. If an external database, such as LDAP, is used for authentication, but you wish to restrict access to the site to users with an existing account only, then this option should be enabled. New accounts will need to be created manually or via the upload users feature. Note that this setting doesn\'t apply to MNet authentication.';
$string['authsettings'] = 'Manage authentication';
$string['autolang'] = 'Language autodetect';
$string['autologinguests'] = 'Auto-login guests';
$string['searchareas'] = 'Search areas';
$string['availableto'] = 'Available to';
$string['backgroundcolour'] = 'Transparent colour';
$string['backups'] = 'Backups';
$string['backup_shortname'] = 'Use course name in backup filename';
$string['backup_shortnamehelp'] = 'Use the course name as part of the backup filename.';
$string['badwordsconfig'] = 'Enter your list of bad words separated by commas.';
$string['badwordsdefault'] = 'If the custom list is empty, a default list from the language pack will be used.';
$string['badwordslist'] = 'Custom bad words list';
$string['blockediplist'] = 'Blocked IP List';
$string['blockinstances'] = 'Instances';
$string['blockmultiple'] = 'Multiple';
$string['blockprotect'] = 'Protect instances';
$string['blockprotect_help'] = 'If you lock a particular type of block, then no-one will be able to add or delete instances. (You can, of course, unlock again if you need to edit instances.)

This is intended to protect blocks like the navigation and settings which are very hard to get back if accidentally deleted.';
$string['blockunprotect'] = 'Unprotect';
$string['blocksettings'] = 'Manage blocks';
$string['bloglevel'] = 'Blog visibility';
$string['bookmarkadded'] = 'Bookmark added.';
$string['bookmarkalreadyexists'] = 'You have already bookmarked this page.';
$string['bookmarkdeleted'] = 'Bookmark deleted.';
$string['bookmarkthispage'] = 'Bookmark this page';
$string['cachejs'] = 'Cache Javascript';
$string['cachejs_help'] = 'Javascript caching and compression greatly improves page loading performance. it is strongly recommended for production sites. Developers will probably want to disable this feature.';
$string['cachetemplates'] = 'Cache templates';
$string['cachetemplates_help'] = 'Template caching will improve page loading performance and is strongly recommended for production sites. Developers will probably want to disable this feature.';
$string['calendarexportsalt'] = 'Calendar export salt';
$string['calendarsettings'] = 'Calendar';
$string['calendartype'] = 'Calendar type';
$string['calendartype_desc'] = 'Choose a default calendar type for the whole site. This setting can be overridden in the course settings or by users in their personal profile.';
$string['calendar_weekend'] = 'Weekend days';
$string['cannotdeletemodfilter'] = 'You cannot uninstall the \'{$a->filter}\' because it is part of the \'{$a->module}\' module.';
$string['cannotuninstall'] = '{$a} can not be uninstalled.';
$string['categoryemail'] = 'Email';
$string['cfgwwwrootslashwarning'] = '$CFG->wwwroot is defined incorrectly in the config.php file. It includes a \'/\' character at the end which must be removed.';
$string['cfgwwwrootwarning'] = '$CFG->wwwroot is defined incorrectly in the config.php file. It should match the URL you are using to access this page.';
$string['checkupgradepending'] = 'Upgrade';
$string['cleanup'] = 'Cleanup';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Exiting gracefully, please wait ...';
$string['cliexitnow'] = 'Exiting right NOW';
$string['cliincorrectvalueerror'] = 'Error, incorrect value "{$a->value}" for "{$a->option}"';
$string['cliincorrectvalueretry'] = 'Incorrect value, please retry';
$string['clistatusdisabled'] = 'Status: disabled';
$string['clistatusenabled'] = 'Status: enabled';
$string['clistatusenabledlater'] = 'status: CLI maintenance mode will be enabled on {$a}';
$string['clitypevalue'] = 'type value';
$string['clitypevaluedefault'] = 'type value, press Enter to use default value ({$a})';
$string['cliunknowoption'] = 'Unrecognised options:
  {$a}
Please use --help option.';
$string['cliupgradedefault'] = 'New setting: {$a}';
$string['cliupgradedefaultheading'] = 'Setting new default values';
$string['cliupgradedefaultverbose'] = 'New setting: {$a->name}, Default value: {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Command line upgrade from {$a->oldversion} to {$a->newversion} completed successfully.';
$string['cliupgradenoneed'] = 'No upgrade needed for the installed version {$a}. Thanks for coming anyway!';
$string['cliupgradepending'] = 'An upgrade is pending';
$string['cliyesnoprompt'] = 'type y (means yes) or n (means no)';
$string['commentsperpage'] = 'Comments displayed per page';
$string['commonactivitysettings'] = 'Common activity settings';
$string['commonfiltersettings'] = 'Common filter settings';
$string['commonsettings'] = 'Common settings';
$string['componentinstalled'] = 'Component installed';
$string['computedfromlogs'] = 'Computed from logs since {$a}.';
$string['condifmodeditdefaults'] = 'Default values are used in the settings form when creating a new activity or resource.';
$string['confeditorhidebuttons'] = 'Select the buttons that should be hidden in the HTML editor.';
$string['configallowattachments'] = 'If enabled, emails sent from the site can have attachments, such as badges.';
$string['configenableactivitychooser'] = 'The activity chooser is a dialog box with a short description of each activity and resource. If disabled, separate resource and activity drop-down menus are provided instead.';
$string['configallcountrycodes'] = 'This is the list of countries that may be selected in various places, for example in a user\'s profile. If blank (the default) the list in countries.php in the standard English language pack is used. That is the list from ISO 3166-1. Otherwise, you can specify a comma-separated list of codes, for example \'GB,FR,ES\'. If you add new, non-standard codes here, you will need to add them to countries.php in \'en\' and your language pack.';
$string['configallowassign'] = 'You can allow people who have the roles on the left side to assign some of the column roles to other people';
$string['configallowcategorythemes'] = 'If you enable this, then themes can be set at the category level. This will affect all child categories and courses unless they have specifically set their own theme. WARNING: Enabling category themes may affect performance.';
$string['configallowcohortthemes'] = 'If you enable this, then themes can be set at the cohort level. This will affect all users with only one cohort or more than one but with the same theme.';
$string['configallowcoursethemes'] = 'If enabled, then courses will be allowed to set their own themes.  Course themes override all other theme choices (site, user, category, cohort or URL-defined themes).';
$string['configallowedemaildomains'] = 'List email domains that are allowed to be disclosed in the "From" section of outgoing email. The default of "Empty" will use the No-reply address for all outgoing email. The use of wildcards is allowed e.g. *.example.com will allow emails sent from any subdomain of example.com, but not example.com itself. This will require separate entry.';
$string['configallowemailaddresses'] = 'To restrict new email addresses to particular domains, list them here separated by spaces. All other domains will be rejected. To allow subdomains, add the domain with a preceding \'.\'. To allow a root domain together with its subdomains, add the domain twice - once with a preceding \'.\' and once without e.g. .ourcollege.edu.au ourcollege.edu.au.';
$string['configallowemojipicker'] = 'The emoji picker enables users to select emojis, such as smilies, to add to messages and other text areas via an emoji picker button in the Atto toolbar.';
$string['configallowemojipickerincompatible'] = 'Your current database configuration does not properly support emojis. In order to enable the emoji picker you will need to <a href="https://docs.moodle.org/en/MySQL_full_unicode_support">upgrade your database for full unicode support</a>.';
$string['configallowguestmymoodle'] = 'If enabled guests can access Dashboard, otherwise guests are redirected to the site front page.';
$string['configallowobjectembed'] = 'As a default security measure, normal users are not allowed to embed multimedia (like Flash) within texts using explicit EMBED and OBJECT tags in their HTML (although it can still be done safely using the mediaplugins filter).  If you wish to allow these tags then enable this option.';
$string['configallowoverride'] = 'You can allow people with the roles on the left side to override some of the column roles';
$string['configallowoverride2'] = 'Select which role(s) can be overridden by each role in the left column.<br />Note that these settings only apply to users who have either the capability moodle/role:override or the capability moodle/role:safeoverride allowed.';
$string['configallowswitch'] = 'Select which roles a user may switch to, based on which roles they already have. In addition to an entry in this table, a user must also have the moodle/role:switchroles capability to be able to switch.<br />Note that it is only possible to switch to roles that have the moodle/course:view capability, and that do not have the moodle/site:doanything capability, so some columns in this table are disabled.';
$string['configallowthemechangeonurl'] = 'If enabled, the theme can be changed by adding either:<br />?theme=themename to any Moodle URL (eg: mymoodlesite.com/?theme=afterburner ) or <br />&theme=themename to any internal Moodle URL (eg: mymoodlesite.com/course/view.php?id=2&theme=afterburner ).';
$string['configallowuserblockhiding'] = 'Do you want to allow users to hide/show side blocks throughout this site?  This feature uses Javascript and cookies to remember the state of each collapsible block, and only affects the user\'s own view.';
$string['configallowusermailcharset'] = 'If enabled, users can choose an email charset in their messaging preferences.';
$string['configallowuserswitchrolestheycantassign'] = 'By default, moodle/role:assign is required for users to switch roles. Enabling this setting removes this requirement, and results in the roles available in the "Switch role to" dropdown menu being determined by settings in the "Allow role assignments" table only.
It is recommended that the settings in the "Allow role assignments" table do not allow users to switch to a role with more capabilities than their existing role.';
$string['configallowuserthemes'] = 'If you enable this, then users will be allowed to set their own themes.  User themes override site themes (but not course themes)';
$string['configallowview'] = 'Select which roles a user will see, be able to filter by etc. based on which roles they already have.';
$string['configallusersaresitestudents'] = 'For activities on the front page of the site, should ALL users be considered as students?  If you answer "Yes", then any confirmed user account will be allowed to participate as a student in those activities.  If you answer "No", then only users who are already a participant in at least one course will be able to take part in those front page activities. Only admins and specially assigned teachers can act as teachers for these front page activities.';
$string['configauthenticationplugins'] = 'Please choose the authentication plugins you wish to use and arrange them in order of failthrough.';
$string['configautolang'] = 'Detect default language from browser setting, if disabled site default is used.';
$string['configautologinguests'] = 'Should visitors be logged in as guests automatically when entering courses with guest access?';
$string['configbloglevel'] = 'This setting allows you to restrict the level to which user blogs can be viewed on this site.  Note that they specify the maximum context of the VIEWER not the poster or the types of blog posts.  Blogs can also be disabled completely if you don\'t want them at all.';
$string['configcalendarcustomexport'] = 'Enable custom date range export of calendar';
$string['configcalendarexportsalt'] = 'This random text is used for improving of security of authentication tokens used for exporting of calendars. Please note that all current tokens are invalidated if you change this hash salt.';
$string['configcookiehttponly'] = 'Enables new PHP 5.2.0 feature - browsers are instructed to send cookie with real http requests only, cookies should not be accessible by scripting languages. This is not supported in all browsers and it may not be fully compatible with current code. It helps to prevent some types of XSS attacks.';
$string['configcookiesecure'] = 'If server is accepting only https connections it is recommended to enable sending of secure cookies. If enabled please make sure that web server is not accepting http:// or set up permanent redirection to https:// address and ideally send HSTS headers. When <em>wwwroot</em> address does not start with https:// this setting is ignored.';
$string['configcountry'] = 'If you set a country here, then this country will be selected by default on new user accounts.  To force users to choose a country, just leave this unset.';
$string['configcoursegraceperiodafter'] = 'Classify past courses as in progress for these many days after the course end date.';
$string['configcoursegraceperiodbefore'] = 'Classify future courses as in progress for these many days prior to the course start date.';
$string['configcourseoverviewfilesext'] = 'A comma-separated list of allowed course image file extensions.';
$string['configcourseoverviewfileslimit'] = 'The maximum number of files that can be displayed next to the course summary on the list of courses page. The first image file added is used as the course image in the course overview on users\' Dashboards; any additional files are displayed on the list of courses page only.';
$string['configcourserequestnotify'] = 'Type username of user to be notified when new course requested.';
$string['configcourserequestnotify2'] = 'Users who will be notified when a course is requested. Only users who can approve course requests are listed here.';
$string['configcoursesperpage'] = 'Enter the number of courses to be displayed per page in a course listing.';
$string['configcourseswithsummarieslimit'] = 'The maximum number of courses to display in a course listing including summaries before falling back to a simpler listing.';
$string['configcronclionly'] = 'Running the cron from a web browser can expose privileged information to anonymous users. Thus it is recommended to only run the cron from the command line or set a cron password for remote access.';
$string['configcronremotepassword'] = 'This means that the cron.php script cannot be run from a web browser without supplying the password using the following form of URL:<pre> https://site.example.com/admin/cron.php?password=opensesame </pre>If this is left empty, no password is required.';
$string['configcurlcache'] = 'Time-to-live for cURL cache, in seconds.';
$string['configcustommenuitems'] = 'A custom menu may be configured here. Enter each menu item on a new line with format: menu text, a link URL (optional, not for a top menu item with sub-items), a tooltip title (optional) and a language code or comma-separated list of codes (optional, for displaying the line to users of the specified language only), separated by pipe characters. Lines starting with a hyphen will appear as menu items in the previous top level menu and ### makes a divider. For example:
<pre>
Courses
-All courses|/course/
-Course search|/course/search.php
-###
-FAQ|https://someurl.xyz/faq
-Preguntas más frecuentes|https://someurl.xyz/pmf||es
Mobile app|https://someurl.xyz/app|Download our app
</pre>';
$string['configcustomusermenuitems'] = 'You can configure the contents of the user menu (with the exception of the log out link, which is automatically added). Each line is separated by pipe characters and consists of 1) a string in "langstringname, componentname" form or as plain text, 2) a URL, and 3) an icon either as a pix icon (in the folder pix with the structure [subfoldername]/[iconname], e.g. i/publish) or as a URL. Dividers can be used by adding a line of one or more # characters where desired.';
$string['configdbsessions'] = 'If enabled, this setting will use the database to store information about current sessions. Note that changing this setting now will log out all current users (including you). If you are using MySQL please make sure that \'max_allowed_packet\' in my.cnf (or my.ini) is at least 4M. Other session drivers can be configured directly in config.php, see config-dist.php for more information. This option disappears if you specify session driver in config.php file.';
$string['configdebug'] = 'If you turn this on, then PHP\'s error_reporting will be increased so that more warnings are printed.  This is only useful for developers.';
$string['configdebugdisplay'] = 'Set to on, the error reporting will go to the HTML page. This is practical, but breaks XHTML, JS, cookies and HTTP headers in general. Set to off, it will send the output to your server logs, allowing better debugging. The PHP setting error_log controls which log this goes to.';
$string['configdebugpageinfo'] = 'Enable if you want page information printed in page footer.';
$string['configdebugvalidators'] = 'Enable if you want to have links to external validator servers in page footer. You may need to create new user with username <em>w3cvalidator</em>, and enable guest access. These changes may allow unauthorized access to server, do not enable on production sites!';
$string['configdefaulthomepage'] = 'This determines the first link in the navigation for logged-in users.';
$string['configdefaultrequestcategory'] = 'Courses requested by users with the capability to request new courses in the system context will be placed in this category unless users are able to select a different category.';
$string['configdefaultrequestedcategory'] = 'Default category to put courses that were requested into, if they\'re approved.';
$string['configdefaultuserroleid'] = 'All logged in users will be given the capabilities of the role you specify here, at the site level, in ADDITION to any other roles they may have been given.  The default is the Authenticated user role.  Note that this will not conflict with other roles they have unless you prohibit capabilities, it just ensures that all users have capabilities that are not assignable at the course level (eg post blog entries, manage own calendar, etc).';
$string['configdeleteincompleteusers'] = 'After this period, any account without the first name, last name or email field filled in is deleted.';
$string['configdeleteunconfirmed'] = 'For certain authentication methods, such as email-based self-registration, users must confirm their account within a certain time. After this period, any old unconfirmed accounts are deleted.';
$string['configdenyemailaddresses'] = 'To deny email addresses from particular domains list them here in the same way.  All other domains will be accepted. To deny subdomains add the domain with a preceding \'.\'. eg <strong>hotmail.com yahoo.co.uk .live.com</strong>';
$string['configenableanalytics'] = 'Analytics models, such as \'Students at risk of dropping out\' or \'Upcoming activities due\', can generate predictions, send insight notifications and offer further actions such as messaging users.';
$string['configenableblogs'] = 'This switch provides all site users with their own blog.';
$string['configenabledevicedetection'] = 'Enables detection of mobiles, smartphones, tablets or default devices (desktop PCs, laptops, etc) for the application of themes and other features.';
$string['configdisableuserimages'] = 'Disable the ability for users to change user profile images.';
$string['configdisplayloginfailures'] = 'This will display information to users about previous failed logins.';
$string['configdndallowtextandlinks'] = 'Enable or disable the dragging and dropping of text and links onto a course page, alongside the dragging and dropping of files. Note that the dragging of text into Firefox or between different browsers is unreliable and may result in no data being uploaded, or corrupted text being uploaded.';
$string['configdoclang'] = 'This language will be used in links for the documentation pages.';
$string['configdocroot'] = 'Defines the path to the Moodle Docs for providing context-specific documentation via \'Moodle Docs for this page\' links in the footer of each page. If the field is left blank, links will not be displayed.';
$string['configdoctonewwindow'] = 'If you enable this, then links to Moodle Docs will be shown in a new window.';
$string['configeditordictionary'] = 'This value will be used if aspell doesn\'t have dictionary for users own language.';
$string['configeditorfontlist'] = 'Select the fonts that should appear in the editor\'s drop-down list.';
$string['configemailchangeconfirmation'] = 'Require an email confirmation step when users change their email address in their profile.';
$string['configemailfromvia'] = 'Add via information in the "From" section of outgoing email. This informs the recipient from where this email came from and also helps combat recipients accidentally replying to no-reply email addresses.';
$string['configemailsubjectprefix'] = 'Text to be prefixed to the subject line of all outgoing mail.';
$string['configenablecalendarexport'] = 'Enable exporting or subscribing to calendars.';
$string['configenablecomments'] = 'Enable comments';
$string['configenablecourserequests'] = 'If enabled, users with the capability to request new courses (moodle/course:request) will have the option to request a course. This capability is not allowed for any of the default roles. It may be applied in the system or category context.';
$string['configenablemobilewebservice'] = 'Enable mobile service for the official Moodle app or other app requesting it. For more information, read the {$a}';
$string['configenablerssfeeds'] = 'If enabled, RSS feeds are generated by various features across the site, such as blogs, forums, database activities and glossaries. Note that RSS feeds also need to be enabled for the particular activity modules.';
$string['configenablerssfeedsdisabled'] = 'It is not available because RSS feeds are disabled in all the Site. To enable them, go to the Variables settings under Admin Configuration.';
$string['configenablerssfeedsdisabled2'] = 'RSS feeds are currently disabled at site level. They may be enabled in Advanced features in the Site administration.';
$string['configenablestats'] = 'If you choose \'yes\' here, Moodle\'s cronjob will process the logs and gather some statistics.  Depending on the amount of traffic on your site, this can take awhile. If you enable this, you will be able to see some interesting graphs and statistics about each of your courses, or on a sitewide basis.';
$string['configenabletrusttext'] = 'By default Moodle will always thoroughly clean text that comes from users to remove any possible bad scripts, media etc that could be a security risk.  The Trusted Content system is a way of giving particular users that you trust the ability to include these advanced features in their content without interference.  To enable this system, you need to first enable this setting, and then grant the Trusted Content permission to a specific Moodle role.  Texts created or uploaded by such users will be marked as trusted and will not be cleaned before display.';
$string['configenablewebservices'] = 'Web services enable other systems, such as the Moodle app, to log in to the site and perform operations. For extra security, the setting should be disabled if you are not using the app, or an external tool/service that requires integration via web services.';
$string['configenablewsdocumentation'] = 'Enable auto-generation of web services documentation. A user can access to his own documentation on his security keys page {$a}. It displays the documentation for the enabled protocols only.';
$string['configerrorlevel'] = 'Choose the amount of PHP warnings that you want to be displayed.  Normal is usually the best choice.';
$string['configexportlookahead'] = 'Days to look ahead during export';
$string['configexportlookback'] = 'Days to look back during export';
$string['configextendedusernamechars'] = 'If enabled, usernames may include any characters except uppercase letters.  Otherwise, only alphanumeric characters with lowercase letters, underscore (_), hyphen (-), period (.) and at symbol (@) are allowed.';
$string['configextramemorylimit'] = 'Some scripts like search, backup/restore or cron require more memory. Set higher values for large sites.';
$string['configfilterall'] = 'Filter all strings, including headings, titles, navigation bar and so on.  This is mostly useful when using the multilang filter, otherwise it will just create extra load on your site for little gain.';
$string['configfiltermatchoneperpage'] = 'Automatic linking filters will only generate a single link for the first matching text instance found on the complete page. All others are ignored.';
$string['configfiltermatchonepertext'] = 'Automatic linking filters will only generate a single link for the first matching text instance found in each item of text on the page. All others are ignored. This setting has no effect if \'Filter match once per page\' is enabled.';
$string['configfilteruploadedfiles'] = 'Process all uploaded HTML and text files with the filters before displaying them, only uploaded HTML files or none at all.';
$string['configforcelogin'] = 'Normally, the front page of the site and the course listings (but not courses) can be read by people without logging in to the site.  If you want to force people to log in before they do ANYTHING on the site, then you should enable this setting.';
$string['configforceloginforprofiles'] = 'This setting forces people to log in as a real (non-guest) account before viewing any user\'s profile. If you disabled this setting, you may find that some users post advertising (spam) or other inappropriate content in their profiles, which is then visible to the whole world.';
$string['configfrontpage'] = 'The items selected above will be displayed on the site\'s front page.';
$string['configfrontpagecourselimit'] = 'Maximum number of courses';
$string['configfrontpagecourselimithelp'] = 'Maximum number of courses to be displayed on the site\'s front page in course listings.';
$string['configfrontpageloggedin'] = 'The items selected above will be displayed on the site\'s front page when a user is logged in.';
$string['configfullnamedisplay'] = 'This defines how names are shown when they are displayed in full. The default value, "language", leaves it to the string "fullnamedisplay" in the current language pack to decide. Some languages have different name display conventions.

For most mono-lingual sites the most efficient setting is "firstname lastname", but you may choose to hide surnames altogether. Placeholders that can be used are: firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, and alternatename.';
$string['configgeoipfile'] = 'Location of GeoLite2 City binary data file. This file is not part of Moodle distribution and must be obtained separately from <a href="https://www.maxmind.com/">MaxMind</a>. You can either buy a commercial version or use the free version. You\'ll need to register to download the City database file, which you can do at <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Once you\'ve registered and downloaded the file, extract it into "{$a}" directory on your server.';
$string['configgetremoteaddrconf'] = 'If your server is behind a reverse proxy, you can use this setting to specify which HTTP headers can be trusted to contain the remote IP address. The headers are read in order, using the first one that is available.';
$string['configgradebookroles'] = 'This setting allows you to control who appears on the gradebook.  Users need to have at least one of these roles in a course to be shown in the gradebook for that course.';
$string['configgradeexport'] = 'Choose which gradebook export formats are your primary methods for exporting grades.  Chosen plugins will then set and use a "last exported" field for every grade.  For example, this might result in exported records being identified as being "new" or "updated".  If you are not sure about this then leave everything unchecked.';
$string['confighiddenuserfields'] = 'Select which user information fields you wish to hide from other users other than course teachers/admins. This will increase student privacy. Hold CTRL key to select multiple fields.';
$string['configidnumber'] = 'This option specifies whether (a) Users are not be asked for an ID number at all, (b) Users are asked for an ID number but can leave it blank or (c) Users are asked for an ID Number and cannot leave it blank. If given the User\'s ID number is displayed in their Profile.';
$string['configintro'] = 'On this page you can specify a number of configuration variables that help make Moodle work properly on your server.  Don\'t worry too much about it - the defaults will usually work fine and you can always come back to this page later and change these settings.';
$string['configintroadmin'] = 'On this page you should configure your main administrator account which will have complete control over the site. Make sure you give it a secure username and password as well as a valid email address.  You can create more admin accounts later on.';
$string['configintrosite'] = 'This page allows you to configure the front page and name of this new site.  You can come back here later to change these settings any time using the Administration menus.';
$string['configiplookup'] = 'When you click on an IP address (such as 34.12.222.93), such as in the logs, you are shown a map with a best guess of where that IP is located.  There are different plugins for this that you can choose from, each has benefits and disadvantages.';
$string['configkeeptagnamecase'] = 'Check this if you want tag names to keep the original casing as entered by users who created them';
$string['configlang'] = 'Choose a default language for the whole site. Users can override this setting using the language menu or the setting in their personal profile.';
$string['configlangstringcache'] = 'Caches all the language strings into compiled files in the data directory.  If you are translating Moodle or changing strings in the Moodle source code then you may want to switch this off.  Otherwise leave it on to see performance benefits.';
$string['configlanglist'] = 'If left blank, all languages installed on the site will be displayed in the language menu. Alternatively, the language menu may be shortened by entering a list of language codes separated by commas e.g. en,de,fr. If desired, a different name for the language than the language pack name may be specified using the format: language code|language name e.g. en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Choose whether or not you want to display the general-purpose language menu on the home page, login page etc.  This does not affect the user\'s ability to set the preferred language in their own profile.';
$string['configlatinexcelexport'] = 'Choose the encoding for Excel exports.';
$string['configlocale'] = 'Choose a sitewide locale - this will override the format and language of dates for all language packs (though names of days in calendar are not affected). You need to have this locale data installed on your operating system (eg for linux en_US.UTF-8 or es_ES.UTF-8). In most cases this field should be left blank.';
$string['configlockrequestcategory'] = 'If enabled, users with the capability to request new courses in the system context will not be able to select a category in the request a new course form. An alternative way of restricting users to requesting a new course in just one category is to apply the capability to request new courses in the category context.';
$string['configloglifetime'] = 'This specifies the length of time you want to keep logs about user activity.  Logs that are older than this age are automatically deleted.  It is best to keep logs as long as possible, in case you need them, but if you have a very busy server and are experiencing performance problems, then you may want to lower the log lifetime. Values lower than 30 are not recommended because statistics may not work properly.';
$string['configlookahead'] = 'Days to look ahead';
$string['configmailnewline'] = 'Newline characters used in mail messages. CRLF is required according to RFC 822bis, some mail servers do automatic conversion from LF to CRLF, other mail servers do incorrect conversion from CRLF to CRCRLF, yet others reject mails with bare LF (qmail for example). Try changing this setting if you are having problems with undelivered emails or double newlines.';
$string['configmaxbytes'] = 'This specifies a maximum size for files uploaded to the site. This setting is limited by the PHP settings post_max_size and upload_max_filesize, as well as the Apache setting LimitRequestBody. In turn, maxbytes limits the range of sizes that can be chosen at course or activity level. If \'Site upload limit\' is chosen, the maximum size allowed by the server will be used.';
$string['configmaxconsecutiveidentchars'] = 'Passwords must not have more than this number of consecutive identical characters. Use 0 to disable this check.';
$string['configmaxeditingtime'] = 'This specifies the amount of time people have to re-edit forum postings, glossary comments etc.  Usually 30 minutes is a good value.';
$string['configmaxevents'] = 'Events to Lookahead';
$string['configmessaging'] = 'If enabled, users can send messages to other users on the site.';
$string['configmessagingallowemailoverride'] = 'Allow users to have email message notifications sent to an email address other than the email address in their profile';
$string['configmessagingdefaultpressenter'] = 'Whether \'Use enter to send\' is enabled by default in users\' messaging settings.';
$string['configmessagingdeletereadnotificationsdelay'] = 'Read notifications can be deleted to save space. How long after a notification is read can it be deleted?';
$string['configmessagingdeleteallnotificationsdelay'] = 'Read and unread notifications can be deleted to save space. How long after a notification is created can it be deleted?';
$string['configmessagingallusers'] = 'If enabled, users can view the list of all users on the site when selecting someone to message, and their message preferences include the option to accept messages from anyone on the site. If disabled, users can only view the list of users in their courses, and they have just two options in message preferences - to accept messages from their contacts only, or their contacts and anyone in their courses.';
$string['configminpassworddigits'] = 'Passwords must have at least these many digits.';
$string['configminpasswordlength'] = 'Passwords must be at least these many characters long.';
$string['configminpasswordlower'] = 'Passwords must have at least these many lower case letters.';
$string['configminpasswordnonalphanum'] = 'Passwords must have at least these many non-alphanumeric characters.';
$string['configminpasswordupper'] = 'Passwords must have at least these many upper case letters.';
$string['configmodchooserdefault'] = 'Should the activity chooser be presented to users by default?';
$string['configmycoursesperpage'] = 'Maximum number of courses to display in any list of a user\'s own courses';
$string['configmymoodleredirect'] = 'This setting forces redirects to /my on login for non-admins and replaces the top level site navigation with /my';
$string['configmypagelocked'] = 'This setting prevents the default page from being edited by any non-admins';
$string['confignavcourselimit'] = 'Limits the number of courses shown to the user in the navigation.';
$string['confignavshowallcourses'] = 'This setting determines whether users who are enrolled in courses can see Courses (listing all courses) in the navigation, in addition to My Courses (listing courses in which they are enrolled).';
$string['confignavshowcategories'] = 'Show course categories in the navigation bar and navigation blocks. This does not occur with courses the user is currently enrolled in, they will still be listed under mycourses without categories.';
$string['confignoreplyaddress'] = 'Emails are sometimes sent out on behalf of a user (eg forum posts). The email address you specify here will be used as the "From" address in those cases when the recipients should not be able to reply directly to the user (eg when a user chooses to keep their address private). This setting will also be used as the envelope sender when sending email.';
$string['confignotifyloginfailures'] = 'Send login failure notification messages to these selected users. This requires an internal logstore (eg Standard Logstore) to be enabled.';
$string['confignotifyloginthreshold'] = 'If notifications about failed logins are active, how many failed login attempts by one user or one IP address is it worth notifying about?';
$string['confignotloggedinroleid'] = 'Users who are not logged in to the site will be treated as if they have this role granted to them at the site context.  Guest is almost always what you want here, but you might want to create roles that are less or more restrictive.  Things like creating posts still require the user to log in properly.';
$string['configopentowebcrawlers'] = 'If you enable this setting, then search engines will be allowed to enter your site as a guest.  In addition, people coming in to your site via a search engine will automatically be logged in as a guest.  Note that this only provides transparent access to courses that already allow guest access.';
$string['configoverride'] = 'Defined in config.php';
$string['configpasswordpolicy'] = 'If enabled, user passwords will be checked against the password policy as specified in the settings below. Enabling the password policy will not affect existing users until they decide to, or are required to, change their password, or the \'Check password on login\' setting is enabled.';
$string['configpasswordpolicycheckonlogin'] = 'If enabled, user passwords will be checked against the password policy each time users log in. If the check fails, the user will be required to change their password before proceeding.
It is useful to enable this setting after updating the password policy.';
$string['configpasswordresettime'] = 'This specifies the amount of time people have to validate a password reset request before it expires. Usually 30 minutes is a good value.';
$string['configpathtodu'] = 'Path to du. Probably something like /usr/bin/du. If you enter this, pages that display directory contents will run much faster for directories with a lot of files.';
$string['configpathtophp'] = 'Path to PHP CLI. Probably something like /usr/bin/php. If you enter this, cron scripts can be executed from admin web interface.';
$string['configperfdebug'] = 'If you turn this on, performance info will be printed in the footer of the standard theme';
$string['configprofileroles'] = 'List of roles that are visible on user profiles and participation page.';
$string['configprofilesforenrolledusersonly'] = 'To prevent misuse by spammers, profile descriptions of users who are not yet enrolled in any course are hidden. New users must enrol in at least one course before they can add a profile description.';
$string['configprotectusernames'] = 'If enabled, the forgotten password form will not display any hints allowing account usernames or email addresses to be guessed.';
$string['configproxybypass'] = 'Comma separated list of (partial) hostnames or IPs that should bypass proxy (e.g., 192.168., .mydomain.com)';
$string['configproxyhost'] = 'If this <b>server</b> needs to use a proxy computer (eg a firewall) to access the Internet, then provide the proxy hostname here.  Otherwise leave it blank.';
$string['configproxypassword'] = 'Password needed to access internet through proxy if required, empty if none (PHP cURL extension required).';
$string['configproxyport'] = 'If this server needs to use a proxy computer, then provide the proxy port here.';
$string['configproxytype'] = 'Type of web proxy (PHP5 and cURL extension required for SOCKS5 support).';
$string['configproxyuser'] = 'Username needed to access internet through proxy if required, empty if none (PHP cURL extension required).';
$string['configrecaptchaprivatekey'] = 'String of characters (secret key) used to communicate between your Moodle server and the recaptcha server. ReCAPTCHA keys can be obtained from <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'String of characters (site key) used to display the reCAPTCHA element in the signup form. ReCAPTCHA keys can be obtained from <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestedstudentname'] = 'Word for student used in requested courses';
$string['configrequestedstudentsname'] = 'Word for students used in requested courses';
$string['configrequestedteachername'] = 'Word for teacher used in requested courses';
$string['configrequestedteachersname'] = 'Word for teachers used in requested courses';
$string['configreverseproxyignore'] = 'If your server is behind multiple reverse proxies that append to the X-Forwarded-For header, then specify a comma-separated list of IP addresses or subnets of the reverse proxies to be ignored in order to find the user\'s correct IP address.';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'Mail';
$string['configsectionmaintenance'] = 'Maintenance';
$string['configsectionmisc'] = 'Miscellaneous';
$string['configsectionoperatingsystem'] = 'Operating system';
$string['configsectionpermissions'] = 'Permissions';
$string['configsectionrequestedcourse'] = 'Course requests';
$string['configsectionsecurity'] = 'Security';
$string['configsectionstats'] = 'Statistics';
$string['configsectionuser'] = 'User';
$string['configsecureforms'] = 'Moodle can use an additional level of security when accepting data from web forms. If this is enabled, then the browser\'s HTTP_REFERER variable is checked against the current form address.  In a very few cases this can cause problems if the user is using a firewall (eg Zonealarm) configured to strip HTTP_REFERER from their web traffic.  Symptoms are getting \'stuck\' on a form. If your users are having problems with the login page (for example) you might want to disable this setting, although it might leave your site more open to brute-force password attacks.  If in doubt, leave this set to \'Yes\'.';
$string['configsessioncookie'] = 'This setting customises the name of the cookie used for Moodle sessions.  This is optional, and only useful to avoid cookies being confused when there is more than one copy of Moodle running within the same web site.';
$string['configsessioncookiedomain'] = 'This allows you to change the domain that the Moodle cookies are available from. This is useful for Moodle customisations (e.g. authentication or enrolment plugins) that need to share Moodle session information with a web application on another subdomain. <strong>WARNING: it is strongly recommended to leave this setting at the default (empty) - an incorrect value will prevent all logins to the site.</strong>';
$string['configsessioncookiepath'] = 'If you need to change where browsers send the Moodle cookies, you can change this setting to specify a subdirectory of your web site.  Otherwise the default \'/\' should be fine.';
$string['configsessiontimeout'] = 'If people logged in to this site are idle for a long time (without loading pages) then they are automatically logged out (their session is ended).  This variable specifies how long this time should be.';
$string['configshowicalsource'] = 'Show source information for iCal events';
$string['configshowcommentscount'] = 'Show comments count, it will cost one more query when display comments link';
$string['configshowsiteparticipantslist'] = 'All of these site students and site teachers will be listed on the site participants list. Who shall be allowed to see this site participants list?';
$string['configsitedefaultlicense'] = 'Default site licence';
$string['configsitedefaultlicensehelp'] = 'The default licence for publishing content on this site';
$string['configsitemailcharset'] = 'This setting specifies the default charset for all emails sent from the site.';
$string['configsitemaxcategorydepth'] = 'Maximum category depth';
$string['configsitemaxcategorydepthhelp'] = 'This specifies the maximum depth of child categories expanded when displaying categories or combo list. Deeper level categories will appear as links and user can expand them with AJAX request.';
$string['configslasharguments'] = '\'Slash arguments\' (using <em>PATH_INFO</em>) is required for SCORM packages and multiple-file resources to display correctly. If your web server doesn\'t support \'slash arguments\' and you are unable to configure it, this setting can be disabled, though it will result in things not working.<br />Note: The use of \'slash arguments\' will be required in future versions of Moodle.';
$string['configsmartpix'] = 'With this on, icons are served through a PHP script that searches the current theme, then all parent themes, then the Moodle /pix folder. This reduces the need to duplicate image files within themes, but has a slight performance cost.';
$string['configsmtpauthtype'] = 'This sets the authentication type to use on smtp server.';
$string['configsmtphosts'] = 'Give the full name of one or more local SMTP servers that Moodle should use to send mail (eg \'mail.a.com\' or \'mail.a.com;mail.b.com\'). To specify a non-default port (i.e other than port 25), you can use the [server]:[port] syntax (eg \'mail.a.com:587\'). For secure connections, port 465 is usually used with SSL, port 587 is usually used with TLS, specify security protocol below if required. If you leave this field blank, Moodle will use the PHP default method of sending mail.';
$string['configsmtpmaxbulk'] = 'Maximum number of messages sent per SMTP session. Grouping messages may speed up the sending of emails. Values lower than 2 force creation of new SMTP session for each email.';
$string['configsmtpsecure'] = 'If SMTP server requires secure connection, specify the correct protocol type.';
$string['configsmtpuser'] = 'If you have specified an SMTP server above, and the server requires authentication, then enter the username and password here.';
$string['configstartwday'] = 'Start of week';
$string['configstatsfirstrun'] = 'This specifies how far back the logs should be processed <b>the first time</b> the cronjob wants to process statistics. If you have a lot of traffic and are on shared hosting, it\'s probably not a good idea to go too far back, as it could take a long time to run and be quite resource intensive. (Note that for this setting, 1 month = 28 days. In the graphs and reports generated, 1 month = 1 calendar month.)';
$string['configstatsmaxruntime'] = 'Stats processing can be quite intensive, so use a combination of this field and the next one to specify when it will run and how long for.';
$string['configstatsmaxruntime2'] = 'Stats processing can be quite intensive, specify maximum time allowed for gathering of one day of statistics. Maximum number of days processed in one cron execution is 31.';
$string['configstatsmaxruntime3'] = 'This specifies the maximum time allowed to calculate the statistics for one day, bearing in mind that statistics processing can put a big load on the server. The maximum number of days processed in one cron can be specified below.';
$string['configstatsruntimedays'] = 'This specifies the maximum number of days processed in each statistics execution. Once the statistics are up-to-date, only one day will be processed, so adjust this value depending of your server load, reducing it if shorter cron executions are needed.';
$string['configstatsruntimestart'] = 'What time should the cronjob that does the statistics processing start? Specifying different times is recommended if there are multiple Moodle sites on one server.';
$string['configstatsuserthreshold'] = 'This setting specifies the minimum number of enrolled users for a course to be included in statistics calculations.';
$string['configstrictformsrequired'] = 'If enabled, users are prevented from entering a space or line break only in required fields in forms.';
$string['configstripalltitletags'] = 'Uncheck this setting to allow HTML tags in activity and resource names.';
$string['configsupportemail'] = 'This email address will be published to users of this site as the one to email when they need general help (for example, when new users create their own accounts).  If this email is left blank then no such helpful email address is supplied.';
$string['configsupportname'] = 'This is the name of a person or other entity offering general help via the support email or web address.';
$string['configsupportpage'] = 'This web address will be published to users of this site as the one to go to when they need general help (for example, when new users create their own accounts).  If this address is left blank then no link will be supplied.';
$string['configtempdatafoldercleanup'] = 'Remove temporary data files from the data folder that are older than the selected time.';
$string['configthemedesignermode'] = 'Normally all theme images and style sheets are cached in browsers and on the server for a very long time, for performance. If you are designing themes or developing code then you probably want to turn this mode on so that you are not served cached versions.  Warning: this will make your site slower for all users!  Alternatively, you can also reset the theme caches manually from the Theme selection page.';
$string['configthemelist'] = 'Leave this blank to allow any valid theme to be used.  If you want to shorten the theme menu, you can specify a comma-separated list of names here (Don\'t use spaces!).
For example:  standard,orangewhite.';
$string['configtimezone'] = 'This is the default timezone for displaying dates - each user can override this setting in their profile. Cron tasks and other server settings are specified in this timezone. You should change the setting if it shows as "Invalid timezone"';
$string['configuseblogassociations'] = 'Should users be able to organize their blog by associating entries with courses and course modules?';
$string['configuseexternalyui'] = 'Instead of using local files, use online files available on Yahoo&#145;s servers. WARNING: This requires an internet connection, or no AJAX will work on your site. This setting is not compatible with sites using https.';
$string['configusesitenameforsitepages'] = 'If enabled the site\'s shortname will be used for the site pages node in the navigation rather than the string \'Site pages\'';
$string['configusetags'] = 'Should tags functionality across the site be enabled?';
$string['configvariables'] = 'Variables';
$string['configverifychangedemail'] = 'Enables verification of changed email addresses using allowed and denied email domains settings. If this setting is disabled the domains are enforced only when creating new users.';
$string['configvisiblecourses'] = 'Display courses in hidden categories normally';
$string['configwarning'] = 'Be careful modifying these settings - strange values could cause problems.';
$string['configyuicomboloading'] = 'This options enables combined file loading optimisation for YUI libraries. This setting should be enabled on production sites for performance reasons.';
$string['confirmation'] = 'Confirmation';
$string['confirmcontextlock'] = '{$a->contextname} is currently unfrozen. Freezing it will make it read-only and prevent users from making changes. Are you sure you wish to continue?';
$string['confirmcontextunlock'] = '{$a->contextname} is currently frozen. Unfreezing it will allow users to make changes. Are you sure you wish to continue?';
$string['confirmdeletecomments'] = 'You are about to delete comments, are you sure?';
$string['confirmed'] = 'Confirmed';
$string['contextlocking'] = 'Context freezing';
$string['contextlocking_desc'] = 'This setting enables read-only access to be set for selected categories, courses, activities or blocks.';
$string['contextlockappliestoadmin'] = 'Context freezing applies to administrators';
$string['contextlockappliestoadmin_desc'] = 'If disabled, administrators remain with write access to any frozen contexts.';
$string['cookiehttponly'] = 'Only http cookies';
$string['cookiesecure'] = 'Secure cookies only';
$string['contenttypeuninstalling'] = 'There are {$a->count} contents supported by {$a->type}. They will be deleted. Are you sure you want to proceed?';
$string['country'] = 'Default country';
$string['course_customfield'] = 'Course custom fields';
$string['coursecolor'] = 'Colour {$a}';
$string['coursecolorheading_desc'] = 'Any courses without a course image set in the course settings are displayed on the Dashboard with a patterned course card. The colours used in the pattern may be specified below.';
$string['coursecolorsettings'] = 'Course card colours';
$string['coursecontact'] = 'Course contacts';
$string['coursecontact_desc'] = 'This setting allows you to control who appears on the course description. Users need to have at least one of these roles in a course to be shown on the course description for that course.';
$string['coursecontactduplicates'] = 'Display all course contact roles';
$string['coursecontactduplicates_desc'] = 'If enabled, users with more than one of the selected course contact roles will be displayed in the course description with each of their roles. Otherwise, they will be displayed with only one role (whichever is listed highest in \'Define roles\' in the Site administration).';
$string['coursegraceperiodafter'] = 'Grace period for past courses';
$string['coursegraceperiodbefore'] = 'Grace period for future courses';
$string['courselistshortnames'] = 'Display extended course names';
$string['courselistshortnames_desc'] = 'If enabled, course short names will be displayed in addition to full names in course lists. If required, extended course names may be customised by editing the \'courseextendednamedisplay\' language string using the language customisation feature.';
$string['coursemgmt'] = 'Manage courses and categories';
$string['courseoverview'] = 'Course overview';
$string['courserequestnotify'] = 'Course request notification';
$string['courserequestnotifyemail'] = 'User {$a->user} requested a new course at {$a->link}';
$string['courserequests'] = 'Course requests';
$string['courserequestspending'] = 'Pending course requests';
$string['courses'] = 'Courses';
$string['coursesperpage'] = 'Courses per page';
$string['courseswithsummarieslimit'] = 'Courses with summaries limit';
$string['creatornewroleid'] = 'Creators\' role in new courses';
$string['creatornewroleid_help'] = 'If the user does not already have the permission to manage the new course, the user is automatically enrolled using this role.';
$string['cron'] = 'Cron';
$string['cron_help'] = 'The cron.php script runs a number of tasks at different scheduled intervals, such as sending forum post notification emails. The script should be run regularly - ideally every minute.';
$string['cron_link'] = 'admin/cron';
$string['cronclionly'] = 'Cron execution via command line only';
$string['cronerrorclionly'] = 'Sorry, internet access to this page has been disabled by the administrator.';
$string['cronerrorpassword'] = 'Sorry, you have not provided a valid password to access this page';
$string['croninfrequent'] = 'There was {$a->actual} between the last two runs of the cron maintenance script and it should run every {$a->expected}. We recommend configuring it to run more frequently.';
$string['cronremotepassword'] = 'Cron password for remote access';
$string['cronwarning'] = 'The <a href="{$a->url}">admin/cron.php script</a> has not been run for {$a->actual} and should run every {$a->expected}.';
$string['cronwarningcli'] = 'The <code>admin/cli/cron.php</code> script has not been run for {$a->actual} and should run every {$a->expected}.';
$string['cronwarningnever'] = 'The <code>admin/cli/cron.php</code> script has never been run and should run every {$a->expected}.';
$string['cronwarningneverweb'] = 'The <a href="{$a->url}">admin/cron.php script</a> has never been run and should run every {$a->expected}.';
$string['ctyperequired'] = 'The ctype PHP extension is now required by Moodle, in order to improve site performance and to offer multilingual compatibility.';
$string['curlsecurityallowedport'] = 'cURL allowed ports list';
$string['curlsecurityallowedportsyntax'] = 'List of port numbers that cURL can connect to. Valid entries are integer numbers only. Put each entry on a new line. If left empty, then all ports are allowed. If set, in almost all cases, both 443 and 80 should be specified for cURL to connect to standard HTTPS and HTTP ports.';
$string['curlsecurityblockedhosts'] = 'cURL blocked hosts list';
$string['curlsecurityblockedhostssyntax'] = 'Put each entry on a new line. Valid entries are either full IPv4 or IPv6 addresses (such as 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::) which match a single host; or CIDR notation (such as 231.54.211.0/20 or fe80::/64); or a range of IP addresses (such as 231.3.56.10-20 or fe80::1111-bbbb) where the range applies to the last group of the address; or domain names (such as localhost or example.com); or wildcard domain names (such as *.example.com or *.sub.example.com). Blank lines are not allowed.';
$string['curlsecurityurlblocked'] = 'The URL is blocked.';
$string['curlcache'] = 'cURL cache TTL';
$string['curlrequired'] = 'The cURL PHP extension is now required by Moodle, in order to communicate with Moodle repositories.';
$string['curltimeoutkbitrate'] = 'Bitrate to use when calculating cURL timeouts (Kbps)';
$string['curltimeoutkbitrate_help'] = 'This setting is used to calculate an appropriate timeout during large cURL requests. As part of this calculation an HTTP HEAD request is made to determine the size of the content. Setting this to 0 disables this request from being made.';
$string['currenttheme'] = 'Current theme';
$string['customcheck'] = 'Other checks';
$string['custommenu'] = 'Custom menu';
$string['custommenuitems'] = 'Custom menu items';
$string['customusermenuitems'] = 'User menu items';
$string['datarootsecurityerror'] = '<p><strong>SECURITY WARNING!</strong></p><p>Your dataroot directory is in the wrong location and is exposed to the web. This means that all your private files are available to anyone in the world, and some of them could be used by a cracker to obtain unauthorised administrative access to your site!</p>
<p>You <em>must</em> move dataroot directory ({$a}) to a new location that is not within your public web directory, and update the <code>$CFG->dataroot</code> setting in your config.php accordingly.</p>';
$string['datarootsecuritywarning'] = 'Your site configuration might not be secure. Please make sure that your dataroot directory ({$a}) is not directly accessible via web.';
$string['dbsessions'] = 'Use database for session information';
$string['debug'] = 'Debug messages';
$string['debugall'] = 'ALL: Show all reasonable PHP debug messages';
$string['debugdeveloper'] = 'DEVELOPER: extra Moodle debug messages for developers';
$string['debugdisplay'] = 'Display debug messages';
$string['debugging'] = 'Debugging';
$string['debugminimal'] = 'MINIMAL: Show only fatal errors';
$string['debugnone'] = 'NONE: Do not show any errors or warnings';
$string['debugnormal'] = 'NORMAL: Show errors, warnings and notices';
$string['debugpageinfo'] = 'Show page information';
$string['debugstringids'] = 'Show origin of languages strings';
$string['debugstringids_desc'] = 'If enabled, language string components and identifiers are displayed when ?strings=1 or &strings=1 is appended to the page URL.';
$string['debugvalidators'] = 'Show validator links';
$string['defaultcity'] = 'Default city';
$string['defaultcity_help'] = 'A city entered here will be the default city when creating new user accounts.';
$string['defaultformatnotset'] = 'Error determining default course format. Please check site settings.';
$string['defaulthomepage'] = 'Home page for users';
$string['defaultrequestcategory'] = 'Default category for course requests';
$string['defaultsettinginfo'] = 'Default: {$a}';
$string['defaultuserroleid'] = 'Default role for all users';
$string['deleteincompleteusers'] = 'Delete incomplete users after';
$string['deleteunconfirmed'] = 'Delete not fully setup users after';
$string['deleteuser'] = 'Delete user';
$string['density'] = 'Density';
$string['denyemailaddresses'] = 'Denied email domains';
$string['devlibdirpresent'] = 'Directories with development libraries, especially <em>/vendor</em> and <em>/node_modules</em>, should not be present on public sites. See the <a href="{$a->moreinfourl}">security overview report</a> for more details.';
$string['development'] = 'Development';
$string['devicedetectregex'] = 'Device detection regular expressions';
$string['devicedetectregex_desc'] = '<p>By default, Moodle can detect devices of the type default (desktop PCs, laptops, etc), mobile (phones and small hand held devices), tablet (iPads, Android tablets) and legacy (Internet Explorer 6 users).  The theme selector can be used to apply separate themes to all of these.  This setting allows regular expressions that allow the detection of extra device types (these take precedence over the default types).</p>
<p>For example, you could enter the regular expression \'/(MIDP-1.0|Maemo|Windows CE)/\' to detect some commonly used feature phones add the return value \'featurephone\'.  This adds \'featurephone\' on the theme selector that would allow you to add a theme that would be used on these devices.  Other phones would still use the theme selected for the mobile device type.</p>';
$string['devicedetectregexexpression'] = 'Regular expression';
$string['devicedetectregexvalue'] = 'Return value';
$string['devicetype'] = 'Device type';
$string['disabled'] = 'Disabled';
$string['disableuserimages'] = 'Disable user profile images';
$string['displayerrorswarning'] = 'Enabling the PHP setting <em>display_errors</em> is not recommended on production sites because some error messages may reveal sensitive information about your server.';
$string['displayloginfailures'] = 'Display login failures';
$string['dndallowtextandlinks'] = 'Drag and drop upload of text/links';
$string['doclang'] = 'Language for docs';
$string['docroot'] = 'Moodle Docs document root';
$string['doctonewwindow'] = 'Open in new window';
$string['doesnotfit'] = 'Email display settings';
$string['doesnotfitdetail'] = 'Display settings for email leaving Moodle.';
$string['download'] = 'Download';
$string['durationunits'] = 'duration units';
$string['edithelpdocs'] = 'Edit help documents';
$string['editlang'] = '<b>Edit</b>';
$string['editorbackgroundcolor'] = 'Background colour';
$string['editordictionary'] = 'Editor dictionary';
$string['editorfontfamily'] = 'Font family';
$string['editorfontlist'] = 'Font list';
$string['editorfontsize'] = 'Font size';
$string['editorhidebuttons'] = 'Hidden buttons';
$string['editorkillword'] = 'Word format filter';
$string['editorspelling'] = 'Editor spelling';
$string['editorspellinghelp'] = 'Enable or disable spell-checking. When enabled, <strong>aspell</strong> must be installed on the server.';
$string['editstrings'] = 'Edit words or phrases';
$string['emailchangeconfirmation'] = 'Email change confirmation';
$string['emailfromvia'] = 'Email via information';
$string['emailsubjectprefix'] = 'Email subject prefix text';
$string['emoticontext'] = 'Text';
$string['emoticonimagename'] = 'Image name';
$string['emoticonalt'] = 'Alternative text';
$string['emoticoncomponent'] = 'Image component';
$string['emoticons'] = 'Emoticons';
$string['emoticons_desc'] = 'This form defines the emoticons (or smileys) used at your site. To remove a row from the table, save the form with an empty value in any of the required fields. To register a new emoticon, fill the fields in the last blank row. To reset all the fields into default values, follow the link above.

* Text (required) - This text will be replaced with the emoticon image. It must be at least two characters long.
* Image name (required) - The emoticon image file name without the extension, relative to the component pix folder.
* Image component (required) - The component providing the icon.
* Alternative text (optional) - String identifier and component of the alternative text of the emoticon.';
$string['emoticonsreset'] = 'Reset emoticons setting to default values';
$string['emptysettingvalue'] = 'Empty';
$string['enableactivitychooser'] = 'Enable activity chooser';
$string['enableanalytics'] = 'Analytics';
$string['enableblogs'] = 'Enable blogs';
$string['enablecalendarexport'] = 'Enable calendar export';
$string['enablecomments'] = 'Enable comments';
$string['enablecourserelativedates'] = 'Enable course relative dates';
$string['enablecourserelativedates_desc'] = 'Allow courses to be set up to display dates relative to the user\'s start date in the course.';
$string['enablecourserequests'] = 'Enable course requests';
$string['enabled'] = 'Enabled';
$string['enabledevicedetection'] = 'Enable device detection';
$string['enableglobalsearch'] = 'Enable global search';
$string['enableglobalsearch_desc'] = 'If enabled, data will be indexed and synchronised by a scheduled task.';
$string['enablegravatar'] = 'Enable Gravatar';
$string['enablegravatar_help'] = 'When enabled Moodle will attempt to fetch a user profile picture from Gravatar if the user has not uploaded an image.';
$string['enablemobilewebservice'] = 'Enable web services for mobile devices';
$string['enablerecordcache'] = 'Enable record cache';
$string['enablerssfeeds'] = 'Enable RSS feeds';
$string['enablesearchareas'] = 'Enable search areas';
$string['enablestats'] = 'Enable statistics';
$string['enabletrusttext'] = 'Enable trusted content';
$string['enableuserfeedback'] = 'Enable feedback about this software';
$string['enableuserfeedback_desc'] = 'If enabled, a \'Give feedback about this software\' link is displayed in the footer for users to give feedback about the Moodle software to Moodle HQ. If the \'Next feedback reminder\' option is set, the user is also shown a reminder on the Dashboard at the specified interval. Setting \'Next feedback reminder\' to \'Never\' disables the Dashboard reminder, while leaving the \'Give feedback about this software\' link in the footer.';
$string['enablewebservices'] = 'Enable web services';
$string['enablewsdocumentation'] = 'Web services documentation';
$string['enrolinstancedefaults'] = 'Enrolment instance defaults';
$string['enrolinstancedefaults_desc'] = 'Default enrolment settings in new courses.';
$string['enrolmultipleusers'] = 'Enrol the users';
$string['environment'] = 'Environment';
$string['environmenterrortodo'] = 'You must solve all the environmental problems (errors) found above before proceeding to install this Moodle version!';
$string['environmenterrorupgrade'] = 'Warning: you should solve all the environmental problems (errors) found above before proceeding to upgrade this Moodle version!  Upgrading without fixing these requirements could cause problems such as data loss.  Are you sure you want to continue with the upgrade?';
$string['environmentmustfixsetting'] = 'PHP setting must be changed.';
$string['environmentok'] = 'Your server environment meets all minimum requirements.';
$string['environmentrecommendcustomcheck'] = 'if this test fails, it indicates a potential problem';
$string['environmentrecommendinstall'] = 'should be installed and enabled for best results';
$string['environmentrecommendversion'] = 'version {$a->needed} is recommended and you are running {$a->current}';
$string['environmentrequirecustomcheck'] = 'this test must pass';
$string['environmentrequireinstall'] = 'must be installed and enabled';
$string['environmentrequireversion'] = 'version {$a->needed} is required and you are running {$a->current}';
$string['environmentsettingok'] = 'recommended setting detected';
$string['environmentshouldfixsetting'] = 'PHP setting should be changed.';
$string['environmentxmlerror'] = 'Error reading environment data ({$a->error_code})';
$string['environmentmariadbwrongdbtype'] = 'Wrong <code>$CFG->dbtype</code>: you need to change it in your <code>config.php</code> file, from \'<code>mysql</code>\' to \'<code>mariadb</code>\'.';
$string['errordeletingconfig'] = 'An error occurred while deleting the configuration records for plugin \'{$a}\'.';
$string['errorsetting'] = 'Could not save setting:';
$string['errorwithsettings'] = 'Some settings were not changed due to an error.';
$string['eventshandlersinuse'] = 'The following plugins in your system are using Events 1 API deprecated handlers: \'{$a}\'. Please, update them to use Events 2 API. See https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Everyone who can \'{$a}\'';
$string['exceptions'] = 'exceptions';
$string['execpathnotallowed'] = 'Setting executable and local paths disabled in config.php';
$string['experimental'] = 'Experimental';
$string['experimentalsettings'] = 'Experimental settings';
$string['extendedusernamechars'] = 'Allow extended characters in usernames';
$string['extramemorylimit'] = 'Extra PHP memory limit';
$string['fatalsessionautostart'] = '<p>Serious configuration error detected, please notify server administrator.</p><p> To operate properly, Moodle requires that administrator changes PHP settings.</p><p><code>session.auto_start</code> must be set to <code>off</code>.</p><p>This setting is controlled by editing <code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['feedbacksettings'] = 'Feedback settings';
$string['filescleanupperiod'] = 'Clean up trash pool files';
$string['filescleanupperiod_help'] = 'How often trash pool files are deleted. These are files that are associated with a context that no longer exists, for example when a course is deleted. Please note: This setting can result in missing files in a course which is backed up, deleted and then restored if the setting \'Include files\' (backup_auto_files) in \'Automated backup settings\' is disabled.';
$string['fileconversioncleanuptask'] = 'Cleanup of temporary records for file conversions';
$string['filecreated'] = 'New file created';
$string['filesizeunits'] = 'file size units';
$string['filestoredin'] = 'Save file into folder :';
$string['filestoredinhelp'] = 'Where the file will be stored';
$string['filterall'] = 'Filter all strings';
$string['filtermatchoneperpage'] = 'Filter match once per page';
$string['filtermatchonepertext'] = 'Filter match once per text';
$string['filters'] = 'Filters';
$string['filtersettings'] = 'Manage filters';
$string['filtersettingsgeneral'] = 'General filter settings';
$string['filteruploadedfiles'] = 'Filter uploaded files';
$string['forceclean'] = 'Content cleaning everywhere';
$string['forceclean_desc'] = 'Content added to the site is normally cleaned before being displayed, to remove anything which might be a security threat. However, content is not cleaned in certain places such as activity descriptions, page resources or HTML blocks to allow scripts, media, inline frames etc. to be added. If this setting is enabled, ALL content will be cleaned. This may result in existing content no longer displaying correctly.';
$string['forcelogin'] = 'Force users to log in';
$string['forceloginforprofileimage'] = 'Force users to log in to view user pictures';
$string['forceloginforprofileimage_help'] = 'If enabled, users must log in in order to view user profile pictures and the default user picture will be used in all notification emails.';
$string['forceloginforprofiles'] = 'Force users to log in for profiles';
$string['forcetimezone'] = 'Force timezone';
$string['formatuninstallwithcourses'] = 'There are {$a->count} courses using {$a->format}. Their format will be changed to {$a->defaultformat} (default format for this site). Some format-specific data may be lost. Are you sure you want to proceed?';
$string['frontpage'] = 'Front page';
$string['frontpagebackup'] = 'Front page backup';
$string['frontpagedefaultrole'] = 'Default frontpage role';
$string['frontpagefilters'] = 'Front page filters';
$string['frontpageloggedin'] = 'Front page items when logged in';
$string['frontpageoverrides'] = 'Front page permission overrides';
$string['frontpagequestions'] = 'Front page questions';
$string['frontpagerestore'] = 'Front page restore';
$string['frontpageroles'] = 'Front page roles';
$string['frontpagesettings'] = 'Front page settings';
$string['fullnamedisplay'] = 'Full name format';
$string['fullnamedisplayprivate'] = 'Full name format - private';
$string['gdrequired'] = 'The GD extension is now required by Moodle for image conversion.';
$string['generalsettings'] = 'General settings';
$string['geoipfile'] = 'GeoLite2 City MaxMind DB';
$string['getremoteaddrconf'] = 'Logged IP address source';
$string['globalsearch'] = 'Global search';
$string['globalsearchmanage'] = 'Manage global search';
$string['groupenrolmentkeypolicy'] = 'Group enrolment key policy';
$string['groupenrolmentkeypolicy_desc'] = 'If enabled, group enrolment keys will be checked against the password policy as specified in the settings above.';
$string['googlemapkey3'] = 'Google Maps API V3 key';
$string['googlemapkey3_help'] = 'You need to enter a special key to use Google Maps for IP address lookup visualization. You can obtain the key free of charge at <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>';
$string['gotofirst'] = 'Go to first missing string';
$string['gradebook'] = 'Gradebook';
$string['gradebookroles'] = 'Graded roles';
$string['gravatardefaulturl'] = 'Gravatar default image URL';
$string['gravatardefaulturl_help'] = 'Gravatar needs a default image to display if it is unable to find a picture for a given user. Provide a full URL for an image. If you leave this setting empty, Moodle will attempt to use the most appropriate default image for the page you are viewing. Note also that Gravatar has a number of codes which can be used to <a href="https://en.gravatar.com/site/implement/images/#default-image">generate default images</a>.';
$string['gradeexport'] = 'Primary grade export methods';
$string['guestroleid'] = 'Role for guest';
$string['guestroleid_help'] = 'This role is automatically assigned to the guest user. It is also temporarily assigned to not enrolled users that enter the course via guest enrolment plugin.';
$string['helpadminseesall'] = 'In the site calendar, do admins see and filter events from all course calendars or just those from courses they are enrolled in? Regardless of the chosen option, admins will always be able to manage events for each course calendar by navigating to the course first, and then accessing the course calendar directly.';
$string['helpcalendarcustomexport'] = 'Enable custom date range export option in calendar exports. Calendar exports must be enabled before this is effective.';
$string['helpexportlookahead'] = 'How many days in the future does the calendar look for events during export for the custom export option?';
$string['helpexportlookback'] = 'How many days in the past does the calendar look for events during export for the custom export option?';
$string['helpforcetimezone'] = 'You can allow users to individually select their timezone, or force a timezone for everyone.';
$string['helpshowicalsource'] = 'If enabled, the subscription name and link will be shown for iCal-imported events.';
$string['helpsitemaintenance'] = 'For upgrades and other work';
$string['helpstartofweek'] = 'Which day starts the week in the calendar?';
$string['helpupcominglookahead'] = 'How many days in the future does the calendar look for upcoming events by default?';
$string['helpupcomingmaxevents'] = 'How many (maximum) upcoming events are shown to users by default?';
$string['helpweekenddays'] = 'Which days of the week are treated as "weekend" and shown with a different colour?';
$string['hiddenuserfields'] = 'Hide user fields';
$string['hidefromall'] = 'Hide from all users';
$string['hidefromnone'] = 'Hide from nobody';
$string['hidefromstudents'] = 'Hide from students';
$string['htmleditor'] = 'HTML editor';
$string['htmleditorsettings'] = 'HTML editor settings';
$string['htmlsettings'] = 'HTML settings';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'HTTP security';
$string['incompleteunicodesupport'] = 'The current setup of MySQL or MariaDB is using \'utf8\'. This character set does not support four byte characters which include some emoji. Trying to use these characters will result in an error when updating a record, and any information being sent to the database will be lost. Please consider changing your settings to \'utf8mb4\'. See the documentation for full details.';
$string['change'] = 'change';
$string['checkboxno'] = 'No';
$string['checkboxyes'] = 'Yes';
$string['choosefiletoedit'] = 'Choose file to edit';
$string['h5pgetcontenttypestask'] = 'Download available H5P content types from h5p.org';
$string['iconvrequired'] = 'Installing ICONV extension is required.';
$string['ignore'] = 'Ignore';
$string['includemoduleuserdata'] = 'Include module user data';
$string['incompatibleblocks'] = 'Incompatible blocks';
$string['indexdata'] = 'Index data';
$string['indexinginfo'] = 'The recommended way to index your site\'s contents is by using the \'Global search indexing\' scheduled task.';
$string['installhijacked'] = 'Installation must be finished from the original IP address, sorry.';
$string['installsessionerror'] = 'Cannot initialise PHP session. Please verify that your browser accepts cookies.';
$string['intlrecommended'] = 'Intl extension is used to improve internationalization support, such as locale aware sorting.';
$string['intlrequired'] = 'Intl extension is required to improve internationalization support, such as locale aware sorting and international domain names.';
$string['invalidagedigitalconsent'] = 'The digital age of consent is not valid: {$a}';
$string['invalidforgottenpasswordurl'] = 'The forgotten password URL is not a valid URL.';
$string['invalidthemepreset'] = 'The chosen preset file is not compatible with this theme. The SCSS compile error was: "{$a}"';
$string['invalidsection'] = 'Invalid section.';
$string['invaliduserchangeme'] = 'Username "changeme" is reserved -- you cannot create an account with it.';
$string['ipblocked'] = 'This site is not available currently.';
$string['ipblocker'] = 'IP blocker';
$string['ipblockersyntax'] = 'Put every entry on one line. Valid entries are either full IP address (such as <b>192.168.10.1</b>) which matches a single host; or partial address (such as <b>192.168</b>) which matches any address starting with those numbers; or CIDR notation (such as <b>231.54.211.0/20</b>); or a range of IP addresses (such as <b>231.3.56.10-20</b>) where the range applies to the last part of the address. Text domain names (like \'example.com\') are not supported. Blank lines, and text following a "#" character are ignored.';
$string['iplookup'] = 'IP address lookup';
$string['iplookupgeoplugin'] = 'The <a href="https://www.geoplugin.com">geoPlugin</a> service is currently being used to look up geographical information. For more accurate results we recommend installing a local copy of the MaxMind GeoLite database.';
$string['iplookupinfo'] = 'By default Moodle uses the free online NetGeo (The Internet Geographic Database) server to lookup location of IP addresses, unfortunately this database is not maintained anymore and may return <em>wildly incorrect</em> data.
It is recommended to install local copy of free GeoLite2 City database from MaxMind.<br />
IP address location is displayed on simple map or using Google Maps. Please note that you need to have a Google account and apply for free Google Maps API key to enable interactive maps.';
$string['iplookupmaxmindnote'] = 'This product includes GeoLite2 data created by MaxMind, available from <a href="https://www.maxmind.com">https://www.maxmind.com</a>.';
$string['ishttpswarning'] = 'It has been detected that your site is not secured using HTTPS. It is strongly recommended to migrate your site to HTTPS for increased security and improved integration with other systems.';
$string['keeptagnamecase'] = 'Keep tag name casing';
$string['lang'] = 'Default language';
$string['langcache'] = 'Cache language menu';
$string['langcache_desc'] = 'Cache the language menu. If enabled, the list of available translations is cached. The cache is automatically refreshed when you install or delete a language pack via the in-built language packs management tool. If you install a new language pack manually, you have to use Purge all caches feature to refresh the cached list.';
$string['langlist'] = 'Languages on language menu';
$string['langmenu'] = 'Display language menu';
$string['langmenuinsecurelayout'] = 'Display language menu in secure layout';
$string['langmenuinsecurelayout_desc'] = 'If enabled, a user will be able to change their language when attempting a quiz or other activity using secure layout.';
$string['langpackwillbeupdated'] = 'NOTE: Moodle will try to download updates for your language packs during the upgrade.';
$string['langstringcache'] = 'Cache all language strings';
$string['languagesettings'] = 'Language settings';
$string['latinexcelexport'] = 'Excel encoding';
$string['legacyfilesaddallowed'] = 'Allow adding to legacy course files';
$string['legacyfilesaddallowed_help'] = 'If a course has legacy course files, allow new files and folders to be added to it.';
$string['legacyfilesinnewcourses'] = 'Legacy course files in new courses';
$string['legacyfilesinnewcourses_help'] = 'By default, legacy course files areas are available in upgraded courses only. Please note that some features such as activity backup and restore are not compatible with this setting.';
$string['libcurlwarning'] = 'It has been detected that libcurl doesn\'t have CURLOPT_PROTOCOL support. An up-to-date libcurl installation is recommended for security reasons.';
$string['licensesettings'] = 'Licence settings';
$string['linkadmincategories'] = 'Link admin categories';
$string['linkadmincategories_help'] = 'If enabled admin setting categories will be displayed as links in the navigation and will lead to the admin category pages.';
$string['linkcoursesections'] = 'Always link course sections';
$string['linkcoursesections_help'] = 'Always try to provide a link for course sections. Course sections are usually only shown as links if the course format displays a single section per page. If this setting is enabled a link will always be provided.';
$string['loading'] = 'Loading';
$string['localetext'] = 'Sitewide locale';
$string['localstringcustomization'] = 'Local string customization';
$string['location'] = 'Location';
$string['locationsettings'] = 'Location settings';
$string['locked'] = 'Locked';
$string['lockoutduration'] = 'Account lockout duration';
$string['lockoutduration_desc'] = 'Locked out account is automatically unlocked after this duration.';
$string['lockoutemailbody'] = 'Your account with username {$a->username} on server \'{$a->sitename}\'
was locked out after multiple invalid login attempts.

To unlock the account immediately go to the following address

{$a->link}

In most mail programs, this should appear as a blue link
which you can just click on.  If that doesn\'t work,
then copy and paste the address into the address
line at the top of your web browser window.

If you need help, please contact the site administrator,
{$a->admin}';
$string['lockoutemailsubject'] = 'Your account on {$a} was locked out';
$string['lockouterrorunlock'] = 'Invalid account unlock information supplied.';
$string['lockoutthreshold'] = 'Account lockout threshold';
$string['lockoutthreshold_desc'] = 'Select number of failed login attempts that result in account lockout. This feature may be abused in denial of service attacks.';
$string['lockoutwindow'] = 'Account lockout observation window';
$string['lockoutwindow_desc'] = 'Observation time for lockout threshold, if there are no failed attempts the threshold counter is reset after this time.';
$string['lockrequestcategory'] = 'Prevent category selection';
$string['log'] = 'Logs';
$string['logguests'] = 'Log guest access';
$string['logguests_help'] = 'This setting enables logging of actions by guest account and not logged in users. High profile sites may want to disable this logging for performance reasons. It is recommended to keep this setting enabled on production sites.';
$string['logininfoinsecurelayout'] = 'Display logged-in user in secure layout';
$string['logininfoinsecurelayout_desc'] = 'If enabled, the logged-in user\'s full name will be displayed in the navigation bar when attempting a quiz or other activity using secure layout.';
$string['loginpageautofocus'] = 'Autofocus login page form';
$string['loginpageautofocus_help'] = 'Enabling this option improves usability of the login page, but automatically focusing fields may be considered an accessibility issue.';
$string['loglifetime'] = 'Keep logs for';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'A full logo to be used as decoration by some themes (such as core themes). This image can be quite high resolution because it will be scaled down for use (and cached for performance). Logos that are wider than they are high usually give better results. Formats accepted: PNG and JPG.';
$string['logocompact'] = 'Compact logo';
$string['logocompact_desc'] = 'A compact version of the same logo as above, such as an emblem, shield or icon. The image should be clear even at small sizes. Formats accepted: PNG and JPG.';
$string['logossettings'] = 'Logos';
$string['logstorenotrequired'] = 'Log store not required';
$string['logstoressupported'] = 'Log stores that support this report';
$string['longtimewarning'] = '<b>Please note that this process can take a long time.</b>';
$string['mailnewline'] = 'Newline characters in mail';
$string['maintenancemode'] = 'In maintenance mode';
$string['maintenancemodeisscheduled'] = 'This site will be switched to maintenance mode in {$a->min} mins {$a->sec} secs';
$string['maintenancemodeisscheduledlong'] = 'This site will be switched to maintenance mode in {$a->hour} hours {$a->min} mins {$a->sec} secs';
$string['maintfileopenerror'] = 'Error opening maintenance files!';
$string['maintinprogress'] = 'Maintenance is in progress...';
$string['managecontextlock'] = 'Freeze this context';
$string['managecontextlocklocked'] = '{$a->contextname} and any lower contexts are now frozen.';
$string['managecontextlockunlocked'] = '{$a->contextname} and any lower contexts are now unfrozen.';
$string['managecontextunlock'] = 'Unfreeze this context';
$string['managecustomfields'] = 'Manage custom field types';
$string['manageformats'] = 'Manage course formats';
$string['manageformatsgotosettings'] = 'Default format can be changed in {$a}';
$string['managelang'] = 'Manage';
$string['manageqbehaviours'] = 'Manage question behaviours';
$string['manageqtypes'] = 'Manage question types';
$string['maturity50'] = 'Alpha';
$string['maturity100'] = 'Beta';
$string['maturity150'] = 'Release candidate';
$string['maturity200'] = 'Stable version';
$string['maturityallowunstable'] = 'Hint: You may want to run this script with --allow-unstable option';
$string['maturitycoreinfo'] = 'Your site is currently running unstable "{$a}" development code.';
$string['maturitycorewarning'] = 'The version of Moodle that you are about to install or upgrade to contains
unstable "{$a}" development code that is not suitable for use on most production
sites. If this is not what you wanted then you should make sure you are updating
from a STABLE branch of the Moodle code. See Moodle Docs for more details.';
$string['maxbytes'] = 'Maximum uploaded file size';
$string['maxconsecutiveidentchars'] = 'Consecutive identical characters';
$string['maxeditingtime'] = 'Maximum time to edit posts';
$string['maxusersperpage'] = ' Maximum users per page';
$string['configmaxusersperpage'] = 'Maximum number of users displayed within user selector in course, group, cohort, webservice etc.';
$string['mbstringrecommended'] = 'Installing the optional MBSTRING library is highly recommended in order to improve site performance, particularly if your site is supporting non-Latin languages.';
$string['mbstringrequired'] = 'Installing the MBSTRING library is required in order to improve site performance, particularly if your site is supporting non-Latin languages.';
$string['mediapluginavi'] = 'Enable .avi filter';
$string['mediapluginflv'] = 'Enable .flv filter';
$string['mediapluginimg'] = 'Enable auto-embedding of linked images';
$string['mediapluginmov'] = 'Enable .mov filter';
$string['mediapluginmpg'] = 'Enable .mpg filter';
$string['mediapluginmp3'] = 'Enable .mp3 filter';
$string['mediapluginogg'] = 'Enable .ogg filter';
$string['mediapluginogv'] = 'Enable .ogv filter';
$string['mediapluginram'] = 'Enable .ram filter';
$string['mediapluginrm'] = 'Enable .rm filter';
$string['mediapluginrpm'] = 'Enable .rpm filter';
$string['mediapluginswf'] = 'Enable .swf filter';
$string['mediapluginswfnote'] = 'As a default security measure, normal users should not be allowed to embed swf flash files.';
$string['mediapluginwmv'] = 'Enable .wmv filter';
$string['mediapluginyoutube'] = 'Enable YouTube links filter';
$string['messaging'] = 'Enable messaging system';
$string['messagingallowemailoverride'] = 'Notification email override';
$string['messagingallusers'] = 'Allow site-wide messaging';
$string['messagingcategory'] = 'Messaging';
$string['messagingdefaultpressenter'] = 'Use enter to send enabled by default';
$string['messagingdeletereadnotificationsdelay'] = 'Delete read notifications';
$string['messagingdeleteallnotificationsdelay'] = 'Delete all notifications';
$string['messagingssettings'] = 'Messaging settings';
$string['minpassworddigits'] = 'Digits';
$string['minpasswordlength'] = 'Password length';
$string['minpasswordlower'] = 'Lowercase letters';
$string['minpasswordnonalphanum'] = 'Non-alphanumeric characters';
$string['minpasswordupper'] = 'Uppercase letters';
$string['misc'] = 'Miscellaneous';
$string['mlbackendsettings'] = 'Machine learning backend settings';
$string['mnetrestore_extusers'] = '<strong>Note:</strong> This backup file contains remote Moodle Network user accounts which will be restored as part of the process.';
$string['mnetrestore_extusers_admin'] = '<strong>Note:</strong> This backup file seems to come from a different Moodle installation and contains remote Moodle Network user accounts. The restore process will try to match the Moodle Network hosts for all created users. Those not matching will be automatically switched to internal authentication (instead of mnet one). The restore log will inform you about that.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Note:</strong> This backup file apparently originates from a different Moodle installation and contains remote Moodle Network user accounts that may fail to restore. This operation is unsupported. If you are certain that it was created on this Moodle installation, or you can ensure that all the needed Moodle Network Hosts are configured, you may want to still try the restore.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Note:</strong> This backup file seems to come from a different Moodle installation and contains remote Moodle Network user accounts. You are not allowed to execute this type of restore. Contact the administrator of the site or, alternatively, restore this course without any user information (modules, files...)';
$string['mnetrestore_extusers_switchuserauth'] = 'Remote Moodle Network user {$a->username} (coming from {$a->mnethosturl}) switched to local {$a->auth} authenticated user.';
$string['mobilenotconfiguredwarning'] = 'The Moodle app is not enabled.';
$string['modchooserdefault'] = 'Activity chooser default';
$string['modeditdefaults'] = 'Default values for activity settings';
$string['modsettings'] = 'Manage activities';
$string['modulesecurity'] = 'Module security';
$string['multilangforceold'] = 'Force old multilang syntax: &lt;span&gt; without the class="multilang" and &lt;lang&gt;';
$string['mustenablestats'] = 'Statistics have not yet been enabled on this site.';
$string['mycoursesperpage'] = 'Number of courses';
$string['mydashboard'] = 'System default dashboard';
$string['mymoodle'] = 'Dashboard';
$string['mymoodleredirect'] = 'Force users to use My Moodle';
$string['mypage'] = 'Default Dashboard page';
$string['myprofile'] = 'Default profile page';
$string['mypagelocked'] = 'Lock default page';
$string['navadduserpostslinks'] = 'Add links to view user posts';
$string['navadduserpostslinks_help'] = 'If enabled two links will be added to each user in the navigation to view discussions the user has started and posts the user has made in forums throughout the site or in specific courses.';
$string['navigationupgrade'] = 'This upgrade introduces two new navigation blocks that will replace these blocks: Administration, Courses, Activities and Participants.  If you had set any special permissions on those blocks you should check to make sure everything is behaving as you want it.';
$string['navcourselimit'] = 'Course limit';
$string['navshowfullcoursenames'] = 'Show course full names';
$string['navshowfullcoursenames_help'] = 'If enabled, course full names will be used in the navigation rather than short names.';
$string['navshowfrontpagemods'] = 'Show front page activities in the navigation';
$string['navshowfrontpagemods_help'] = 'If enabled, front page activities will be shown on the navigation under site pages.';
$string['navshowallcourses'] = 'Show all courses';
$string['navshowcategories'] = 'Show course categories';
$string['navshowmycoursecategories'] = 'Show my course categories';
$string['navshowmycoursecategories_help'] = 'If enabled courses in the users my courses branch will be shown in categories.';
$string['navsortmycourseshiddenlast'] = 'Sort my hidden courses last';
$string['navsortmycourseshiddenlast_help'] = 'If enabled, any hidden courses will be listed after visible courses (for users who can view hidden courses). Otherwise, all courses, regardless of their visibility, will be listed according to the \'Sort my courses\' setting.';
$string['navsortmycoursessort'] = 'Sort my courses';
$string['navsortmycoursessort_help'] = 'This determines whether courses are listed under My courses according to the sort order (i.e. the order set in Site administration > Courses > Manage courses and categories) or alphabetically by course setting.';
$string['never'] = 'Never';
$string['neverdeleteruns'] = 'Never delete runs';
$string['newestdocindexed'] = 'Newest document indexed';
$string['nobookmarksforuser'] = 'You do not have any bookmarks.';
$string['nodatabase'] = 'No database';
$string['nohttpsformobilewarning'] = 'It is recommended to enable HTTPS with a valid certificate. The Moodle app will always try to use a secured connection first.';
$string['nomissingstrings'] = 'No missing strings';
$string['none'] = 'None';
$string['nonewsettings'] = 'No new settings were added during this upgrade.';
$string['nonexistentbookmark'] = 'The bookmark you requested does not exist.';
$string['nosupportedlogstore'] = 'No supported logstore found';
$string['maxtimelimit'] = 'Maximum time limit';
$string['maxtimelimit_desc'] = 'To restrict the maximum PHP execution time that Moodle will allow without any output being displayed, enter a value in seconds here. 0 means that Moodle default restrictions are used. If you have a front-end server with its own time limit, set this value lower to receive PHP errors in logs. Does not apply to CLI scripts.';
$string['moodleapp'] = 'Moodle app';
$string['moodleapp_help'] = '<p>The free Moodle app enables users to access their courses on mobile devices. Additional app features are available with a Pro or Premium app plan.</p>
<a href="https://moodle.com/mobile-app">Get the Moodle app</a><br />
<a href="https://apps.moodle.com">Moodle Apps Portal</a>';
$string['moodlebrandedapp'] = 'Branded Moodle app';
$string['moodlebrandedapp_help'] = '<p>The Branded Moodle app has all the functionality of our free mobile app for Moodle combined with your own custom branding.</p>
<a href="https://moodle.com/branded-app">About the Branded Moodle app</a>';
$string['moodlebrandedappreference'] = 'Alternatively, get a <a href="https://moodle.com/branded-app/">Branded Moodle app</a> with your own custom branding.';
$string['moodlepartners'] = 'Moodle Partners';
$string['moodlepartners_help'] = '<p>Moodle Partners are services providers that are certified by Moodle HQ to provide high quality Moodle services for your organisation\'s online learning environment.</p>
<a href="https://moodle.com/about-partners/">About our Partners</a><br />
<a href="https://moodle.com/partners">Find a Partner</a>';
$string['moodleservices'] = 'Moodle services';
$string['moodleservices_help'] = 'Make sure you get the best from your Moodle learning environment by using these Moodle services:';
$string['noreplyaddress'] = 'No-reply address';
$string['noreplydomain'] = 'No-reply and domain';
$string['noreplydomaindetail'] = 'Settings for No-reply and configured domains';
$string['noresults'] = 'No results found.';
$string['noroles'] = 'No roles';
$string['notifications'] = 'Notifications';
$string['notifyloginfailures'] = 'Email login failures to';
$string['notifyloginthreshold'] = 'Threshold for email notifications';
$string['notloggedinroleid'] = 'Role for visitors';
$string['numberofmissingstrings'] = 'Number of missing strings: {$a}';
$string['numberofstrings'] = 'Total number of strings: {$a->strings}<br />Missing: {$a->missing} ({$a->missingpercent}&nbsp;%)';
$string['oauthrefreshtokenexpired'] = 'The refresh token for one of the OAuth services {$a->issuer} on your site {$a->siteurl} has expired. This will limit the functionality of any plugins that use this service. To fix this issue, visit the OAuth 2 Services configuration page and click on the "Connect system account" icon in the table row for this service. Be sure to login using the same service account for the OAuth system each time.';
$string['oauthrefreshtokenexpiredshort'] = 'OAuth refresh token expired for {$a->issuer} on your site {$a->siteurl}.';
$string['onlynoreply'] = 'Only when from a no-reply address';
$string['opcacherecommended'] = 'PHP opcode caching improves performance and lowers memory requirements, OPcache extension is recommended and fully supported.';
$string['opensslrecommended'] = 'Installing the optional OpenSSL library is highly recommended -- it enables Moodle Networking functionality.';
$string['opensslrequired'] = 'The OpenSSL PHP extension is now required by Moodle to provide stronger cryptographic services.';
$string['opentowebcrawlers'] = 'Open to search engines';
$string['optionalmaintenancemessage'] = 'Optional maintenance message';
$string['order1'] = 'First';
$string['order2'] = 'Second';
$string['order3'] = 'Third';
$string['order4'] = 'Fourth';
$string['outgoingmailconfig'] = 'Outgoing mail configuration';
$string['overridetossl'] = 'HTTPS for logins has now been deprecated. This instance is now forced to SSL. To remedy this warning change your wwwroot in config.php to https://';
$string['pageinfodebugsummary'] = 'This page is: {$a}';
$string['passwordchangelogout'] = 'Log out after password change';
$string['passwordchangelogout_desc'] = 'If enabled, when a password is changed, all browser sessions are terminated, apart from the one in which the new password is specified. (This setting does not affect password changes via bulk user upload.)';
$string['passwordchangetokendeletion'] = 'Remove web service access tokens after password change';
$string['passwordchangetokendeletion_desc'] = 'If enabled, when a password is changed, all the user web service access tokens are deleted.';
$string['passwordpolicy'] = 'Password policy';
$string['passwordpolicycheckonlogin'] = 'Check password on login';
$string['passwordresettime'] = 'Maximum time to validate password reset request';
$string['passwordreuselimit'] = 'Password rotation limit';
$string['passwordreuselimit_desc'] = 'Number of times a user must change their password before they are allowed to reuse a password. Hashes of previously used passwords are stored in local database table. This feature might not be compatible with some external authentication plugins.';
$string['pathtodot'] = 'Path to dot';
$string['pathtodot_help'] = 'Path to dot. On Linux it is something like /usr/bin/dot. On Windows it is something like C:\Program Files (x86)\Graphviz2.38\bin\dot.exe. On Mac it is something like /opt/local/bin/dot. To be able to generate graphics from DOT files, you must have installed the dot executable and point to it here.';
$string['pathtophp'] = 'Path to PHP CLI';
$string['pathtodu'] = 'Path to du';
$string['pathtogs'] = 'Path to ghostscript';
$string['pathtogs_help'] = 'On most Linux installs, this can be left as \'/usr/bin/gs\'. On Windows it will be something like \'c:\\gs\\bin\\gswin32c.exe\' (make sure there are no spaces in the path - if necessary copy the files \'gswin32c.exe\' and \'gsdll32.dll\' to a new folder without a space in the path)';
$string['pathtopgdump'] = 'Path to pg_dump';
$string['pathtopgdumpdesc'] = 'This is only necessary to enter if you have more than one pg_dump on your system (for example if you have more than one version of postgresql installed)';
$string['pathtopgdumpinvalid'] = 'Invalid path to pg_dump - either wrong path or not executable';
$string['pathtopsql'] = 'Path to psql';
$string['pathtopsqldesc'] = 'This is only necessary to enter if you have more than one psql on your system (for example if you have more than one version of postgresql installed)';
$string['pathtopsqlinvalid'] = 'Invalid path to psql - either wrong path or not executable';
$string['pathtopython'] = 'Path to Python';
$string['pathtopythondesc'] = 'Path to your executable Python binary (both Python 2 and Python 3 are acceptable).';
$string['pathtosassc'] = 'Path to SassC';
$string['pathtosassc_help'] = 'Specifying the location of the SassC binary will switch the SASS compiler from Moodle\'s PHP implementation to SassC. See https://github.com/sass/sassc for more information.';
$string['pcreunicodewarning'] = 'It is strongly recommended to use PCRE PHP extension that is compatible with Unicode characters.';
$string['perfdebug'] = 'Performance info';
$string['performance'] = 'Performance';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'PostgreSQL version/cluster parameter for command line operations. If you only have one postgresql on your system or you are not sure what this is, leave this blank.';
$string['phpfloatproblem'] = 'Detected unexpected problem in handling of PHP float numbers - {$a}';
$string['pleaserefreshregistration'] = 'Your site is registered. Registration last updated {$a}.<br />The \'Site registration\' scheduled task keeps your registration up to date. You can also manually update your registration at any time.';
$string['pleaserefreshregistrationunknown'] = 'Your site has been registered but the registration date is unknown. Please update your registration using the \'Update registration\' button or ensure that the \'Site registration\' scheduled task is enabled so your registration is automatically updated.';
$string['pleaserefreshregistrationnewdata'] = 'Registration information has been changed. Please confirm it using the \'Update registration\' button.';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Plugin dependencies check';
$string['pluginscheckfailed'] = 'Dependencies check failed for {$a->pluginslist}';
$string['pluginschecktodo'] = 'You must solve all the plugin requirements before proceeding to install this Moodle version!';
$string['pluginsoverview'] = 'Plugins overview';
$string['pluginsoverviewsee'] = 'See <a href="{$a->url}">plugins overview</a> page for more details.';
$string['policysettings'] = 'Policy settings';
$string['privacyandpolicies'] = 'Privacy and policies';
$string['privacysettings'] = 'Privacy settings';
$string['privacy:metadata'] = 'The Administration plugin does not store any personal data.';
$string['profilecategory'] = 'Category';
$string['profilecategoryname'] = 'Category name (must be unique)';
$string['profilecategorynamenotunique'] = 'This category name is already in use';
$string['profilecommonsettings'] = 'Common settings';
$string['profileconfirmcategorydeletion'] = 'There is/are {$a} field/s in this category which will be moved into the category above (or below if in the top category).<br />Do you still wish to delete this category?';
$string['profileconfirmfielddeletion'] = 'There is/are {$a} user record/s for this field which will be deleted.<br />Do you still wish to delete this field?';
$string['profilecreatecategory'] = 'Create a new profile category';
$string['profilecreatefield'] = 'Create a new profile field:';
$string['profilecreatenewcategory'] = 'Creating a new category';
$string['profilecreatenewfield'] = 'Creating a new \'{$a}\' profile field';
$string['profiledefaultcategory'] = 'Other fields';
$string['profiledefaultdata'] = 'Default value';
$string['profiledefaultchecked'] = 'Checked by default';
$string['profiledeletecategory'] = 'Deleting a category';
$string['profiledeletefield'] = 'Deleting field \'{$a}\'';
$string['profiledescription'] = 'Description of the field';
$string['profiledscript'] = 'This script has been profiled';
$string['profiledscriptview'] = 'View profiling information for this script';
$string['profileeditcategory'] = 'Editing category: {$a}';
$string['profileeditfield'] = 'Editing profile field: {$a}';
$string['profilefield'] = 'Profile field';
$string['profilefieldcolumns'] = 'Columns';
$string['profilefieldispassword'] = 'Is this a password field?';
$string['profilefieldlink'] = 'Link';
$string['profilefieldlink_help'] = 'To transform the text into a link, enter a URL containing $$, where $$ will be replaced with the text. For example, to transform a Twitter ID to a link, enter https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Link target';
$string['profilefieldmaxlength'] = 'Maximum length';
$string['profilefieldrows'] = 'Rows';
$string['profilefields'] = 'User profile fields';
$string['profilefieldsize'] = 'Display size';
$string['profileforceunique'] = 'Should the data be unique?';
$string['profileinvaliddata'] = 'Invalid value';
$string['profilelocked'] = 'Is this field locked?';
$string['profilemenudefaultnotinoptions'] = 'The default value is not one of the options';
$string['profilemenunooptions'] = 'No menu options supplied';
$string['profilemenuoptions'] = 'Menu options (one per line)';
$string['profilemenutoofewoptions'] = 'You must provide at least 2 options';
$string['profilename'] = 'Name';
$string['profilenofieldsdefined'] = 'No fields have been defined';
$string['profilerequired'] = 'Is this field required?';
$string['profileroles'] = 'Profile visible roles';
$string['profilesforenrolledusersonly'] = 'Profiles for enrolled users only';
$string['profileshortname'] = 'Short name (must be unique)';
$string['profileshortnameinvalid'] = 'This short name can only contain alphanumeric characters (letters and numbers) or underscore (_).';
$string['profileshortnamenotunique'] = 'This short name is already in use';
$string['profilesignup'] = 'Display on signup page?';
$string['profilespecificsettings'] = 'Specific settings';
$string['profilevisible'] = 'Who is this field visible to?';
$string['profilevisible_help'] = '* Not visible - For private data only viewable by administrators
* Visible to user - For private data only viewable by the user and by administrators
* Visible to everyone';
$string['profilevisibleall'] = 'Visible to everyone';
$string['profilevisiblenone'] = 'Not visible';
$string['profilevisibleprivate'] = 'Visible to user';
$string['profiling'] = 'Profiling';
$string['profilingallowall'] = 'Continuous profiling';
$string['profilingallowall_help'] = 'If you enable this setting, then, at any moment, you can use the PROFILEALL parameter anywhere (PGC) to enable profiling for all the executed scripts along the Moodle session life. Analogously, you can use the PROFILEALLSTOP parameter to stop it.';
$string['profilingallowme'] = 'Selective profiling';
$string['profilingallowme_help'] = 'If you enable this setting, then, selectively, you can use the PROFILEME parameter anywhere (PGC) and profiling for that script will happen. Analogously, you can use the DONTPROFILEME parameter to prevent profiling to happen';
$string['profilingautofrec'] = 'Automatic profiling';
$string['profilingautofrec_help'] = 'By configuring this setting, some request (randomly, based on the frequency specified - 1 of N) will be picked and automatically profiled, storing results for further analysis. Note that this way of profiling observes the include/exclude settings. Set it to 0 to disable automatic profiling.';
$string['profilingenabled'] = 'Enable profiling';
$string['profilingenabled_help'] = 'If you enable this setting, then profiling will be available in this site and you will be able to define its behavior by configuring the next options.';
$string['profilingexcluded'] = 'Exclude profiling';
$string['profilingexcluded_help'] = 'List of (comma or newline separated, absolute skipping wwwroot, callable) URLs that will be excluded from being profiled from the ones defined by \'Profile these\' setting.';
$string['profilingimportprefix'] = 'Profiling import prefix';
$string['profilingimportprefix_desc'] = 'For easier detection, all the imported profiling runs will be prefixed with the value specified here.';
$string['profilingincluded'] = 'Profile these';
$string['profilingincluded_help'] = 'List of (comma or newline separated, absolute skipping wwwroot, callable) URLs that will be automatically profiled. Examples: /index.php, /course/view.php. Also accepts the * wildchar at any position. Examples: /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Keep profiling runs';
$string['profilinglifetime_help'] = 'Specify the time you want to keep information about old profiling runs. Older ones will be pruned periodically. Note that this excludes any profiling run marked as \'reference run\'.';
$string['profilingslow'] = 'Profile slow pages';
$string['profilingslow_help'] = 'By setting a minimum time in seconds all pages slower will be profiled. Only profiles which are slower than an existing profile for the same script will be kept. Set to 0 to disable. Note that this observes the exclude settings.';
$string['protectusernames'] = 'Protect usernames';
$string['proxybypass'] = 'Proxy bypass hosts';
$string['proxyhost'] = 'Proxy host';
$string['proxypassword'] = 'Proxy password';
$string['proxyport'] = 'Proxy port';
$string['proxytype'] = 'Proxy type';
$string['proxyuser'] = 'Proxy username';
$string['query'] = 'Query';
$string['question'] = 'Question';
$string['questionbehaviours'] = 'Question behaviours';
$string['questioncwqpfscheck'] = 'One or more \'random\' questions in a quiz are set up to select questions from a mixture of shared and unshared question categories. There is a more detailed report <a href="{$a->reporturl}">here</a> and see Moodle Docs page <a href="{$a->docsurl}">here</a>.';
$string['questioncwqpfsok'] = 'Good. There are no \'random\' questions in your quizzes that are set up to select questions from a mixture of shared and unshared question categories.';
$string['questiontype'] = 'Question type';
$string['questiontypes'] = 'Question types';
$string['quizattemptsupgradedmessage'] = 'In Moodle 2.1 there was a major upgrade to questions. It was possible to delay parts of the database upgrade to be run later. Before upgrading to Moodle 2.7, this upgrade must be completed.';
$string['recaptchaprivatekey'] = 'ReCAPTCHA secret key';
$string['recaptchapublickey'] = 'ReCAPTCHA site key';
$string['register'] = 'Register your site';
$string['registration'] = 'Registration';
$string['registration_help'] = 'By registering:

* You will receive security alerts
* You can activate mobile app push notifications from your site
* You are contributing to our Moodle statistics of the worldwide community';
$string['registrationwarning'] = 'Your site is not yet registered.';
$string['registrationwarningcontactadmin'] = 'Your site is not yet registered. Please notify your administrator.';
$string['releasenoteslink'] = 'For information about this version of Moodle, please see the online <a target="_blank" href="{$a}">Release Notes</a>';
$string['rememberuserlicensepref'] = 'Remember user licence preference';
$string['rememberuserlicensepref_help'] = 'If enabled, the last licence selected by the user is preselected when uploading a file in the file picker. Otherwise, the default site licence is preselected.';
$string['rememberusername'] = 'Remember username';
$string['rememberusername_desc'] = 'Enable if you want to store permanent cookies with usernames during user login. Permanent cookies may be considered a privacy issue if used without consent.';
$string['reportsmanage'] = 'Manage reports';
$string['requiredentrieschanged'] = 'Note: After upgrading, the setting \'Required entries before viewing\' is now enforced in the following database activities:<br/>{$a->text}<br/>';
$string['requiremodintro'] = 'Require activity description';
$string['requiremodintro_desc'] = 'If enabled, users will be forced to enter a description for each activity.';
$string['required'] = 'Required';
$string['requires'] = 'Requires';
$string['purgecaches'] = 'Purge all caches';
$string['purgecachesconfirm'] = 'Moodle can cache themes, javascript, language strings, filtered text, rss feeds and many other pieces of calculated data.  Purging these caches will delete that data from the server and force browsers to refetch data, so that you can be sure you are seeing the most up-to-date values produced by the current code.  There is no danger in purging caches, but your site may appear slower for a while until the server and clients calculate new information and cache it.';
$string['purgecachesfinished'] = 'All caches were purged.';
$string['purgecachesnoneselected'] = 'Select one or more caches to purge';
$string['purgecachespage'] = 'Purge caches';
$string['purgefiltercache'] = 'Text filters';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Language strings';
$string['purgemuc'] = 'All MUC caches';
$string['purgeothercaches'] = 'All file and miscellaneous caches';
$string['purgeselectedcaches'] = 'Purge selected caches';
$string['purgeselectedcachesfinished'] = 'The selected caches were purged.';
$string['purgetemplates'] = 'Templates';
$string['purgethemecache'] = 'Themes';
$string['restorecourse'] = 'Restore course';
$string['restorernewroleid'] = 'Restorers\' role in courses';
$string['restorernewroleid_help'] = 'If the user does not already have the permission to manage the newly restored course, the user is automatically assigned this role and enrolled if necessary. Select "None" if you do not want restorers to be able to manage every restored course.';
$string['resultfilter'] = 'Filter by result';
$string['reverseproxy'] = 'Reverse proxy';
$string['reverseproxyignore'] = 'Ignore reverse proxies';
$string['riskconfig'] = 'Users could change site configuration and behaviour';
$string['riskconfigshort'] = 'Configuration risk';
$string['riskdataloss'] = 'Users could destroy large amounts of content or information';
$string['riskdatalossshort'] = 'Data loss risk';
$string['riskmanagetrust'] = 'Users could change trust settings of other users';
$string['riskmanagetrustshort'] = 'Manage trusts';
$string['riskpersonal'] = 'Users could gain access to private information of other users';
$string['riskpersonalshort'] = 'Privacy risk';
$string['riskspam'] = 'Users could send spam to site users or others';
$string['riskspamshort'] = 'Spam risk';
$string['riskxss'] = 'Users could add files and texts that allow cross-site scripting (XSS)';
$string['riskxssshort'] = 'XSS risk';
$string['roleswithexceptions'] = '{$a->roles}, with {$a->exceptions}';
$string['rssglobaldisabled'] = 'Disabled at site level';
$string['save'] = 'Save';
$string['savechanges'] = 'Save changes';
$string['scssinvalid'] = 'SCSS code is not valid, fails with: {$a}';
$string['search'] = 'Search';
$string['searchablecourses'] = 'Searchable courses';
$string['searchallavailablecourses'] = 'Searchable courses';
$string['searchallavailablecourses_off'] = 'Search within enrolled courses only';
$string['searchallavailablecourses_on'] = 'Search within all courses the user can access';
$string['searchallavailablecourses_desc'] = 'In some situations the search engine may not work when searching across a large number of courses. Set to search only enrolled courses if you need to restrict the number of courses searched.';
$string['searchdisplay'] = 'Search results display options';
$string['searchenablecategories'] = 'Display results in separate categories';
$string['searchenablecategories_desc'] = 'If enabled, search results will be displayed in separate categories.';
$string['searchhideallcategory'] = 'Hide All results category';
$string['searchhideallcategory_desc'] = 'If checked, the category with all results will be hidden on the search result screen.';
$string['searchdefaultcategory'] = 'Default search category';
$string['searchdefaultcategory_desc'] = 'Results from the selected search area category will be displayed by default.';
$string['searchallavailablecoursesdesc'] = 'If set to search within enrolled courses only, course information (name and summary) and course content will only be searched in courses which the user is enrolled in. Otherwise, course information and course content will be searched in all courses which the user can access, such as courses with guest access enabled.';
$string['searchincludeallcourses'] = 'Include all visible courses';
$string['searchincludeallcourses_desc'] = 'If enabled, search results will include course information (name and summary) of courses which are visible to the user, even if they don\'t have access to the course content.';
$string['searchalldeleted'] = 'All indexed contents have been deleted';
$string['searchareaenabled'] = 'Search area enabled';
$string['searchareadisabled'] = 'Search area disabled';
$string['searchdeleteindex'] = 'Delete all indexed contents';
$string['searchengine'] = 'Search engine';
$string['searchindexactions'] = 'Index actions';
$string['searchindexdeleted'] = 'Index deleted';
$string['searchindextime'] = 'Indexing time limit';
$string['searchindextime_desc'] = 'When indexing large amounts of new content, the scheduled task will stop after this time limit is reached. It will continue the next time the task runs.';
$string['searchindexupdated'] = 'Search engine contents have been updated';
$string['searchindexwhendisabled'] = 'Index when disabled';
$string['searchindexwhendisabled_desc'] = 'Allows the scheduled task to build the search index even when search is disabled. This is useful if you want to build the index before the search facility appears to students.';
$string['searchinsettings'] = 'Search in settings';
$string['searchlastrun'] = 'Last run (time, # docs, # records, # ignores)';
$string['searchnotavailable'] = 'Search is not available';
$string['searchpartial'] = '(not yet fully indexed)';
$string['searchoptions'] = 'Search options';
$string['searchreindexed'] = 'All site contents have been reindexed.';
$string['searchreindexindex'] = 'Reindex all site contents';
$string['searchresults'] = 'Search results';
$string['searchsetupinfo'] = 'Search setup';
$string['searchupdateindex'] = 'Update indexed contents';
$string['sectionerror'] = 'Section error!';
$string['secureforms'] = 'Use additional form security';
$string['security'] = 'Security';
$string['selectdevice'] = 'Select device';
$string['selectsearchengine'] = 'Select search engine';
$string['selecttheme'] = 'Select theme for {$a} device';
$string['server'] = 'Server';
$string['serverchecks'] = 'Server checks';
$string['serverlimit'] = 'Server limit';
$string['sessionautostartwarning'] = '<p>Serious configuration error detected, please notify server administrator.</p><p> To operate properly, Moodle requires that administrator changes PHP settings.</p><p><code>session.auto_start</code> must be set to <code>off</code>.</p><p>This setting is controlled by editing <code>php.ini</code>, Apache/IIS <br />configuration or <code>.htaccess</code> file on the server.</p>';
$string['sessioncookie'] = 'Cookie prefix';
$string['sessioncookiedomain'] = 'Cookie domain';
$string['sessioncookiepath'] = 'Cookie path';
$string['sessionhandling'] = 'Session handling';
$string['sessiontimeout'] = 'Timeout';
$string['settingdependenton'] = 'This setting may be hidden, based on the value of <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'File uploading is required for normal operation, please enable it in PHP configuration.';
$string['settingmemorylimit'] = 'Insufficient memory detected, please set higher memory limit in PHP settings.';
$string['settingsafemode'] = 'Moodle is not fully compatible with safe mode, please ask server administrator to turn it off. Running Moodle under safe mode is not supported, please expect various problems if you do so.';
$string['setupsearchengine'] = 'Setup search engine';
$string['showcommentscount'] = 'Show comments count';
$string['showdetails'] = 'Show details';
$string['showuseridentity'] = 'Show user identity';
$string['showuseridentity_desc'] = 'When selecting or searching for users, and when displaying lists of users, these fields may be shown in addition to their full name. The fields are only shown to users who have the moodle/site:viewuseridentity capability; by default, teachers and managers. (This option makes most sense if you choose one or two fields that are mandatory at your institution.)';
$string['simplexmlrequired'] = 'The SimpleXML PHP extension is now required by Moodle.';
$string['sitemenubar'] = 'Site navigation';
$string['sitemailcharset'] = 'Character set';
$string['sitemaintenance'] = 'The site is undergoing maintenance and is currently not available';
$string['sitemaintenancemode'] = 'Maintenance mode';
$string['sitemaintenanceoff'] = 'Maintenance mode has been disabled and the site is running normally again';
$string['sitemaintenanceon'] = 'Your site is currently in maintenance mode (only admins can log in or use the site).';
$string['sitemaintenanceoncli'] = 'Your site is currently in CLI maintenance mode, no web access is allowed.';
$string['sitemaintenancewarning'] = 'Your site is currently in maintenance mode (only admins can log in).  To return this site to normal operation, <a href="maintenance.php">disable maintenance mode</a>.';
$string['sitemaintenancewarning2'] = 'Your site is currently in maintenance mode (only admins can log in).  To return this site to normal operation, <a href="{$a}">disable maintenance mode</a>.';
$string['sitepolicies'] = 'Site security settings';
$string['sitepolicy'] = 'Site policy URL';
$string['sitepolicy_help'] = 'The URL of the site policy that all registered users must see and agree to before accessing the site. Note that this setting will only have an effect if the site policy handler is set to default (core).';
$string['sitepolicyhandler'] = 'Site policy handler';
$string['sitepolicyhandler_desc'] = 'This determines how policies and user consents are managed. The default (core) handler enables a site policy URL and a site policy URL for guests to be specified. The policies handler enables site, privacy and other policies to be set. It also enables user consents to be viewed and, if necessary, consent on behalf of minors to be given.';
$string['sitepolicyhandlercore'] = 'Default (core)';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitepolicyguest'] = 'Site policy URL for guests';
$string['sitepolicyguest_help'] = 'The URL of the site policy that all guests must see and agree to before accessing the site. Note that this setting will only have an effect if the site policy handler is set to default (core).';
$string['sitesectionhelp'] = 'If selected, a topic section will be displayed on the site\'s front page.';
$string['sixtyfourbitswarning'] = 'It has been detected that your site is not using a 64-bit PHP version. It is recommended that you upgrade your site to ensure future compatibility.';
$string['slasharguments'] = 'Use slash arguments';
$string['slashargumentswarning'] = 'It is recommended that the use of slash arguments is enabled. In future it will be required. For more details, see the documentation <a href="https://docs.moodle.org/en/admin/environment/slasharguments">Using slash arguments</a>.';
$string['smartpix'] = 'Smart pix search';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'SMTP Auth Type';
$string['smtpdetail'] = 'Simple Mail Transfer Protocol (SMTP) settings for sending email.';
$string['smtphosts'] = 'SMTP hosts';
$string['smtpmaxbulk'] = 'SMTP session limit';
$string['smtppass'] = 'SMTP password';
$string['smtpsecure'] = 'SMTP security';
$string['smtpuser'] = 'SMTP username';
$string['soaprecommended'] = 'Installing the optional SOAP extension is useful for web services and some plugins.';
$string['sort_fullname'] = 'Course full name';
$string['sort_idnumber'] = 'Course ID number';
$string['sort_shortname'] = 'Course short name';
$string['sort_sortorder'] = 'Sort order';
$string['spellengine'] = 'Spell engine';
$string['spelllanguagelist'] = 'Spell language list';
$string['splrequired'] = 'The SPL PHP extension is now required by Moodle.';
$string['stats'] = 'Statistics';
$string['statsfirstrun'] = 'Maximum processing interval';
$string['statsmaxruntime'] = 'Maximum runtime';
$string['statsmoodleorg'] = 'statistics';
$string['statsruntimedays'] = 'Days to process';
$string['statsruntimestart'] = 'Run at';
$string['statsuserthreshold'] = 'User threshold';
$string['stickyblocks'] = 'Sticky blocks';
$string['stickyblockscourseview'] = 'Course page';
$string['stickyblocksduplicatenotice'] = 'If any block you add here is already present in a particular page, it will result in a duplicate.<br />Only the pinned block will be non-editable, the duplicate will still be editable.';
$string['stickyblocksmymoodle'] = 'My Moodle';
$string['stickyblockspagetype'] = 'Page type to configure';
$string['strictformsrequired'] = 'Strict validation of required fields';
$string['stripalltitletags'] = 'Remove HTML tags from all activity names';
$string['supportcontact'] = 'Support contact';
$string['supportemail'] = 'Support email';
$string['supportname'] = 'Support name';
$string['supportpage'] = 'Support page';
$string['suspenduser'] = 'Suspend user account';
$string['switchlang'] = 'Switch lang directory';
$string['systempaths'] = 'System paths';
$string['tablenosave'] = 'Changes in table above are saved automatically.';
$string['tablesnosave'] = 'Changes in tables above are saved automatically.';
$string['tabselectedtofront'] = 'On tables with tabs, should the row with the currently selected tab be placed at the front';
$string['tabselectedtofronttext'] = 'Bring selected tab row to front';
$string['testsiteupgradewarning'] = 'You are currently using the {$a} test site, to upgrade it properly use the command line interface tool';
$string['task_scheduled_concurrency_limit'] = 'Scheduled task concurrency limit';
$string['task_scheduled_concurrency_limit_desc'] = 'The number of scheduled task runners allowed to run concurrently. If the limit is high then the server may experience high load which affects performance. A setting of 0 will disable processing of scheduled tasks completely.';
$string['task_scheduled_max_runtime'] = 'Scheduled task runner lifetime';
$string['task_scheduled_max_runtime_desc'] = 'The age of a scheduled task runner before it is freed.';
$string['task_adhoc_concurrency_limit'] = 'Ad hoc task concurrency limit';
$string['task_adhoc_concurrency_limit_desc'] = 'The number of ad hoc task runners allowed to run concurrently. If the limit is high then scheduled tasks may not run regularly when there are lots of ad hoc tasks. A setting of 0 will disable processing of ad hoc tasks completely.';
$string['task_adhoc_max_runtime'] = 'Ad hoc task runner lifetime';
$string['task_adhoc_max_runtime_desc'] = 'The age of an ad hoc task runner before it is freed. A low duration is recommended as there is no limit to the number of ad hoc tasks queued. If this number is too high and you have a large ad hoc task queue then scheduled tasks may not be run regularly.';
$string['task_logmode'] = 'When to log';
$string['task_logmode_desc'] = 'You can choose when you wish task logging to take place. By default logs are always captured. You can disable logging entirely, or change to only log tasks which fail.';
$string['task_logmode_none'] = 'Do not log anything';
$string['task_logmode_all'] = 'Store the log output of all jobs';
$string['task_logmode_failonly'] = 'Only store logs for jobs which fail';
$string['task_logretention'] = 'Retention period';
$string['task_logretention_desc'] = 'The maximum period that logs should be kept for. This setting interacts with the \'Retain runs\' setting: whichever is reached first will apply';
$string['task_logretainruns'] = 'Retain runs';
$string['task_logretainruns_desc'] = 'The number of runs of each task to retain. This setting interacts with the \'Retention period\' setting: whichever is reached first will apply.';
$string['task_logtostdout'] = 'Display log output';
$string['task_logtostdout_desc'] = 'When jobs are running and the output is captured, whether the captured output should also be displayed as the task runs.';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Scheduled';
$string['task_result:failed'] = 'Fail';
$string['task_stats:dbreads'] = '{$a} reads';
$string['task_stats:dbwrites'] = '{$a} writes';
$string['task_starttime'] = 'Start time';
$string['task_duration'] = 'Duration';
$string['task_dbstats'] = 'Database';
$string['task_result'] = 'Result';
$string['tasktype'] = 'Type';
$string['taskadmintitle'] = 'Tasks';
$string['taskanalyticscleanup'] = 'Analytics cleanup';
$string['taskautomatedbackup'] = 'Automated backups';
$string['taskbackupcleanup'] = 'Clean backup tables and logs';
$string['taskbadgescron'] = 'Award badges';
$string['taskbadgesmessagecron'] = 'Background processing for sending badges notifications';
$string['taskblogcron'] = 'Sync external blogs';
$string['taskcachecleanup'] = 'Remove expired cache entries';
$string['taskcachecron'] = 'Background processing for caches';
$string['taskcalendarcron'] = 'Send calendar notifications';
$string['taskcheckforupdates'] = 'Check for updates';
$string['taskcompletionregular'] = 'Calculate regular completion data';
$string['taskcompletiondaily'] = 'Completion mark as started';
$string['taskcontextcleanup'] = 'Cleanup contexts';
$string['tasklogging'] = 'Task log configuration';
$string['taskcreatecontexts'] = 'Create missing contexts';
$string['taskdeletecachetext'] = 'Delete old text cache records';
$string['taskdeleteincompleteusers'] = 'Delete incomplete users';
$string['taskdeleteunconfirmedusers'] = 'Delete unconfirmed users';
$string['taskeventscron'] = 'Background processing for events';
$string['taskfiletrashcleanup'] = 'Cleanup files in trash';
$string['taskglobalsearchindex'] = 'Global search indexing';
$string['taskglobalsearchoptimize'] = 'Global search index optimization';
$string['taskgradecron'] = 'Background processing for gradebook';
$string['taskgradehistorycleanup'] = 'Background processing for cleaning grade history tables';
$string['tasklegacycron'] = 'Legacy cron processing for plugins';
$string['tasklogcleanup'] = 'Cleanup of task logs';
$string['tasklogs'] = 'Task logs';
$string['taskmessagingcleanup'] = 'Background processing for messaging';
$string['taskpasswordresetcleanup'] = 'Cleanup password reset attempts';
$string['taskplagiarismcron'] = 'Background processing for legacy cron in plagiarism plugins';
$string['taskportfoliocron'] = 'Background processing for portfolio plugins';
$string['taskprocessing'] = 'Task processing';
$string['taskquestioncron'] = 'Background processing for cleaning up question previews';
$string['taskquestionstatscleanupcron'] = 'Background processing for cleaning up question statistics caches';
$string['taskrefreshsystemtokens'] = 'Refresh OAuth tokens for service accounts';
$string['taskregistrationcron'] = 'Site registration';
$string['tasksendfailedloginnotifications'] = 'Send failed login notifications';
$string['tasksendnewuserpasswords'] = 'Send new user passwords';
$string['tasksessioncleanup'] = 'Cleanup old sessions';
$string['taskstatscron'] = 'Background processing for statistics';
$string['tasktagcron'] = 'Background processing for tags';
$string['tasktempfilecleanup'] = 'Delete stale temp files';
$string['tempdatafoldercleanup'] = 'Clean up temporary data files older than';
$string['templates'] = 'Templates';
$string['testoutgoingmailconf'] = 'Test outgoing mail configuration';
$string['testoutgoingmaildetail'] = 'Note: Before testing, please save your configuration.<br />{$a}';
$string['testoutgoingmailconf_message'] = 'This is a test message to confirm that you have successfully configured your site\'s outgoing mail.';
$string['testoutgoingmailconf_errorcommunications'] = 'Your site couldn\'t communicate with your mail server. Please check your outgoing mail configuration.';
$string['testoutgoingmailconf_sendtest'] = 'Send a test message';
$string['testoutgoingmailconf_sentmail'] = 'This site has successfully sent a test message to the mail server.<br />From: {$a->fromemail}<br />To: {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a}: test message';
$string['testoutgoingmailconf_toemail'] = 'To email address';
$string['themedesignermode'] = 'Theme designer mode';
$string['themedesignermodewarning'] = 'Theme designer mode is enabled. This should not be enabled on production sites as it can significantly reduce performance.';
$string['themelist'] = 'Theme list';
$string['themenoselected'] = 'No theme selected';
$string['themeresetcaches'] = 'Clear theme caches';
$string['themeselect'] = 'Change theme';
$string['themeselector'] = 'Theme selector';
$string['themesettings'] = 'Theme settings';
$string['therewereerrors'] = 'There were errors in your data';
$string['thirdpartylibrary'] = 'Library';
$string['thirdpartylibrarylocation'] = 'Location';
$string['thirdpartylibs'] = 'Third party libraries';
$string['timezone'] = 'Default timezone';
$string['timezoneforced'] = 'This is forced by the site administrator';
$string['timezoneinvalid'] = 'Invalid timezone "{$a}"';
$string['timezoneisforcedto'] = 'Force all users to use';
$string['timezonenotforced'] = 'Users can choose their own timezone';
$string['timezonephpdefault'] = 'Default PHP timezone ({$a})';
$string['timezoneserver'] = 'Server timezone ({$a})';
$string['tlswarning'] = 'No PHP/cURL extension with TLSv1.2 support has been detected. Some services may not work. It is strongly recommended to upgrade your TLS libraries.';
$string['tokenduration'] = 'User created token duration';
$string['tokenduration_desc'] = 'Length of time for which a web services token created by a user (for example via the mobile app) is valid.';
$string['tokenizerrecommended'] = 'Installing the optional PHP Tokenizer extension is recommended -- it improves Moodle Networking functionality.';
$string['tools'] = 'Admin tools';
$string['toolsmanage'] = 'Manage admin tools';
$string['unattendedoperation'] = 'Unattended operation';
$string['unbookmarkthispage'] = 'Unbookmark this page';
$string['unicoderequired'] = 'It is required that you store all your data in Unicode format (UTF-8). New installations must be performed into databases that have their default character set as Unicode.  If you are upgrading, you should perform the UTF-8 migration process (see the Admin page).';
$string['uninstallplugin'] = 'Uninstall';
$string['unlockaccount'] = 'Unlock account';
$string['unoconvwarning'] = 'The version of unoconv you have installed is not supported.';
$string['unsettheme'] = 'Unset theme';
$string['unsupported'] = 'Unsupported';
$string['unsupporteddbfileformat'] = 'Your database uses Antelope as the file format. Full UTF-8 support in MySQL and MariaDB requires the Barracuda file format. Please switch to the Barracuda file format. See the documentation <a href="https://docs.moodle.org/en/admin/environment/custom check/mysql full unicode support">MySQL full unicode support</a> for details.';
$string['unsupporteddbfilepertable'] = 'For full support of UTF-8 both MySQL and MariaDB require you to change your MySQL setting \'innodb_file_per_table\' to \'ON\'. See the documentation for further details.';
$string['unsupporteddblargeprefix'] = 'For full support of UTF-8 both MySQL and MariaDB require you to change your MySQL setting \'innodb_large_prefix\' to \'ON\'. See the documentation for further details.';
$string['unsupporteddbstorageengine'] = 'The database storage engine being used is no longer supported.';
$string['unsupporteddbtablerowformat'] = 'Your database has tables using Antelope as the file format. You are recommended to convert the tables to the Barracuda file format. See the documentation <a href="https://docs.moodle.org/en/cli">Administration via command line</a> for details of a tool for converting InnoDB tables to Barracuda.';
$string['unsupportedphpversion7'] = 'PHP version 7 is not supported.';
$string['unsupportedphpversion71'] = 'PHP version 7.1 is not supported.';
$string['unsupportedphpversion72'] = 'PHP version 7.2 is not supported.';
$string['unsupportedphpversion73'] = 'PHP version 7.3 is not supported.';
$string['unsupportedphpversion74'] = 'PHP version 7.4 is not supported.';
$string['unsupportedphpversion80'] = 'PHP version 8.0 is not supported.';
$string['unsuspenduser'] = 'Activate user account';
$string['updateaccounts'] = 'Update existing accounts';
$string['updatecomponent'] = 'Update component';
$string['updateavailable'] = 'There is a newer Moodle version available!';
$string['updateavailabledetailslink'] = 'See {$a->url} for more details';
$string['updateavailableforplugin'] = 'There is a newer version for some of your plugins available!';
$string['updateavailable_moreinfo'] = 'More info...';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Version {$a}';
$string['updateavailableinstall'] = 'Install this update';
$string['updateavailableinstallall'] = 'Install available updates ({$a})';
$string['updateavailableinstallallhead'] = 'Installing available updates';
$string['updateavailablenot'] = 'Your Moodle code is up-to-date!';
$string['updateavailablerecommendation'] = 'It is strongly recommended that you update your site to the latest version to obtain all recent security and bug fixes.';
$string['updatenotifications'] = 'Update notifications';
$string['updatenotificationfooter'] = 'Your Moodle site {$a->siteurl} is configured to automatically check for available updates. You are receiving this message as the administrator of the site. You can disable automatic checks for available updates in Site administration / Server / Update notifications or customise the delivery of this message via your preferences page.';
$string['updatenotificationsubject'] = 'Moodle updates are available ({$a->siteurl})';
$string['updateautocheck'] = 'Automatically check for available updates';
$string['updateautocheck_desc'] = 'If enabled, your site will automatically check for available updates for both Moodle code and all additional plugins. If there is a new update available, a notification will be sent to site admins.';
$string['updateminmaturity'] = 'Required code maturity';
$string['updateminmaturity_desc'] = 'Notify about available updates only if the available code has the selected maturity level at least. Updates for plugins that do not declare their code maturity level are always reported regardless this setting.';
$string['updatenotifybuilds'] = 'Notify about new builds';
$string['updatenotifybuilds_desc'] = 'If enabled, the available update for Moodle code is also reported when a new build for the current version is available. Builds are continuous improvements of a given Moodle version. They are generally released every week. If disabled, the available update will be reported only when there is a higher version of Moodle released. Checks for plugins are not affected by this setting.';
$string['upgradestart'] = 'Upgrade Moodle database now';
$string['upgradepluginsfirst'] = 'It is recommended to install all available updates first';
$string['upgradepluginsinfo'] = 'Updating plugins';
$string['upgradepluginsinfo_help'] = 'There are available updates for some of your plugins. You should install them all prior to upgrading Moodle database. If your site does not support automatic updates deployment, you have to download and install new plugin versions at your server manually.';
$string['upgradepluginsinfo_link'] = 'admin/upgradepluginsinfo';
$string['upgradeerror'] = 'Unknown error upgrading {$a->plugin} to version {$a->version}. Cannot continue.';
$string['upgradeforumread'] = 'A new feature has been added in Moodle 1.5 to track read/unread forum posts.<br />To use this functionality you need to <a href="{$a}">update your tables</a>.';
$string['upgradeforumreadinfo'] = 'A new feature has been added in Moodle 1.5 to track read/unread forum posts.  To use this functionality you need to update your tables with all the tracking information for existing posts.  Depending on the size of your site this can take a long time (hours) and can be quite taxing on the database, so it\'s best to do it during a quiet period.  However, your site will continue functioning during this upgrade and users won\'t be affected.  Once you start this process you should let it finish (keep your browser window open).  However, if you stop the process by closing the window: don\'t worry, you can start over.<br /><br />Do you want to start the upgrading process now?';
$string['upgradekeyreq'] = 'Upgrade key required';
$string['upgradekeyset'] = 'Upgrade key (leave empty to not set it)';
$string['upgradelogs'] = 'For full functionality, your old logs need to be upgraded.  <a href="{$a}">More information</a>';
$string['upgradelogsinfo'] = 'Some changes have recently been made in the way logs are stored.  To be able to view all of your old logs on a per-activity basis, your old logs need to be upgraded.  Depending on your site this can take a long time (eg several hours) and can be quite taxing on the database for large sites.  Once you start this process you should let it finish (by keeping the browser window open).  Don\'t worry - your site will work fine for other people while the logs are being upgraded.<br /><br />Do you want to upgrade your logs now?';
$string['upgradesettings'] = 'New settings';
$string['upgradesettingsintro'] = 'The settings shown below were added during your last Moodle upgrade. Make any changes necessary to the defaults and then click the \'Save changes\' button at the bottom of this page.';
$string['upgradestalefiles'] = 'Mixed Moodle versions detected, upgrade cannot continue';
$string['upgradestalefilesinfo'] = 'The Moodle update process has been paused because PHP scripts from at least two major versions of Moodle have been detected in the Moodle directory.

This can cause significant problems later, so in order to continue you must ensure that the Moodle directory contains only files for a single version of Moodle.

The recommended way to clean your Moodle directory is as follows:

* rename the current Moodle directory to "moodle_old"
* create a new Moodle directory containing only files from either a standard Moodle package download, or from the Moodle Git repository
* move the original config.php file and any non-standard plugins from the "moodle_old" directory to the new Moodle directory

When you have a clean Moodle directory, refresh this page to resume the Moodle update process.

This warning is often caused by unzipping a standard Moodle package over a previous version of Moodle. While this is OK for minor upgrades, it is strongly discouraged for major Moodle upgrades.

This warning can also be caused by an incomplete checkout or update operation from the Git repository, in which case you may just have to wait for the operation to complete, or perhaps run the appropriate clean-up command and retry the operation.

You can find more information in upgrade documentation at <a href="{$a}">{$a}</a>.';
$string['upgradesure'] = '<p>Your Moodle files have been changed, and you are about to automatically upgrade your server to this version:</p>
<p><strong>{$a}</strong></p>
<p>Once you do this you can not go back again. Please note that this process can take a long time.</p>
<p>Are you sure you want to upgrade this server to this version?</p>';
$string['upgradetimedout'] = 'Upgrade timed out, please restart the upgrade.';
$string['upgradingdata'] = 'Upgrading data';
$string['upgradinglogs'] = 'Upgrading logs';
$string['upgradingversion'] = 'Upgrading to new version';
$string['upwards'] = 'upwards';
$string['useblogassociations'] = 'Enable associations';
$string['useexternalyui'] = 'Use online YUI libraries';
$string['user'] = 'User';
$string['userbulk'] = 'Bulk user actions';
$string['userbulkdownload'] = 'Export users as';
$string['userfeedbackafterupgrade'] = 'After every major upgrade';
$string['userfeedbackencouragement'] = '<p>In Moodle 3.9 onwards, a new feature is included which gives users the option to provide feedback about Moodle software to Moodle HQ via an external survey site hosted by Moodle HQ. No user-identifying information is forwarded to the survey site.</p>
<p>Moodle HQ strives to be open and transparent about its data collection practices. Thus, we want to make sure that you are aware and in control of this functionality.</p>
<p>Feedback from users will greatly assist Moodle HQ in improving the Moodle software. To enable this feature, please go to <a href="{$a}">Feedback settings</a>.</p>';
$string['userfeedbacknextreminder'] = 'Next feedback reminder';
$string['userfeedbacknextreminder_desc'] = 'When should we ask the user to give feedback again?';
$string['userfeedbackperiodically'] = 'Periodically';
$string['userfeedbackremindafter'] = 'Show reminder after';
$string['userfeedbackremindafter_desc'] = 'Remind users again to give feedback after the given number of days.';
$string['userimagesdisabled'] = 'Profile user images are disabled';
$string['userlist'] = 'Browse list of users';
$string['userdefaultpreferences'] = 'User default preferences';
$string['userfiltersdefault'] = 'Default user filters';
$string['userfiltersdefault_desc'] = 'Select the filters that should be shown on the \'Browse list of users\' page and on the \'Bulk user actions\' page. Hold down the Ctrl key to select multiple items. Any filters not selected will be available by clicking the \'Show more\' link.';
$string['usermanagement'] = 'User management';
$string['userpreference'] = 'User preference';
$string['userpolicies'] = 'User policies';
$string['users'] = 'Users';
$string['userquota'] = 'Private files space';
$string['userquota_desc'] = 'The maximum amount of data that each user can store in their private files area.';
$string['usesitenameforsitepages'] = 'Use site name for site pages';
$string['usetags'] = 'Enable tags functionality';
$string['validateemptylineerror'] = 'Empty lines are not valid';
$string['validateerror'] = 'This value is not valid';
$string['validateerrorlist'] = 'These entries are invalid: {$a}';
$string['validateiperror'] = 'These IP addresses are invalid: {$a}';
$string['verifychangedemail'] = 'Restrict domains when changing email';
$string['warningcurrentsetting'] = 'Invalid current value: {$a}';
$string['warningiconvbuggy'] = 'Your version of the iconv library does not support the //IGNORE modifier. You should install the mbstring extension which can be used instead for cleaning strings containing invalid UTF-8 characters.';
$string['webproxy'] = 'Web proxy';
$string['webproxyinfo'] = 'Fill in the following options if your Moodle server cannot access the internet directly. Internet access is required for the download of environment data, language packs, RSS feeds, timezones, etc.<br /><em>The PHP cURL extension is highly recommended.</em>';
$string['xmlrpcrecommended'] = 'The XMLRPC extension is useful for web services and Moodle networking.';
$string['yuicomboloading'] = 'YUI combo loading';
$string['ziprequired'] = 'The Zip PHP extension is now required by Moodle, info-ZIP binaries or PclZip library are not used anymore.';


$string['caching'] = 'Caching';
$string['cachesettings'] = 'Cache settings';
$string['cacherequest'] = 'Request cache';
$string['cacherequesthelp'] = 'User specific cache that expires when the request is complete. Designed to replace areas where we are using the static stores.';
$string['cachesession'] = 'Session cache';
$string['cachesessionhelp'] = 'User specific cache that expires when the user\'s session ends. Designed to alleviate session bloat/strain.';
$string['cacheapplication'] = 'Application cache';
$string['cacheapplicationhelp'] = 'Cached items are shared among all users and expire by a determined time to live (ttl).';

// Deprecated since Moodle 3.7.
$string['allowblockstodock'] = 'Allow blocks to use the dock';
$string['configallowblockstodock'] = 'If enabled and supported by the selected theme users can choose to move blocks to a special dock.';
// Deprecated since Moodle 3.8.
$string['configuserquota'] = 'The maximum number of bytes that a user can store in their own private file area. {$a->bytes} bytes == {$a->displaysize}';
$string['registermoodlenet'] = '<p>We\'d love to stay in touch and provide you with important things for your Moodle site!</p><p>By registering:</p><ul><li>You can subscribe to receive notifications of new Moodle releases, security alerts and other important news.</li><li>You can access and activate mobile push notifications from your Moodle site through our free <a href="https://download.moodle.org/mobile/">Moodle app</a>.</li><li>You are contributing to our <a href="https://stats.moodle.org">Moodle statistics</a> of the worldwide community, which help us improve Moodle and our community sites.</li><li>If you wish, your site can be included in the <a href="https://stats.moodle.org/sites/">list of registered Moodle sites</a> in your country.</li></ul>';
$string['registermoodleorg'] = 'When you register your site';
$string['registermoodleorgli1'] = 'You are added to a low-volume mailing list for important notifications such as security alerts and new releases of Moodle.';
$string['registermoodleorgli2'] = 'Statistics about your site will be added to the {$a} of the worldwide Moodle community.';
$string['registerwithmoodleorg'] = 'Register your site';
$string['configrequestcategoryselection'] = 'Allow the selection of a category when requesting a course.';
$string['requestcategoryselection'] = 'Enable category selection';

// Deprecated since Moodle 3.9.
$string['availablelicenses'] = 'Available licences';
$string['managelicenses'] = 'Manage licences';
