/*
YUI 3.13.0 (build 508226d)
Copyright 2013 Yahoo! Inc. All rights reserved.
Licensed under the BSD License.
http://yuilibrary.com/license/
*/

if (typeof __coverage__ === 'undefined') { __coverage__ = {}; }
if (!__coverage__['build/querystring-stringify/querystring-stringify.js']) {
   __coverage__['build/querystring-stringify/querystring-stringify.js'] = {"path":"build/querystring-stringify/querystring-stringify.js","s":{"1":0,"2":0,"3":0,"4":0,"5":0,"6":0,"7":0,"8":0,"9":0,"10":0,"11":0,"12":0,"13":0,"14":0,"15":0,"16":0,"17":0,"18":0,"19":0,"20":0,"21":0,"22":0,"23":0,"24":0,"25":0,"26":0,"27":0,"28":0,"29":0,"30":0,"31":0,"32":0,"33":0,"34":0},"b":{"1":[0,0],"2":[0,0],"3":[0,0],"4":[0,0],"5":[0,0],"6":[0,0],"7":[0,0],"8":[0,0,0],"9":[0,0],"10":[0,0],"11":[0,0],"12":[0,0],"13":[0,0],"14":[0,0],"15":[0,0],"16":[0,0],"17":[0,0],"18":[0,0],"19":[0,0],"20":[0,0],"21":[0,0]},"f":{"1":0,"2":0},"fnMap":{"1":{"name":"(anonymous_1)","line":1,"loc":{"start":{"line":1,"column":33},"end":{"line":1,"column":52}}},"2":{"name":"(anonymous_2)","line":48,"loc":{"start":{"line":48,"column":24},"end":{"line":48,"column":48}}}},"statementMap":{"1":{"start":{"line":1,"column":0},"end":{"line":106,"column":41}},"2":{"start":{"line":10,"column":0},"end":{"line":12,"column":15}},"3":{"start":{"line":25,"column":0},"end":{"line":25,"column":40}},"4":{"start":{"line":48,"column":0},"end":{"line":103,"column":2}},"5":{"start":{"line":49,"column":4},"end":{"line":52,"column":50}},"6":{"start":{"line":54,"column":4},"end":{"line":56,"column":5}},"7":{"start":{"line":55,"column":8},"end":{"line":55,"column":57}},"8":{"start":{"line":58,"column":4},"end":{"line":60,"column":5}},"9":{"start":{"line":59,"column":8},"end":{"line":59,"column":19}},"10":{"start":{"line":62,"column":4},"end":{"line":64,"column":5}},"11":{"start":{"line":63,"column":8},"end":{"line":63,"column":71}},"12":{"start":{"line":66,"column":4},"end":{"line":75,"column":5}},"13":{"start":{"line":67,"column":8},"end":{"line":67,"column":15}},"14":{"start":{"line":68,"column":8},"end":{"line":68,"column":39}},"15":{"start":{"line":69,"column":8},"end":{"line":69,"column":23}},"16":{"start":{"line":70,"column":8},"end":{"line":72,"column":9}},"17":{"start":{"line":71,"column":12},"end":{"line":71,"column":61}},"18":{"start":{"line":74,"column":8},"end":{"line":74,"column":27}},"19":{"start":{"line":79,"column":4},"end":{"line":83,"column":5}},"20":{"start":{"line":80,"column":8},"end":{"line":82,"column":9}},"21":{"start":{"line":81,"column":12},"end":{"line":81,"column":73}},"22":{"start":{"line":85,"column":4},"end":{"line":85,"column":20}},"23":{"start":{"line":86,"column":4},"end":{"line":86,"column":11}},"24":{"start":{"line":87,"column":4},"end":{"line":87,"column":35}},"25":{"start":{"line":88,"column":4},"end":{"line":88,"column":26}},"26":{"start":{"line":89,"column":4},"end":{"line":94,"column":5}},"27":{"start":{"line":90,"column":8},"end":{"line":93,"column":9}},"28":{"start":{"line":91,"column":12},"end":{"line":91,"column":32}},"29":{"start":{"line":92,"column":12},"end":{"line":92,"column":56}},"30":{"start":{"line":96,"column":4},"end":{"line":96,"column":16}},"31":{"start":{"line":97,"column":4},"end":{"line":97,"column":20}},"32":{"start":{"line":98,"column":4},"end":{"line":100,"column":5}},"33":{"start":{"line":99,"column":8},"end":{"line":99,"column":26}},"34":{"start":{"line":102,"column":4},"end":{"line":102,"column":13}}},"branchMap":{"1":{"line":50,"type":"cond-expr","locations":[{"start":{"line":50,"column":27},"end":{"line":50,"column":32}},{"start":{"line":50,"column":35},"end":{"line":50,"column":38}}]},"2":{"line":50,"type":"binary-expr","locations":[{"start":{"line":50,"column":14},"end":{"line":50,"column":15}},{"start":{"line":50,"column":19},"end":{"line":50,"column":24}}]},"3":{"line":51,"type":"cond-expr","locations":[{"start":{"line":51,"column":25},"end":{"line":51,"column":29}},{"start":{"line":51,"column":32},"end":{"line":51,"column":35}}]},"4":{"line":51,"type":"binary-expr","locations":[{"start":{"line":51,"column":13},"end":{"line":51,"column":14}},{"start":{"line":51,"column":18},"end":{"line":51,"column":22}}]},"5":{"line":52,"type":"cond-expr","locations":[{"start":{"line":52,"column":31},"end":{"line":52,"column":41}},{"start":{"line":52,"column":44},"end":{"line":52,"column":49}}]},"6":{"line":52,"type":"binary-expr","locations":[{"start":{"line":52,"column":13},"end":{"line":52,"column":14}},{"start":{"line":52,"column":18},"end":{"line":52,"column":28}}]},"7":{"line":54,"type":"if","locations":[{"start":{"line":54,"column":4},"end":{"line":54,"column":4}},{"start":{"line":54,"column":4},"end":{"line":54,"column":4}}]},"8":{"line":54,"type":"binary-expr","locations":[{"start":{"line":54,"column":8},"end":{"line":54,"column":21}},{"start":{"line":54,"column":25},"end":{"line":54,"column":43}},{"start":{"line":54,"column":47},"end":{"line":54,"column":64}}]},"9":{"line":55,"type":"cond-expr","locations":[{"start":{"line":55,"column":22},"end":{"line":55,"column":51}},{"start":{"line":55,"column":54},"end":{"line":55,"column":56}}]},"10":{"line":58,"type":"if","locations":[{"start":{"line":58,"column":4},"end":{"line":58,"column":4}},{"start":{"line":58,"column":4},"end":{"line":58,"column":4}}]},"11":{"line":58,"type":"binary-expr","locations":[{"start":{"line":58,"column":8},"end":{"line":58,"column":24}},{"start":{"line":58,"column":28},"end":{"line":58,"column":86}}]},"12":{"line":62,"type":"if","locations":[{"start":{"line":62,"column":4},"end":{"line":62,"column":4}},{"start":{"line":62,"column":4},"end":{"line":62,"column":4}}]},"13":{"line":62,"type":"binary-expr","locations":[{"start":{"line":62,"column":8},"end":{"line":62,"column":23}},{"start":{"line":62,"column":27},"end":{"line":62,"column":42}}]},"14":{"line":66,"type":"if","locations":[{"start":{"line":66,"column":4},"end":{"line":66,"column":4}},{"start":{"line":66,"column":4},"end":{"line":66,"column":4}}]},"15":{"line":68,"type":"cond-expr","locations":[{"start":{"line":68,"column":20},"end":{"line":68,"column":31}},{"start":{"line":68,"column":34},"end":{"line":68,"column":38}}]},"16":{"line":80,"type":"if","locations":[{"start":{"line":80,"column":8},"end":{"line":80,"column":8}},{"start":{"line":80,"column":8},"end":{"line":80,"column":8}}]},"17":{"line":87,"type":"cond-expr","locations":[{"start":{"line":87,"column":19},"end":{"line":87,"column":29}},{"start":{"line":87,"column":32},"end":{"line":87,"column":34}}]},"18":{"line":88,"type":"cond-expr","locations":[{"start":{"line":88,"column":17},"end":{"line":88,"column":20}},{"start":{"line":88,"column":23},"end":{"line":88,"column":25}}]},"19":{"line":90,"type":"if","locations":[{"start":{"line":90,"column":8},"end":{"line":90,"column":8}},{"start":{"line":90,"column":8},"end":{"line":90,"column":8}}]},"20":{"line":98,"type":"if","locations":[{"start":{"line":98,"column":4},"end":{"line":98,"column":4}},{"start":{"line":98,"column":4},"end":{"line":98,"column":4}}]},"21":{"line":98,"type":"binary-expr","locations":[{"start":{"line":98,"column":8},"end":{"line":98,"column":10}},{"start":{"line":98,"column":14},"end":{"line":98,"column":18}}]}},"code":["(function () { YUI.add('querystring-stringify', function (Y, NAME) {","","/**"," * Provides Y.QueryString.stringify method for converting objects to Query Strings."," *"," * @module querystring"," * @submodule querystring-stringify"," */","","var QueryString = Y.namespace(\"QueryString\"),","    stack = [],","    L = Y.Lang;","","/**"," * Provides Y.QueryString.escape method to be able to override default encoding"," * method.  This is important in cases where non-standard delimiters are used, if"," * the delimiters would not normally be handled properly by the builtin"," * (en|de)codeURIComponent functions."," * Default: encodeURIComponent"," *"," * @method escape"," * @for QueryString"," * @static"," **/","QueryString.escape = encodeURIComponent;","","/**"," * <p>Converts an arbitrary value to a Query String representation.</p>"," *"," * <p>Objects with cyclical references will trigger an exception.</p>"," *"," * @method stringify"," * @for QueryString"," * @public"," * @param obj {Variant} any arbitrary value to convert to query string"," * @param cfg {Object} (optional) Configuration object.  The three"," * supported configurations are:"," * <ul><li>sep: When defined, the value will be used as the key-value"," * separator.  The default value is \"&\".</li>"," * <li>eq: When defined, the value will be used to join the key to"," * the value.  The default value is \"=\".</li>"," * <li>arrayKey: When set to true, the key of an array will have the"," * '[]' notation appended to the key.  The default value is false."," * </li></ul>"," * @param name {String} (optional) Name of the current key, for handling children recursively."," * @static"," */","QueryString.stringify = function (obj, c, name) {","    var begin, end, i, l, n, s,","        sep = c && c.sep ? c.sep : \"&\",","        eq = c && c.eq ? c.eq : \"=\",","        aK = c && c.arrayKey ? c.arrayKey : false;","","    if (L.isNull(obj) || L.isUndefined(obj) || L.isFunction(obj)) {","        return name ? QueryString.escape(name) + eq : '';","    }","","    if (L.isBoolean(obj) || Object.prototype.toString.call(obj) === '[object Boolean]') {","        obj =+ obj;","    }","","    if (L.isNumber(obj) || L.isString(obj)) {","        return QueryString.escape(name) + eq + QueryString.escape(obj);","    }","","    if (L.isArray(obj)) {","        s = [];","        name = aK ? name + '[]' : name;","        l = obj.length;","        for (i = 0; i < l; i++) {","            s.push( QueryString.stringify(obj[i], c, name) );","        }","","        return s.join(sep);","    }","    // now we know it's an object.","","    // Check for cyclical references in nested objects","    for (i = stack.length - 1; i >= 0; --i) {","        if (stack[i] === obj) {","            throw new Error(\"QueryString.stringify. Cyclical reference\");","        }","    }","","    stack.push(obj);","    s = [];","    begin = name ? name + '[' : '';","    end = name ? ']' : '';","    for (i in obj) {","        if (obj.hasOwnProperty(i)) {","            n = begin + i + end;","            s.push(QueryString.stringify(obj[i], c, n));","        }","    }","","    stack.pop();","    s = s.join(sep);","    if (!s && name) {","        return name + \"=\";","    }","","    return s;","};","","","}, '3.13.0', {\"requires\": [\"yui-base\"]});","","}());"]};
}
var __cov_MF$vqAUJeR_umistRYm1qw = __coverage__['build/querystring-stringify/querystring-stringify.js'];
__cov_MF$vqAUJeR_umistRYm1qw.s['1']++;YUI.add('querystring-stringify',function(Y,NAME){__cov_MF$vqAUJeR_umistRYm1qw.f['1']++;__cov_MF$vqAUJeR_umistRYm1qw.s['2']++;var QueryString=Y.namespace('QueryString'),stack=[],L=Y.Lang;__cov_MF$vqAUJeR_umistRYm1qw.s['3']++;QueryString.escape=encodeURIComponent;__cov_MF$vqAUJeR_umistRYm1qw.s['4']++;QueryString.stringify=function(obj,c,name){__cov_MF$vqAUJeR_umistRYm1qw.f['2']++;__cov_MF$vqAUJeR_umistRYm1qw.s['5']++;var begin,end,i,l,n,s,sep=(__cov_MF$vqAUJeR_umistRYm1qw.b['2'][0]++,c)&&(__cov_MF$vqAUJeR_umistRYm1qw.b['2'][1]++,c.sep)?(__cov_MF$vqAUJeR_umistRYm1qw.b['1'][0]++,c.sep):(__cov_MF$vqAUJeR_umistRYm1qw.b['1'][1]++,'&'),eq=(__cov_MF$vqAUJeR_umistRYm1qw.b['4'][0]++,c)&&(__cov_MF$vqAUJeR_umistRYm1qw.b['4'][1]++,c.eq)?(__cov_MF$vqAUJeR_umistRYm1qw.b['3'][0]++,c.eq):(__cov_MF$vqAUJeR_umistRYm1qw.b['3'][1]++,'='),aK=(__cov_MF$vqAUJeR_umistRYm1qw.b['6'][0]++,c)&&(__cov_MF$vqAUJeR_umistRYm1qw.b['6'][1]++,c.arrayKey)?(__cov_MF$vqAUJeR_umistRYm1qw.b['5'][0]++,c.arrayKey):(__cov_MF$vqAUJeR_umistRYm1qw.b['5'][1]++,false);__cov_MF$vqAUJeR_umistRYm1qw.s['6']++;if((__cov_MF$vqAUJeR_umistRYm1qw.b['8'][0]++,L.isNull(obj))||(__cov_MF$vqAUJeR_umistRYm1qw.b['8'][1]++,L.isUndefined(obj))||(__cov_MF$vqAUJeR_umistRYm1qw.b['8'][2]++,L.isFunction(obj))){__cov_MF$vqAUJeR_umistRYm1qw.b['7'][0]++;__cov_MF$vqAUJeR_umistRYm1qw.s['7']++;return name?(__cov_MF$vqAUJeR_umistRYm1qw.b['9'][0]++,QueryString.escape(name)+eq):(__cov_MF$vqAUJeR_umistRYm1qw.b['9'][1]++,'');}else{__cov_MF$vqAUJeR_umistRYm1qw.b['7'][1]++;}__cov_MF$vqAUJeR_umistRYm1qw.s['8']++;if((__cov_MF$vqAUJeR_umistRYm1qw.b['11'][0]++,L.isBoolean(obj))||(__cov_MF$vqAUJeR_umistRYm1qw.b['11'][1]++,Object.prototype.toString.call(obj)==='[object Boolean]')){__cov_MF$vqAUJeR_umistRYm1qw.b['10'][0]++;__cov_MF$vqAUJeR_umistRYm1qw.s['9']++;obj=+obj;}else{__cov_MF$vqAUJeR_umistRYm1qw.b['10'][1]++;}__cov_MF$vqAUJeR_umistRYm1qw.s['10']++;if((__cov_MF$vqAUJeR_umistRYm1qw.b['13'][0]++,L.isNumber(obj))||(__cov_MF$vqAUJeR_umistRYm1qw.b['13'][1]++,L.isString(obj))){__cov_MF$vqAUJeR_umistRYm1qw.b['12'][0]++;__cov_MF$vqAUJeR_umistRYm1qw.s['11']++;return QueryString.escape(name)+eq+QueryString.escape(obj);}else{__cov_MF$vqAUJeR_umistRYm1qw.b['12'][1]++;}__cov_MF$vqAUJeR_umistRYm1qw.s['12']++;if(L.isArray(obj)){__cov_MF$vqAUJeR_umistRYm1qw.b['14'][0]++;__cov_MF$vqAUJeR_umistRYm1qw.s['13']++;s=[];__cov_MF$vqAUJeR_umistRYm1qw.s['14']++;name=aK?(__cov_MF$vqAUJeR_umistRYm1qw.b['15'][0]++,name+'[]'):(__cov_MF$vqAUJeR_umistRYm1qw.b['15'][1]++,name);__cov_MF$vqAUJeR_umistRYm1qw.s['15']++;l=obj.length;__cov_MF$vqAUJeR_umistRYm1qw.s['16']++;for(i=0;i<l;i++){__cov_MF$vqAUJeR_umistRYm1qw.s['17']++;s.push(QueryString.stringify(obj[i],c,name));}__cov_MF$vqAUJeR_umistRYm1qw.s['18']++;return s.join(sep);}else{__cov_MF$vqAUJeR_umistRYm1qw.b['14'][1]++;}__cov_MF$vqAUJeR_umistRYm1qw.s['19']++;for(i=stack.length-1;i>=0;--i){__cov_MF$vqAUJeR_umistRYm1qw.s['20']++;if(stack[i]===obj){__cov_MF$vqAUJeR_umistRYm1qw.b['16'][0]++;__cov_MF$vqAUJeR_umistRYm1qw.s['21']++;throw new Error('QueryString.stringify. Cyclical reference');}else{__cov_MF$vqAUJeR_umistRYm1qw.b['16'][1]++;}}__cov_MF$vqAUJeR_umistRYm1qw.s['22']++;stack.push(obj);__cov_MF$vqAUJeR_umistRYm1qw.s['23']++;s=[];__cov_MF$vqAUJeR_umistRYm1qw.s['24']++;begin=name?(__cov_MF$vqAUJeR_umistRYm1qw.b['17'][0]++,name+'['):(__cov_MF$vqAUJeR_umistRYm1qw.b['17'][1]++,'');__cov_MF$vqAUJeR_umistRYm1qw.s['25']++;end=name?(__cov_MF$vqAUJeR_umistRYm1qw.b['18'][0]++,']'):(__cov_MF$vqAUJeR_umistRYm1qw.b['18'][1]++,'');__cov_MF$vqAUJeR_umistRYm1qw.s['26']++;for(i in obj){__cov_MF$vqAUJeR_umistRYm1qw.s['27']++;if(obj.hasOwnProperty(i)){__cov_MF$vqAUJeR_umistRYm1qw.b['19'][0]++;__cov_MF$vqAUJeR_umistRYm1qw.s['28']++;n=begin+i+end;__cov_MF$vqAUJeR_umistRYm1qw.s['29']++;s.push(QueryString.stringify(obj[i],c,n));}else{__cov_MF$vqAUJeR_umistRYm1qw.b['19'][1]++;}}__cov_MF$vqAUJeR_umistRYm1qw.s['30']++;stack.pop();__cov_MF$vqAUJeR_umistRYm1qw.s['31']++;s=s.join(sep);__cov_MF$vqAUJeR_umistRYm1qw.s['32']++;if((__cov_MF$vqAUJeR_umistRYm1qw.b['21'][0]++,!s)&&(__cov_MF$vqAUJeR_umistRYm1qw.b['21'][1]++,name)){__cov_MF$vqAUJeR_umistRYm1qw.b['20'][0]++;__cov_MF$vqAUJeR_umistRYm1qw.s['33']++;return name+'=';}else{__cov_MF$vqAUJeR_umistRYm1qw.b['20'][1]++;}__cov_MF$vqAUJeR_umistRYm1qw.s['34']++;return s;};},'3.13.0',{'requires':['yui-base']});
