/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.util.WeakListeners;

@Deprecated
public class DefaultPropertyModel
implements ExPropertyModel,
PropertyChangeListener {
    Object bean;
    String propertyName;
    private PropertyChangeSupport support;
    private PropertyDescriptor prop;
    private Method readMethod;
    private Method writeMethod;
    private Class propertyTypeClass;
    private boolean donotfire = false;

    public DefaultPropertyModel(Object object, String string) throws IllegalArgumentException {
        this(object, DefaultPropertyModel.findInfo(object, string));
    }

    public DefaultPropertyModel(Object object, PropertyDescriptor propertyDescriptor) {
        this.bean = object;
        this.propertyName = propertyDescriptor.getName();
        this.support = new PropertyChangeSupport(this);
        this.prop = propertyDescriptor;
        this.propertyTypeClass = propertyDescriptor.getPropertyType();
        this.readMethod = propertyDescriptor.getReadMethod();
        this.writeMethod = propertyDescriptor.getWriteMethod();
        try {
            try {
                Method method = object.getClass().getMethod("addPropertyChangeListener", String.class, PropertyChangeListener.class);
                method.invoke(object, this.propertyName, WeakListeners.propertyChange((PropertyChangeListener)this, (Object)object));
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Method method = object.getClass().getMethod("addPropertyChangeListener", PropertyChangeListener.class);
                    method.invoke(object, WeakListeners.propertyChange((PropertyChangeListener)this, (Object)object));
                }
                catch (NoSuchMethodException noSuchMethodException2) {}
            }
        }
        catch (Exception exception) {
            Logger.getLogger(DefaultPropertyModel.class.getName()).log(Level.WARNING, null, exception);
        }
    }

    private static PropertyDescriptor findInfo(Object object, String string) throws IllegalArgumentException {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getName().equals(string)) continue;
                return propertyDescriptorArray[i];
            }
            throw new IllegalArgumentException("No property named " + string + " in class " + object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            throw (IllegalArgumentException)new IllegalArgumentException(introspectionException.toString()).initCause(introspectionException);
        }
    }

    public Class getPropertyType() {
        return this.propertyTypeClass;
    }

    public Object getValue() throws InvocationTargetException {
        try {
            return this.readMethod == null ? null : this.readMethod.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(DefaultPropertyModel.class.getName()).log(Level.WARNING, null, illegalAccessException);
            throw new InvocationTargetException(illegalAccessException);
        }
    }

    public void setValue(Object object) throws InvocationTargetException {
        try {
            if (this.writeMethod != null) {
                this.donotfire = true;
                this.writeMethod.invoke(this.bean, object);
                this.donotfire = false;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            Logger.getLogger(DefaultPropertyModel.class.getName()).log(Level.WARNING, null, illegalAccessException);
            throw new InvocationTargetException(illegalAccessException);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.propertyName.equals(propertyChangeEvent.getPropertyName()) && !this.donotfire) {
            this.support.firePropertyChange("value", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public Class getPropertyEditorClass() {
        return this.prop.getPropertyEditorClass();
    }

    public Object[] getBeans() {
        return new Object[]{this.bean};
    }

    public FeatureDescriptor getFeatureDescriptor() {
        return this.prop;
    }
}

