/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.search.MatchingObject;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.util.NbBundle;
import org.openide.util.UserQuestionException;

final class ReplaceTask
implements Runnable {
    private static final int MAX_ERRORS_CHECKED = 20;
    private final MatchingObject[] matchingObjects;
    private final ProgressHandle progressHandle;
    private final List<String> problems;
    private ResultStatus resultStatus = null;

    ReplaceTask(MatchingObject[] matchingObjectArray) {
        this.matchingObjects = matchingObjectArray;
        this.problems = new ArrayList<String>(4);
        this.progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"LBL_Replacing"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        assert (!EventQueue.isDispatchThread());
        this.progressHandle.start(this.matchingObjects.length * 2);
        try {
            this.replace();
            assert (this.resultStatus != null);
        }
        finally {
            this.progressHandle.finish();
        }
    }

    private void replace() {
        assert (!EventQueue.isDispatchThread());
        this.checkForErrors();
        if (this.resultStatus == null) {
            this.doReplace();
        }
    }

    private void checkForErrors() {
        assert (!EventQueue.isDispatchThread());
        int n = 0;
        for (int i = 0; i < this.matchingObjects.length; ++i) {
            MatchingObject.InvalidityStatus invalidityStatus = this.matchingObjects[i].checkValidity();
            if (invalidityStatus == null) continue;
            this.problems.add(invalidityStatus.getDescription(this.matchingObjects[i].getFile().getPath()));
            if (++n > 20) break;
        }
        if (!this.problems.isEmpty()) {
            this.resultStatus = ResultStatus.PRE_CHECK_FAILED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReplace() {
        assert (!EventQueue.isDispatchThread());
        for (int i = 0; i < this.matchingObjects.length; ++i) {
            MatchingObject matchingObject = this.matchingObjects[i];
            this.progressHandle.progress(matchingObject.getName(), i + this.matchingObjects.length);
            if (!matchingObject.isSelected() || !matchingObject.isValid()) continue;
            String string = matchingObject.getInvalidityDescription();
            if (string != null) {
                this.problems.add(string);
                continue;
            }
            String string2 = null;
            FileLock fileLock = null;
            try {
                fileLock = matchingObject.lock();
                MatchingObject.InvalidityStatus invalidityStatus = matchingObject.replace();
                if (invalidityStatus == null) {
                    matchingObject.write(fileLock);
                } else {
                    string2 = invalidityStatus.getDescription(matchingObject.getFile().getPath());
                }
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                string2 = ReplaceTask.createMsgFileLocked(matchingObject);
            }
            catch (UserQuestionException userQuestionException) {
                string2 = ReplaceTask.createMsgFileLocked(matchingObject);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                string2 = iOException.getLocalizedMessage();
                if (string2 == null) {
                    string2 = iOException.getMessage();
                }
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
            if (string2 == null) continue;
            this.problems.add(string2);
        }
        this.resultStatus = this.problems.isEmpty() ? ResultStatus.SUCCESS : ResultStatus.PROBLEMS_ENCOUNTERED;
    }

    private static String createMsgFileLocked(MatchingObject matchingObject) {
        return NbBundle.getMessage(ReplaceTask.class, (String)"MSG_cannot_access_file_already_locked", (Object)matchingObject.getName());
    }

    ResultStatus getResultStatus() {
        return this.resultStatus;
    }

    String[] getProblems() {
        return this.problems.isEmpty() ? null : this.problems.toArray(new String[this.problems.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ResultStatus {
        SUCCESS,
        PRE_CHECK_FAILED,
        PROBLEMS_ENCOUNTERED;

    }
}

