/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.SwingUtilities;
import org.netbeans.updater.Localization;
import org.netbeans.updater.ModuleUpdate;
import org.netbeans.updater.UpdateTracking;
import org.netbeans.updater.UpdaterFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleUpdater
extends Thread {
    private static final String DOWNLOAD_DIR_NAME = "download";
    static final String DOWNLOAD_DIR = "update" + UpdateTracking.FILE_SEPARATOR + "download";
    private static final String BACKUP_DIR = "update" + UpdateTracking.FILE_SEPARATOR + "backup";
    public static final String UPDATE_NETBEANS_DIR = "netbeans";
    public static final String UPDATE_JAVA_EXT_DIR = "java_ext";
    public static final String UPDATE_MAIN_DIR = "main";
    private static final String JVM_PARAMS_FILE = "main.properties";
    public static final String NBM_EXTENSION = "nbm";
    public static final String LOG_FILE_NAME = "update.log";
    public static final String LATER_FILE_NAME = "install_later.xml";
    public static final char SPACE = ' ';
    public static final char QUOTE = '\"';
    private static final String TEMP_FILE_NAME = "temporary";
    private Collection<File> forInstall;
    private Map<File, Collection<File>> files2clustersForInstall;
    private volatile boolean stop = false;
    private volatile boolean suspend = false;
    private long totalLength;

    public ModuleUpdater(Collection<File> collection) {
        this.forInstall = collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (!SwingUtilities.isEventDispatchThread()) : "Cannot run in EQ";
        try {
            this.checkStop();
            if (this.getClustersForInstall().isEmpty()) {
                this.endRun();
            }
            this.checkStop();
            this.totalLength();
            this.checkStop();
            this.unpack();
            for (File file : UpdateTracking.clusters(true)) {
                this.deleteAdditionalInfo(file);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (UpdaterFrame.isFromIDE()) {
                UpdaterFrame.getUpdaterFrame().runningFinished();
            }
        }
    }

    private void deleteInstallLater(File file) {
        File file2 = new File(file, UpdateTracking.FILE_SEPARATOR + DOWNLOAD_DIR + UpdateTracking.FILE_SEPARATOR + LATER_FILE_NAME);
        if (file2.exists()) {
            file2.delete();
        }
        for (File file3 = file2.getParentFile(); file3 != null && file3.delete(); file3 = file3.getParentFile()) {
        }
    }

    private void deleteAdditionalInfo(File file) {
        File file2;
        File file3 = new File(file, UpdateTracking.FILE_SEPARATOR + DOWNLOAD_DIR + UpdateTracking.FILE_SEPARATOR + "additional_information.xml");
        if (file3 != null && file3.exists()) {
            file3.delete();
        }
        File file4 = file2 = file3 == null ? null : file3.getParentFile();
        while (file2 != null && file2.delete()) {
            file2 = file2.getParentFile();
        }
    }

    void endRun() {
        this.stop = true;
    }

    private void checkStop() {
        if (this.suspend) {
            while (this.suspend) {
            }
        }
        if (this.stop) {
            if (UpdaterFrame.isFromIDE()) {
                UpdaterFrame.getUpdaterFrame().unpackingFinished();
            } else {
                System.exit(0);
            }
        }
    }

    private void processFilesForInstall() {
        if (this.forInstall == null) {
            this.files2clustersForInstall = new HashMap<File, Collection<File>>();
            for (File file : UpdateTracking.clusters(true)) {
                Set<File> set = ModuleUpdater.getModulesToInstall(file);
                this.files2clustersForInstall.put(file, set);
                if (UpdaterFrame.isFromIDE()) continue;
                this.deleteInstallLater(file);
            }
        } else {
            this.files2clustersForInstall = new HashMap<File, Collection<File>>();
            for (File file : this.forInstall) {
                File file2 = ModuleUpdater.getCluster(file);
                if (this.files2clustersForInstall.get(file2) == null) {
                    this.files2clustersForInstall.put(file2, new HashSet());
                }
                this.files2clustersForInstall.get(file2).add(file);
            }
        }
    }

    private static File getCluster(File file) {
        File file2 = null;
        try {
            assert (file.exists()) : file + " for install exists.";
            assert (file.getParentFile() != null) : file + " has parent.";
            assert (DOWNLOAD_DIR_NAME.equalsIgnoreCase(file.getParentFile().getName())) : file + " is in directory " + "download";
            assert (file.getParentFile().getParentFile() != null) : file.getParentFile() + " has parent.";
            assert ("update".equalsIgnoreCase(file.getParentFile().getParentFile().getName())) : file + " is in directory " + "update";
            assert (file.getParentFile().getParentFile().getParentFile() != null) : file.getParentFile().getParentFile() + " has parent.";
            file2 = file.getParentFile().getParentFile().getParentFile();
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("Error: getCluster (" + file + ") throws " + nullPointerException);
        }
        return file2;
    }

    private Collection<File> getFilesForInstallInCluster(File file) {
        if (this.files2clustersForInstall == null) {
            this.processFilesForInstall();
        }
        return this.files2clustersForInstall.get(file);
    }

    private Collection<File> getClustersForInstall() {
        if (this.files2clustersForInstall == null) {
            this.processFilesForInstall();
        }
        return this.files2clustersForInstall.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void totalLength() {
        this.totalLength = 0L;
        UpdaterFrame.setLabel(Localization.getBrandedString("CTL_PreparingUnpack"));
        HashSet<File> hashSet = new HashSet<File>();
        for (File object : this.getClustersForInstall()) {
            hashSet.addAll(this.getFilesForInstallInCluster(object));
        }
        UpdaterFrame.setProgressRange(0L, hashSet.size());
        int n = 0;
        for (File file : hashSet) {
            JarFile jarFile = null;
            try {
                jarFile = new JarFile(file);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    this.checkStop();
                    if (!jarEntry.getName().startsWith(UPDATE_NETBEANS_DIR) && !jarEntry.getName().startsWith(UPDATE_JAVA_EXT_DIR) && !jarEntry.getName().startsWith(UPDATE_MAIN_DIR) || jarEntry.isDirectory()) continue;
                    this.totalLength += jarEntry.getSize();
                }
                UpdaterFrame.setProgressValue(n++);
            }
            catch (IOException iOException) {
                System.out.println("Error: Counting size of entries in " + file + " throws " + iOException);
            }
            finally {
                try {
                    if (jarFile == null) continue;
                    jarFile.close();
                }
                catch (IOException iOException) {
                    System.out.println("Error: Closing " + jarFile + " input stream throws " + iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpack() {
        UpdateTracking.Version version;
        UpdateTracking.Module module;
        long l = 0L;
        UpdaterFrame.setLabel("");
        UpdaterFrame.setProgressRange(0L, this.totalLength);
        ArrayList<UpdateTracking> arrayList = new ArrayList<UpdateTracking>();
        HashMap<ModuleUpdate, UpdateTracking.Version> hashMap = new HashMap<ModuleUpdate, UpdateTracking.Version>();
        for (File object : this.getClustersForInstall()) {
            UpdateTracking updateTracking = UpdateTracking.getTracking(object, true);
            if (updateTracking == null) {
                throw new RuntimeException("No update_tracking file in cluster " + object);
            }
            arrayList.add(updateTracking);
            for (File file : this.getFilesForInstallInCluster(object)) {
                Object object2;
                Object object3;
                UpdaterFrame.getUpdaterFrame().unpackingIsRunning();
                ModuleUpdate moduleUpdate = null;
                try {
                    moduleUpdate = new ModuleUpdate(file);
                }
                catch (RuntimeException runtimeException) {
                    if (!file.exists() || file.delete()) continue;
                    System.out.println("Error: File " + file + " cannot be deleted. Propably file lock on the file.");
                    assert (false) : "Error: File " + file + " cannot be deleted. Propably file lock on the file.";
                    file.deleteOnExit();
                    continue;
                }
                assert (moduleUpdate != null) : "Module update is not null for file: " + file;
                if (moduleUpdate.isL10n()) {
                    module = null;
                    version = updateTracking.createVersion("0");
                    hashMap.put(moduleUpdate, version);
                } else {
                    module = updateTracking.readModuleTracking(moduleUpdate.getCodenamebase(), true);
                    object3 = UpdateTracking.getAdditionalInformation(object);
                    object2 = object3 != null && ((UpdateTracking.AdditionalInfo)object3).getSource(file.getName()) != null ? ((UpdateTracking.AdditionalInfo)object3).getSource(file.getName()) : "updater";
                    version = module.addNewVersion(moduleUpdate.getSpecification_version(), (String)object2);
                }
                boolean bl = false;
                UpdaterFrame.setLabel(Localization.getBrandedString("CTL_UnpackingFile") + "  " + file.getName());
                UpdaterFrame.setProgressValue(l);
                object3 = null;
                try {
                    Object object4;
                    Object object5;
                    Object object6;
                    object3 = new JarFile(file);
                    object2 = ((JarFile)object3).entries();
                    while (object2.hasMoreElements()) {
                        object6 = (JarEntry)object2.nextElement();
                        this.checkStop();
                        if (((ZipEntry)object6).getName().startsWith(UPDATE_NETBEANS_DIR)) {
                            if (((ZipEntry)object6).isDirectory()) continue;
                            object5 = ((ZipEntry)object6).getName().substring(UPDATE_NETBEANS_DIR.length() + 1);
                            if (moduleUpdate.isL10n()) {
                                version.addL10NFileWithCrc((String)object5, Long.toString(((ZipEntry)object6).getCrc()), moduleUpdate.getSpecification_version());
                            } else {
                                version.addFileWithCrc((String)object5, Long.toString(((ZipEntry)object6).getCrc()));
                            }
                            object4 = new File(object, ((ZipEntry)object6).getName().substring(UPDATE_NETBEANS_DIR.length()));
                            if (((File)object4).exists()) {
                                File file2 = new File(this.getBackupDirectory(object), ((ZipEntry)object6).getName());
                                file2.getParentFile().mkdirs();
                                this.copyStreams(new FileInputStream((File)object4), new FileOutputStream(file2), -1L);
                                if (!((File)object4).delete() && ModuleUpdater.isWindows()) {
                                    ModuleUpdater.trickyDeleteOnWindows((File)object4);
                                }
                            } else {
                                ((File)object4).getParentFile().mkdirs();
                            }
                            l = this.copyStreams(((JarFile)object3).getInputStream((ZipEntry)object6), new FileOutputStream((File)object4), l);
                            UpdaterFrame.setProgressValue(l);
                            continue;
                        }
                        if (!((ZipEntry)object6).getName().startsWith(UPDATE_MAIN_DIR) || ((ZipEntry)object6).isDirectory()) continue;
                        object5 = new File(this.getMainDirectory(object), ((ZipEntry)object6).getName().substring(UPDATE_MAIN_DIR.length() + 1));
                        ((File)object5).getParentFile().mkdirs();
                        bl = true;
                        l = this.copyStreams(((JarFile)object3).getInputStream((ZipEntry)object6), new FileOutputStream((File)object5), l);
                        UpdaterFrame.setProgressValue(l);
                    }
                    if (bl && ((MainConfig)(object6 = new MainConfig(this.getMainDirString(object) + UpdateTracking.FILE_SEPARATOR + JVM_PARAMS_FILE, object))).isValid()) {
                        object5 = System.getProperty("java.home") + UpdateTracking.FILE_SEPARATOR + "bin" + UpdateTracking.FILE_SEPARATOR + "java";
                        object5 = ModuleUpdater.quoteString((String)object5);
                        object4 = (String)object5 + " -cp " + ModuleUpdater.quoteString(this.getMainDirString(object) + ((MainConfig)object6).getClasspath()) + ((MainConfig)object6).getCommand();
                        this.startCommand((String)object4);
                        this.deleteDir(this.getMainDirectory(object));
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    try {
                        if (object3 != null) {
                            ((ZipFile)object3).close();
                        }
                    }
                    catch (IOException iOException) {}
                    if (!file.delete()) {
                        System.out.println("Error: Cannot delete " + file);
                        file.deleteOnExit();
                    }
                }
                if (moduleUpdate.isL10n()) continue;
                module.write();
                module.writeConfigModuleXMLIfMissing();
            }
        }
        for (UpdateTracking updateTracking : arrayList) {
            for (Map.Entry entry : hashMap.entrySet()) {
                ModuleUpdate moduleUpdate = (ModuleUpdate)entry.getKey();
                version = (UpdateTracking.Version)entry.getValue();
                module = updateTracking.readModuleTracking(moduleUpdate.getCodenamebase(), true);
                module.addL10NVersion(version);
                module.write();
            }
            updateTracking.deleteUnusedFiles();
        }
    }

    private static boolean trickyDeleteOnWindows(File file) {
        assert (ModuleUpdater.isWindows()) : "Call it only on Windows but system is " + System.getProperty("os.name");
        File file2 = new File(file.getParentFile(), file.getName());
        assert (file2.exists()) : "The file " + file2 + " must exists.";
        try {
            File file3 = File.createTempFile(TEMP_FILE_NAME, null, file2.getParentFile());
            if (file3.delete()) {
                file2.renameTo(file3);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return !file2.exists();
    }

    private static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string != null && string.toLowerCase().startsWith("windows");
    }

    private void startCommand(String string) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process;
            final Process process2 = process = runtime.exec(ModuleUpdater.parseParameters(string));
            new Thread(){

                public void run() {
                    try {
                        String string;
                        InputStreamReader inputStreamReader = new InputStreamReader(process2.getErrorStream());
                        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                        do {
                            if ((string = bufferedReader.readLine()) == null) continue;
                            System.out.println(string);
                        } while (string != null);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }.start();
            int n = process.waitFor();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public File getBackupDirectory(File file) {
        File file2 = new File(file, BACKUP_DIR);
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        return file2;
    }

    private File getMainDirectory(File file) {
        File file2 = new File(file, UpdateTracking.FILE_SEPARATOR + "update" + UpdateTracking.FILE_SEPARATOR + UPDATE_MAIN_DIR);
        if (!file2.isDirectory()) {
            file2.mkdirs();
        }
        return file2;
    }

    private String getMainDirString(File file) {
        return this.getMainDirectory(file).getPath();
    }

    public static final String quoteString(String string) {
        if (string.indexOf(32) > -1) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = 0;
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) == '\"') {
                    stringBuffer.deleteCharAt(n);
                    continue;
                }
                ++n;
            }
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copyStreams(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        int n = 0;
        try {
            int n2;
            while ((n2 = bufferedInputStream.read()) != -1) {
                bufferedOutputStream.write(n2);
                if (++n <= 8500) continue;
                if (l >= 0L) {
                    UpdaterFrame.setProgressValue(l += (long)n);
                }
                n = 0;
                this.checkStop();
            }
            if (l >= 0L) {
                l += (long)n;
            }
        }
        finally {
            bufferedInputStream.close();
            bufferedOutputStream.close();
            inputStream.close();
            outputStream.close();
        }
        return l;
    }

    private void deleteDir(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            this.deleteDir(fileArray[i]);
            if (fileArray[i].delete()) continue;
            System.out.println("Error: Cannot delete " + fileArray[i]);
            assert (false) : "Cannot delete " + fileArray[i];
        }
    }

    private static String[] parseParameters(String string) {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 4;
        int n5 = 8;
        Vector<String> vector = new Vector<String>(5, 5);
        int n6 = n;
        StringBuilder stringBuilder = new StringBuilder(20);
        int n7 = string.length();
        for (int i = 0; i < n7; ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) {
                if (n6 == n) {
                    if (stringBuilder.length() <= 0) continue;
                    vector.addElement(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (n6 == n4) {
                    vector.addElement(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    n6 = n;
                    continue;
                }
                if (n6 == n5) {
                    stringBuilder.append('\\');
                    vector.addElement(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    n6 = n;
                    continue;
                }
                if (n6 == n3) {
                    n6 = n2;
                    stringBuilder.append('\\');
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '\\') {
                if (n6 == n) {
                    if (++i < n7) {
                        char c2 = string.charAt(i);
                        if (c2 == '\"' || c2 == '\\') {
                            stringBuilder.append(c2);
                            continue;
                        }
                        if (Character.isWhitespace(c2)) {
                            stringBuilder.append(c);
                            --i;
                            continue;
                        }
                        stringBuilder.append(c);
                        stringBuilder.append(c2);
                        continue;
                    }
                    stringBuilder.append('\\');
                    break;
                }
                if (n6 == n2) {
                    n6 = n3;
                    continue;
                }
                if (n6 == n3) {
                    stringBuilder.append('\\');
                    n6 = n2;
                    continue;
                }
                if (n6 == n4) {
                    n6 = n5;
                    continue;
                }
                if (n6 != n5) continue;
                stringBuilder.append('\\');
                n6 = n4;
                continue;
            }
            if (c == '\"') {
                if (n6 == n) {
                    n6 = n2;
                    continue;
                }
                if (n6 == n2) {
                    n6 = n4;
                    continue;
                }
                if (n6 == n4) {
                    n6 = n2;
                    continue;
                }
                if (n6 == n5) {
                    stringBuilder.append('\"');
                    n6 = n4;
                    continue;
                }
                stringBuilder.append('\"');
                n6 = n2;
                continue;
            }
            if (n6 == n3) {
                stringBuilder.append('\\');
                n6 = n2;
            } else if (n6 == n5) {
                stringBuilder.append('\\');
                n6 = n4;
            }
            stringBuilder.append(c);
        }
        if (n6 == n2) {
            vector.addElement(stringBuilder.toString());
        } else if ((n6 & (n3 | n5)) != 0) {
            stringBuilder.append('\\');
            vector.addElement(stringBuilder.toString());
        } else if (stringBuilder.length() != 0) {
            vector.addElement(stringBuilder.toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Set<File> getModulesToInstall(File file) {
        File file2 = new File(file, DOWNLOAD_DIR);
        class NbmFilter
        implements FilenameFilter {
            NbmFilter() {
            }

            public boolean accept(File file, String string) {
                return string.endsWith(ModuleUpdater.NBM_EXTENSION);
            }
        }
        File[] fileArray = file2.listFiles(new NbmFilter());
        if (fileArray == null) {
            return Collections.emptySet();
        }
        return new HashSet<File>(Arrays.asList(fileArray));
    }

    class MainConfig {
        private final String PAR_MAIN = "mainClass";
        private final String PAR_RELCP = "relativeClassPath";
        private final String PAR_JVMPAR = "jvm.parameters";
        private final String PAR_MAINARGS = "mainClass.arguments";
        private final String VAR_IDE_HOME = "%IDE_HOME%";
        private final String VAR_IDE_USER = "%IDE_USER%";
        private final String VAR_FILE_SEPARATOR = "%FS%";
        private final String VAR_JAVA_HOME = "%JAVA_HOME%";
        private String parameters = "";
        private String classpath = "";
        private boolean valid = false;
        private final File activeCluster;

        public MainConfig(String string, File file) {
            this.valid = this.readParms(string);
            this.activeCluster = file;
        }

        public String getCommand() {
            return this.parameters;
        }

        public String getClasspath() {
            return this.classpath;
        }

        public boolean isValid() {
            return this.valid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean readParms(String string) {
            String string2;
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string);
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                boolean bl = false;
                return bl;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            String string3 = properties.getProperty("relativeClassPath", null);
            if (string3 != null) {
                string3 = this.replaceVars(string3);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, UpdateTracking.PATH_SEPARATOR, false);
                while (stringTokenizer.hasMoreTokens()) {
                    this.classpath = this.classpath + UpdateTracking.PATH_SEPARATOR + this.changeRelative(stringTokenizer.nextToken());
                }
            }
            this.parameters = "";
            String string4 = properties.getProperty("jvm.parameters", null);
            if (string4 != null) {
                this.parameters = this.parameters + " " + string4;
            }
            if ((string2 = properties.getProperty("mainClass", null)) == null) {
                return false;
            }
            this.parameters = this.parameters + " " + string2;
            String string5 = properties.getProperty("mainClass.arguments", null);
            if (string5 != null) {
                this.parameters = this.parameters + " " + string5;
            }
            this.parameters = this.replaceVars(this.parameters);
            return true;
        }

        private String replaceVars(String string) {
            string = this.replaceAll(string, "%IDE_HOME%", UpdateTracking.getPlatformDir() == null ? "" : UpdateTracking.getPlatformDir().getPath());
            string = this.replaceAll(string, "%IDE_USER%", UpdateTracking.getPlatformDir() == null ? "" : UpdateTracking.getPlatformDir().getPath());
            string = this.replaceAll(string, "%FS%", UpdateTracking.FILE_SEPARATOR);
            string = this.replaceAll(string, "%JAVA_HOME%", System.getProperty("java.home"));
            return string;
        }

        private String changeRelative(String string) {
            if (new File(string).isAbsolute()) {
                return string;
            }
            return ModuleUpdater.this.getMainDirString(this.activeCluster) + UpdateTracking.FILE_SEPARATOR + string;
        }

        private String replaceAll(String string, String string2, String string3) {
            StringBuffer stringBuffer = new StringBuffer(string);
            int n = stringBuffer.toString().indexOf(string2);
            int n2 = string2.length();
            while (n > -1) {
                stringBuffer.replace(n, n + n2, string3);
                n = stringBuffer.toString().indexOf(string2, n + 1);
            }
            return stringBuffer.toString();
        }
    }
}

