/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.diff.XMLEncodingHelper;
import org.openide.ErrorManager;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodedReaderFactory {
    private static final String CHAR_SET_ATTRIBUTE = "Content-Encoding";
    private static EncodedReaderFactory factory;

    private EncodedReaderFactory() {
    }

    public static synchronized EncodedReaderFactory getDefault() {
        if (factory == null) {
            factory = new EncodedReaderFactory();
        }
        return factory;
    }

    public Reader getReader(File file, String string) throws FileNotFoundException {
        return this.getReader(file, string, this.getEncoding(file));
    }

    public Reader getReader(File file, String string, String string2) throws FileNotFoundException {
        String string3;
        if (string2 != null) {
            try {
                return new InputStreamReader((InputStream)new FileInputStream(file), string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorManager.getDefault().notify(1, (Throwable)unsupportedEncodingException);
            }
        }
        Reader reader = null;
        String string4 = file.getName();
        int n = string4.lastIndexOf(46);
        String string5 = string3 = n >= 0 && n < string4.length() - 1 ? string4.substring(n + 1) : "";
        if (!"java".equalsIgnoreCase(string3)) {
            try {
                file = FileUtil.normalizeFile((File)file);
                FileObject fileObject = FileUtil.toFileObject((File)file);
                if (fileObject != null) {
                    reader = this.getReaderFromEditorSupport(fileObject, fileObject);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
            }
            if (reader == null) {
                reader = this.getReaderFromKit(file, null, string);
            }
        }
        if (reader == null) {
            reader = new InputStreamReader(new FileInputStream(file));
        }
        return reader;
    }

    public Reader getReader(FileObject fileObject, String string) throws FileNotFoundException {
        return this.getReader(fileObject, string, fileObject.getExt());
    }

    public Reader getReader(FileObject fileObject, String string, String string2) throws FileNotFoundException {
        return this.getReader(fileObject, string, fileObject, string2);
    }

    public Reader getReader(FileObject fileObject, String string, FileObject fileObject2) throws FileNotFoundException {
        return this.getReader(fileObject, string, fileObject2, fileObject2.getExt());
    }

    private Reader getReader(FileObject fileObject, String string, FileObject fileObject2, String string2) throws FileNotFoundException {
        if (string != null) {
            try {
                return new InputStreamReader(fileObject.getInputStream(), string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorManager.getDefault().notify(1, (Throwable)unsupportedEncodingException);
            }
        }
        Reader reader = null;
        String string3 = fileObject2.getExt();
        if (!("java".equalsIgnoreCase(string3) && string3.equals(string2) || (reader = this.getReaderFromEditorSupport(fileObject, fileObject2)) != null)) {
            reader = this.getReaderFromKit(null, fileObject, fileObject2.getMIMEType());
        }
        if (reader == null) {
            reader = new InputStreamReader(fileObject.getInputStream());
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader getReaderFromEditorSupport(FileObject fileObject, FileObject fileObject2) throws FileNotFoundException {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject2);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        if (!fileObject2.equals(dataObject.getPrimaryFile())) {
            return null;
        }
        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        CloneableEditorSupport cloneableEditorSupport = null;
        if (editCookie instanceof CloneableEditorSupport) {
            cloneableEditorSupport = (CloneableEditorSupport)editCookie;
        }
        if (cloneableEditorSupport == null) {
            return null;
        }
        try {
            Method method = EncodedReaderFactory.getDeclaredMethod(cloneableEditorSupport.getClass(), "createEditorKit", new Class[0]);
            method.setAccessible(true);
            EditorKit editorKit = (EditorKit)method.invoke((Object)cloneableEditorSupport, new Object[0]);
            Method method2 = EncodedReaderFactory.getDeclaredMethod(cloneableEditorSupport.getClass(), "createStyledDocument", new Class[]{EditorKit.class});
            method2.setAccessible(true);
            StyledDocument styledDocument = (StyledDocument)method2.invoke((Object)cloneableEditorSupport, editorKit);
            Method method3 = EncodedReaderFactory.getDeclaredMethod(cloneableEditorSupport.getClass(), "loadFromStreamToKit", new Class[]{StyledDocument.class, InputStream.class, EditorKit.class});
            method3.setAccessible(true);
            InputStream inputStream = fileObject.getInputStream();
            try {
                method3.invoke((Object)cloneableEditorSupport, styledDocument, inputStream, editorKit);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            String string = styledDocument.getText(0, styledDocument.getLength());
            styledDocument = null;
            return new StringReader(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Writer getWriterFromEditorSupport(FileObject fileObject, FileLock fileLock) throws FileNotFoundException {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
        if (!fileObject.equals(dataObject.getPrimaryFile())) {
            return null;
        }
        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
        CloneableEditorSupport cloneableEditorSupport = editCookie instanceof CloneableEditorSupport ? (CloneableEditorSupport)editCookie : null;
        if (cloneableEditorSupport == null) {
            return null;
        }
        try {
            Method method = EncodedReaderFactory.getDeclaredMethod(cloneableEditorSupport.getClass(), "createEditorKit", new Class[0]);
            method.setAccessible(true);
            EditorKit editorKit = (EditorKit)method.invoke((Object)cloneableEditorSupport, new Object[0]);
            Method method2 = EncodedReaderFactory.getDeclaredMethod(cloneableEditorSupport.getClass(), "createStyledDocument", new Class[]{EditorKit.class});
            method2.setAccessible(true);
            StyledDocument styledDocument = (StyledDocument)method2.invoke((Object)cloneableEditorSupport, editorKit);
            Method method3 = EncodedReaderFactory.getDeclaredMethod(cloneableEditorSupport.getClass(), "saveFromKitToStream", new Class[]{StyledDocument.class, EditorKit.class, OutputStream.class});
            method3.setAccessible(true);
            return new DocWriter(styledDocument, fileObject, fileLock, null, editorKit, cloneableEditorSupport, method3);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
            return null;
        }
    }

    private static Method getDeclaredMethod(Class<?> clazz, String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2 != null) {
                return EncodedReaderFactory.getDeclaredMethod(clazz2, string, classArray);
            }
            throw noSuchMethodException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader getReaderFromKit(File file, FileObject fileObject, String string) throws FileNotFoundException {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string);
        if (editorKit.getContentType().equalsIgnoreCase("text/plain") && "text/x-dtd".equalsIgnoreCase(string)) {
            editorKit = CloneableEditorSupport.getEditorKit((String)"text/xml");
        }
        if (editorKit != null) {
            Document document = editorKit.createDefaultDocument();
            InputStream inputStream = null;
            try {
                inputStream = file != null ? new FileInputStream(file) : fileObject.getInputStream();
                editorKit.read(inputStream, document, 0);
                String string2 = document.getText(0, document.getLength());
                document = null;
                StringReader stringReader = new StringReader(string2);
                return stringReader;
            }
            catch (IOException iOException) {
                FileNotFoundException fileNotFoundException = file != null ? new FileNotFoundException("Can not read file " + file.getAbsolutePath()) : new FileNotFoundException("Can not read file " + fileObject);
                fileNotFoundException.initCause(iOException);
                throw fileNotFoundException;
            }
            catch (BadLocationException badLocationException) {
                ErrorManager.getDefault().notify((Throwable)badLocationException);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    private Writer getWriterFromKit(File file, FileObject fileObject, FileLock fileLock, String string) throws FileNotFoundException {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)string);
        if (editorKit.getContentType().equalsIgnoreCase("text/plain") && "text/x-dtd".equalsIgnoreCase(string)) {
            editorKit = CloneableEditorSupport.getEditorKit((String)"text/xml");
        }
        if (editorKit != null) {
            Document document = editorKit.createDefaultDocument();
            return new DocWriter(document, fileObject, fileLock, file, editorKit, null, null);
        }
        return null;
    }

    public Writer getWriter(File file, String string) throws FileNotFoundException {
        return this.getWriter(file, string, this.getEncoding(file));
    }

    public Writer getWriter(File file, String string, String string2) throws FileNotFoundException {
        String string3;
        if (string2 != null) {
            try {
                return new OutputStreamWriter((OutputStream)new FileOutputStream(file), string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorManager.getDefault().notify(1, (Throwable)unsupportedEncodingException);
            }
        }
        Writer writer = null;
        String string4 = file.getName();
        int n = string4.lastIndexOf(46);
        String string5 = string3 = n >= 0 && n < string4.length() - 1 ? string4.substring(n + 1) : "";
        if (!"java".equalsIgnoreCase(string3)) {
            block10: {
                try {
                    FileLock fileLock;
                    file = FileUtil.normalizeFile((File)file);
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (fileObject == null) break block10;
                    try {
                        fileLock = fileObject.lock();
                    }
                    catch (IOException iOException) {
                        FileNotFoundException fileNotFoundException = new FileNotFoundException(iOException.getLocalizedMessage());
                        fileNotFoundException.initCause(iOException);
                        throw fileNotFoundException;
                    }
                    writer = this.getWriterFromEditorSupport(fileObject, fileLock);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                }
            }
            if (writer == null) {
                writer = this.getWriterFromKit(file, null, null, string);
            }
        }
        if (writer == null) {
            writer = new OutputStreamWriter(new FileOutputStream(file));
        }
        return writer;
    }

    public Writer getWriter(FileObject fileObject, FileLock fileLock, String string) throws IOException {
        if (fileLock == null) {
            fileLock = fileObject.lock();
        }
        if (string != null) {
            try {
                return new OutputStreamWriter(fileObject.getOutputStream(fileLock), string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ErrorManager.getDefault().notify(1, (Throwable)unsupportedEncodingException);
            }
        }
        Writer writer = null;
        String string2 = fileObject.getExt();
        if (!"java".equalsIgnoreCase(string2) && (writer = this.getWriterFromEditorSupport(fileObject, fileLock)) == null) {
            writer = this.getWriterFromKit(null, fileObject, fileLock, fileObject.getMIMEType());
        }
        if (writer == null) {
            writer = new OutputStreamWriter(fileObject.getOutputStream(fileLock));
        }
        return writer;
    }

    public String getEncoding(File file) {
        return this.getEncoding(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
    }

    public static String decodeName(FileObject fileObject) {
        String string;
        int n;
        String string2 = fileObject.getNameExt();
        if (fileObject.getParent() != null && fileObject.getParent().getPath().endsWith("CVS" + File.separator + "RevisionCache") && (n = (string = fileObject.getName()).lastIndexOf("#")) != 1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getEncoding(FileObject fileObject) {
        String string = EncodedReaderFactory.decodeName(fileObject).toLowerCase();
        if (string.endsWith(".properties")) {
            return EncodedReaderFactory.findPropertiesEncoding();
        }
        if (string.endsWith(".form")) {
            return "utf8";
        }
        Object object = null;
        if (fileObject != null) {
            if (string.endsWith(".java")) {
                object = EncodedReaderFactory.findJavaEncoding(fileObject);
            }
            if (object == null) {
                object = fileObject.getAttribute(CHAR_SET_ATTRIBUTE);
            }
        }
        if (string.endsWith(".xml") || string.endsWith(".dtd") || string.endsWith(".xsd") || string.endsWith(".xsl")) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(fileObject.getInputStream(), 2048);
                object = XMLEncodingHelper.detectEncoding(bufferedInputStream);
            }
            catch (IOException iOException) {
                ErrorManager errorManager = ErrorManager.getDefault();
                errorManager.annotate((Throwable)iOException, "Can not detect encoding for: " + fileObject.getPath());
                errorManager.notify(1, (Throwable)iOException);
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    private static String findJavaEncoding(FileObject fileObject) {
        Object object;
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        Method method = null;
        try {
            object = classLoader.loadClass("org.netbeans.modules.java.Util");
            method = ((Class)object).getMethod("getFileEncoding", FileObject.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (method != null) {
            try {
                object = (String)method.invoke(null, fileObject);
                return object;
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(1, (Throwable)exception);
            }
        }
        return null;
    }

    private static String findPropertiesEncoding() {
        return "ISO-8859-1";
    }

    private static class DocWriter
    extends Writer {
        private Document doc;
        private FileObject fo;
        private FileLock foLock;
        private File file;
        private EditorKit kit;
        private CloneableEditorSupport editorSupport;
        private Method saveFromKitToStreamMethod;
        private boolean closed;

        public DocWriter(Document document, FileObject fileObject, FileLock fileLock, File file, EditorKit editorKit, CloneableEditorSupport cloneableEditorSupport, Method method) {
            this.doc = document;
            this.fo = fileObject;
            this.foLock = fileLock;
            this.file = file;
            this.kit = editorKit;
            this.editorSupport = cloneableEditorSupport;
            this.saveFromKitToStreamMethod = method;
        }

        public void write(int n) throws IOException {
            try {
                this.doc.insertString(this.doc.getLength(), Character.toString((char)n), null);
            }
            catch (BadLocationException badLocationException) {
                IOException iOException = new IOException(badLocationException.getLocalizedMessage());
                iOException.initCause(badLocationException);
                throw iOException;
            }
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            try {
                this.doc.insertString(this.doc.getLength(), new String(cArray, n, n2), null);
            }
            catch (BadLocationException badLocationException) {
                IOException iOException = new IOException(badLocationException.getLocalizedMessage());
                iOException.initCause(badLocationException);
                throw iOException;
            }
        }

        public void write(String string) throws IOException {
            try {
                this.doc.insertString(this.doc.getLength(), string, null);
            }
            catch (BadLocationException badLocationException) {
                IOException iOException = new IOException(badLocationException.getLocalizedMessage());
                iOException.initCause(badLocationException);
                throw iOException;
            }
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
            if (this.closed) {
                return;
            }
            if (this.saveFromKitToStreamMethod != null) {
                OutputStream outputStream = this.fo.getOutputStream(this.foLock);
                try {
                    this.saveFromKitToStreamMethod.invoke((Object)this.editorSupport, this.doc, this.kit, outputStream);
                }
                catch (Exception exception) {
                    IOException iOException = new IOException(exception.getLocalizedMessage());
                    iOException.initCause(exception);
                    throw iOException;
                }
                finally {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {}
                    this.foLock.releaseLock();
                }
            }
            OutputStream outputStream = this.file != null ? new FileOutputStream(this.file) : this.fo.getOutputStream(this.foLock);
            try {
                this.kit.write(outputStream, this.doc, 0, this.doc.getLength());
            }
            catch (BadLocationException badLocationException) {
                IOException iOException = new IOException(badLocationException.getLocalizedMessage());
                iOException.initCause(badLocationException);
                throw iOException;
            }
            finally {
                outputStream.close();
            }
            this.closed = true;
        }
    }
}

