/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.nodes.dnd;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.ui.nodes.FolderNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.openide.nodes.Node;
import org.openide.util.datatransfer.PasteType;

public class FolderPasteType
extends PasteType {
    private FolderNode destinationNode;
    private Node originNode;
    private int dropAction = 0;

    public static FolderPasteType createFolderPasteType(int dropAction, FolderNode toFolderNode, Node originNode) {
        if (toFolderNode == null || originNode == null) {
            return null;
        }
        if (originNode instanceof ResourceNode) {
            if (toFolderNode.getFolder().getServer() != ((ResourceNode)originNode).getRepositoryObject().getServer()) {
                return null;
            }
            String origin_uri = ((ResourceNode)originNode).getResourceDescriptor().getUriString();
            String destination_uri = toFolderNode.getResourceDescriptor().getUriString();
            if (!destination_uri.equals("/") && destination_uri.startsWith(origin_uri)) {
                return null;
            }
            if (origin_uri.equals("/")) {
                return null;
            }
            if (((ResourceNode)originNode).getResourceDescriptor().getParentFolder().equals(destination_uri)) {
                return null;
            }
            return new FolderPasteType(dropAction, toFolderNode, originNode);
        }
        return null;
    }

    protected FolderPasteType(int dropAction, FolderNode toFolderNode, Node originNode) {
        this.destinationNode = toFolderNode;
        this.originNode = originNode;
        this.dropAction = dropAction;
    }

    public Transferable paste() throws IOException {
        ResourceNode origin = (ResourceNode)this.getOriginNode();
        ResourceDescriptor origin_rd = origin.getResourceDescriptor();
        Node originParent = this.getOriginNode().getParentNode();
        String origin_uri = origin.getResourceDescriptor().getUriString();
        String destination_uri = this.getDestinationNode().getResourceDescriptor().getUriString();
        if ((this.getDropAction() & 6) != 0) {
            try {
                origin.getRepositoryObject().getServer().getWSClient().move(origin_rd, destination_uri);
                if (originParent != null && originParent instanceof FolderNode) {
                    ((FolderNode)originParent).getResourceDescriptor().getChildren().remove(origin_rd);
                    ((FolderNode)originParent).refreshChildrens(false);
                }
                origin_rd.setParentFolder(destination_uri);
                origin_rd.setUriString(destination_uri + "/" + origin_rd.getName());
                this.getDestinationNode().getResourceDescriptor().getChildren().add(origin_rd);
                this.getDestinationNode().refreshChildrens(false);
            }
            catch (Exception ex) {
                Misc.showErrorMessage((String)("Unable to move the resource: " + ex.getMessage()), (String)"Move error");
            }
        } else {
            try {
                System.out.println("Pasting resource... " + ((ResourceNode)this.originNode).getResourceDescriptor().getUriString() + " to " + destination_uri);
                System.out.flush();
                String newResName = origin_rd.getName();
                newResName = destination_uri.endsWith("/") ? destination_uri + newResName : destination_uri + "/" + newResName;
                ResourceDescriptor newRd = origin.getRepositoryObject().getServer().getWSClient().copy(origin_rd, newResName);
                this.getDestinationNode().getResourceDescriptor().getChildren().add(origin_rd);
                this.getDestinationNode().refreshChildrens(false);
            }
            catch (Exception ex) {
                Misc.showErrorMessage((String)("Unable to copy the resource: " + ex.getMessage()), (String)"Move error");
            }
        }
        return null;
    }

    public FolderNode getDestinationNode() {
        return this.destinationNode;
    }

    public void setDestinationNode(FolderNode destinationNode) {
        this.destinationNode = destinationNode;
    }

    public Node getOriginNode() {
        return this.originNode;
    }

    public void setOriginNode(Node originNode) {
        this.originNode = originNode;
    }

    public int getDropAction() {
        return this.dropAction;
    }

    public void setDropAction(int dropAction) {
        this.dropAction = dropAction;
    }
}

