/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.RepositoryReportUnit;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class DeleteAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(DeleteAction.class, (String)"CTL_DeleteAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] activatedNodes) {
        int i;
        ArrayList destroiedUris = new ArrayList();
        Node[] parents = new Node[activatedNodes.length];
        for (i = 0; i < activatedNodes.length; ++i) {
            parents[i] = activatedNodes[i].getParentNode();
        }
        for (i = 0; i < activatedNodes.length; ++i) {
            ResourceNode parentNode;
            ResourceNode node = (ResourceNode)activatedNodes[i];
            RepositoryFolder rf = node.getRepositoryObject();
            for (String destroiedUri : destroiedUris) {
                if (!rf.getDescriptor().getUriString().startsWith(destroiedUri)) continue;
            }
            String reportUnitUri = null;
            if (activatedNodes[i].getParentNode() != null && activatedNodes[i].getParentNode() instanceof ResourceNode && (parentNode = (ResourceNode)activatedNodes[i].getParentNode()).getRepositoryObject() instanceof RepositoryReportUnit) {
                reportUnitUri = parentNode.getResourceDescriptor().getUriString();
            }
            String msg = JasperServerManager.getFormattedString("repositoryExplorer.message.confirmDeleteResource", "Are you sure you want to remove the resource {0} ?", new Object[]{rf.getDescriptor().getLabel()});
            if (node.getResourceDescriptor().getWsType().equals("folder")) {
                msg = JasperServerManager.getFormattedString("repositoryExplorer.message.confirmDeleteFolder", "Are you sure you want to remove the folder {0}\n and all its contents?", new Object[]{rf.getDescriptor().getLabel()});
            } else if (node.getResourceDescriptor().getWsType().equals("reportUnit")) {
                msg = JasperServerManager.getFormattedString("repositoryExplorer.message.confirmDeleteReportUnit", "Are you sure you want to remove the report unit {0}\n and all its contents?", new Object[]{rf.getDescriptor().getLabel()});
            } else if (reportUnitUri != null) {
                if (RepositoryFolder.isDataSource(rf.getDescriptor())) {
                    JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getString("repositoryExplorer.message.cannotDeleteRUDatasource", "You can not delete the report datasource.\nUse Report Unit properties menu item to modify the datasource type."), "", 0);
                    return;
                }
                if (rf.getDescriptor().isMainReport()) {
                    // empty if block
                }
            }
            if (JOptionPane.showConfirmDialog(Misc.getMainFrame(), msg) != 0) continue;
            try {
                ResourceNode parentResourceNode = (ResourceNode)parents[i];
                rf.getServer().getWSClient().delete(rf.getDescriptor(), reportUnitUri);
                if (parentResourceNode == null) continue;
                RepositoryFolder parentFolder = parentResourceNode.getRepositoryObject();
                parentFolder.getDescriptor().getChildren().remove(rf.getDescriptor());
                parentResourceNode.refreshChildrens(false);
                continue;
            }
            catch (Exception ex) {
                String errorMessage = ex.getMessage();
                if (errorMessage == null) {
                    errorMessage = "No reason reported.";
                }
                if (errorMessage.length() > 120) {
                    String emsg = "";
                    while (errorMessage.length() > 120) {
                        if (emsg.length() > 0) {
                            emsg = emsg + "\n";
                        }
                        emsg = emsg + errorMessage.substring(0, 120);
                        if ((errorMessage = errorMessage.substring(120)).length() > 120) continue;
                        emsg = emsg + "\n" + errorMessage;
                        break;
                    }
                    System.out.println("Message: " + emsg);
                    errorMessage = emsg;
                }
                JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{errorMessage}));
                ex.printStackTrace();
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length < 1) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (!(activatedNodes[i] instanceof ResourceNode)) {
                return false;
            }
            ResourceNode node = (ResourceNode)activatedNodes[i];
            if (!node.getRepositoryObject().isRoot()) continue;
            return false;
        }
        return true;
    }
}

