/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.tools.HexColorChooserPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.design.JRDesignDataRange;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignExpression;

public class MeterIntervalDialog
extends JDialog {
    private JRMeterInterval meterInterval = null;
    Color backGroundColor = null;
    private int dialogResult = 2;
    private JButton JButtonSelectColor;
    private JPanel colorSelectorPanel;
    private JButton jButtonCancel;
    private JButton jButtonDefaultColor;
    private JButton jButtonOK;
    private JLabel jLabelAlpha;
    private JLabel jLabelColor;
    private JLabel jLabelLabel;
    private JLabel jLabelRangeHigh;
    private JLabel jLabelRangeLow;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private ExpressionEditorArea jRTextExpressionHigh;
    private ExpressionEditorArea jRTextExpressionLow;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerAlpha;
    private JTextField jTextFieldLabel;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_LOW_EXPRESSION = 1;
    public static final int COMPONENT_HIGH_EXPRESSION = 2;

    public MeterIntervalDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public MeterIntervalDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.setSize(500, 500);
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                MeterIntervalDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.jSpinnerAlpha.setModel(new SpinnerNumberModel(1.0, 0.0, 1.0, 0.01));
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public void setExpressionContext(ExpressionContext expressionContext) {
        this.jRTextExpressionHigh.setExpressionContext(expressionContext);
        this.jRTextExpressionLow.setExpressionContext(expressionContext);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabelLabel = new JLabel();
        this.jTextFieldLabel = new JTextField();
        this.jLabelColor = new JLabel();
        this.jPanel2 = new JPanel();
        this.colorSelectorPanel = new JPanel();
        this.JButtonSelectColor = new JButton();
        this.jButtonDefaultColor = new JButton();
        this.jLabelAlpha = new JLabel();
        this.jSpinnerAlpha = new JSpinner();
        this.jLabelRangeLow = new JLabel();
        this.jRTextExpressionLow = new ExpressionEditorArea();
        this.jLabelRangeHigh = new JLabel();
        this.jRTextExpressionHigh = new ExpressionEditorArea();
        this.jSeparator1 = new JSeparator();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(I18n.getString("MeterIntervalDialog.Dialog.Title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setPreferredSize(new Dimension(400, 250));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabelLabel.setText(I18n.getString("MeterIntervalDialog.Label.Label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jLabelLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jTextFieldLabel, gridBagConstraints);
        this.jLabelColor.setText(I18n.getString("MeterIntervalDialog.Label.Color"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jLabelColor, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.colorSelectorPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 6);
        this.jPanel2.add((Component)this.colorSelectorPanel, gridBagConstraints);
        this.JButtonSelectColor.setText(I18n.getString("MeterIntervalDialog.Button.SelectColor"));
        this.JButtonSelectColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalDialog.this.JButtonSelectColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        this.jPanel2.add((Component)this.JButtonSelectColor, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonDefaultColor.setText(I18n.getString("MeterIntervalDialog.Button.UseDefaultColor"));
        this.jButtonDefaultColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalDialog.this.jButtonDefaultColorActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonDefaultColor, gridBagConstraints);
        this.jLabelAlpha.setText(I18n.getString("MeterIntervalDialog.Label.Alpha"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 4);
        this.jPanel1.add((Component)this.jLabelAlpha, gridBagConstraints);
        this.jSpinnerAlpha.setMinimumSize(new Dimension(100, 18));
        this.jSpinnerAlpha.setPreferredSize(new Dimension(130, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jSpinnerAlpha, gridBagConstraints);
        this.jLabelRangeLow.setText(I18n.getString("MeterIntervalDialog.Label.DataRangeLowExpression"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelRangeLow, gridBagConstraints);
        this.jRTextExpressionLow.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionLow.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionLow.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jRTextExpressionLow, gridBagConstraints);
        this.jLabelRangeHigh.setText(I18n.getString("MeterIntervalDialog.Label.DataRangeHighExpression"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.jLabelRangeHigh, gridBagConstraints);
        this.jRTextExpressionHigh.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionHigh.setMinimumSize(new Dimension(10, 10));
        this.jRTextExpressionHigh.setPreferredSize(new Dimension(10, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jRTextExpressionHigh, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel6.add((Component)this.jPanel7, gridBagConstraints);
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText(I18n.getString("Global.Button.Ok"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel6.add((Component)this.jButtonOK, gridBagConstraints);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText(I18n.getString("Global.Button.Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MeterIntervalDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel6.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel6, gridBagConstraints);
        this.pack();
    }

    private void jButtonDefaultColorActionPerformed(ActionEvent evt) {
        this.colorSelectorPanel.setBackground(null);
        this.backGroundColor = null;
    }

    private void JButtonSelectColorActionPerformed(ActionEvent evt) {
        Color c = HexColorChooserPanel.showDialog(this, I18n.getString("MeterIntervalDialog.Dialog.PickColor"), null);
        if (c != null) {
            this.colorSelectorPanel.setBackground(c);
            this.backGroundColor = c;
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        JRMeterInterval tmpmi = this.getMeterInterval();
        if (tmpmi == null) {
            tmpmi = new JRMeterInterval();
        }
        tmpmi.setLabel(this.jTextFieldLabel.getText());
        tmpmi.setBackgroundColor(this.backGroundColor);
        tmpmi.setAlpha(((SpinnerNumberModel)this.jSpinnerAlpha.getModel()).getNumber().doubleValue());
        tmpmi.setDataRange((JRDataRange)new JRDesignDataRange(null));
        JRDesignExpression expLow = new JRDesignExpression();
        expLow.setValueClassName("java.lang.Number");
        expLow.setText(this.jRTextExpressionLow.getText());
        ((JRDesignDataRange)tmpmi.getDataRange()).setLowExpression((JRExpression)expLow);
        JRDesignExpression expHigh = new JRDesignExpression();
        expHigh.setValueClassName("java.lang.Number");
        expHigh.setText(this.jRTextExpressionHigh.getText());
        ((JRDesignDataRange)tmpmi.getDataRange()).setHighExpression((JRExpression)expHigh);
        this.setMeterInterval(tmpmi);
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public JRMeterInterval getMeterInterval() {
        return this.meterInterval;
    }

    public void setMeterInterval(JRMeterInterval meterInterval) {
        this.meterInterval = meterInterval;
        if (meterInterval != null) {
            this.jTextFieldLabel.setText(meterInterval.getLabel());
            ((SpinnerNumberModel)this.jSpinnerAlpha.getModel()).setValue(new Double(meterInterval.getAlpha()));
            if (meterInterval.getBackgroundColor() != null) {
                this.backGroundColor = meterInterval.getBackgroundColor();
                this.colorSelectorPanel.setBackground(this.backGroundColor);
            }
            if (meterInterval.getDataRange() != null) {
                this.jRTextExpressionLow.setText(this.getExpressionText(meterInterval.getDataRange().getLowExpression()));
                this.jRTextExpressionHigh.setText(this.getExpressionText(meterInterval.getDataRange().getHighExpression()));
            }
        }
    }

    private String getExpressionText(JRExpression exp) {
        if (exp == null) {
            return "";
        }
        if (exp.getText() == null) {
            return "";
        }
        return exp.getText();
    }

    public void setFocusedExpression(Object[] expressionInfo) {
        if (expressionInfo == null) {
            return;
        }
        int expID = (Integer)expressionInfo[0];
        switch (expID) {
            case 1: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionLow.getExpressionEditorPane());
                break;
            }
            case 2: {
                Misc.selectTextAndFocusArea(this.jRTextExpressionHigh.getExpressionEditorPane());
            }
        }
    }
}

