/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.outline.nodes.ScriptletNode;
import com.jaspersoft.ireport.designer.outline.nodes.ScriptletsChildren;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignScriptlet;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ScriptletsNode
extends IRIndexedNode
implements PropertyChangeListener {
    private JasperDesign jd = null;
    private JRDesignDataset dataset = null;

    public ScriptletsNode(JasperDesign jd, Lookup doLkp) {
        this(jd, (JRDesignDataset)jd.getMainDataset(), doLkp);
    }

    public ScriptletsNode(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        this(new ScriptletsChildren(jd, dataset, doLkp), jd, dataset, doLkp);
    }

    public ScriptletsNode(ScriptletsChildren pc, JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, dataset})}));
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                List list = ScriptletsNode.this.getDataset().getScriptletsList();
                ArrayList<JRDesignScriptlet> newList = new ArrayList<JRDesignScriptlet>();
                Node[] nodes = ScriptletsNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    JRDesignScriptlet p = ((ScriptletNode)nodes[i]).getScriptlet();
                    if (p.getName().equals("REPORT")) continue;
                    newList.add(p);
                }
                list.clear();
                list.addAll(newList);
                ScriptletsNode.this.getDataset().getEventSupport().firePropertyChange(new PropertyChangeEvent(ScriptletsNode.this.getDataset(), "scriptlets", null, null));
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        this.jd = jd;
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        this.dataset = dataset;
        dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.setDisplayName(I18n.getString("ScriptletNode.Property.Scriptlets"));
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/scriptlets-16.png");
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignScriptlet scriptlet;
        final Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        final int dropAction = DnDUtilities.getTransferAction(t);
        if (null != dropNode && null != (scriptlet = (JRDesignScriptlet)dropNode.getLookup().lookup(JRDesignScriptlet.class))) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    if (scriptlet.getName().equals("REPORT")) {
                        return null;
                    }
                    List list = ScriptletsNode.this.getDataset().getScriptletsList();
                    int currentIndex = -1;
                    int lastSystemDefinedScriptletIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        JRDesignScriptlet p = (JRDesignScriptlet)list.get(i);
                        if (p == scriptlet) {
                            currentIndex = i;
                        }
                        if (!p.getName().equals("REPORT")) continue;
                        lastSystemDefinedScriptletIndex = i;
                    }
                    if ((dropAction & 6) != 0) {
                        int newIndex = -1;
                        if (currentIndex != -1) {
                            Node[] nodes = ScriptletsNode.this.getChildren().getNodes();
                            for (int i = 0; i < nodes.length; ++i) {
                                if (((ScriptletNode)nodes[i]).getScriptlet() != scriptlet) continue;
                                newIndex = i;
                                break;
                            }
                            list.remove(scriptlet);
                            if (newIndex == -1) {
                                list.add(scriptlet);
                            } else {
                                list.add(Math.max(newIndex, lastSystemDefinedScriptletIndex + 1), scriptlet);
                            }
                        } else {
                            try {
                                JRDesignScriptlet newParam = (JRDesignScriptlet)scriptlet.clone();
                                Map map = ScriptletsNode.this.getDataset().getScriptletsMap();
                                int k = 1;
                                while (map.containsKey(newParam.getName())) {
                                    newParam.setName(scriptlet.getName() + "_" + k);
                                    ++k;
                                }
                                ScriptletsNode.this.getDataset().addScriptlet((JRScriptlet)newParam);
                                if (dropNode.getParentNode() instanceof ScriptletsNode) {
                                    ScriptletsNode pn = (ScriptletsNode)dropNode.getParentNode();
                                    pn.getDataset().removeScriptlet((JRScriptlet)scriptlet);
                                }
                            }
                            catch (JRException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    } else {
                        try {
                            JRDesignScriptlet newParam = (JRDesignScriptlet)scriptlet.clone();
                            Map map = ScriptletsNode.this.getDataset().getScriptletsMap();
                            int k = 1;
                            while (map.containsKey(newParam.getName())) {
                                newParam.setName(scriptlet.getName() + "_" + k);
                                ++k;
                            }
                            ScriptletsNode.this.getDataset().addScriptlet((JRScriptlet)newParam);
                        }
                        catch (JRException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class), SystemAction.get(ReorderAction.class)};
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public JRDesignDataset getDataset() {
        return this.dataset;
    }

    public void setDataset(JRDesignDataset dataset) {
        this.dataset = dataset;
    }

    public NewType[] getNewTypes() {
        return NewTypesUtils.getNewType((Node)this, 12);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName().equals("scriptlets")) {
            ((ScriptletsChildren)this.getChildren()).recalculateKeys();
        }
    }
}

