/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.outline.nodes.ConditionalStyleChildren;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.outline.nodes.StyleChildren;
import com.jaspersoft.ireport.designer.sheet.JRPenProperty;
import com.jaspersoft.ireport.designer.sheet.properties.StylePatternProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.BackcolorProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.BlankWhenNullProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.BoldProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.FillProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.FontNameProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.FontSizeProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.ForecolorProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.HorizontalAlignmentProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.ItalicProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.LineSpacingProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.ModeProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.PaddingAndBordersProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.PdfEmbeddedProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.PdfEncodingProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.PdfFontNameProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.RadiusProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.RotationProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.ScaleImageProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.StrikeThroughProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.StyledTextProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.UnderlineProperty;
import com.jaspersoft.ireport.designer.sheet.properties.style.VerticalAlignmentProperty;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class AbstractStyleNode
extends IRIndexedNode
implements PropertyChangeListener {
    JasperDesign jd = null;
    private JRBaseStyle style = null;

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public AbstractStyleNode(StyleChildren pc, JasperDesign jd, JRDesignStyle style, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, style})}));
        this.jd = jd;
        this.style = style;
        this.init();
    }

    public AbstractStyleNode(JasperDesign jd, JRDesignStyle style, Lookup doLkp) {
        this(new StyleChildren(jd, style, doLkp), jd, style, doLkp);
    }

    public AbstractStyleNode(JasperDesign jd, JRDesignConditionalStyle style, Lookup doLkp) {
        super((Children)new ConditionalStyleChildren(jd, style, doLkp), null, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, style})}));
        this.jd = jd;
        this.style = style;
        this.init();
    }

    private void init() {
        this.setDisplayName(this.style.getName());
        super.setName(this.style.getName());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/style-16.png");
        this.style.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)this.style.getLinePen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        JRBaseLineBox baseBox = (JRBaseLineBox)this.style.getLineBox();
        baseBox.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getTopPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getBottomPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getLeftPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        ((JRBasePen)baseBox.getRightPen()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getDisplayName() {
        return this.getStyle().getName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new ModeProperty(this.getStyle()));
        set.put((Node.Property)new ForecolorProperty(this.getStyle()));
        set.put((Node.Property)new BackcolorProperty(this.getStyle()));
        set.put((Node.Property)new PaddingAndBordersProperty(this.getStyle()));
        JRPenProperty penProp = new JRPenProperty(this.getStyle().getLinePen(), (JRPenContainer)this.getStyle());
        set.put((Node.Property)penProp);
        set.put((Node.Property)new FillProperty(this.getStyle()));
        set.put((Node.Property)new RadiusProperty(this.getStyle()));
        set.put((Node.Property)new ScaleImageProperty(this.getStyle()));
        set.put((Node.Property)new HorizontalAlignmentProperty(this.getStyle()));
        set.put((Node.Property)new VerticalAlignmentProperty(this.getStyle()));
        set.put((Node.Property)new RotationProperty(this.getStyle()));
        set.put((Node.Property)new LineSpacingProperty(this.getStyle()));
        set.put((Node.Property)new StyledTextProperty(this.getStyle()));
        set.put((Node.Property)new FontNameProperty(this.getStyle()));
        set.put((Node.Property)new FontSizeProperty(this.getStyle()));
        set.put((Node.Property)new BoldProperty(this.getStyle()));
        set.put((Node.Property)new ItalicProperty(this.getStyle()));
        set.put((Node.Property)new UnderlineProperty(this.getStyle()));
        set.put((Node.Property)new StrikeThroughProperty(this.getStyle()));
        set.put((Node.Property)new PdfFontNameProperty(this.getStyle()));
        set.put((Node.Property)new PdfEmbeddedProperty(this.getStyle()));
        set.put((Node.Property)new PdfEncodingProperty(this.getStyle()));
        set.put((Node.Property)new StylePatternProperty(this.getStyle()));
        set.put((Node.Property)new BlankWhenNullProperty(this.getStyle()));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getStyle().getName());
            this.setDisplayName(this.getStyle().getName());
        } else if (evt.getPropertyName().equals("lineColor") || evt.getPropertyName().equals("lineStyle") || evt.getPropertyName().equals("lineWidth")) {
            if (ModelUtils.containsProperty(this.getPropertySets(), "pen")) {
                this.firePropertyChange("pen", evt.getOldValue(), evt.getNewValue());
            }
            if (ModelUtils.containsProperty(this.getPropertySets(), "linebox")) {
                this.firePropertyChange("linebox", evt.getOldValue(), evt.getNewValue());
            }
        } else if ((evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding") || evt.getPropertyName().equals("bottomPadding")) && ModelUtils.containsProperty(this.getPropertySets(), "linebox")) {
            this.firePropertyChange("linebox", evt.getOldValue(), evt.getNewValue());
        }
        if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public JRBaseStyle getStyle() {
        return this.style;
    }

    public void setStyle(JRBaseStyle style) {
        this.style = style;
    }
}

