/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.menu.preview;

import com.jaspersoft.ireport.designer.IReportManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public abstract class AbstractPreviewAction
extends CallableSystemAction
implements PreferenceChangeListener,
ItemListener {
    private JCheckBoxMenuItem item = new JCheckBoxMenuItem(this.getName());

    public abstract String getPreviewType();

    public AbstractPreviewAction() {
        IReportManager.getPreferences().addPreferenceChangeListener(this);
        this.preferenceChange(null);
        this.item.addItemListener(this);
    }

    public JMenuItem getMenuPresenter() {
        return this.item;
    }

    public void performAction() {
        if (this.item.isSelected()) {
            if (this.getPreviewType().length() > 0) {
                IReportManager.getPreferences().put("output_format", this.getPreviewType());
            } else {
                IReportManager.getPreferences().remove("output_format");
            }
        }
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        this.item.setSelected(IReportManager.getPreferences().get("output_format", "").equals(this.getPreviewType()));
    }

    public void itemStateChanged(ItemEvent e) {
        this.performAction();
    }
}

