/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.logpane;

import com.jaspersoft.ireport.designer.logpane.LogTextArea;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IRConsoleTopComponent
extends TopComponent
implements ActionListener {
    private LogTextArea mainLogTextArea;
    private LogTextArea pointedLogTextArea = null;
    private List logsComponents = new ArrayList();
    private static IRConsoleTopComponent instance;
    private static final String PREFERRED_ID = "IRConsoleTopComponent";
    private JTabbedPane jTabbedPaneLogs;

    private IRConsoleTopComponent() {
        this.initComponents();
        this.mainLogTextArea = new LogTextArea(I18n.getString("IRConsoleTopComponent.TextArea.iReportConsole"));
        this.mainLogTextArea.setLogPane(this);
        this.mainLogTextArea.addActionListener(this);
        this.jTabbedPaneLogs.add(this.mainLogTextArea.getTitle(), this.mainLogTextArea);
        this.updateLogTabs();
    }

    protected void updateLogTabs() {
        if (this.logsComponents.size() > 0) {
            if (this.getComponent(0) != this.jTabbedPaneLogs) {
                while (this.getComponentCount() > 0) {
                    this.remove(0);
                }
                this.add(this.jTabbedPaneLogs, "Center");
            }
            this.jTabbedPaneLogs.removeAll();
            this.jTabbedPaneLogs.add(this.mainLogTextArea.getTitle(), this.mainLogTextArea);
            for (int i = 0; i < this.logsComponents.size(); ++i) {
                this.jTabbedPaneLogs.add(((LogTextArea)this.logsComponents.get(i)).getTitle(), (LogTextArea)this.logsComponents.get(i));
            }
        } else if (this.getComponent(0) != this.mainLogTextArea) {
            while (this.getComponentCount() > 0) {
                this.remove(0);
            }
            this.add(this.mainLogTextArea, "Center");
        }
        this.updateUI();
    }

    private void initComponents() {
        this.jTabbedPaneLogs = new JTabbedPane();
        this.setLayout(new BorderLayout());
        this.add(this.jTabbedPaneLogs, "Center");
    }

    public static synchronized IRConsoleTopComponent getDefault() {
        if (instance == null) {
            instance = new IRConsoleTopComponent();
        }
        return instance;
    }

    public static synchronized IRConsoleTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(IRConsoleTopComponent.class.getName()).warning(I18n.getString("IRConsoleTopComponent.Message.ErrorA") + PREFERRED_ID + I18n.getString("IRConsoleTopComponent.Message.ErrorB"));
            return IRConsoleTopComponent.getDefault();
        }
        if (win instanceof IRConsoleTopComponent) {
            return (IRConsoleTopComponent)win;
        }
        Logger.getLogger(IRConsoleTopComponent.class.getName()).warning(I18n.getString("IRConsoleTopComponent.Message.WarningA") + PREFERRED_ID + I18n.getString("IRConsoleTopComponent.Message.WarningB"));
        return IRConsoleTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public LogTextArea createNewLog() {
        LogTextArea lta = new LogTextArea(I18n.getString("IRConsoleTopComponent.TextArea.Log"));
        lta.setLogPane(this);
        lta.addActionListener(this);
        this.logsComponents.add(lta);
        for (int i = 0; i < this.logsComponents.size(); ++i) {
            Object component = this.logsComponents.get(i);
            if (!(component instanceof LogTextArea) || !((LogTextArea)component).isRemovable()) continue;
            this.logsComponents.remove(i);
            --i;
        }
        this.updateLogTabs();
        return lta;
    }

    public void removeLog(LogTextArea logTextArea) {
        if (logTextArea.isRemovable()) {
            this.logsComponents.remove(logTextArea);
            this.updateLogTabs();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == null) {
            return;
        }
        for (int i = 1; i < this.jTabbedPaneLogs.getComponentCount(); ++i) {
            LogTextArea lta = (LogTextArea)this.jTabbedPaneLogs.getComponent(i);
            if (lta != actionEvent.getSource()) continue;
            this.jTabbedPaneLogs.setTitleAt(i, lta.getTitle());
            break;
        }
    }

    public LogTextArea getMainLogTextArea() {
        return this.mainLogTextArea;
    }

    public void setMainLogTextArea(LogTextArea mainLogTextArea) {
        this.mainLogTextArea = mainLogTextArea;
    }

    public void setActiveLog(LogTextArea c) {
        try {
            this.jTabbedPaneLogs.setSelectedComponent(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setActiveLogComponent(Component c) {
        try {
            this.jTabbedPaneLogs.setSelectedComponent(c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDisplayName() {
        return I18n.getString("IRConsoleTopComponent.Display.iROutput");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return IRConsoleTopComponent.getDefault();
        }
    }
}

