/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportManager;
import java.text.MessageFormat;

public class JDBCDriverDefinition
implements Comparable {
    private String urlPattern = "";
    private String dbName = "";
    private String driverName = "";
    private String defaultDBName = "MYDATABASE";

    public JDBCDriverDefinition(String dbName, String driverName, String urlPattern) {
        this(dbName, driverName, urlPattern, "MYDATABASE");
    }

    public JDBCDriverDefinition(String dbName, String driverName, String urlPattern, String defaultDBName) {
        this.dbName = dbName;
        this.driverName = driverName;
        this.urlPattern = urlPattern;
        this.defaultDBName = defaultDBName;
    }

    public String getUrl(String server, String database) {
        if (database == null || database.trim().length() == 0) {
            database = this.getDefaultDBName();
        }
        database = database.trim();
        return MessageFormat.format(this.getUrlPattern(), server, database);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable() {
        try {
            Class.forName(this.getDriverName(), false, IReportManager.getReportClassLoader());
            return true;
        }
        catch (ClassNotFoundException ex) {}
        finally {
            return false;
        }
    }

    public String getUrlPattern() {
        return this.urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.urlPattern = urlPattern;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDriverName() {
        return this.driverName;
    }

    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    public String getDefaultDBName() {
        return this.defaultDBName;
    }

    public void setDefaultDBName(String defaultDBName) {
        this.defaultDBName = defaultDBName;
    }

    public String toString() {
        return this.dbName + " (" + this.driverName + ")";
    }

    public int compareTo(Object o) {
        return (o + "").compareTo(this.toString());
    }
}

