/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.gui.ConnectionDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ConnectionsDialog
extends JDialog {
    boolean updating_row = false;
    private JButton jButtonDefault;
    private JButton jButtonDeleteParameter;
    private JButton jButtonExport;
    private JButton jButtonImport;
    private JButton jButtonModifyParameter;
    private JButton jButtonNewParameter;
    private JPanel jPanelButtons;
    private JPanel jPanelParameters;
    private JScrollPane jScrollPane1;
    private JTable jTableParameters;

    public ConnectionsDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
        this.applyI18n();
    }

    public ConnectionsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
        this.applyI18n();
    }

    public void initAll() {
        this.initComponents();
        this.setSize(490, 500);
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ConnectionsDialog.this.jTableParametersListSelectionValueChanged(e);
            }
        });
        DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
        dtm.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (ConnectionsDialog.this.updating_row) {
                    return;
                }
                if (e.getType() == 0 && e.getColumn() == 2) {
                    if (ConnectionsDialog.this.jTableParameters.getValueAt(e.getFirstRow(), 2).equals(Boolean.TRUE)) {
                        ConnectionsDialog.this.jButtonSetDefaultActionPerformed(null);
                    } else {
                        ConnectionsDialog.this.updating_row = true;
                        IReportConnection con = (IReportConnection)ConnectionsDialog.this.jTableParameters.getValueAt(e.getFirstRow(), 0);
                        ConnectionsDialog.this.jTableParameters.setValueAt(con == IReportManager.getInstance().getDefaultConnection(), e.getFirstRow(), 2);
                        ConnectionsDialog.this.updating_row = false;
                    }
                }
            }
        });
        List<IReportConnection> connections = IReportManager.getInstance().getConnections();
        IReportConnection default_irc = IReportManager.getInstance().getDefaultConnection();
        this.updating_row = true;
        for (IReportConnection con : connections) {
            dtm.addRow(new Object[]{con, con.getDescription(), new Boolean(default_irc == con)});
        }
        this.updating_row = false;
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ConnectionsDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.setLocationRelativeTo(null);
    }

    public void jTableParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.jButtonModifyParameter.setEnabled(true);
            this.jButtonDeleteParameter.setEnabled(true);
            this.jButtonDefault.setEnabled(true);
        } else {
            this.jButtonModifyParameter.setEnabled(false);
            this.jButtonDeleteParameter.setEnabled(false);
            this.jButtonDefault.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jPanelParameters = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableParameters = new JTable();
        this.jPanelButtons = new JPanel();
        this.jButtonNewParameter = new JButton();
        this.jButtonModifyParameter = new JButton();
        this.jButtonDeleteParameter = new JButton();
        this.jButtonDefault = new JButton();
        this.jButtonImport = new JButton();
        this.jButtonExport = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Connections / Datasources");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConnectionsDialog.this.closeDialog(evt);
            }
        });
        this.jPanelParameters.setLayout(new GridBagLayout());
        this.jScrollPane1.setBackground(new Color(255, 255, 255));
        this.jTableParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Datasource type", "Default"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, Object.class, Boolean.class};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableParameters.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ConnectionsDialog.this.jTableParametersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableParameters);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelParameters.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanelButtons.setMinimumSize(new Dimension(100, 10));
        this.jPanelButtons.setPreferredSize(new Dimension(100, 10));
        this.jPanelButtons.setLayout(new GridBagLayout());
        this.jButtonNewParameter.setText("New");
        this.jButtonNewParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonNewParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanelButtons.add((Component)this.jButtonNewParameter, gridBagConstraints);
        this.jButtonModifyParameter.setText("Modify");
        this.jButtonModifyParameter.setEnabled(false);
        this.jButtonModifyParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonModifyParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonModifyParameter, gridBagConstraints);
        this.jButtonDeleteParameter.setText("Delete");
        this.jButtonDeleteParameter.setEnabled(false);
        this.jButtonDeleteParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonDeleteParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonDeleteParameter, gridBagConstraints);
        this.jButtonDefault.setText("Set as default");
        this.jButtonDefault.setActionCommand("Set as active");
        this.jButtonDefault.setEnabled(false);
        this.jButtonDefault.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonSetDefaultActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonDefault, gridBagConstraints);
        this.jButtonImport.setText("Import...");
        this.jButtonImport.setActionCommand("Set as active");
        this.jButtonImport.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonImportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonImport, gridBagConstraints);
        this.jButtonExport.setText("Export...");
        this.jButtonExport.setActionCommand("Set as active");
        this.jButtonExport.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonExport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConnectionsDialog.this.jButtonExportActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 5, 3);
        this.jPanelButtons.add((Component)this.jButtonExport, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelParameters.add((Component)this.jPanelButtons, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanelParameters, "Center");
        this.pack();
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        if (this.jTableParameters.getRowCount() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("ConnectionsDialog.Message.NoExport"), "", 1);
            return;
        }
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".xml") || file.isDirectory();
            }

            public String getDescription() {
                return I18n.getString("ConnectionsDialog.Description.Definition");
            }
        });
        if (jfc.showSaveDialog(this) == 0) {
            try {
                File f = jfc.getSelectedFile();
                String fileName = f.getName();
                if (fileName.indexOf(".") < 0) {
                    fileName = fileName + ".xml";
                }
                if ((f = new File(f.getParent(), fileName)).exists() && JOptionPane.showConfirmDialog(this, Misc.formatString(I18n.getString("ConnectionsDialog.Message.ConnExists"), new Object[]{"" + f}), "", 1, 2) != 0) {
                    return;
                }
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF8"));
                pw.print("<?xml version=\"1.0\"?>");
                pw.println("<!-- iReport connections -->");
                pw.println("<iReportConnectionSet>");
                List<IReportConnection> connections = IReportManager.getInstance().getConnections();
                int i = 0;
                for (IReportConnection con : connections) {
                    ++i;
                    con.save(pw);
                }
                pw.println("</iReportConnectionSet>");
                pw.close();
                JOptionPane.showMessageDialog(this, Misc.formatString(I18n.getString("ConnectionsDialog.Message.Exported"), new Object[]{new Integer(i)}), "", 1);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, Misc.formatString(I18n.getString("ConnectionsDialog.Message.ErrorSave"), new Object[]{ex.getMessage()}));
                ex.printStackTrace();
            }
        }
    }

    private void jButtonImportActionPerformed(ActionEvent evt) {
        Vector new_cons;
        JFileChooser jfc = new JFileChooser();
        jfc.setMultiSelectionEnabled(false);
        jfc.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                return filename.endsWith(".xml") || file.isDirectory();
            }

            public String getDescription() {
                return I18n.getString("ConnectionsDialog.Description.Definition");
            }
        });
        if (jfc.showOpenDialog(this) == 0 && (new_cons = this.loadConnections(jfc.getSelectedFile())) != null) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
            int i = 0;
            this.updating_row = true;
            for (i = 0; i < new_cons.size(); ++i) {
                IReportConnection con = (IReportConnection)new_cons.elementAt(i);
                dtm.addRow(new Object[]{con, con.getDescription()});
                IReportManager.getInstance().addConnection(con);
            }
            this.updating_row = false;
            IReportManager.getInstance().saveiReportConfiguration();
            JOptionPane.showMessageDialog(this, Misc.formatString(I18n.getString("ConnectionsDialog.Message.Imported"), new Object[]{new Integer(i)}), "", 1);
        }
    }

    private void jTableParametersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1) {
                this.jButtonModifyParameterActionPerformed(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButtonSetDefaultActionPerformed(ActionEvent evt) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            this.updating_row = true;
            IReportConnection irc = null;
            try {
                irc = (IReportConnection)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
                IReportManager.getInstance().setDefaultConnection(irc);
                this.jTableParameters.getModel().setValueAt(new Boolean(true), this.jTableParameters.getSelectedRow(), 2);
                for (int i = 0; i < this.jTableParameters.getRowCount(); ++i) {
                    if (i == this.jTableParameters.getSelectedRow()) continue;
                    this.jTableParameters.getModel().setValueAt(new Boolean(false), i, 2);
                }
            }
            catch (Exception ex) {
                return;
            }
            finally {
                this.updating_row = false;
            }
        }
    }

    private void jButtonDeleteParameterActionPerformed(ActionEvent evt) {
        if (this.jTableParameters.getSelectedRowCount() > 0) {
            while (this.jTableParameters.getSelectedRowCount() > 0) {
                IReportConnection irc = null;
                try {
                    irc = (IReportConnection)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
                }
                catch (Exception ex) {
                    return;
                }
                if (IReportManager.getInstance().getDefaultConnection() == irc) {
                    IReportManager.getInstance().setDefaultConnection(null);
                }
                IReportManager.getInstance().removeConnection(irc);
                ((DefaultTableModel)this.jTableParameters.getModel()).removeRow(this.jTableParameters.getSelectedRow());
                this.jTableParameters.updateUI();
            }
            IReportManager.getInstance().saveiReportConfiguration();
        }
    }

    private void jButtonModifyParameterActionPerformed(ActionEvent evt) {
        Window pWin = Misc.getParentWindow(this);
        ConnectionDialog cd = null;
        cd = pWin instanceof Dialog ? new ConnectionDialog((Dialog)pWin, true) : (pWin instanceof Frame ? new ConnectionDialog((Frame)pWin, false) : new ConnectionDialog((Dialog)null, false));
        if (this.jTableParameters.getSelectedRow() < 0) {
            return;
        }
        IReportConnection irc = null;
        try {
            irc = (IReportConnection)this.jTableParameters.getModel().getValueAt(this.jTableParameters.getSelectedRow(), 0);
        }
        catch (Exception ex) {
            return;
        }
        if (irc == null) {
            return;
        }
        cd.setIReportConnection(irc);
        cd.setVisible(true);
        if (cd.getDialogResult() == 0) {
            IReportConnection con = cd.getIReportConnection();
            try {
                this.jTableParameters.getModel().setValueAt(con, this.jTableParameters.getSelectedRow(), 0);
                this.jTableParameters.getModel().setValueAt(con.getDescription(), this.jTableParameters.getSelectedRow(), 1);
                this.jTableParameters.getModel().setValueAt(new Boolean(true), this.jTableParameters.getSelectedRow(), 2);
            }
            catch (Exception ex) {
                return;
            }
            this.updating_row = true;
            for (int i = 0; i < this.jTableParameters.getRowCount(); ++i) {
                if (i == this.jTableParameters.getSelectedRow()) continue;
                this.jTableParameters.getModel().setValueAt(new Boolean(false), i, 2);
            }
            this.updating_row = false;
            IReportManager.getInstance().updateConnection(IReportManager.getInstance().getConnections().indexOf(irc), con);
            IReportManager.getInstance().setDefaultConnection(con);
            IReportManager.getInstance().saveiReportConfiguration();
        }
    }

    private void jButtonNewParameterActionPerformed(ActionEvent evt) {
        Window parent = Misc.getParentWindow(this);
        ConnectionDialog cd = new ConnectionDialog((Dialog)this, true);
        cd.setVisible(true);
        if (cd.getDialogResult() == 0) {
            IReportConnection con = cd.getIReportConnection();
            DefaultTableModel dtm = (DefaultTableModel)this.jTableParameters.getModel();
            this.updating_row = true;
            dtm.addRow(new Object[]{con, con.getDescription(), new Boolean(true)});
            for (int i = 0; i < this.jTableParameters.getRowCount(); ++i) {
                if (i == dtm.getRowCount() - 1) continue;
                this.jTableParameters.getModel().setValueAt(new Boolean(false), i, 2);
            }
            this.updating_row = false;
            IReportManager.getInstance().addConnection(con);
            IReportManager.getInstance().setDefaultConnection(con);
            IReportManager.getInstance().saveiReportConfiguration();
        }
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public void updateConnections() {
    }

    public void setVisible(boolean visible) {
        this.updateConnections();
        super.setVisible(visible);
    }

    public Vector loadConnections(File xmlfile) {
        Vector<IReportConnection> v = new Vector<IReportConnection>();
        try {
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(DOMParser.class.getClassLoader());
            DOMParser parser = new DOMParser();
            FileInputStream fis = new FileInputStream(xmlfile);
            InputSource input_sss = new InputSource(fis);
            parser.parse(input_sss);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
            Document document = parser.getDocument();
            Element node = document.getDocumentElement();
            NodeList list_child = node.getChildNodes();
            for (int ck = 0; ck < list_child.getLength(); ++ck) {
                Node connectionNode = list_child.item(ck);
                if (connectionNode.getNodeName() == null || !connectionNode.getNodeName().equals("iReportConnection")) continue;
                String connectionName = "";
                String connectionClass = "";
                HashMap<String, String> hm = new HashMap<String, String>();
                NamedNodeMap nnm = connectionNode.getAttributes();
                if (nnm.getNamedItem("name") != null) {
                    connectionName = nnm.getNamedItem("name").getNodeValue();
                }
                if (nnm.getNamedItem("connectionClass") != null) {
                    connectionClass = nnm.getNamedItem("connectionClass").getNodeValue();
                }
                NodeList list_child2 = connectionNode.getChildNodes();
                for (int ck2 = 0; ck2 < list_child2.getLength(); ++ck2) {
                    String parameterName = "";
                    Node child_child = list_child2.item(ck2);
                    if (child_child.getNodeType() != 1 || !child_child.getNodeName().equals("connectionParameter")) continue;
                    NamedNodeMap nnm2 = child_child.getAttributes();
                    if (nnm2.getNamedItem("name") != null) {
                        parameterName = nnm2.getNamedItem("name").getNodeValue();
                    }
                    hm.put(parameterName, Misc.readPCDATA(child_child));
                }
                connectionName = ConnectionsDialog.getAvailableConnectionName(connectionName);
                try {
                    IReportConnection con = (IReportConnection)Class.forName(connectionClass).newInstance();
                    con.loadProperties(hm);
                    con.setName(connectionName);
                    v.add(con);
                    continue;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, Misc.formatString(I18n.getString("ConnectionsDialog.Message.Error"), new Object[]{connectionName}), I18n.getString("ConnectionsDialog.Message.Err"), 0);
                    ex.printStackTrace();
                }
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, Misc.formatString(I18n.getString("ConnectionsDialog.Message.Err2"), new Object[]{ex.getMessage()}), I18n.getString("ConnectionsDialog.Message.Err"), 0);
            ex.printStackTrace();
        }
        return v;
    }

    public static String getAvailableConnectionName(String proposedConnectionName) {
        return ConnectionsDialog.getAvailableConnectionName(proposedConnectionName, 0);
    }

    private static String getAvailableConnectionName(String proposedConnectionName, int testNumber) {
        String name = proposedConnectionName;
        if (testNumber != 0) {
            name = name + " (" + testNumber + ")";
        }
        List<IReportConnection> connections = IReportManager.getInstance().getConnections();
        IReportConnection default_irc = IReportManager.getInstance().getDefaultConnection();
        for (IReportConnection con : connections) {
            String conName = "" + con;
            if (!name.equals(conName)) continue;
            return ConnectionsDialog.getAvailableConnectionName(proposedConnectionName, testNumber + 1);
        }
        return name;
    }

    public void applyI18n() {
        this.jTableParameters.getColumnModel().getColumn(0).setHeaderValue(I18n.getString("connectionsDialog.tablecolumn.name"));
        this.jTableParameters.getColumnModel().getColumn(1).setHeaderValue(I18n.getString("connectionsDialog.tablecolumn.datasourceType"));
        this.jTableParameters.getColumnModel().getColumn(2).setHeaderValue(I18n.getString("connectionsDialog.tablecolumn.default"));
    }
}

