/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.crosstab.CrosstabObjectScene;
import com.jaspersoft.ireport.designer.crosstab.widgets.CrosstabWidget;
import com.jaspersoft.ireport.designer.widgets.GuideLineWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAlignWithWidgetCollector
implements AlignWithWidgetCollector {
    private List<Integer> verticalGuideLines = new ArrayList<Integer>();
    private List<Integer> horizontalGuideLines = new ArrayList<Integer>();
    private AbstractReportObjectScene scene = null;

    public List<Integer> getHorizontalGuideLines() {
        return this.horizontalGuideLines;
    }

    public void setHorizontalGuideLines(List<Integer> horizontalGuideLines) {
        this.horizontalGuideLines = horizontalGuideLines;
    }

    public List<Integer> getVerticalGuideLines() {
        return this.verticalGuideLines;
    }

    public void setVerticalGuideLines(List<Integer> verticalGuideLines) {
        this.verticalGuideLines = verticalGuideLines;
    }

    public ReportAlignWithWidgetCollector(AbstractReportObjectScene scene) {
        this.scene = scene;
    }

    public boolean isSelectedObject(Widget widget) {
        JRDesignElement obj = null;
        if (widget instanceof JRDesignElementWidget) {
            obj = ((JRDesignElementWidget)widget).getElement();
        } else if (widget instanceof SelectionWidget) {
            obj = ((SelectionWidget)widget).getRealWidget().getElement();
        }
        return ((AbstractReportObjectScene)widget.getScene()).getSelectedObjects().contains(obj);
    }

    public boolean isChildOf(Widget widget, Widget parent) {
        if (widget instanceof JRDesignElementWidget) {
            if (parent instanceof SelectionWidget) {
                parent = ((SelectionWidget)parent).getRealWidget();
            }
            if (parent instanceof JRDesignElementWidget) {
                JRDesignElement frame = ((JRDesignElementWidget)parent).getElement();
                JRDesignElement element = ((JRDesignElementWidget)widget).getElement();
                if (((JRDesignElementWidget)widget).getChildrenElements() != null) {
                    ModelUtils.isChildOf(element, ((JRDesignElementWidget)widget).getChildrenElements());
                }
            }
        }
        return false;
    }

    public Collection<Rectangle> getRegions(Widget movingWidget) {
        ArrayList<Rectangle> regions;
        block16: {
            int i;
            block15: {
                List children = this.scene.getElementsLayer().getChildren();
                regions = new ArrayList<Rectangle>(children.size());
                for (Widget widget : children) {
                    if (widget == movingWidget || this.isSelectedObject(widget) || this.isChildOf(widget, movingWidget)) continue;
                    regions.add(widget.convertLocalToScene(widget.getClientArea()));
                }
                children = this.scene.getGuideLinesLayer().getChildren();
                for (Widget widget : children) {
                    if (!(widget instanceof GuideLineWidget)) continue;
                    Rectangle r = widget.getClientArea();
                    r.width = 0;
                    regions.add(widget.convertLocalToScene(r));
                }
                if (!(this.scene instanceof ReportObjectScene)) break block15;
                JasperDesign jd = this.scene.getJasperDesign();
                int bandLocation = jd.getTopMargin();
                regions.add(new Rectangle(jd.getLeftMargin(), bandLocation, jd.getPageWidth() - jd.getRightMargin() - jd.getLeftMargin(), 0));
                for (JRBand band : ModelUtils.getBands(jd)) {
                    if (band.getHeight() <= 0) continue;
                    regions.add(new Rectangle(jd.getLeftMargin(), bandLocation += band.getHeight(), jd.getPageWidth() - jd.getRightMargin() - jd.getLeftMargin(), 0));
                }
                break block16;
            }
            if (!(this.scene instanceof CrosstabObjectScene)) break block16;
            List separators = ((CrosstabObjectScene)this.scene).getCellSeparatorsLayer().getChildren();
            CrosstabWidget cw = ((CrosstabObjectScene)this.scene).getCrosstabWidget();
            int header_width = ModelUtils.getHeaderCellWidth(cw.getCrosstab());
            int header_height = ModelUtils.getHeaderCellHeight(cw.getCrosstab());
            JRCrosstabRowGroup[] row_groups = cw.getCrosstab().getRowGroups();
            JRCrosstabColumnGroup[] col_groups = cw.getCrosstab().getColumnGroups();
            JRCrosstabCell[][] cells = ModelUtils.normalizeCell(cw.getCrosstab().getCells(), row_groups, col_groups);
            int x = header_width;
            int y = header_height;
            for (int i2 = cells.length - 1; i2 >= 0; --i2) {
                x = header_width;
                for (int k = cells[i2].length - 1; k >= 0; --k) {
                    JRCrosstabCell cell = cells[i2][k];
                    if (cell == null) continue;
                    regions.add(new Rectangle(x, y, cell.getContents().getWidth(), cell.getContents().getHeight()));
                    x += cell.getContents().getWidth();
                }
                if (cells[i2][0] == null || cells[i2][0].getContents() == null) continue;
                y += cells[i2][0].getContents().getHeight();
            }
            int data_width = x - header_width;
            int data_height = y - header_height;
            x = 0;
            y = header_height;
            for (i = 0; i < row_groups.length; ++i) {
                switch (row_groups[i].getTotalPosition()) {
                    case 1: {
                        regions.add(new Rectangle(x, y, row_groups[i].getTotalHeader().getWidth(), row_groups[i].getTotalHeader().getHeight()));
                        data_height -= row_groups[i].getTotalHeader().getHeight();
                        y += row_groups[i].getTotalHeader().getHeight();
                        break;
                    }
                    case 2: {
                        int y_loc = y + data_height - row_groups[i].getTotalHeader().getHeight();
                        regions.add(new Rectangle(x, y_loc, row_groups[i].getTotalHeader().getWidth(), row_groups[i].getTotalHeader().getHeight()));
                        data_height -= row_groups[i].getTotalHeader().getHeight();
                    }
                }
                regions.add(new Rectangle(x, y, row_groups[i].getHeader().getWidth(), row_groups[i].getHeader().getHeight()));
                x += row_groups[i].getHeader().getWidth();
            }
            x = header_width;
            y = 0;
            for (i = 0; i < col_groups.length; ++i) {
                switch (col_groups[i].getTotalPosition()) {
                    case 1: {
                        regions.add(new Rectangle(x, y, col_groups[i].getTotalHeader().getWidth(), col_groups[i].getTotalHeader().getHeight()));
                        data_width -= col_groups[i].getTotalHeader().getWidth();
                        x += col_groups[i].getTotalHeader().getWidth();
                        break;
                    }
                    case 2: {
                        int x_loc = x + data_width - col_groups[i].getTotalHeader().getWidth();
                        regions.add(new Rectangle(x_loc, y, col_groups[i].getTotalHeader().getWidth(), col_groups[i].getTotalHeader().getHeight()));
                        data_width -= col_groups[i].getTotalHeader().getWidth();
                        break;
                    }
                }
                regions.add(new Rectangle(x, y, col_groups[i].getHeader().getWidth(), col_groups[i].getHeader().getHeight()));
                y += col_groups[i].getHeader().getHeight();
            }
        }
        return regions;
    }
}

