/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs;

import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.util.Utilities;

final class ResourcePath {
    private final String resourcePath;
    private static final ResourcePath root;
    static final /* synthetic */ boolean $assertionsDisabled;

    ResourcePath(StringBuilder stringBuilder) {
        this.resourcePath = stringBuilder.toString();
    }

    ResourcePath(String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.resourcePath = ResourcePath.getNormalizedPath(string);
        if (!($assertionsDisabled || this.resourcePath.length() > 0 && this.resourcePath.charAt(0) == '/')) {
            throw new AssertionError();
        }
    }

    static ResourcePath getRoot() {
        return root;
    }

    boolean isRoot() {
        return this.getParent() == null;
    }

    File getFile() {
        if (Utilities.isWindows() || Utilities.getOperatingSystem() == 2048) {
            File file = null;
            if (!this.isRoot()) {
                String string = this.resourcePath.substring(1).replace('/', File.separatorChar);
                if (this.getParent().isRoot() && !string.endsWith("/")) {
                    string = string + "/";
                }
                file = new File(string);
            }
            return file;
        }
        return new File(this.resourcePath);
    }

    final String getNormalizedPath() {
        return this.resourcePath;
    }

    Enumeration getElements() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.resourcePath, "/");
        return stringTokenizer;
    }

    ResourcePath getChild(String string) {
        ResourcePath resourcePath = null;
        StringBuilder stringBuilder = new StringBuilder(this.resourcePath);
        if (!this.resourcePath.endsWith("/")) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string);
        resourcePath = new ResourcePath(stringBuilder);
        return resourcePath;
    }

    ResourcePath getChild(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(this.resourcePath);
        if (!this.resourcePath.endsWith("/")) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string);
        if (string2 != null && string2.length() != 0) {
            stringBuilder.append('.').append(string2);
        }
        return new ResourcePath(stringBuilder.toString());
    }

    ResourcePath getParent() {
        int n = this.resourcePath.lastIndexOf(47);
        if (n == 0 && this.resourcePath.length() == 1) {
            return null;
        }
        return new ResourcePath(n <= 0 ? "/" : this.resourcePath.substring(0, n));
    }

    String getExt() {
        return FileInfo.getExt(this.getNameExt());
    }

    String getName() {
        return FileInfo.getName(this.getNameExt());
    }

    String getNameExt() {
        int n = this.resourcePath.lastIndexOf(47);
        if (!$assertionsDisabled && n == -1) {
            throw new AssertionError((Object)this.resourcePath);
        }
        return this.resourcePath.substring(++n);
    }

    String getPath() {
        return this.resourcePath.substring(1);
    }

    static String getNormalizedPath(String string) {
        if (string == null) {
            return string;
        }
        if (!(string = string.replace('\\', '/')).startsWith("/")) {
            string = "/" + string;
        }
        if (string.endsWith("/") && string.length() != "/".length()) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    public int hashCode() {
        return this.resourcePath.hashCode();
    }

    public boolean equals(Object object) {
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof ResourcePath) {
            string = ((ResourcePath)object).getNormalizedPath();
        }
        return this.resourcePath.equals(string);
    }

    public String toString() {
        return this.getNormalizedPath();
    }

    static {
        $assertionsDisabled = !ResourcePath.class.desiredAssertionStatus();
        root = new ResourcePath("/");
    }
}

