/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Level;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.Type;

public class LevelExpr
extends ExpBase
implements Exp {
    private final Level level;

    public LevelExpr(Level level) {
        Util.assertPrecondition(level != null, "level != null");
        this.level = level;
    }

    public Level getLevel() {
        return this.level;
    }

    public String toString() {
        return this.level.getUniqueName();
    }

    public Type getType() {
        return LevelType.forLevel(this.level);
    }

    public LevelExpr clone() {
        return new LevelExpr(this.level);
    }

    public int getCategory() {
        return 4;
    }

    public Exp accept(Validator validator) {
        return this;
    }

    public Calc accept(ExpCompiler compiler) {
        return ConstantCalc.constantLevel(this.level);
    }

    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }
}

