/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.storage.SettingsType;
import org.netbeans.modules.editor.settings.storage.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeTypesTracker {
    private static final Logger LOG = Logger.getLogger(MimeTypesTracker.class.getName());
    public static final String PROP_MIME_TYPES = "mime-types";
    private final String LOCK = new String("MimeTypesTracker.LOCK");
    private final String basePath;
    private final String[] basePathElements;
    private final SettingsType.Locator locator;
    private FileObject folder;
    private boolean isBaseFolder;
    private Map<String, String> mimeTypes = Collections.emptyMap();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final FileChangeListener listener;

    public MimeTypesTracker(String string, SettingsType settingsType) {
        this.basePath = string;
        this.basePathElements = string.split("/");
        this.locator = settingsType == null ? null : settingsType.getLocator();
        this.rebuild();
        this.listener = new Listener();
        FileSystem fileSystem = Repository.getDefault().getDefaultFileSystem();
        fileSystem.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.listener, (Object)fileSystem));
    }

    public String getBasePath() {
        return this.basePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMimeTypes() {
        String string = this.LOCK;
        synchronized (string) {
            return this.mimeTypes.keySet();
        }
    }

    public String getMimeTypeDisplayName(String string) {
        String string2 = this.mimeTypes.get(string);
        return string2 == null ? string : string2;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuild() {
        PropertyChangeEvent propertyChangeEvent = null;
        String string = this.LOCK;
        synchronized (string) {
            Object[] objectArray = MimeTypesTracker.findTarget(this.basePathElements);
            FileObject fileObject = (FileObject)objectArray[0];
            boolean bl = (Boolean)objectArray[1];
            if (fileObject != this.folder) {
                this.folder = fileObject;
                this.isBaseFolder = bl;
                LOG.finest("folder = '" + this.folder.getPath() + "'");
                LOG.finest("isBaseFolder = '" + this.isBaseFolder + "'");
            }
            if (this.isBaseFolder) {
                Map<String, Object> map = new HashMap();
                FileObject[] fileObjectArray = this.folder.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    if (!MimeTypesTracker.isValidType(fileObjectArray[i])) continue;
                    FileObject[] fileObjectArray2 = fileObjectArray[i].getChildren();
                    for (int j = 0; j < fileObjectArray2.length; ++j) {
                        boolean bl2;
                        Object object;
                        if (!MimeTypesTracker.isValidSubtype(fileObjectArray2[j])) continue;
                        String string2 = fileObjectArray[i].getNameExt() + "/" + fileObjectArray2[j].getNameExt();
                        if (this.locator != null) {
                            object = new HashMap();
                            this.locator.scan(this.folder, string2, null, false, true, true, (Map<String, List<Object[]>>)object);
                            bl2 = !object.isEmpty();
                        } else {
                            bl2 = true;
                        }
                        if (!bl2) continue;
                        object = Utils.getLocalizedName(fileObjectArray2[j], null);
                        if (object == null) {
                            object = Utils.getLocalizedName(fileObjectArray2[j], string2, string2);
                        }
                        map.put(string2, object);
                    }
                }
                if (!((Object)this.mimeTypes).equals(map = Collections.unmodifiableMap(map))) {
                    propertyChangeEvent = new PropertyChangeEvent(this, PROP_MIME_TYPES, this.mimeTypes, map);
                    this.mimeTypes = map;
                }
            }
        }
        if (propertyChangeEvent != null) {
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    private static boolean isValidType(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getNameExt();
        return MimePath.validate((CharSequence)string, null);
    }

    private static boolean isValidSubtype(FileObject fileObject) {
        if (!fileObject.isFolder()) {
            return false;
        }
        String string = fileObject.getNameExt();
        return MimePath.validate(null, (CharSequence)string) && !string.equals("base");
    }

    private static Object[] findTarget(String[] stringArray) {
        FileObject fileObject;
        FileObject fileObject2 = Repository.getDefault().getDefaultFileSystem().getRoot();
        boolean bl = 0 == stringArray.length;
        for (int i = 0; i < stringArray.length && (fileObject = fileObject2.getFileObject(stringArray[i])) != null && fileObject.isFolder() && fileObject.isValid() && !fileObject.isVirtual(); ++i) {
            fileObject2 = fileObject;
            bl = i + 1 == stringArray.length;
        }
        return new Object[]{fileObject2, bl};
    }

    private final class Listener
    extends FileChangeAdapter {
        public void fileFolderCreated(FileEvent fileEvent) {
            this.notifyRebuild(fileEvent.getFile());
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.notifyRebuild(fileEvent.getFile());
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.notifyRebuild(fileRenameEvent.getFile());
        }

        private void notifyRebuild(FileObject fileObject) {
            String string = fileObject.getPath();
            if (string.startsWith(MimeTypesTracker.this.basePath)) {
                MimeTypesTracker.this.rebuild();
            }
        }
    }
}

