/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.TextFunction;

public final class Substitute
extends TextFunction {
    protected ValueEval evaluateFunc(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
        String result;
        if (args.length < 3 || args.length > 4) {
            return ErrorEval.VALUE_INVALID;
        }
        String oldStr = Substitute.evaluateStringArg(args[0], srcCellRow, srcCellCol);
        String searchStr = Substitute.evaluateStringArg(args[1], srcCellRow, srcCellCol);
        String newStr = Substitute.evaluateStringArg(args[2], srcCellRow, srcCellCol);
        switch (args.length) {
            default: {
                throw new IllegalStateException("Cannot happen");
            }
            case 4: {
                int instanceNumber = Substitute.evaluateIntArg(args[3], srcCellRow, srcCellCol);
                if (instanceNumber < 1) {
                    return ErrorEval.VALUE_INVALID;
                }
                result = Substitute.replaceOneOccurrence(oldStr, searchStr, newStr, instanceNumber);
                break;
            }
            case 3: {
                result = Substitute.replaceAllOccurrences(oldStr, searchStr, newStr);
            }
        }
        return new StringEval(result);
    }

    private static String replaceAllOccurrences(String oldStr, String searchStr, String newStr) {
        StringBuffer sb = new StringBuffer();
        int startIndex = 0;
        int nextMatch = -1;
        while (true) {
            if ((nextMatch = oldStr.indexOf(searchStr, startIndex)) < 0) {
                sb.append(oldStr.substring(startIndex));
                return sb.toString();
            }
            sb.append(oldStr.substring(startIndex, nextMatch));
            sb.append(newStr);
            startIndex = nextMatch + searchStr.length();
        }
    }

    private static String replaceOneOccurrence(String oldStr, String searchStr, String newStr, int instanceNumber) {
        if (searchStr.length() < 1) {
            return oldStr;
        }
        int startIndex = 0;
        int nextMatch = -1;
        int count = 0;
        while ((nextMatch = oldStr.indexOf(searchStr, startIndex)) >= 0) {
            if (++count == instanceNumber) {
                StringBuffer sb = new StringBuffer(oldStr.length() + newStr.length());
                sb.append(oldStr.substring(0, nextMatch));
                sb.append(newStr);
                sb.append(oldStr.substring(nextMatch + searchStr.length()));
                return sb.toString();
            }
            startIndex = nextMatch + searchStr.length();
        }
        return oldStr;
    }
}

