/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.IndexRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;
import org.apache.poi.hssf.record.aggregates.ValueRecordsAggregate;
import org.apache.poi.hssf.record.formula.FormulaShifter;

public final class RowRecordsAggregate
extends RecordAggregate {
    private int _firstrow = -1;
    private int _lastrow = -1;
    private final Map _rowRecords = new TreeMap();
    private final ValueRecordsAggregate _valuesAgg = new ValueRecordsAggregate();
    private final List _unknownRecords = new ArrayList();
    private final SharedValueManager _sharedValueManager;

    public RowRecordsAggregate() {
        this(SharedValueManager.EMPTY);
    }

    private RowRecordsAggregate(SharedValueManager svm) {
        this._sharedValueManager = svm;
    }

    public RowRecordsAggregate(RecordStream rs, SharedValueManager svm) {
        this(svm);
        block4: while (rs.hasNext()) {
            Record rec = rs.getNext();
            switch (rec.getSid()) {
                case 520: {
                    this.insertRow((RowRecord)rec);
                    continue block4;
                }
                case 215: {
                    continue block4;
                }
            }
            if (rec instanceof UnknownRecord) {
                this.addUnknownRecord((UnknownRecord)rec);
                continue;
            }
            if (!(rec instanceof CellValueRecordInterface)) {
                throw new RuntimeException("Unexpected record type (" + rec.getClass().getName() + ")");
            }
            this._valuesAgg.construct((CellValueRecordInterface)((Object)rec), rs, svm);
        }
    }

    private void addUnknownRecord(UnknownRecord rec) {
        this._unknownRecords.add(rec);
    }

    public void insertRow(RowRecord row) {
        this._rowRecords.put(new Integer(row.getRowNumber()), row);
        if (row.getRowNumber() < this._firstrow || this._firstrow == -1) {
            this._firstrow = row.getRowNumber();
        }
        if (row.getRowNumber() > this._lastrow || this._lastrow == -1) {
            this._lastrow = row.getRowNumber();
        }
    }

    public void removeRow(RowRecord row) {
        int rowIndex = row.getRowNumber();
        this._valuesAgg.removeAllCellsValuesForRow(rowIndex);
        Integer key = new Integer(rowIndex);
        RowRecord rr = (RowRecord)this._rowRecords.remove(key);
        if (rr == null) {
            throw new RuntimeException("Invalid row index (" + key + ")");
        }
        if (row != rr) {
            this._rowRecords.put(key, rr);
            throw new RuntimeException("Attempt to remove row that does not belong to this sheet");
        }
    }

    public RowRecord getRow(int rowIndex) {
        if (rowIndex < 0 || rowIndex > 65535) {
            throw new IllegalArgumentException("The row number must be between 0 and 65535");
        }
        return (RowRecord)this._rowRecords.get(new Integer(rowIndex));
    }

    public int getPhysicalNumberOfRows() {
        return this._rowRecords.size();
    }

    public int getFirstRowNum() {
        return this._firstrow;
    }

    public int getLastRowNum() {
        return this._lastrow;
    }

    public int getRowBlockCount() {
        int size = this._rowRecords.size() / 32;
        if (this._rowRecords.size() % 32 != 0) {
            ++size;
        }
        return size;
    }

    private int getRowBlockSize(int block) {
        return 20 * this.getRowCountForBlock(block);
    }

    public int getRowCountForBlock(int block) {
        int startIndex = block * 32;
        int endIndex = startIndex + 32 - 1;
        if (endIndex >= this._rowRecords.size()) {
            endIndex = this._rowRecords.size() - 1;
        }
        return endIndex - startIndex + 1;
    }

    private int getStartRowNumberForBlock(int block) {
        int startIndex = block * 32;
        Iterator rowIter = this._rowRecords.values().iterator();
        RowRecord row = null;
        for (int i = 0; i <= startIndex; ++i) {
            row = (RowRecord)rowIter.next();
        }
        if (row == null) {
            throw new RuntimeException("Did not find start row for block " + block);
        }
        return row.getRowNumber();
    }

    private int getEndRowNumberForBlock(int block) {
        int endIndex = (block + 1) * 32 - 1;
        if (endIndex >= this._rowRecords.size()) {
            endIndex = this._rowRecords.size() - 1;
        }
        Iterator rowIter = this._rowRecords.values().iterator();
        RowRecord row = null;
        for (int i = 0; i <= endIndex; ++i) {
            row = (RowRecord)rowIter.next();
        }
        if (row == null) {
            throw new RuntimeException("Did not find start row for block " + block);
        }
        return row.getRowNumber();
    }

    private int visitRowRecordsForBlock(int blockIndex, RecordAggregate.RecordVisitor rv) {
        int i;
        int startIndex = blockIndex * 32;
        int endIndex = startIndex + 32;
        Iterator rowIterator = this._rowRecords.values().iterator();
        for (i = 0; i < startIndex; ++i) {
            rowIterator.next();
        }
        int result = 0;
        while (rowIterator.hasNext() && i++ < endIndex) {
            Record rec = (Record)rowIterator.next();
            result += rec.getRecordSize();
            rv.visitRecord(rec);
        }
        return result;
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        RecordAggregate.PositionTrackingVisitor stv = new RecordAggregate.PositionTrackingVisitor(rv, 0);
        int blockCount = this.getRowBlockCount();
        for (int blockIndex = 0; blockIndex < blockCount; ++blockIndex) {
            int pos = 0;
            int rowBlockSize = this.visitRowRecordsForBlock(blockIndex, rv);
            pos += rowBlockSize;
            int startRowNumber = this.getStartRowNumberForBlock(blockIndex);
            int endRowNumber = this.getEndRowNumberForBlock(blockIndex);
            DBCellRecord cellRecord = new DBCellRecord();
            int cellRefOffset = rowBlockSize - 20;
            for (int row = startRowNumber; row <= endRowNumber; ++row) {
                if (!this._valuesAgg.rowHasCells(row)) continue;
                stv.setPosition(0);
                this._valuesAgg.visitCellsForRow(row, stv);
                int rowCellSize = stv.getPosition();
                pos += rowCellSize;
                cellRecord.addCellOffset((short)cellRefOffset);
                cellRefOffset = rowCellSize;
            }
            cellRecord.setRowOffset(pos);
            rv.visitRecord(cellRecord);
        }
        for (int i = 0; i < this._unknownRecords.size(); ++i) {
            rv.visitRecord((Record)this._unknownRecords.get(i));
        }
    }

    public Iterator getIterator() {
        return this._rowRecords.values().iterator();
    }

    public Iterator getAllRecordsIterator() {
        ArrayList<Object> result = new ArrayList<Object>(this._rowRecords.size() * 2);
        result.addAll(this._rowRecords.values());
        Iterator vi = this._valuesAgg.getIterator();
        while (vi.hasNext()) {
            result.add(vi.next());
        }
        return result.iterator();
    }

    public int findStartOfRowOutlineGroup(int row) {
        RowRecord rowRecord = this.getRow(row);
        short level = rowRecord.getOutlineLevel();
        int currentRow = row;
        while (this.getRow(currentRow) != null) {
            rowRecord = this.getRow(currentRow);
            if (rowRecord.getOutlineLevel() < level) {
                return currentRow + 1;
            }
            --currentRow;
        }
        return currentRow + 1;
    }

    public int findEndOfRowOutlineGroup(int row) {
        int currentRow;
        short level = this.getRow(row).getOutlineLevel();
        for (currentRow = row; currentRow < this.getLastRowNum() && this.getRow(currentRow) != null && this.getRow(currentRow).getOutlineLevel() >= level; ++currentRow) {
        }
        return currentRow - 1;
    }

    public int writeHidden(RowRecord rowRecord, int row, boolean hidden) {
        short level = rowRecord.getOutlineLevel();
        while (rowRecord != null && this.getRow(row).getOutlineLevel() >= level) {
            rowRecord.setZeroHeight(hidden);
            rowRecord = this.getRow(++row);
        }
        return row - 1;
    }

    public void collapseRow(int rowNumber) {
        int startRow = this.findStartOfRowOutlineGroup(rowNumber);
        RowRecord rowRecord = this.getRow(startRow);
        int lastRow = this.writeHidden(rowRecord, startRow, true);
        if (this.getRow(lastRow + 1) != null) {
            this.getRow(lastRow + 1).setColapsed(true);
        } else {
            RowRecord row = RowRecordsAggregate.createRow(lastRow + 1);
            row.setColapsed(true);
            this.insertRow(row);
        }
    }

    public static RowRecord createRow(int rowNumber) {
        return new RowRecord(rowNumber);
    }

    public boolean isRowGroupCollapsed(int row) {
        int collapseRow = this.findEndOfRowOutlineGroup(row) + 1;
        if (this.getRow(collapseRow) == null) {
            return false;
        }
        return this.getRow(collapseRow).getColapsed();
    }

    public void expandRow(int rowNumber) {
        int idx = rowNumber;
        if (idx == -1) {
            return;
        }
        if (!this.isRowGroupCollapsed(idx)) {
            return;
        }
        int startIdx = this.findStartOfRowOutlineGroup(idx);
        RowRecord row = this.getRow(startIdx);
        int endIdx = this.findEndOfRowOutlineGroup(idx);
        if (!this.isRowGroupHiddenByParent(idx)) {
            for (int i = startIdx; i <= endIdx; ++i) {
                if (row.getOutlineLevel() == this.getRow(i).getOutlineLevel()) {
                    this.getRow(i).setZeroHeight(false);
                    continue;
                }
                if (this.isRowGroupCollapsed(i)) continue;
                this.getRow(i).setZeroHeight(false);
            }
        }
        this.getRow(endIdx + 1).setColapsed(false);
    }

    public boolean isRowGroupHiddenByParent(int row) {
        boolean startHidden;
        short startLevel;
        boolean endHidden;
        short endLevel;
        int endOfOutlineGroupIdx = this.findEndOfRowOutlineGroup(row);
        if (this.getRow(endOfOutlineGroupIdx + 1) == null) {
            endLevel = 0;
            endHidden = false;
        } else {
            endLevel = this.getRow(endOfOutlineGroupIdx + 1).getOutlineLevel();
            endHidden = this.getRow(endOfOutlineGroupIdx + 1).getZeroHeight();
        }
        int startOfOutlineGroupIdx = this.findStartOfRowOutlineGroup(row);
        if (startOfOutlineGroupIdx - 1 < 0 || this.getRow(startOfOutlineGroupIdx - 1) == null) {
            startLevel = 0;
            startHidden = false;
        } else {
            startLevel = this.getRow(startOfOutlineGroupIdx - 1).getOutlineLevel();
            startHidden = this.getRow(startOfOutlineGroupIdx - 1).getZeroHeight();
        }
        if (endLevel > startLevel) {
            return endHidden;
        }
        return startHidden;
    }

    public CellValueRecordInterface[] getValueRecords() {
        return this._valuesAgg.getValueRecords();
    }

    public IndexRecord createIndexRecord(int indexRecordOffset, int sizeOfInitialSheetRecords) {
        IndexRecord result = new IndexRecord();
        result.setFirstRow(this._firstrow);
        result.setLastRowAdd1(this._lastrow + 1);
        int blockCount = this.getRowBlockCount();
        int indexRecSize = IndexRecord.getRecordSizeForBlockCount(blockCount);
        int currentOffset = indexRecordOffset + indexRecSize + sizeOfInitialSheetRecords;
        for (int block = 0; block < blockCount; ++block) {
            currentOffset += this.getRowBlockSize(block);
            result.addDbcell(currentOffset += this._valuesAgg.getRowCellBlockSize(this.getStartRowNumberForBlock(block), this.getEndRowNumberForBlock(block)));
            currentOffset += 8 + this.getRowCountForBlock(block) * 2;
        }
        return result;
    }

    public void insertCell(CellValueRecordInterface cvRec) {
        this._valuesAgg.insertCell(cvRec);
    }

    public void removeCell(CellValueRecordInterface cvRec) {
        this._valuesAgg.removeCell(cvRec);
    }

    public FormulaRecordAggregate createFormula(int row, int col) {
        FormulaRecord fr = new FormulaRecord();
        fr.setRow(row);
        fr.setColumn((short)col);
        return new FormulaRecordAggregate(fr, null, this._sharedValueManager);
    }

    public void updateFormulasAfterRowShift(FormulaShifter formulaShifter, int currentExternSheetIndex) {
        this._valuesAgg.updateFormulasAfterRowShift(formulaShifter, currentExternSheetIndex);
    }
}

