/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.comparer;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import nickyb.sqleonardo.common.gui.BorderLayoutPanel;
import nickyb.sqleonardo.common.jdbc.ConnectionAssistant;
import nickyb.sqleonardo.common.jdbc.ConnectionHandler;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.comparer._Analyzer;
import nickyb.sqleonardo.environment.ctrl.comparer._Starter;
import nickyb.sqleonardo.environment.ctrl.content.TableMetaData;

public class ReportPane
extends BorderLayoutPanel
implements _Analyzer,
Runnable {
    private static final String TAB = "\t";
    private static final String WAIT = "...";
    private static final String INDENT = "\t> ";
    private JTextArea output = new JTextArea();
    private _Starter starter;
    private Thread task;

    public ReportPane() {
        this.setComponentCenter(new JScrollPane(this.output));
        this.output.setTabSize(4);
        this.output.setEditable(false);
    }

    private boolean isAlive() {
        return this.task != null && this.task.isAlive();
    }

    public void onStopped() {
        this.printLn("[" + new Date(System.currentTimeMillis()) + "] STOPPED!");
        this.task.interrupt();
        this.task = null;
    }

    public void perform(_Starter starter) {
        this.starter = starter;
        this.task = new Thread(this);
        this.task.start();
    }

    private void print(String s) {
        this.output.append(s);
    }

    private void printLn(String s) {
        this.print(s + "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.output.setText(null);
        this.printLn("[" + new Date(System.currentTimeMillis()) + "] STARTED!\n");
        ConnectionHandler ch1 = ConnectionAssistant.getHandler(this.starter.getKeyHandler1());
        ConnectionHandler ch2 = ConnectionAssistant.getHandler(this.starter.getKeyHandler2());
        try {
            String catalog2;
            String catalog1 = this.starter.getSchema1() == null ? null : ch1.get().getCatalog();
            String string = catalog2 = this.starter.getSchema2() == null ? null : ch2.get().getCatalog();
            if (!this.isAlive()) {
                return;
            }
            ArrayList al1 = this.getTables(ch1, this.starter.getKeyHandler1(), catalog1, this.starter.getSchema1());
            if (!this.isAlive()) {
                return;
            }
            ArrayList al2 = this.getTables(ch2, this.starter.getKeyHandler2(), catalog2, this.starter.getSchema2());
            this.print("\n" + this.getConnectionInfo(this.starter.getKeyHandler1(), this.starter.getSchema1()) + " <==> ");
            this.printLn(this.getConnectionInfo(this.starter.getKeyHandler2(), this.starter.getSchema2()));
            if (!this.isAlive()) {
                return;
            }
            this.compareNames(al1, al2);
            if (this.starter.isViceVersa()) {
                this.print("\n" + this.getConnectionInfo(this.starter.getKeyHandler2(), this.starter.getSchema2()) + " <==> ");
                this.printLn(this.getConnectionInfo(this.starter.getKeyHandler1(), this.starter.getSchema1()));
                if (!this.isAlive()) {
                    return;
                }
                this.compareNames(al2, al1);
            }
            this.printLn("\n[" + new Date(System.currentTimeMillis()) + "] FINISHED!\n");
        }
        catch (SQLException e) {
            Application.println(e, true);
            this.print(e.toString());
        }
        finally {
            this.starter.onFinished();
        }
    }

    private String getConnectionInfo(String keycah, String schema) {
        return keycah + (schema != null ? "( " + schema + " )" : "");
    }

    private ArrayList getTables(ConnectionHandler ch, String keycah, String catalog, String schema) throws SQLException {
        this.print("searching into: " + this.getConnectionInfo(keycah, schema) + WAIT);
        ArrayList<TableMetaData> al = new ArrayList<TableMetaData>();
        ResultSet rs = ch.get().getMetaData().getTables(catalog, schema, this.starter.getTablePattern(), new String[]{"TABLE"});
        while (this.isAlive() && rs.next()) {
            al.add(new TableMetaData(keycah, rs.getString(2), rs.getString(3)));
        }
        rs.close();
        this.printLn("found " + al.size());
        return al;
    }

    private void compareNames(ArrayList alSource, ArrayList alTarget) {
        int notfounds = 0;
        for (int i = 0; this.isAlive() && i < alSource.size(); ++i) {
            TableMetaData tmdSource = (TableMetaData)alSource.get(i);
            TableMetaData tmdTarget = null;
            for (int j = 0; this.isAlive() && j < alTarget.size(); ++j) {
                tmdTarget = (TableMetaData)alTarget.get(j);
                if (tmdSource.getName().equalsIgnoreCase(tmdTarget.getName())) break;
                tmdTarget = null;
            }
            if (tmdTarget == null) {
                this.printLn("\t> TABLE NOT FOUND: " + tmdSource.getName());
                alSource.remove(i--);
                ++notfounds;
                continue;
            }
            this.printLn(TAB + tmdSource.getName());
            if (this.starter.checkColumns()) {
                if (!this.isAlive()) {
                    return;
                }
                this.compareColumns(tmdSource, tmdTarget);
            }
            if (this.starter.checkPrimaryKeys()) {
                if (!this.isAlive()) {
                    return;
                }
                this.comparePrimaryKeys(tmdSource, tmdTarget);
            }
            if (this.starter.checkExportedKeys()) {
                if (!this.isAlive()) {
                    return;
                }
                this.compareExportedKeys(tmdSource, tmdTarget);
            }
            if (!this.starter.checkImportedKeys()) continue;
            if (!this.isAlive()) {
                return;
            }
            this.compareImportedKeys(tmdSource, tmdTarget);
        }
        this.printLn(notfounds + " TABLES NOT FOUND");
    }

    private void compareImportedKeys(TableMetaData tmdSource, TableMetaData tmdTarget) {
        ArrayList alSourceIK = tmdSource.getImportedKeys();
        ArrayList alTargetIK = tmdTarget.getImportedKeys();
        for (int j = 0; this.isAlive() && j < alSourceIK.size(); ++j) {
            String s = tmdSource.getImportedKeyProperty(j, 2);
            s = s + "." + tmdSource.getImportedKeyProperty(j, 3);
            boolean found = false;
            for (int z = 0; this.isAlive() && !found && z < alTargetIK.size(); ++z) {
                String t = tmdTarget.getImportedKeyProperty(z, 2);
                if (!s.equalsIgnoreCase(t = t + "." + tmdTarget.getImportedKeyProperty(z, 3))) continue;
                found = true;
            }
            if (found) continue;
            this.printLn("\t\t> RELATION NOT FOUND: " + s);
        }
    }

    private void compareExportedKeys(TableMetaData tmdSource, TableMetaData tmdTarget) {
        ArrayList alSourceEK = tmdSource.getExportedKeys();
        ArrayList alTargetEK = tmdTarget.getExportedKeys();
        for (int j = 0; this.isAlive() && j < alSourceEK.size(); ++j) {
            String s = tmdSource.getExportedKeyProperty(j, 6);
            s = s + "." + tmdSource.getExportedKeyProperty(j, 7);
            boolean found = false;
            for (int z = 0; this.isAlive() && !found && z < alTargetEK.size(); ++z) {
                String t = tmdTarget.getExportedKeyProperty(z, 6);
                if (!s.equalsIgnoreCase(t = t + "." + tmdTarget.getExportedKeyProperty(z, 7))) continue;
                found = true;
            }
            if (found) continue;
            this.printLn("\t\t> RELATION NOT FOUND: " + s);
        }
    }

    private void comparePrimaryKeys(TableMetaData tmdSource, TableMetaData tmdTarget) {
        ArrayList alSourcePK = tmdSource.getPrimaryKeys();
        ArrayList alTargetPK = tmdTarget.getPrimaryKeys();
        for (int j = 0; this.isAlive() && j < alSourcePK.size(); ++j) {
            String s = tmdSource.getPrimaryKeyProperty(j, 3);
            boolean found = false;
            for (int z = 0; this.isAlive() && !found && z < alTargetPK.size(); ++z) {
                String t = tmdTarget.getPrimaryKeyProperty(z, 3);
                if (!s.equalsIgnoreCase(t)) continue;
                found = true;
            }
            if (found) continue;
            this.printLn("\t\t> COLUMN IS NOT PRIMARY KEY: " + s);
        }
    }

    private void compareColumns(TableMetaData tmdSource, TableMetaData tmdTarget) {
        ArrayList alSourceCols = tmdSource.getColumns();
        ArrayList alTargetCols = tmdTarget.getColumns();
        for (int j = 0; this.isAlive() && j < alSourceCols.size(); ++j) {
            String s = tmdSource.getColumnProperty(j, 3);
            boolean found = false;
            for (int z = 0; this.isAlive() && !found && z < alTargetCols.size(); ++z) {
                String t = tmdTarget.getColumnProperty(z, 3);
                if (!s.equalsIgnoreCase(t)) continue;
                found = true;
            }
            if (found) continue;
            this.printLn("\t\t> COLUMN NOT FOUND: " + s);
        }
    }
}

