/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.netbeans.api.visual.model.ObjectSceneEvent;
import org.netbeans.api.visual.model.ObjectSceneEventType;
import org.netbeans.api.visual.model.ObjectSceneListener;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSceneSelectionManager
implements ObjectSceneListener {
    private AbstractReportObjectScene scene;
    private List<JRDesignElement> selectedElements = null;

    public ObjectSceneSelectionManager(AbstractReportObjectScene scene) {
        this.scene = scene;
        this.selectedElements = new ArrayList<JRDesignElement>();
        scene.addObjectSceneListener(this, new ObjectSceneEventType[]{ObjectSceneEventType.OBJECT_SELECTION_CHANGED});
    }

    public void objectAdded(ObjectSceneEvent arg0, Object arg1) {
    }

    public void objectRemoved(ObjectSceneEvent arg0, Object arg1) {
    }

    public void objectStateChanged(ObjectSceneEvent arg0, Object arg1, ObjectState arg2, ObjectState arg3) {
    }

    public void selectionChanged(ObjectSceneEvent event, Set<Object> previousSelection, Set<Object> newSelection) {
        for (int i = 0; i < this.selectedElements.size(); ++i) {
            if (newSelection.contains(this.selectedElements.get(i))) continue;
            this.selectedElements.remove(i);
            --i;
        }
        for (Object elem : newSelection) {
            if (!(elem instanceof JRDesignElement)) continue;
            JRDesignElement delem = (JRDesignElement)elem;
            this.selectedElements.add(delem);
        }
        if (this.selectedElements.size() > 0) {
            for (JRDesignElement element : this.selectedElements) {
                Widget w = this.getScene().findWidget(element);
                if (!(w instanceof JRDesignElementWidget)) continue;
                JRDesignElementWidget dew = (JRDesignElementWidget)w;
                dew.getSelectionWidget().updateBounds();
                dew.getSelectionWidget().revalidate(true);
            }
            this.getScene().validate();
        }
    }

    public void highlightingChanged(ObjectSceneEvent arg0, Set<Object> arg1, Set<Object> arg2) {
    }

    public void hoverChanged(ObjectSceneEvent arg0, Object arg1, Object arg2) {
    }

    public void focusChanged(ObjectSceneEvent arg0, Object arg1, Object arg2) {
    }

    public AbstractReportObjectScene getScene() {
        return this.scene;
    }

    public void setScene(AbstractReportObjectScene scene) {
        this.scene = scene;
    }

    public List<JRDesignElement> getSelectedElements() {
        return this.selectedElements;
    }
}

