/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui;

import com.jaspersoft.ireport.jasperserver.JServer;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.ui.RepositoryListCellRenderer;
import com.jaspersoft.ireport.jasperserver.ui.RepositoryTableCellRenderer;
import com.jaspersoft.ireport.jasperserver.ui.ResourceSelectedListener;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ResourceChooser
extends JPanel {
    private JServer server = null;
    private JDialog dialog = null;
    private int dialogResult = 2;
    private boolean foldersOnly = false;
    private ResourceDescriptor root = null;
    private ResourceDescriptor currentParent = null;
    private ResourceDescriptor selectedDescriptor = null;
    private final Set<ResourceSelectedListener> listeners = new HashSet<ResourceSelectedListener>(1);
    private ButtonGroup buttonGroup1;
    private JButton jButtonClose;
    private JToggleButton jButtonDetails;
    private JToggleButton jButtonList;
    private JButton jButtonOpen;
    private JButton jButtonUp;
    private JComboBox jComboBox2;
    private JComboBox jComboBoxLookIn;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelTop;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTextField jTextField1;

    public ResourceChooser() {
        this.initComponents();
        this.jList1.setModel(new DefaultListModel());
        this.jScrollPane2.getViewport().setBackground(Color.WHITE);
        this.adjustListView();
        this.setRoot(new ResourceDescriptor());
        this.getRoot().setUriString("/");
        this.getRoot().setChildren(null);
        this.getRoot().setWsType("folder");
        this.jList1.setCellRenderer(new RepositoryListCellRenderer());
        TableColumn col = this.jTable1.getColumnModel().getColumn(0);
        col.setCellRenderer(new RepositoryTableCellRenderer());
        this.jList1.getSelectionModel().setSelectionMode(0);
        this.jTable1.setSelectionMode(0);
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ResourceChooser.this.jTable1ValueChanged(evt);
            }
        });
        this.jComboBoxLookIn.removeAllItems();
        this.jComboBoxLookIn.setRenderer(new RepositoryListCellRenderer(true));
        this.jButtonDetails.setIcon(UIManager.getIcon("FileChooser.detailsViewIcon"));
        this.jButtonDetails.setText("");
        this.jButtonList.setIcon(UIManager.getIcon("FileChooser.listViewIcon"));
        this.jButtonList.setText("");
        this.jButtonUp.setIcon(UIManager.getIcon("FileChooser.upFolderIcon"));
        this.jButtonUp.setText("");
        this.jTextField1.requestFocusInWindow();
        this.jTextField1.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                ResourceChooser.this.updateSelectedDescriptor();
            }

            public void insertUpdate(DocumentEvent evt) {
                ResourceChooser.this.updateSelectedDescriptor();
            }

            public void removeUpdate(DocumentEvent evt) {
                ResourceChooser.this.updateSelectedDescriptor();
            }
        });
        this.applyI18n();
    }

    public void applyI18n() {
        this.jButtonClose.setText(JasperServerManager.getString("resourceChooser.buttonCancel", "Cancel"));
        this.jButtonDetails.setToolTipText(JasperServerManager.getString("resourceChooser.buttonDetails", "Details"));
        this.jButtonList.setToolTipText(JasperServerManager.getString("resourceChooser.buttonList", "List"));
        this.jButtonOpen.setText(JasperServerManager.getString("resourceChooser.buttonOpenResource", "Open resource"));
        this.jButtonUp.setToolTipText(JasperServerManager.getString("resourceChooser.buttonUp", "Up"));
        this.jLabel1.setText(JasperServerManager.getString("resourceChooser.labelLookIn", "Look in:"));
        this.jLabel2.setText(JasperServerManager.getString("resourceChooser.labelResourceName", "Resource name:"));
        this.jLabel3.setText(JasperServerManager.getString("resourceChooser.labelResourceType", "Type:"));
        this.jTable1.getColumn("Name").setHeaderValue(JasperServerManager.getString("resourceChooser.table.label", "Name"));
        this.jTable1.getColumn("Label").setHeaderValue(JasperServerManager.getString("resourceChooser.table.value", "Label"));
        this.jTable1.getColumn("Type").setHeaderValue(JasperServerManager.getString("resourceChooser.table.type", "Type"));
        this.jTable1.updateUI();
    }

    public JServer getServer() {
        return this.server;
    }

    public void setServer(JServer server) {
        this.server = server;
    }

    public void updateSelectedDescriptor() {
        this.selectedDescriptor = null;
    }

    public List list(ResourceDescriptor rd) throws Exception {
        List list = new ArrayList();
        if (this.getServer() != null && rd.getWsType().equals("folder") && rd.getChildren() == null) {
            list = this.getServer().getWSClient().list(rd);
            if (this.isFoldersOnly()) {
                for (int i = 0; i < list.size(); ++i) {
                    ResourceDescriptor res = (ResourceDescriptor)list.get(i);
                    if (res.getWsType().equals("folder")) continue;
                    list.remove(i);
                    --i;
                }
            }
        }
        return list;
    }

    public int showDialog(Component parent, String approveButtonText) {
        this.dialogResult = 2;
        if (approveButtonText == null) {
            approveButtonText = JasperServerManager.getString("resourceChooser.buttonOpenResource", "Open resource");
        }
        this.jButtonOpen.setText(approveButtonText);
        Window w = SwingUtilities.getWindowAncestor(parent);
        this.dialog = w instanceof Frame ? new JDialog((Frame)w, true) : (w instanceof Dialog ? new JDialog((Dialog)w, true) : new JDialog((Frame)null, true));
        this.dialog.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.dialog.getContentPane().add((Component)this, gridBagConstraints);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(null);
        this.jComboBoxLookIn.removeAllItems();
        this.setCurrentParent(this.getRoot());
        this.dialog.setVisible(true);
        return this.getDialogResult();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanelTop = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxLookIn = new JComboBox();
        this.jButtonUp = new JButton();
        this.jButtonList = new JToggleButton();
        this.jButtonDetails = new JToggleButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jComboBox2 = new JComboBox();
        this.jButtonOpen = new JButton();
        this.jButtonClose = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanelTop.setLayout(new GridBagLayout());
        this.jPanelTop.setMinimumSize(new Dimension(10, 30));
        this.jPanelTop.setPreferredSize(new Dimension(10, 30));
        this.jLabel1.setText("Look in:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelTop.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBoxLookIn.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBoxLookIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceChooser.this.jComboBoxLookInActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelTop.add((Component)this.jComboBoxLookIn, gridBagConstraints);
        this.jButtonUp.setText("Up");
        this.jButtonUp.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceChooser.this.jButtonUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanelTop.add((Component)this.jButtonUp, gridBagConstraints);
        this.buttonGroup1.add(this.jButtonList);
        this.jButtonList.setSelected(true);
        this.jButtonList.setText("List");
        this.jButtonList.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceChooser.this.jButtonListActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.jPanelTop.add((Component)this.jButtonList, gridBagConstraints);
        this.buttonGroup1.add(this.jButtonDetails);
        this.jButtonDetails.setLabel("Details");
        this.jButtonDetails.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceChooser.this.jButtonDetailsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanelTop.add((Component)this.jButtonDetails, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jPanelTop, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jScrollPane1.setPreferredSize(new Dimension(400, 200));
        this.jList1.setLayoutOrientation(1);
        this.jList1.setVisibleRowCount(-1);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ResourceChooser.this.jList1ValueChanged(evt);
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ResourceChooser.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jScrollPane2.setBackground(new Color(255, 255, 255));
        this.jScrollPane2.setOpaque(false);
        this.jScrollPane2.setPreferredSize(new Dimension(400, 200));
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Label", "Type"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.setIntercellSpacing(new Dimension(0, 0));
        this.jTable1.setRequestFocusEnabled(false);
        this.jTable1.setShowHorizontalLines(false);
        this.jTable1.setShowVerticalLines(false);
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ResourceChooser.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jTable1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jScrollPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setMinimumSize(new Dimension(10, 60));
        this.jPanel2.setPreferredSize(new Dimension(10, 60));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("Resource name:");
        this.jLabel2.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Type:");
        this.jLabel3.setHorizontalTextPosition(4);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jTextField1.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                ResourceChooser.this.jTextField1KeyPressed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.jPanel2.add((Component)this.jTextField1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel2.add((Component)this.jComboBox2, gridBagConstraints);
        this.jButtonOpen.setText("Open resource");
        this.jButtonOpen.setMargin(new Insets(2, 12, 2, 12));
        this.jButtonOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceChooser.this.jButtonOpenActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(0, 16, 0, 4);
        this.jPanel2.add((Component)this.jButtonOpen, gridBagConstraints);
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.setMargin(new Insets(2, 12, 2, 12));
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ResourceChooser.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 16, 0, 4);
        this.jPanel2.add((Component)this.jButtonClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jTextField1KeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.jButtonOpenActionPerformed(null);
        }
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        this.selectedDescriptor = null;
        this.setDialogResult(2);
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    private void jButtonOpenActionPerformed(ActionEvent evt) {
        if (this.jTextField1.getText().trim().length() == 0) {
            return;
        }
        if (this.getSelectedDescriptor() == null) {
            String uri = this.jTextField1.getText().trim();
            while (uri.endsWith("/")) {
                uri = uri.substring(0, uri.length() - 1);
            }
            if (uri.length() == 0) {
                return;
            }
            if (uri.indexOf("/") >= 0) {
                ResourceDescriptor nrd = new ResourceDescriptor();
                nrd.setUriString(uri);
                nrd.setWsType("-");
                try {
                    nrd = this.getServer().getWSClient().get(nrd, null);
                    if (!nrd.getWsType().equals("-")) {
                        if (nrd.getWsType().equals("folder")) {
                            this.openFolder(nrd);
                            return;
                        }
                        this.selectedDescriptor = nrd;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                ResourceDescriptor nrd = new ResourceDescriptor();
                uri = ((ResourceDescriptor)this.jComboBoxLookIn.getSelectedItem()).getUriString() + "/" + uri;
                nrd.setUriString(uri);
                nrd.setWsType("folder");
                try {
                    nrd = this.getServer().getWSClient().get(nrd, null);
                    if (nrd.getWsType() != null) {
                        if (nrd.getWsType().equals("folder")) {
                            this.openFolder(nrd);
                            return;
                        }
                        this.selectedDescriptor = nrd;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (this.getSelectedDescriptor() == null) {
                JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("resourceChooser.message.fileNotFound", "{0}\nResource not found or not valid.\nPlease verify the correct file name was given.", new Object[]{uri}));
                return;
            }
        }
        this.setDialogResult(0);
        this.dialog.setVisible(false);
        this.dialog.dispose();
    }

    public void openFolder(ResourceDescriptor nrd) {
        try {
            nrd.setChildren(null);
            this.jComboBoxLookIn.setSelectedIndex(0);
            String path = nrd.getUriString();
            String complete_path = "";
            while (path.startsWith("/")) {
                path = path.substring(1);
            }
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            while (path.indexOf("/") >= 0) {
                String folderName = path.substring(0, path.indexOf("/"));
                path = path.substring(path.indexOf("/") + 1);
                complete_path = complete_path + "/" + folderName;
                ResourceDescriptor nr = new ResourceDescriptor();
                nr.setUriString(complete_path);
                nr.setName(folderName);
                nr.setWsType("folder");
                nr.setChildren(null);
                this.jComboBoxLookIn.addItem(nr);
            }
            this.jComboBoxLookIn.addItem(nrd);
            this.jComboBoxLookIn.setSelectedItem(nrd);
            this.jTextField1.setText(nrd.getUriString());
            this.jTextField1.setSelectionStart(0);
            this.jTextField1.setSelectionEnd(nrd.getUriString().length());
            this.jTextField1.requestFocusInWindow();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jList1ValueChanged(ListSelectionEvent evt) {
        if (this.jList1.getSelectedIndex() < 0) {
            this.jTable1.getSelectionModel().clearSelection();
        } else {
            this.jTable1.getSelectionModel().setSelectionInterval(this.jList1.getSelectedIndex(), this.jList1.getSelectedIndex());
        }
        this.selectionChanged();
    }

    private void jTable1ValueChanged(ListSelectionEvent evt) {
        if (this.jTable1.getSelectedRowCount() == 0) {
            this.jList1.getSelectionModel().clearSelection();
        } else {
            this.jList1.getSelectionModel().setSelectionInterval(this.jTable1.getSelectedRow(), this.jTable1.getSelectedRow());
        }
        this.selectionChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectionChanged() {
        this.selectedDescriptor = null;
        if (this.jList1.getSelectedIndex() >= 0) {
            Iterator<ResourceSelectedListener> it;
            ResourceDescriptor rd = (ResourceDescriptor)this.jList1.getSelectedValue();
            if (rd.getWsType() != null && !rd.getWsType().equals("folder")) {
                this.selectedDescriptor = rd;
                this.jTextField1.setText(rd.getName());
            }
            Set<ResourceSelectedListener> set = this.listeners;
            synchronized (set) {
                it = new HashSet<ResourceSelectedListener>(this.listeners).iterator();
            }
            while (it.hasNext()) {
                it.next().resourceSelected(rd);
            }
        }
    }

    private void jButtonUpActionPerformed(ActionEvent evt) {
        if (this.jComboBoxLookIn.getSelectedIndex() > 0) {
            this.jComboBoxLookIn.setSelectedIndex(this.jComboBoxLookIn.getSelectedIndex() - 1);
        }
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            ResourceDescriptor rd;
            if (evt.getButton() == 1 && this.jTable1.getSelectedRow() >= 0 && (rd = (ResourceDescriptor)this.jTable1.getValueAt(this.jTable1.getSelectedRow(), 0)).getWsType() != null && rd.getWsType().equals("folder")) {
                this.setCurrentParent(rd);
            }
        }
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            ResourceDescriptor rd;
            if (evt.getButton() == 1 && (rd = (ResourceDescriptor)this.jList1.getSelectedValue()) != null && rd.getWsType() != null && rd.getWsType().equals("folder")) {
                this.setCurrentParent(rd);
            }
        }
    }

    private void jComboBoxLookInActionPerformed(ActionEvent evt) {
        this.setCurrentParent((ResourceDescriptor)this.jComboBoxLookIn.getSelectedItem());
    }

    private void jButtonDetailsActionPerformed(ActionEvent evt) {
        this.adjustListView();
    }

    private void jButtonListActionPerformed(ActionEvent evt) {
        this.adjustListView();
    }

    public void adjustListView() {
        this.jScrollPane1.setVisible(this.jButtonList.isSelected());
        this.jScrollPane2.setVisible(!this.jButtonList.isSelected());
        this.jPanel1.doLayout();
        this.jPanel1.updateUI();
    }

    public ResourceDescriptor getRoot() {
        return this.root;
    }

    public void setRoot(ResourceDescriptor root) {
        this.root = root;
    }

    public ResourceDescriptor getCurrentParent() {
        return this.currentParent;
    }

    public void clearLookInList() {
        this.jComboBoxLookIn.removeAllItems();
    }

    public void setCurrentParent(ResourceDescriptor currentParent) {
        if (this.currentParent == currentParent && currentParent != null && currentParent.getChildren() != null) {
            return;
        }
        this.currentParent = currentParent;
        boolean found = false;
        for (int i = 0; i < this.jComboBoxLookIn.getItemCount(); ++i) {
            ResourceDescriptor tmprd = (ResourceDescriptor)this.jComboBoxLookIn.getItemAt(i);
            if (tmprd != currentParent) continue;
            this.jComboBoxLookIn.setSelectedIndex(i);
            found = true;
            while (this.jComboBoxLookIn.getItemCount() > i + 1) {
                this.jComboBoxLookIn.removeItemAt(i + 1);
            }
            break;
        }
        if (!found && currentParent != null) {
            this.jComboBoxLookIn.addItem(currentParent);
            this.jComboBoxLookIn.setSelectedItem(currentParent);
        }
        this.refreshContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshContent() {
        block13: {
            try {
                int i;
                this.setCursor(Cursor.getPredefinedCursor(3));
                DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
                DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
                dlm.removeAllElements();
                dtm.setRowCount(0);
                if (this.currentParent == null) {
                    return;
                }
                if (this.getServer() == null) {
                    return;
                }
                if (this.currentParent == null) break block13;
                List children = this.currentParent.getChildren();
                if (children == null) {
                    try {
                        children = this.list(this.currentParent);
                        for (i = 0; i < children.size(); ++i) {
                            ((ResourceDescriptor)children.get(i)).setChildren(null);
                        }
                        this.currentParent.setChildren(children);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(this, JasperServerManager.getFormattedString("resourceChooser.message.unableToList", "Unable to list {0}\n{1}", new Object[]{this.currentParent, ex.getMessage()}));
                        ex.printStackTrace();
                    }
                }
                if (children != null) {
                    for (i = 0; i < children.size(); ++i) {
                        ResourceDescriptor rd = (ResourceDescriptor)children.get(i);
                        dlm.addElement(rd);
                        dtm.addRow(new Object[]{rd, rd.getLabel(), rd.getWsType()});
                    }
                }
            }
            finally {
                this.jList1.updateUI();
                this.jTable1.updateUI();
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public ResourceDescriptor getSelectedDescriptor() {
        return this.selectedDescriptor;
    }

    public void hideDialogPanel() {
        this.jPanel2.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addResourceSelectedListener(ResourceSelectedListener l) {
        Set<ResourceSelectedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeResourceSelectedListener(ResourceSelectedListener l) {
        Set<ResourceSelectedListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    public boolean isFoldersOnly() {
        return this.foldersOnly;
    }

    public void setFoldersOnly(boolean foldersOnly) {
        this.foldersOnly = foldersOnly;
    }
}

