/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDownloadSupport {
    private static final FileFilter NBM_FILE_FILTER = new NbmFileFilter();
    private Map<String, File> units2file = new HashMap<String, File>();
    private static String LOCAL_DOWNLOAD_DIRECTORY_KEY = "local-download-directory";
    private static String LOCAL_DOWNLOAD_FILES = "local-download-files";
    private FileList fileList = new FileList();
    private List<UpdateUnit> updateUnits;
    private Logger err = Logger.getLogger(LocalDownloadSupport.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean selectNbmFiles() {
        Window window;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.addChoosableFileFilter(NBM_FILE_FILTER);
        jFileChooser.setFileFilter(NBM_FILE_FILTER);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setFileHidingEnabled(false);
        jFileChooser.setDialogTitle(LocalDownloadSupport.getBundle("CTL_FileChooser_Title", new String[0]));
        File file = LocalDownloadSupport.getDefaultDir();
        if (file != null && file.exists()) {
            jFileChooser.setCurrentDirectory(file);
        }
        if (jFileChooser.showOpenDialog(window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == 0) {
            Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
            synchronized (LocalDownloadSupport.class) {
                this.updateUnits = null;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                LocalDownloadSupport.getPreferences().put(LOCAL_DOWNLOAD_DIRECTORY_KEY, jFileChooser.getCurrentDirectory().getAbsolutePath());
                this.fileList.addFiles(jFileChooser.getSelectedFiles());
                return true;
            }
        }
        return false;
    }

    public Collection<UpdateUnit> getInstalledUpdateUnits() {
        HashSet<UpdateUnit> hashSet = new HashSet<UpdateUnit>();
        for (UpdateUnit updateUnit : this.getUpdateUnits()) {
            if ((updateUnit.getInstalled() == null || !updateUnit.getAvailableUpdates().isEmpty()) && !updateUnit.isPending()) continue;
            hashSet.add(updateUnit);
        }
        return hashSet;
    }

    /*
     * Exception decompiling
     */
    public List<UpdateUnit> getUpdateUnits() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[MONITOR]], but top level block is 11[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean removeAll(Collection<UpdateUnit> collection) {
        if (collection == null) {
            return false;
        }
        boolean bl = false;
        for (UpdateUnit updateUnit : collection) {
            bl |= this.remove(updateUnit);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean remove(UpdateUnit updateUnit) {
        File file = this.units2file.remove(updateUnit.getCodeName());
        if (file != null) {
            this.fileList.removeFile(file);
            Class<LocalDownloadSupport> clazz = LocalDownloadSupport.class;
            // MONITORENTER : org.netbeans.modules.autoupdate.ui.LocalDownloadSupport.class
            this.updateUnits = null;
            // MONITOREXIT : clazz
        }
        if (file == null) return false;
        return true;
    }

    private static File getDefaultDir() {
        File file = new File(LocalDownloadSupport.getPreferences().get(LOCAL_DOWNLOAD_DIRECTORY_KEY, System.getProperty("netbeans.user")));
        return file.exists() ? file : new File(System.getProperty("netbeans.user"));
    }

    public static String getBundle(String string, String ... stringArray) {
        return NbBundle.getMessage(LocalDownloadSupport.class, (String)string, (Object[])stringArray);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(LocalDownloadSupport.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileList {
        private Set<File> selectedFiles = null;

        private FileList() {
        }

        Set<File> getSelectedFiles() {
            if (this.selectedFiles == null) {
                this.selectedFiles = new LinkedHashSet<File>();
                this.addFiles(FileList.loadPresistentState());
            }
            return this.selectedFiles;
        }

        void addFiles(File[] fileArray) {
            this.addFiles(Arrays.asList(fileArray));
        }

        void addFiles(Collection<File> collection) {
            this.getSelectedFiles().addAll(collection);
            this.selectedFiles = FileList.stripNoNBMs(FileList.stripNotExistingFiles(this.getSelectedFiles()));
            FileList.makePersistent(this.selectedFiles);
        }

        void removeFile(File file) {
            this.removeFiles(Collections.singleton(file));
        }

        void removeFiles(Collection<File> collection) {
            this.getSelectedFiles().removeAll(collection);
            this.selectedFiles = FileList.stripNoNBMs(FileList.stripNotExistingFiles(this.getSelectedFiles()));
            FileList.makePersistent(this.selectedFiles);
        }

        private static Set<File> loadPresistentState() {
            HashSet<File> hashSet = new HashSet<File>();
            String string = LocalDownloadSupport.getPreferences().get(LOCAL_DOWNLOAD_FILES, null);
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    hashSet.add(new File(string2));
                }
            }
            return hashSet;
        }

        private static void makePersistent(Set<File> set) {
            StringBuilder stringBuilder = null;
            if (!set.isEmpty()) {
                for (File file : set) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(file.getAbsolutePath());
                        continue;
                    }
                    stringBuilder.append(',').append(file.getAbsolutePath());
                }
            }
            if (stringBuilder == null) {
                LocalDownloadSupport.getPreferences().remove(LOCAL_DOWNLOAD_FILES);
            } else {
                LocalDownloadSupport.getPreferences().put(LOCAL_DOWNLOAD_FILES, stringBuilder.toString());
            }
        }

        private static Set<File> stripNotExistingFiles(Set<File> set) {
            HashSet<File> hashSet = new HashSet<File>();
            for (File file : set) {
                if (!file.exists()) continue;
                hashSet.add(file);
            }
            return hashSet;
        }

        private static Set<File> stripNoNBMs(Set<File> set) {
            HashSet<File> hashSet = new HashSet<File>();
            for (File file : set) {
                if (!NBM_FILE_FILTER.accept(file)) continue;
                hashSet.add(file);
            }
            return hashSet;
        }
    }

    private static class NbmFileFilter
    extends FileFilter {
        private NbmFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().toLowerCase().endsWith(".nbm");
        }

        public String getDescription() {
            return LocalDownloadSupport.getBundle("CTL_FileFilterDescription", new String[0]);
        }
    }
}

