/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.windows;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXTipOfTheDay;
import org.jdesktop.swingx.plaf.basic.BasicTipOfTheDayUI;

public class WindowsTipOfTheDayUI
extends BasicTipOfTheDayUI {
    public static ComponentUI createUI(JComponent c) {
        return new WindowsTipOfTheDayUI((JXTipOfTheDay)c);
    }

    public WindowsTipOfTheDayUI(JXTipOfTheDay tipPane) {
        super(tipPane);
    }

    public JDialog createDialog(Component parentComponent, JXTipOfTheDay.ShowOnStartupChoice choice) {
        return this.createDialog(parentComponent, choice, false);
    }

    protected void installComponents() {
        this.tipPane.setLayout(new BorderLayout());
        JLabel tipIcon = new JLabel();
        tipIcon.setPreferredSize(new Dimension(60, 100));
        tipIcon.setIcon(UIManager.getIcon("TipOfTheDay.icon"));
        tipIcon.setHorizontalAlignment(0);
        tipIcon.setVerticalAlignment(1);
        tipIcon.setBorder(BorderFactory.createEmptyBorder(24, 0, 0, 0));
        this.tipPane.add("West", tipIcon);
        JPanel rightPane = new JPanel(new BorderLayout());
        JLabel didYouKnow = new JLabel(UIManager.getString("TipOfTheDay.didYouKnowText"));
        didYouKnow.setPreferredSize(new Dimension(50, 32));
        didYouKnow.setOpaque(true);
        didYouKnow.setBackground(UIManager.getColor("TextArea.background"));
        didYouKnow.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(0, 0, 2, 0, this.tipPane.getBackground()), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
        didYouKnow.setFont(this.tipPane.getFont().deriveFont(1, 15.0f));
        rightPane.add("North", didYouKnow);
        this.tipArea = new JPanel(new BorderLayout());
        this.tipArea.setOpaque(true);
        this.tipArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.tipArea.setBackground(UIManager.getColor("TextArea.background"));
        rightPane.add("Center", this.tipArea);
        this.tipPane.add("Center", rightPane);
    }

    public static class TipAreaBorder
    implements Border {
        public Insets getBorderInsets(Component c) {
            return new Insets(2, 2, 2, 2);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(UIManager.getColor("TipOfTheDay.background"));
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 1);
            g.setColor(Color.black);
            g.drawLine(x + 1, y + 1, x + width - 3, y + 1);
            g.drawLine(x + 1, y + 1, x + 1, y + height - 3);
            g.setColor(Color.white);
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
        }
    }
}

