/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.widgets;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.borders.ElementSelectedBorder;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class SelectionWidget
extends Widget {
    protected ElementSelectedBorder SELECTED_BORDER = new ElementSelectedBorder();
    private int status = 0;
    protected JRDesignElementWidget realWidget = null;

    public JRDesignElementWidget getRealWidget() {
        return this.realWidget;
    }

    public SelectionWidget(AbstractReportObjectScene scene, JRDesignElementWidget w) {
        super((Scene)scene);
        this.realWidget = w;
        this.setBorder(this.SELECTED_BORDER);
        this.updateBounds();
        this.realWidget.getElement().getEventSupport().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (SelectionWidget.this.isVisible() && (evt.getPropertyName().equals("x") || evt.getPropertyName().equals("y") || evt.getPropertyName().equals("width") || evt.getPropertyName().equals("height"))) {
                    SelectionWidget.this.updateStatus();
                }
            }
        });
    }

    public void updateBounds() {
        Insets insets = this.getBorder().getInsets();
        Rectangle r = this.realWidget.getPreferredBounds();
        r.x -= insets.left;
        r.y -= insets.top;
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        this.setPreferredBounds(r);
        Point p = this.realWidget.getPreferredLocation();
        this.setPreferredLocation(p);
        try {
            this.updateStatus();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void updateStatus() {
        int newStatus = this.findWidgetStatus();
        if (newStatus != this.getStatus()) {
            this.setStatus(newStatus);
        }
    }

    private int findWidgetStatus() {
        AbstractReportObjectScene theScene = (AbstractReportObjectScene)this.getRealWidget().getScene();
        JRDesignElement element = this.getRealWidget().getElement();
        List widgets = theScene.getElementsLayer().getChildren();
        Rectangle r0 = this.getElementWidgetBouns(this.getRealWidget());
        boolean intersect = false;
        for (Widget w2 : widgets) {
            if (w2 == this.getRealWidget() || !(w2 instanceof JRDesignElementWidget)) continue;
            JRDesignElementWidget dew = (JRDesignElementWidget)w2;
            Rectangle r1 = this.getElementWidgetBouns(dew);
            if (r0.contains(r1)) {
                return ElementSelectedBorder.STATUS_TOTAL_OVERLAP;
            }
            if (!r0.intersects(r1)) continue;
            intersect = true;
        }
        if (intersect) {
            return ElementSelectedBorder.STATUS_PARTIAL_OVERLAP;
        }
        List<JRDesignElement> selection = theScene.getSelectionManager().getSelectedElements();
        if (selection == null || selection.isEmpty()) {
            return ElementSelectedBorder.STATUS_NONE;
        }
        if (selection.get(0) == element) {
            return ElementSelectedBorder.STATUS_PRIMARY_SELECTION;
        }
        if (selection.contains(element)) {
            return ElementSelectedBorder.STATUS_SECONDARY_SELECTION;
        }
        return ElementSelectedBorder.STATUS_NONE;
    }

    protected Rectangle getElementWidgetBouns(JRDesignElementWidget w) {
        JRDesignElement element = w.getElement();
        Point p0 = null;
        if (p0 == null) {
            p0 = ModelUtils.getParentLocation(((AbstractReportObjectScene)w.getScene()).getJasperDesign(), element);
            p0.x += element.getX();
            p0.y += element.getY();
        }
        Rectangle r0 = new Rectangle(p0.x, p0.y, element.getWidth(), element.getHeight());
        return r0;
    }

    protected Cursor getCursorAt(Point localLocation) {
        Rectangle bounds = this.getBounds();
        Insets insets = this.getBorder().getInsets();
        if (new Rectangle(bounds.x, bounds.y, insets.left, insets.top).contains(localLocation)) {
            return Cursor.getPredefinedCursor(6);
        }
        if (new Rectangle(bounds.x + bounds.width / 2 - insets.top / 2, bounds.y, insets.top, insets.top).contains(localLocation)) {
            return Cursor.getPredefinedCursor(8);
        }
        if (new Rectangle(bounds.x + bounds.width - insets.right, bounds.y, insets.right, insets.top).contains(localLocation)) {
            return Cursor.getPredefinedCursor(7);
        }
        if (new Rectangle(bounds.x, bounds.y + bounds.height - insets.bottom, insets.left, insets.bottom).contains(localLocation)) {
            return Cursor.getPredefinedCursor(4);
        }
        if (new Rectangle(bounds.x + bounds.width / 2 - insets.bottom / 2, bounds.y + bounds.height - insets.bottom, insets.bottom, insets.bottom).contains(localLocation)) {
            return Cursor.getPredefinedCursor(9);
        }
        if (new Rectangle(bounds.x + bounds.width - insets.right, bounds.y + bounds.height - insets.bottom, insets.left, insets.top).contains(localLocation)) {
            return Cursor.getPredefinedCursor(5);
        }
        if (new Rectangle(bounds.x, bounds.y + bounds.height / 2 - insets.left / 2, insets.left, insets.left).contains(localLocation)) {
            return Cursor.getPredefinedCursor(10);
        }
        if (new Rectangle(bounds.x + bounds.width - insets.right, bounds.y + bounds.height / 2 - insets.right / 2, insets.right, insets.right).contains(localLocation)) {
            return Cursor.getPredefinedCursor(11);
        }
        return super.getCursorAt(localLocation);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
        this.SELECTED_BORDER.setStatus(status);
        this.revalidate(true);
        this.getScene().revalidate();
    }
}

