/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.styles;

import com.jaspersoft.ireport.designer.jrtx.TemplateNode;
import com.jaspersoft.ireport.designer.styles.StylesLibraryChildren;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.xml.JRXmlTemplateLoader;
import net.sf.jasperreports.engine.xml.JRXmlTemplateWriter;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class StylesLibraryTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static StylesLibraryTopComponent instance;
    static final String ICON_PATH = "com/jaspersoft/ireport/designer/resources/jasperreports_jrtx.png";
    static final String LIBRARY_PARENT = "ireport";
    static final String LIBRARY_NAME = "style_library.jrtx";
    static final String LIBRARY_PATH = "ireport/style_library.jrtx";
    private static final String PREFERRED_ID = "StylesLibraryTopComponent";
    private BeanTreeView view;
    private final ExplorerManager manager = new ExplorerManager();
    private AbstractNode noReportNode = null;
    private final InstanceContent ic;
    private final Lookup lookup;
    private JRSimpleTemplate library = null;

    private StylesLibraryTopComponent() {
        this.initComponents();
        Misc.getMainFrame().addWindowListener(new WindowListener(){

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                StylesLibraryTopComponent.this.saveLibrary();
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.setName(NbBundle.getMessage(StylesLibraryTopComponent.class, (String)"CTL_StylesLibraryTopComponent"));
        this.setToolTipText(NbBundle.getMessage(StylesLibraryTopComponent.class, (String)"HINT_StylesLibraryTopComponent"));
        this.setIcon(Utilities.loadImage((String)ICON_PATH, (boolean)true));
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        this.noReportNode = new AbstractNode(Children.LEAF);
        this.noReportNode.setDisplayName("No Chart Theme available");
        ActionMap map = this.getActionMap();
        map.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.manager));
        map.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.manager));
        map.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.manager));
        map.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.manager, (boolean)true));
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{this.lookup, ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map)}));
        this.setLayout(new BorderLayout());
        this.view = new BeanTreeView();
        this.add((Component)this.view, "Center");
        this.getExplorerManager().setRootContext((Node)this.noReportNode);
        this.loadLibrary();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public void loadLibrary() {
        this.library = new JRSimpleTemplate();
        FileObject libraryObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(LIBRARY_PATH);
        if (libraryObject != null) {
            try {
                this.library = (JRSimpleTemplate)JRXmlTemplateLoader.load((InputStream)libraryObject.getInputStream());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.view.setRootVisible(false);
        this.getExplorerManager().setRootContext((Node)new TemplateNode(new StylesLibraryChildren(this.library, this.lookup), this.library, this.lookup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLibrary() {
        FileObject libraryObject = null;
        FileLock lock = null;
        try {
            libraryObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(LIBRARY_PATH);
            if (libraryObject == null) {
                libraryObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(LIBRARY_PARENT).createData(LIBRARY_NAME);
            }
            if (libraryObject != null) {
                lock = libraryObject.lock();
                JRXmlTemplateWriter.writeTemplate((JRTemplate)this.library, (OutputStream)libraryObject.getOutputStream(lock));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (lock != null) {
                lock.releaseLock();
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized StylesLibraryTopComponent getDefault() {
        if (instance == null) {
            instance = new StylesLibraryTopComponent();
        }
        return instance;
    }

    public static synchronized StylesLibraryTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(StylesLibraryTopComponent.class.getName()).warning("Cannot find StylesLibraryTopComponent component. It will not be located properly in the window system.");
            return StylesLibraryTopComponent.getDefault();
        }
        if (win instanceof StylesLibraryTopComponent) {
            return (StylesLibraryTopComponent)win;
        }
        Logger.getLogger(StylesLibraryTopComponent.class.getName()).warning("There seem to be multiple components with the 'StylesLibraryTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return StylesLibraryTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return StylesLibraryTopComponent.getDefault();
        }
    }
}

