/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.actions.AddBandAction;
import com.jaspersoft.ireport.designer.actions.DeleteGroupAction;
import com.jaspersoft.ireport.designer.actions.MoveGroupDownAction;
import com.jaspersoft.ireport.designer.actions.MoveGroupUpAction;
import com.jaspersoft.ireport.designer.outline.nodes.BandNode;
import com.jaspersoft.ireport.designer.outline.nodes.GroupNode;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.outline.nodes.NullBand;
import com.jaspersoft.ireport.locale.I18n;
import java.util.ArrayList;
import javax.swing.Action;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Children;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class NullBandNode
extends IRAbstractNode
implements GroupNode {
    JasperDesign jd = null;
    NullBand band = null;

    public NullBandNode(JasperDesign jd, NullBand band, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, band})}));
        this.jd = jd;
        this.band = band;
        this.setDisplayName(ModelUtils.nameOf(band.getOrigin()));
        if (band.getOrigin().getBandType() == 7) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/groupfooter-16.png");
        } else if (band.getOrigin().getBandType() == 5) {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/groupheader-16.png");
        } else {
            this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/band-16.png");
        }
    }

    public String getHtmlDisplayName() {
        return "<font color=#999999>" + this.getDisplayName();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        JRDesignGroup group = this.getGroup();
        if (group != null) {
            Sheet.Set groupPropertiesSet = Sheet.createPropertiesSet();
            groupPropertiesSet.setName("GROUP_PROPERTIES");
            groupPropertiesSet.setDisplayName(I18n.getString("BandNode.Property.Groupproperties"));
            groupPropertiesSet = BandNode.fillGroupPropertySet(groupPropertiesSet, this.getDataset(), group);
            sheet.put(groupPropertiesSet);
        }
        return sheet;
    }

    public Action[] getActions(boolean popup) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(SystemAction.get(AddBandAction.class));
        JRDesignGroup group = this.getGroup();
        if (group != null) {
            list.add(null);
            list.add(SystemAction.get(MoveGroupUpAction.class));
            list.add(SystemAction.get(MoveGroupDownAction.class));
            list.add((Object)DeleteGroupAction.getInstance());
        }
        return list.toArray(new Action[list.size()]);
    }

    public JRDesignDataset getDataset() {
        return this.jd.getMainDesignDataset();
    }

    public JRDesignGroup getGroup() {
        if (this.band.getOrigin() != null && this.band.getOrigin().getGroupName() != null) {
            return (JRDesignGroup)this.getDataset().getGroupsMap().get(this.band.getOrigin().getGroupName());
        }
        return null;
    }
}

