/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.actions.EditConditionalStyleExpressionBandAction;
import com.jaspersoft.ireport.designer.editor.FullExpressionContext;
import com.jaspersoft.ireport.designer.outline.nodes.AbstractStyleNode;
import com.jaspersoft.ireport.designer.sheet.properties.ExpressionProperty;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ConditionalStyleNode
extends AbstractStyleNode
implements PropertyChangeListener {
    private JRDesignStyle parentStyle;

    public ConditionalStyleNode(JasperDesign jd, JRDesignConditionalStyle style, Lookup doLkp, JRDesignStyle parentStyle) {
        super(jd, style, (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)style), doLkp}));
        this.parentStyle = parentStyle;
        style.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.setName("conditionalStyle");
    }

    public JRDesignConditionalStyle getConditionalStyle() {
        return (JRDesignConditionalStyle)this.getStyle();
    }

    public String getDisplayName() {
        if (this.getConditionalStyle().getConditionExpression() != null) {
            return Misc.getExpressionText(this.getConditionalStyle().getConditionExpression());
        }
        return "<No condition set>";
    }

    protected Sheet createSheet() {
        int i;
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        Node.Property[] props = set.getProperties();
        for (i = 0; i < props.length; ++i) {
            set.remove(props[i].getName());
        }
        set.put((Node.Property)new ConditionExpressionProperty(this.getConditionalStyle(), this.jd));
        for (i = 0; i < props.length; ++i) {
            set.put(props[i]);
        }
        return sheet;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canCut() {
        return true;
    }

    public void destroy() throws IOException {
        int index = this.parentStyle.getConditionalStyleList().indexOf(this.getStyle());
        this.parentStyle.removeConditionalStyle((JRConditionalStyle)this.getConditionalStyle());
        super.destroy();
    }

    public JRDesignStyle getParentStyle() {
        return this.parentStyle;
    }

    public void setParentStyle(JRDesignStyle parentStyle) {
        this.parentStyle = parentStyle;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("conditionExpression")) {
            this.fireDisplayNameChange(null, null);
        }
        super.propertyChange(evt);
    }

    public Action getPreferredAction() {
        return SystemAction.get(EditConditionalStyleExpressionBandAction.class);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(EditConditionalStyleExpressionBandAction.class), null, SystemAction.get(NewAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), SystemAction.get(CutAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public static final class ConditionExpressionProperty
    extends ExpressionProperty {
        private final JRDesignConditionalStyle conditionalStyle;
        private final JasperDesign jd;

        public JRDesignConditionalStyle getConditionalStyle() {
            return this.conditionalStyle;
        }

        public ConditionExpressionProperty(JRDesignConditionalStyle conditionalStyle, JasperDesign jd) {
            super((Object)conditionalStyle, new FullExpressionContext(jd));
            this.setName("conditionExpression");
            this.setDisplayName("Condition Expression");
            this.setShortDescription("The expression used as condition. It should return a boolean object.");
            this.conditionalStyle = conditionalStyle;
            this.jd = jd;
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public String getDefaultExpressionClassName() {
            return "java.lang.Boolean";
        }

        public JRDesignExpression getExpression() {
            return (JRDesignExpression)this.conditionalStyle.getConditionExpression();
        }

        public void setExpression(JRDesignExpression expression) {
            this.conditionalStyle.setConditionExpression((JRExpression)expression);
        }
    }
}

