/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.formatting.actions;

import com.jaspersoft.ireport.designer.formatting.actions.AbstractFormattingToolAction;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Rectangle;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;

public class SameHeightAction
extends AbstractFormattingToolAction {
    public SameHeightAction() {
        this.putValue("Name", this.getName());
    }

    protected String iconResource() {
        return "com/jaspersoft/ireport/designer/resources/formatting/elem_same_vsize.png";
    }

    protected void performAction(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        JasperDesign jd = (JasperDesign)nodes[0].getLookup().lookup(JasperDesign.class);
        if (jd == null) {
            return;
        }
        List<JRDesignElement> elements = this.getSelectedElements(nodes);
        int height = elements.get(0).getHeight();
        boolean aggregate = false;
        for (int i = 1; i < elements.size(); ++i) {
            JRDesignElement element = elements.get(i);
            Rectangle oldBounds = this.getElementBounds(element);
            element.setHeight(height);
            aggregate = this.addTransformationUndo(element, oldBounds, aggregate);
        }
    }

    public String getName() {
        return I18n.getString("formatting.tools.sameHeight");
    }

    public boolean requiresMultipleObjects() {
        return true;
    }
}

