/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.charts;

import com.jaspersoft.ireport.designer.charts.ChartCellRenderer;
import com.jaspersoft.ireport.designer.charts.ChartDescriptor;
import com.jaspersoft.ireport.designer.charts.JListView;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.design.JRDesignChartAxis;
import net.sf.jasperreports.charts.design.JRDesignDataRange;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.design.JRDesignValueDataset;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;

public class ChartSelectionJDialog
extends JDialog {
    private int dialogResult = 2;
    private JListView jListView = null;
    private JList jList1 = null;
    private JasperDesign jasperDesign = null;
    private JRDesignChart chart = null;
    private boolean multiAxisMode = false;
    private JButton jButtonCancel;
    private JButton jButtonOk;
    private JLabel jLabel1;
    private JLabel jLabelChartNameVal;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanelChartType;

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
    }

    public ChartSelectionJDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public ChartSelectionJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void updateCharts() {
        DefaultListModel dlm = (DefaultListModel)this.jList1.getModel();
        dlm.removeAllElements();
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/pie.png", I18n.getString("ChartSelectionJDialog.Chart.Pie"), 9));
        }
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/pie3d.png", I18n.getString("ChartSelectionJDialog.Chart.Pie3D"), 8));
        }
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/bar.png", I18n.getString("ChartSelectionJDialog.Chart.Bar"), 3));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/bar3d.png", I18n.getString("ChartSelectionJDialog.Chart.Bar3D"), 2));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/xybar.png", I18n.getString("ChartSelectionJDialog.Chart.YX_Bar"), 14));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/stackedbar.png", I18n.getString("ChartSelectionJDialog.Chart.Stacked_Bar"), 12));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/stackedbar3d.png", I18n.getString("ChartSelectionJDialog.Chart.Stacked_Bar_3D"), 11));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/line.png", I18n.getString("ChartSelectionJDialog.Chart.Line"), 7));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/xyline.png", I18n.getString("ChartSelectionJDialog.Chart.XY_Line"), 15));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/area.png", I18n.getString("ChartSelectionJDialog.Chart.Area"), 1));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/xyarea.png", I18n.getString("ChartSelectionJDialog.Chart.YX_Area"), 13));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/stackedarea.png", I18n.getString("ChartSelectionJDialog.Chart.Stacked_Area"), 20));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/scatter.png", I18n.getString("ChartSelectionJDialog.Chart.Scatter"), 10));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/bubble.png", I18n.getString("ChartSelectionJDialog.Chart.Bubble"), 4));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/timeseries.png", I18n.getString("ChartSelectionJDialog.Chart.Time_Series"), 16));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/highlow.png", I18n.getString("ChartSelectionJDialog.Chart.High_Low"), 6));
        dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/candlestick.png", I18n.getString("ChartSelectionJDialog.Chart.Candlestick"), 5));
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/gantt.png", I18n.getString("ChartSelectionJDialog.Chart.Gantt"), 21));
        }
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/meter.png", I18n.getString("ChartSelectionJDialog.Chart.Meter"), 17));
        }
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/thermometer.png", I18n.getString("ChartSelectionJDialog.Chart.Thermometer"), 18));
        }
        if (!this.isMultiAxisMode()) {
            dlm.addElement(new ChartDescriptor("/com/jaspersoft/ireport/designer/charts/icons/multiaxis.png", I18n.getString("ChartSelectionJDialog.Chart.Multi_Axis"), 19));
        }
        this.jList1.updateUI();
    }

    public void initAll() {
        this.initComponents();
        this.getContentPane().remove(this.jLabel1);
        this.setDialogResult(2);
        this.jListView = new JListView();
        this.jList1 = this.jListView.getList();
        this.jPanelChartType.add((Component)this.jListView, "Center");
        DefaultListModel dlm = new DefaultListModel();
        this.jList1.setModel(dlm);
        this.jList1.setCellRenderer(new ChartCellRenderer());
        this.updateCharts();
        this.jList1.setLayoutOrientation(2);
        this.setSize(400, 400);
        this.setLocationRelativeTo(null);
        this.jList1.setSelectionMode(0);
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ChartSelectionJDialog.this.selectedChart();
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChartSelectionJDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOk);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanelChartType = new JPanel();
        this.jPanel5 = new JPanel();
        this.jLabelChartNameVal = new JLabel();
        this.jPanel6 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setBackground(new Color(255, 255, 153));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/errorhandler/information.png")));
        this.jLabel1.setText("Please select a chart for the primary axis of the MultiAxis chart");
        this.jLabel1.setMinimumSize(new Dimension(196, 25));
        this.jLabel1.setOpaque(true);
        this.jLabel1.setPreferredSize(new Dimension(196, 25));
        this.getContentPane().add((Component)this.jLabel1, "North");
        this.jPanelChartType.setLayout(new BorderLayout());
        this.jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Chart info"));
        this.jPanel5.setMinimumSize(new Dimension(10, 50));
        this.jPanel5.setPreferredSize(new Dimension(10, 50));
        this.jPanel5.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel5.add((Component)this.jLabelChartNameVal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel5.add((Component)this.jPanel6, gridBagConstraints);
        this.jPanelChartType.add((Component)this.jPanel5, "South");
        this.getContentPane().add((Component)this.jPanelChartType, "Center");
        this.jPanel1.setMinimumSize(new Dimension(10, 30));
        this.jPanel1.setPreferredSize(new Dimension(10, 30));
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonOk.setText("OK");
        this.jButtonOk.setEnabled(false);
        this.jButtonOk.setMaximumSize(new Dimension(200, 25));
        this.jButtonOk.setPreferredSize(new Dimension(100, 25));
        this.jButtonOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChartSelectionJDialog.this.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(4, 2, 4, 4);
        this.jPanel1.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChartSelectionJDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 2, 4, 2);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        block6: {
            this.setDialogResult(0);
            ChartDescriptor cd = (ChartDescriptor)this.jList1.getSelectedValue();
            try {
                this.setChart(new JRDesignChart((JRDefaultStyleProvider)this.getJasperDesign(), cd.getChartType()));
                if (cd.getChartType() == 14) {
                    this.getChart().setDataset((JRChartDataset)new JRDesignXyDataset(this.getChart().getDataset()));
                    break block6;
                }
                if (cd.getChartType() == 18) {
                    JRDesignValueDataset vds = new JRDesignValueDataset(this.getChart().getDataset());
                    JRDesignExpression exp = new JRDesignExpression();
                    exp.setValueClass(Double.class);
                    vds.setValueExpression((JRExpression)exp);
                    this.getChart().setDataset((JRChartDataset)vds);
                    ((JRDesignThermometerPlot)this.getChart().getPlot()).setDataRange((JRDataRange)this.createDataRange());
                    ((JRDesignThermometerPlot)this.getChart().getPlot()).setLowRange((JRDataRange)this.createDataRange());
                    ((JRDesignThermometerPlot)this.getChart().getPlot()).setMediumRange((JRDataRange)this.createDataRange());
                    ((JRDesignThermometerPlot)this.getChart().getPlot()).setHighRange((JRDataRange)this.createDataRange());
                    break block6;
                }
                if (cd.getChartType() == 17) {
                    JRDesignValueDataset vds = new JRDesignValueDataset(this.getChart().getDataset());
                    JRDesignExpression exp = new JRDesignExpression();
                    exp.setValueClass(Double.class);
                    vds.setValueExpression((JRExpression)exp);
                    this.getChart().setDataset((JRChartDataset)vds);
                    ((JRDesignMeterPlot)this.getChart().getPlot()).setDataRange((JRDataRange)this.createDataRange());
                    break block6;
                }
                if (cd.getChartType() != 19) break block6;
                ChartSelectionJDialog dialog = null;
                dialog = new ChartSelectionJDialog((Dialog)this, true);
                dialog.setJasperDesign(this.getJasperDesign());
                dialog.setMultiAxisMode(true);
                dialog.setVisible(true);
                if (dialog.getDialogResult() == 0) {
                    JRDesignChart designChart = dialog.getChart();
                    JRDesignChartAxis axis = new JRDesignChartAxis(this.getChart());
                    axis.setChart(designChart);
                    ((JRDesignMultiAxisPlot)this.getChart().getPlot()).setChart(this.getChart());
                    ((JRDesignMultiAxisPlot)this.getChart().getPlot()).addAxis((JRChartAxis)axis);
                    break block6;
                }
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.setVisible(true);
        this.dispose();
    }

    private JRDesignDataRange createDataRange() {
        JRDesignDataRange dr = new JRDesignDataRange(null);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setValueClass(Double.class);
        dr.setHighExpression((JRExpression)exp);
        dr.setLowExpression((JRExpression)exp.clone());
        return dr;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    void selectedChart() {
        if (this.jList1.getSelectedIndex() >= 0) {
            ChartDescriptor cd = (ChartDescriptor)this.jList1.getSelectedValue();
            this.jLabelChartNameVal.setText(cd.getDisplayName());
            this.jButtonOk.setEnabled(true);
        } else {
            this.jButtonOk.setEnabled(false);
        }
    }

    public JRDesignChart getChart() {
        return this.chart;
    }

    public void setChart(JRDesignChart chart) {
        this.chart = chart;
    }

    public boolean isMultiAxisMode() {
        return this.multiAxisMode;
    }

    public void setMultiAxisMode(boolean multiAxisMode) {
        this.multiAxisMode = multiAxisMode;
        if (multiAxisMode) {
            this.getContentPane().add((Component)this.jLabel1, "North");
        } else {
            this.getContentPane().remove(this.jLabel1);
        }
        this.updateCharts();
    }
}

