/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.structure.api;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.structure.DocumentModelProviderFactory;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.editor.structure.api.DocumentModelListener;
import org.netbeans.modules.editor.structure.api.DocumentModelStateListener;
import org.netbeans.modules.editor.structure.api.DocumentModelUtils;
import org.netbeans.modules.editor.structure.spi.DocumentModelProvider;
import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentModel {
    private static int MODEL_UPDATE_TIMEOUT = 2000;
    private BaseDocument doc;
    private DocumentModelProvider provider;
    private DocumentChangesWatcher changesWatcher;
    private RequestProcessor requestProcessor;
    private RequestProcessor.Task task;
    private ElementsArray elements = new ElementsArray();
    private DocumentElement rootElement;
    private DocumentModelModificationTransaction modelUpdateTransaction = null;
    boolean documentDirty = true;
    private int numReaders = 0;
    private int numWriters = 0;
    private Thread currWriter = null;
    private Thread currReader = null;
    private HashSet<DocumentModelListener> dmListeners = new HashSet();
    private HashSet<DocumentModelStateListener> dmsListeners = new HashSet();
    private static final int ELEMENT_ADDED = 1;
    private static final int ELEMENT_REMOVED = 2;
    private static final int ELEMENT_CHANGED = 3;
    private static final int ELEMENT_ATTRS_CHANGED = 4;
    private static Map<Document, Object> locks = new WeakHashMap<Document, Object>();
    final Map<String, String> elementsNamesCache = new WeakHashMap<String, String>();
    final Map<String, String> elementsTypesCache = new WeakHashMap<String, String>();
    final Map<String, String> elementsAttrNamesCache = new WeakHashMap<String, String>();
    final Map<String, String> elementsAttrValueCache = new WeakHashMap<String, String>();
    private static final Map<String, String> EMPTY_ATTRS_MAP = Collections.emptyMap();
    private static final List<DocumentElement> EMPTY_ELEMENTS_LIST = Collections.emptyList();
    public static final Comparator<DocumentElement> ELEMENTS_COMPARATOR = new Comparator<DocumentElement>(){

        @Override
        public int compare(DocumentElement documentElement, DocumentElement documentElement2) {
            DocumentModel documentModel = documentElement.getDocumentModel();
            if (documentModel.isRootElement(documentElement) && !documentModel.isRootElement(documentElement2)) {
                return -1;
            }
            if (!documentModel.isRootElement(documentElement) && documentModel.isRootElement(documentElement2)) {
                return 1;
            }
            if (documentModel.isRootElement(documentElement2) && documentModel.isRootElement(documentElement)) {
                return 0;
            }
            int n = documentElement.getStartOffset() - documentElement2.getStartOffset();
            if (n != 0) {
                return n;
            }
            int n2 = documentElement2.getEndOffset() - documentElement.getEndOffset();
            if (n2 != 0) {
                return documentElement.isEmpty() || documentElement2.isEmpty() ? -n2 : n2;
            }
            int n3 = documentElement.getType().compareTo(documentElement2.getType());
            if (n3 != 0) {
                return n3;
            }
            int n4 = documentElement.getName().compareTo(documentElement2.getName());
            if (n4 != 0) {
                return n4;
            }
            int n5 = ((DocumentElement.Attributes)documentElement.getAttributes()).compareTo(documentElement2.getAttributes());
            if (n5 != 0) {
                return n5;
            }
            return documentElement.isEmpty() ? documentElement2.hashCode() - documentElement.hashCode() : 0;
        }

        @Override
        public boolean equals(Object object) {
            return object.equals(ELEMENTS_COMPARATOR);
        }
    };
    private long parent = 0L;
    private long parent_count = 0L;
    private DocumentElement last_parent = null;
    private int last_empty_element_start_offset = -1;
    private static final String DOCUMENT_ROOT_ELEMENT_TYPE = "ROOT_ELEMENT";
    private static final boolean debug = Boolean.getBoolean("org.netbeans.editor.model.debug");
    private static final boolean measure = Boolean.getBoolean("org.netbeans.editor.model.measure");
    private static final String GENERATING_MODEL_PROPERTY = "generating_document_model";

    DocumentModel(Document document, DocumentModelProvider documentModelProvider) throws DocumentModelException {
        this.doc = (BaseDocument)document;
        this.provider = documentModelProvider;
        this.requestProcessor = new RequestProcessor(DocumentModel.class.getName());
        this.task = this.requestProcessor.create(new Runnable(){

            public void run() {
                DocumentModel.this.updateModel();
            }
        });
        this.addRootElement();
        this.initDocumentModel();
        this.changesWatcher = new DocumentChangesWatcher();
        this.getDocument().addDocumentListener(WeakListeners.document((DocumentListener)this.changesWatcher, (Object)document));
    }

    public static DocumentModel getDocumentModel(Document document) throws DocumentModelException {
        Object object = DocumentModel.getLock(document);
        synchronized (object) {
            DocumentModel documentModel;
            if (!(document instanceof BaseDocument)) {
                throw new ClassCastException("Currently it is necessary to pass org.netbeans.editor.BaseDocument instance into the DocumentModel.getDocumentProvider(j.s.t.Document) method.");
            }
            WeakReference weakReference = (WeakReference)document.getProperty(DocumentModel.class);
            DocumentModel documentModel2 = documentModel = weakReference == null ? null : (DocumentModel)weakReference.get();
            if (documentModel != null) {
                return documentModel;
            }
            Class clazz = ((BaseDocument)document).getKitClass();
            BaseKit baseKit = BaseKit.getKit((Class)clazz);
            if (baseKit != null) {
                String string = baseKit.getContentType();
                DocumentModelProvider documentModelProvider = DocumentModelProviderFactory.getDefault().getDocumentModelProvider(string);
                if (documentModelProvider != null) {
                    DocumentModel documentModel3 = new DocumentModel(document, documentModelProvider);
                    document.putProperty(DocumentModel.class, new WeakReference<DocumentModel>(documentModel3));
                    return documentModel3;
                }
                return null;
            }
            throw new IllegalStateException("No editor kit for document " + document + "!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getLock(Document document) {
        Map<Document, Object> map = locks;
        synchronized (map) {
            Object object = locks.get(document);
            if (object == null) {
                object = new Object();
                locks.put(document, object);
            }
            return object;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public DocumentElement getRootElement() {
        return this.rootElement;
    }

    public void addDocumentModelListener(DocumentModelListener documentModelListener) {
        this.dmListeners.add(documentModelListener);
    }

    public void removeDocumentModelListener(DocumentModelListener documentModelListener) {
        this.dmListeners.remove(documentModelListener);
    }

    public void addDocumentModelStateListener(DocumentModelStateListener documentModelStateListener) {
        this.dmsListeners.add(documentModelStateListener);
    }

    public void removeDocumentModelStateListener(DocumentModelStateListener documentModelStateListener) {
        this.dmsListeners.remove(documentModelStateListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDescendantOf(DocumentElement documentElement, DocumentElement documentElement2) {
        this.readLock();
        try {
            if (documentElement == documentElement2) {
                if (debug) {
                    System.out.println("ERROR in " + documentElement);
                }
                this.debugElements();
                throw new IllegalArgumentException("ancestor == descendant!!!");
            }
            if (this.isRootElement(documentElement)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = DocumentModel.isDescendantOf(documentElement.getStartOffset(), documentElement.getEndOffset(), documentElement2.getStartOffset(), documentElement2.getEndOffset());
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    private static boolean isDescendantOf(int n, int n2, int n3, int n4) {
        if (n4 != n3 && (n == n3 && n2 > n4 || n2 == n4 && n < n3)) {
            return true;
        }
        return n < n3 && n2 > n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentElement getLeafElementForOffset(int n) {
        this.readLock();
        this.checkDocumentDirty();
        try {
            DocumentElement documentElement;
            if (this.getDocument().getLength() == 0) {
                DocumentElement documentElement2 = this.getRootElement();
                return documentElement2;
            }
            DocumentElement documentElement3 = null;
            for (int i = 0; i < this.elements.size() && (documentElement = this.elements.get(i)).getStartOffset() <= n; ++i) {
                if (documentElement.getEndOffset() < n) continue;
                if (documentElement.getStartOffset() == documentElement.getEndOffset() && documentElement.getStartOffset() == n) break;
                documentElement3 = documentElement;
            }
            if (documentElement3 == null) {
                documentElement3 = this.getRootElement();
            }
            DocumentElement documentElement4 = documentElement3;
            return documentElement4;
        }
        finally {
            this.readUnlock();
        }
    }

    public void forceUpdate() {
        this.requestModelUpdate(true);
    }

    static void setModelUpdateTimout(int n) {
        MODEL_UPDATE_TIMEOUT = n;
    }

    private boolean isRootElement(DocumentElement documentElement) {
        return documentElement == this.getRootElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentElement getDocumentElement(int n, int n2) throws BadLocationException {
        this.readLock();
        this.checkDocumentDirty();
        try {
            for (int i = 0; i < this.elements.size(); ++i) {
                DocumentElement documentElement = this.elements.get(i);
                if (documentElement.getStartOffset() == n && documentElement.getEndOffset() == n2) {
                    DocumentElement documentElement2 = documentElement;
                    return documentElement2;
                }
                if (documentElement.getStartOffset() > n) break;
            }
            DocumentElement documentElement = null;
            return documentElement;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DocumentElement> getDocumentElements(int n) throws BadLocationException {
        this.readLock();
        this.checkDocumentDirty();
        try {
            Object object;
            int n2 = this.elements.binarySearchForOffset(n);
            if (n2 < 0) {
                List<DocumentElement> list = Collections.emptyList();
                return list;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(this.elements.get(n2));
            int n3 = n2;
            while (--n3 >= 0 && ((DocumentElement)(object = this.elements.get(n3))).getStartOffset() == n) {
                arrayList.add(0, object);
            }
            while (++n2 < this.elements.size() && ((DocumentElement)(object = this.elements.get(n2))).getStartOffset() == n) {
                arrayList.add(object);
            }
            object = arrayList;
            return object;
        }
        finally {
            this.readUnlock();
        }
    }

    private DocumentModelModificationTransaction createTransaction(boolean bl) {
        return new DocumentModelModificationTransaction(bl);
    }

    private void initDocumentModel() throws DocumentModelException {
        block2: {
            try {
                DocumentModelModificationTransaction documentModelModificationTransaction = this.createTransaction(true);
                this.provider.updateModel(documentModelModificationTransaction, this, new DocumentChange[]{new DocumentChange(this.getDocument().getStartPosition(), this.getDocument().getLength(), 0)});
                documentModelModificationTransaction.commit();
            }
            catch (DocumentModelTransactionCancelledException documentModelTransactionCancelledException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError((Object)"We should never get here");
            }
        }
    }

    private void requestModelUpdate(boolean bl) {
        if (this.modelUpdateTransaction != null) {
            this.modelUpdateTransaction.setTransactionCancelled();
        }
        this.task.schedule(bl ? 0 : MODEL_UPDATE_TIMEOUT);
    }

    private void updateModel() {
        block8: {
            this.fireScanningStarted();
            try {
                this.modelUpdateTransaction = this.createTransaction(false);
                DocumentChange[] documentChangeArray = this.changesWatcher.getDocumentChanges();
                if (debug) {
                    this.debugElements();
                }
                this.provider.updateModel(this.modelUpdateTransaction, this, documentChangeArray);
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                DocumentModel.this.writeLock();
                                DocumentModel.this.fireUpdateStarted();
                                DocumentModel.this.modelUpdateTransaction.commit();
                                DocumentModel.this.changesWatcher.clearChanges();
                                DocumentModel.this.modelUpdateTransaction = null;
                            }
                            catch (DocumentModelTransactionCancelledException documentModelTransactionCancelledException) {
                            }
                            catch (Exception exception) {
                                ErrorManager.getDefault().notify(4096, (Throwable)exception);
                            }
                            finally {
                                DocumentModel.this.writeUnlock();
                                DocumentModel.this.fireUpdateFinished();
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (DocumentModelException documentModelException) {
                if (debug) {
                    System.err.println("[DocumentModelUpdate] " + documentModelException.getMessage());
                }
            }
            catch (DocumentModelTransactionCancelledException documentModelTransactionCancelledException) {
                if (!debug) break block8;
                System.out.println("[document model] update transaction cancelled.");
            }
        }
        if (debug) {
            DocumentModelUtils.dumpElementStructure(this.getRootElement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDocumentDirty() {
        if (this.documentDirty) {
            this.writeLock();
            try {
                this.doc.readLock();
                try {
                    this.elements.resort();
                }
                finally {
                    this.doc.readUnlock();
                }
            }
            finally {
                this.writeUnlock();
            }
            this.documentDirty = false;
        }
    }

    private void addRootElement() {
        block3: {
            try {
                DocumentModelModificationTransaction documentModelModificationTransaction = this.createTransaction(false);
                this.rootElement = documentModelModificationTransaction.addDocumentElement("root", DOCUMENT_ROOT_ELEMENT_TYPE, EMPTY_ATTRS_MAP, 0, this.getDocument().getLength());
                documentModelModificationTransaction.commit();
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalStateException("Adding of root document element failed - strange!");
            }
            catch (DocumentModelTransactionCancelledException documentModelTransactionCancelledException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)"We should never get here");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<DocumentElement> getChildren(DocumentElement documentElement) {
        this.readLock();
        this.checkDocumentDirty();
        try {
            Object object;
            int n = this.elements.indexof(documentElement);
            if (n < 0) {
                if (debug) {
                    System.out.println("Warning: DocumentModel.getChildren(...) called for " + documentElement + " which has already been removed!");
                }
                List<DocumentElement> list = Collections.emptyList();
                return list;
            }
            if (documentElement.isEmpty()) {
                if (this.isRootElement(documentElement)) {
                    if (this.elements.size() > 1) {
                        List<DocumentElement> list = Arrays.asList(this.elements.subarray(1, this.elements.size()));
                        return list;
                    }
                    List<DocumentElement> list = Collections.emptyList();
                    return list;
                }
                List<DocumentElement> list = Collections.emptyList();
                return list;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (++n < this.elements.size()) {
                DocumentElement documentElement2;
                int n2;
                object = this.elements.get(n);
                arrayList.add(object);
                if (!this.isDescendantOf(documentElement, (DocumentElement)object)) {
                    List<DocumentElement> list = Collections.emptyList();
                    return list;
                }
                Object object2 = object;
                for (int i = n + 1; i < this.elements.size() && (n2 = (documentElement2 = this.elements.get(i)).getStartOffset()) <= documentElement.getEndOffset(); ++i) {
                    if (n2 < ((DocumentElement)object2).getEndOffset()) continue;
                    arrayList.add(documentElement2);
                    object2 = documentElement2;
                }
            }
            object = arrayList;
            return object;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentElement getParent(DocumentElement documentElement) {
        this.readLock();
        this.checkDocumentDirty();
        try {
            int n = this.elements.indexof(documentElement);
            if (n < 0) {
                throw new IllegalArgumentException("getParent() called for " + documentElement + " which is not in the elements list!");
            }
            if (n == 0) {
                DocumentElement documentElement2 = null;
                return documentElement2;
            }
            int n2 = documentElement.getStartOffset();
            int n3 = documentElement.getEndOffset();
            for (int i = n - 1; i >= 0; --i) {
                DocumentElement documentElement3 = this.elements.get(i);
                int n4 = documentElement3.getStartOffset();
                int n5 = documentElement3.getEndOffset();
                if (n4 >= n2 || n4 == n5 || !DocumentModel.isDescendantOf(n4, n5, n2, n3)) continue;
                DocumentElement documentElement4 = documentElement3;
                return documentElement4;
            }
            DocumentElement documentElement5 = this.getRootElement();
            return documentElement5;
        }
        finally {
            this.readUnlock();
        }
    }

    private DocumentElement createDocumentElement(String string, String string2, Map<String, String> map, int n, int n2) throws BadLocationException {
        return new DocumentElement(string, string2, map, n, n2, this);
    }

    private void fireDocumentModelEvent(DocumentElement documentElement, int n) {
        for (DocumentModelListener documentModelListener : this.dmListeners) {
            switch (n) {
                case 1: {
                    documentModelListener.documentElementAdded(documentElement);
                    break;
                }
                case 2: {
                    documentModelListener.documentElementRemoved(documentElement);
                    break;
                }
                case 3: {
                    documentModelListener.documentElementChanged(documentElement);
                    break;
                }
                case 4: {
                    documentModelListener.documentElementAttributesChanged(documentElement);
                }
            }
        }
    }

    private void fireSourceChanged() {
        for (DocumentModelStateListener documentModelStateListener : this.dmsListeners) {
            documentModelStateListener.sourceChanged();
        }
    }

    private void fireScanningStarted() {
        for (DocumentModelStateListener documentModelStateListener : this.dmsListeners) {
            documentModelStateListener.scanningStarted();
        }
    }

    private void fireUpdateStarted() {
        for (DocumentModelStateListener documentModelStateListener : this.dmsListeners) {
            documentModelStateListener.updateStarted();
        }
    }

    private void fireUpdateFinished() {
        for (DocumentModelStateListener documentModelStateListener : this.dmsListeners) {
            documentModelStateListener.updateFinished();
        }
    }

    public final synchronized void readLock() {
        try {
            while (this.currWriter != null) {
                if (this.currWriter == Thread.currentThread()) {
                    return;
                }
                this.wait();
            }
            this.currReader = Thread.currentThread();
            ++this.numReaders;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interrupted attempt to aquire read lock");
        }
    }

    public final synchronized void readUnlock() {
        if (this.currWriter == Thread.currentThread()) {
            return;
        }
        assert (this.numReaders > 0) : "Bad read lock state!";
        --this.numReaders;
        if (this.numReaders == 0) {
            this.currReader = null;
        }
        this.notify();
    }

    private final synchronized void writeLock() {
        try {
            while (this.numReaders > 0 || this.currWriter != null) {
                if (Thread.currentThread() == this.currWriter) {
                    ++this.numWriters;
                    return;
                }
                if (Thread.currentThread() == this.currReader) {
                    return;
                }
                this.wait();
            }
            this.currWriter = Thread.currentThread();
            this.numWriters = 1;
        }
        catch (InterruptedException interruptedException) {
            throw new Error("Interrupted attempt to aquire write lock");
        }
    }

    private final synchronized void writeUnlock() {
        if (--this.numWriters <= 0) {
            this.numWriters = 0;
            this.currWriter = null;
            this.notifyAll();
        }
    }

    void debugElements() {
        System.out.println("DEBUG ELEMENTS:");
        for (int i = 0; i < this.elements.size(); ++i) {
            System.out.println(this.elements.get(i));
        }
        System.out.println("*****\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DocumentElement[] elements() {
        this.readLock();
        try {
            DocumentElement[] documentElementArray = new DocumentElement[this.elements.size()];
            System.arraycopy(this.elements.elements, 0, documentElementArray, 0, documentElementArray.length);
            DocumentElement[] documentElementArray2 = documentElementArray;
            return documentElementArray2;
        }
        finally {
            this.readUnlock();
        }
    }

    private static class ElementsArray {
        private DocumentElement[] elements = new DocumentElement[1000];
        private int size = 0;
        private int increase_capacity_delta = 100;
        private boolean needs_resort = false;

        ElementsArray() {
        }

        public void fastAdd(DocumentElement documentElement) {
            this.checkCapacity();
            this.elements[this.size++] = documentElement;
            this.needs_resort = true;
        }

        public void add(DocumentElement documentElement) {
            this.checkIntegrity();
            int n = this.indexof(documentElement);
            if (n >= 0) {
                return;
            }
            this.checkCapacity();
            n = -n - 1;
            this.checkIndex(n);
            int n2 = this.size - n - 1;
            if (n2 > 0) {
                System.arraycopy(this.elements, n, this.elements, n + 1, n2);
            }
            this.elements[n] = documentElement;
            ++this.size;
        }

        public void remove(int n) {
            this.checkIntegrity();
            if (n < 0) {
                return;
            }
            this.checkIndex(n);
            int n2 = this.size - n - 1;
            if (n2 > 0) {
                System.arraycopy(this.elements, n + 1, this.elements, n, n2);
            }
            this.elements[--this.size] = null;
        }

        public void remove(DocumentElement documentElement) {
            this.checkIntegrity();
            this.remove(this.indexof(documentElement));
        }

        public int indexof(DocumentElement documentElement) {
            this.checkIntegrity();
            return this.binarySearch(documentElement);
        }

        public DocumentElement get(int n) {
            this.checkIntegrity();
            this.checkIndex(n);
            return this.elements[n];
        }

        public boolean contains(DocumentElement documentElement) {
            return this.indexof(documentElement) >= 0;
        }

        public int size() {
            this.checkIntegrity();
            return this.size;
        }

        public void resort() {
            Arrays.sort(this.elements, 0, this.size, ELEMENTS_COMPARATOR);
            this.needs_resort = false;
        }

        public DocumentElement[] subarray(int n, int n2) {
            this.checkIntegrity();
            this.checkIndex(n);
            if (n2 < 0 || n2 > this.size) {
                throw new IllegalArgumentException("Index out of range: " + n2 + " (size = " + this.size + ")");
            }
            int n3 = n2 - n;
            if (n3 < 0) {
                throw new IllegalArgumentException("from > to: " + n + " > " + n2);
            }
            DocumentElement[] documentElementArray = new DocumentElement[n3];
            System.arraycopy(this.elements, n, documentElementArray, 0, n3);
            return documentElementArray;
        }

        private void checkIntegrity() {
            if (this.needs_resort) {
                throw new IllegalStateException("Elements are inconsistent - fastAdd() called without subsequent resort() call!");
            }
        }

        private void checkIndex(int n) {
            if (n < 0 || n >= this.size) {
                throw new IllegalArgumentException("Index out of range: " + n + " (size = " + this.size + ")");
            }
        }

        private void checkCapacity() {
            int n = this.elements.length - this.size;
            assert (n >= 0);
            if (n == 0) {
                this.increase_capacity_delta *= 5;
                DocumentElement[] documentElementArray = this.elements;
                this.elements = new DocumentElement[this.size + this.increase_capacity_delta];
                System.arraycopy(documentElementArray, 0, this.elements, 0, documentElementArray.length);
            }
        }

        private int binarySearch(DocumentElement documentElement) {
            int n = 0;
            int n2 = this.size() - 1;
            while (n <= n2) {
                int n3 = n + n2 >> 1;
                DocumentElement documentElement2 = this.elements[n3];
                int n4 = ELEMENTS_COMPARATOR.compare(documentElement2, documentElement);
                if (n4 < 0) {
                    n = n3 + 1;
                    continue;
                }
                if (n4 > 0) {
                    n2 = n3 - 1;
                    continue;
                }
                return n3;
            }
            return -(n + 1);
        }

        public int binarySearchForOffset(int n) {
            this.checkIntegrity();
            int n2 = 0;
            int n3 = this.size() - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >> 1;
                DocumentElement documentElement = this.elements[n4];
                int n5 = documentElement.getStartOffset();
                int n6 = n5 - n;
                if (n6 < 0) {
                    n2 = n4 + 1;
                    continue;
                }
                if (n6 > 0) {
                    n3 = n4 - 1;
                    continue;
                }
                return n4;
            }
            return -(n2 + 1);
        }
    }

    public class DocumentChange {
        public static final int INSERT = 0;
        public static final int REMOVE = 1;
        private Position changeStart;
        private int changeLength;
        private int type;

        DocumentChange(Position position, int n, int n2) {
            this.changeStart = position;
            this.changeLength = n;
            this.type = n2;
        }

        public Position getChangeStart() {
            return this.changeStart;
        }

        public int getChangeLength() {
            return this.changeLength;
        }

        public int getChangeType() {
            return this.type;
        }

        public String toString() {
            return "Change[" + this.getChangeStart().getOffset() + "-" + (this.getChangeStart().getOffset() + this.getChangeLength()) + "-" + (this.type == 0 ? "INSERT" : "REMOVE") + "] text: " + this.getChangeText();
        }

        private String getChangeText() {
            try {
                String string = DocumentModel.this.getDocument().getText(this.getChangeStart().getOffset(), this.getChangeLength());
                if (this.type == 0) {
                    return string;
                }
                if (this.type == 1) {
                    return "[cannot provide removed text]; the text on remove offset: " + string;
                }
                assert (false) : "Wrong document change type!";
            }
            catch (BadLocationException badLocationException) {
                return "BadLocationException thrown: " + badLocationException.getMessage();
            }
            return null;
        }
    }

    private final class DocumentChangesWatcher
    implements DocumentListener {
        private ArrayList<DocumentChange> documentChanges = new ArrayList();

        private DocumentChangesWatcher() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.documentChanged(documentEvent);
        }

        private void documentChanged(DocumentEvent documentEvent) {
            if (!DocumentModel.this.documentDirty) {
                DocumentModel.this.fireSourceChanged();
            }
            DocumentModel.this.documentDirty = true;
            try {
                if (DocumentModel.this.getRootElement().getStartOffset() > 0 || DocumentModel.this.getRootElement().getEndOffset() < DocumentModel.this.getDocument().getLength()) {
                    DocumentModel.this.getRootElement().setStartPosition(0);
                    DocumentModel.this.getRootElement().setEndPosition(DocumentModel.this.getDocument().getLength());
                }
                int n = documentEvent.getOffset();
                int n2 = documentEvent.getLength();
                int n3 = documentEvent.getType().equals(DocumentEvent.EventType.REMOVE) ? 1 : 0;
                DocumentChange documentChange = new DocumentChange(DocumentModel.this.getDocument().createPosition(n), n2, n3);
                this.documentChanges.add(documentChange);
                if (debug) {
                    System.out.println(documentChange);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
            DocumentModel.this.requestModelUpdate(false);
        }

        public DocumentChange[] getDocumentChanges() {
            List list = (List)this.documentChanges.clone();
            return list.toArray(new DocumentChange[0]);
        }

        public void clearChanges() {
            this.documentChanges.clear();
        }
    }

    public final class DocumentModelTransactionCancelledException
    extends Exception {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DocumentModelModificationTransaction {
        private ArrayList<DocumentModelModification> modifications = new ArrayList();
        private boolean transactionCancelled = false;
        private boolean init;

        DocumentModelModificationTransaction(boolean bl) {
            this.init = bl;
        }

        public DocumentElement addDocumentElement(String string, String string2, Map<String, String> map, int n, int n2) throws BadLocationException, DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentElement documentElement = DocumentModel.this.createDocumentElement(string, string2, map, n, n2);
            if (!DocumentModel.this.elements.contains(documentElement)) {
                if (debug) {
                    System.out.println("# ADD " + documentElement + " adding into transaction");
                }
                DocumentModelModification documentModelModification = new DocumentModelModification(documentElement, 1);
                this.modifications.add(documentModelModification);
            }
            return documentElement;
        }

        public void removeDocumentElement(DocumentElement documentElement, boolean bl) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            if (DocumentModel.this.isRootElement(documentElement)) {
                if (debug) {
                    System.out.println("WARNING: root element cannot be removed!");
                }
                return;
            }
            if (debug) {
                System.out.println("# REMOVE " + documentElement + " adding into transaction ");
            }
            if (bl) {
                for (DocumentElement documentElement2 : DocumentModel.this.getChildren(documentElement)) {
                    this.removeDocumentElement(documentElement2, true);
                }
            }
            DocumentModelModification documentModelModification = new DocumentModelModification(documentElement, 2);
            this.modifications.add(documentModelModification);
        }

        public void updateDocumentElementText(DocumentElement documentElement) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentModelModification documentModelModification = new DocumentModelModification(documentElement, 3);
            if (!this.modifications.contains(documentModelModification)) {
                this.modifications.add(documentModelModification);
            }
        }

        public void updateDocumentElementAttribs(DocumentElement documentElement, Map<String, String> map) throws DocumentModelTransactionCancelledException {
            if (this.transactionCancelled) {
                throw new DocumentModelTransactionCancelledException();
            }
            DocumentModelModification documentModelModification = new DocumentModelModification(documentElement, 4, map);
            if (!this.modifications.contains(documentModelModification)) {
                this.modifications.add(documentModelModification);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit() throws DocumentModelTransactionCancelledException {
            long l = System.currentTimeMillis();
            DocumentModel.this.writeLock();
            try {
                if (this.transactionCancelled) {
                    throw new DocumentModelTransactionCancelledException();
                }
                long l2 = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting REMOVEs");
                }
                Iterator<DocumentModelModification> iterator = this.modifications.iterator();
                int n = 0;
                DocumentModel.this.last_empty_element_start_offset = -1;
                DocumentModel.this.last_parent = null;
                while (iterator.hasNext()) {
                    DocumentModelModification documentModelModification = iterator.next();
                    if (documentModelModification.type != 2) continue;
                    if (this.removeDE(documentModelModification.de)) {
                        ++n;
                        continue;
                    }
                    System.out.println("[DMT] cannot remove element " + documentModelModification.de);
                }
                if (measure) {
                    System.out.println("[xmlmodel] " + n + " removes commited in " + (System.currentTimeMillis() - l2));
                }
                long l3 = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting ADDs");
                }
                iterator = this.modifications.iterator();
                ArrayList<DocumentElement> arrayList = new ArrayList<DocumentElement>();
                while (iterator.hasNext()) {
                    DocumentModelModification documentModelModification = iterator.next();
                    if (documentModelModification.type != 1) continue;
                    arrayList.add(documentModelModification.de);
                    DocumentModel.this.elements.fastAdd(documentModelModification.de);
                }
                DocumentModel.this.elements.resort();
                if (!this.init) {
                    for (DocumentElement documentElement : arrayList) {
                        this.fireElementAddedEvent(documentElement);
                    }
                }
                if (measure) {
                    System.out.println("[xmlmodel] " + arrayList.size() + " adds commited in " + (System.currentTimeMillis() - l3));
                }
                long l4 = System.currentTimeMillis();
                if (debug) {
                    System.out.println("\n# commiting text UPDATESs");
                }
                for (DocumentModelModification documentModelModification : this.modifications) {
                    if (documentModelModification.type != 3) continue;
                    this.updateDEText(documentModelModification.de);
                }
                if (debug) {
                    System.out.println("\n# commiting attribs UPDATESs");
                }
                for (DocumentModelModification documentModelModification : this.modifications) {
                    if (documentModelModification.type != 4) continue;
                    this.updateDEAttrs(documentModelModification.de, documentModelModification.attrs);
                }
                if (measure) {
                    System.out.println("[xmlmodel] updates commit done in " + (System.currentTimeMillis() - l4));
                }
            }
            finally {
                DocumentModel.this.writeUnlock();
            }
            if (debug) {
                System.out.println("# commit finished\n");
            }
            if (measure) {
                System.out.println("[xmlmodel] commit done in " + (System.currentTimeMillis() - l));
            }
        }

        private void updateDEText(DocumentElement documentElement) {
            DocumentModel.this.fireDocumentModelEvent(documentElement, 3);
            documentElement.contentChanged();
        }

        private void updateDEAttrs(DocumentElement documentElement, Map<String, String> map) {
            documentElement.setAttributes(map);
            DocumentModel.this.fireDocumentModelEvent(documentElement, 4);
            documentElement.attributesChanged();
        }

        private void fireElementAddedEvent(DocumentElement documentElement) {
            DocumentElement documentElement2 = documentElement.getParentElement();
            if (documentElement2 != null) {
                List<DocumentElement> list = documentElement.getChildren();
                documentElement2.childAdded(documentElement);
                for (DocumentElement documentElement3 : list) {
                    documentElement2.childRemoved(documentElement3);
                    documentElement.childAdded(documentElement3);
                }
            }
            DocumentModel.this.fireDocumentModelEvent(documentElement, 1);
        }

        private boolean removeDE(DocumentElement documentElement) {
            int n;
            boolean bl;
            if (debug) {
                System.out.println("[DTM] removing " + documentElement);
            }
            DocumentElement documentElement2 = null;
            int n2 = documentElement.getStartOffset();
            int n3 = documentElement.getEndOffset();
            boolean bl2 = bl = n3 - n2 == 0;
            if (bl && DocumentModel.this.last_empty_element_start_offset == n2) {
                documentElement2 = DocumentModel.this.last_parent;
            }
            if (documentElement2 == null) {
                documentElement2 = DocumentModel.this.getParent(documentElement);
                if (bl) {
                    DocumentModel.this.last_empty_element_start_offset = n2;
                    DocumentModel.this.last_parent = documentElement2;
                }
            }
            if ((n = DocumentModel.this.elements.indexof(documentElement)) <= 0) {
                return false;
            }
            List<DocumentElement> list = bl ? null : documentElement.getChildren();
            DocumentModel.this.elements.remove(n);
            if (!bl) {
                for (DocumentElement documentElement3 : list) {
                    if (debug) {
                        System.out.println("switching child " + documentElement3 + "from removed " + documentElement + "to parent " + documentElement2);
                    }
                    documentElement.childRemoved(documentElement3);
                    documentElement2.childAdded(documentElement3);
                }
            }
            if (documentElement2 != null) {
                documentElement2.childRemoved(documentElement);
            }
            DocumentModel.this.fireDocumentModelEvent(documentElement, 2);
            if (debug) {
                System.out.println("[DMT] removed element " + documentElement + " ;parent = " + documentElement2);
            }
            return true;
        }

        private void setTransactionCancelled() {
            this.transactionCancelled = true;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private final class DocumentModelModification {
            public static final int ELEMENT_ADD = 1;
            public static final int ELEMENT_REMOVED = 2;
            public static final int ELEMENT_CHANGED = 3;
            public static final int ELEMENT_ATTRS_CHANGED = 4;
            public int type;
            public DocumentElement de;
            public Map<String, String> attrs = null;

            public DocumentModelModification(DocumentElement documentElement, int n) {
                this.de = documentElement;
                this.type = n;
            }

            public DocumentModelModification(DocumentElement documentElement, int n, Map<String, String> map) {
                this(documentElement, n);
                this.attrs = map;
            }

            public boolean equals(Object object) {
                if (!(object instanceof DocumentModelModification)) {
                    return false;
                }
                DocumentModelModification documentModelModification = (DocumentModelModification)object;
                return documentModelModification.type == this.type && documentModelModification.de.equals(this.de);
            }
        }
    }
}

