/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import mondrian.gui.MondrianGuiDef;

public class SchemaTreeCellEditor
extends DefaultTreeCellEditor {
    private final ClassLoader myClassLoader;
    JComboBox listEditor;
    ArrayList listeners = new ArrayList();
    private final ResourceBundle resources;

    public SchemaTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
        super(tree, renderer, editor);
        this.myClassLoader = this.getClass().getClassLoader();
        this.resources = ResourceBundle.getBundle("mondrian.gui.resources.gui");
        renderer.setLeafIcon(new ImageIcon(this.myClassLoader.getResource(this.resources.getString("table"))));
        renderer.setOpenIcon(new ImageIcon(this.myClassLoader.getResource(this.resources.getString("join"))));
        renderer.setClosedIcon(new ImageIcon(this.myClassLoader.getResource(this.resources.getString("join"))));
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        Component retValue = null;
        if (value instanceof MondrianGuiDef.Relation) {
            String valueClass = value.getClass().getName();
            String[] simpleName = valueClass.split("[$.]", 0);
            retValue = super.getTreeCellEditorComponent(tree, simpleName[simpleName.length - 1], isSelected, expanded, leaf, row);
        }
        return retValue;
    }

    public boolean isCellEditable(EventObject event) {
        if (event != null && event.getSource() instanceof JTree && event instanceof MouseEvent) {
            boolean editable;
            TreePath path = this.tree.getPathForLocation(((MouseEvent)event).getX(), ((MouseEvent)event).getY());
            boolean bl = editable = this.lastPath != null && path != null && this.lastPath.equals(path);
            if (path != null) {
                Object parent;
                Object value = path.getLastPathComponent();
                TreePath parentPath = path.getParentPath();
                Object object = parent = parentPath == null ? null : parentPath.getLastPathComponent();
                if (value instanceof MondrianGuiDef.Relation && (parent instanceof MondrianGuiDef.Hierarchy || parent instanceof MondrianGuiDef.Relation)) {
                    return ((MouseEvent)event).getClickCount() == 2;
                }
                return false;
            }
        }
        return false;
    }

    public Object getCellEditorValue() {
        Object retValue = super.getCellEditorValue();
        return retValue;
    }

    protected void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.listeners.get(i)).editingStopped(ce);
        }
    }

    public void addCellEditorListener(CellEditorListener l) {
        this.listeners.add(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this.listeners.remove(l);
    }

    public void setValueAt(JTree tree) {
        MondrianGuiDef.Relation relationObj = null;
        String retValue = (String)this.getCellEditorValue();
        if (retValue.equals("Join")) {
            relationObj = new MondrianGuiDef.Join("", "", new MondrianGuiDef.Table("", "Table 1", ""), "", "", new MondrianGuiDef.Table("", "Table 2", ""));
        } else if (retValue.equals("Table")) {
            relationObj = new MondrianGuiDef.Table("", "Table", "");
        }
        TreePath tpath = tree.getSelectionPath();
        if (tpath != null) {
            Object value = tpath.getLastPathComponent();
            TreePath parentpath = tpath.getParentPath();
            if (parentpath != null) {
                Object parent = parentpath.getLastPathComponent();
                if (parent instanceof MondrianGuiDef.Hierarchy) {
                    ((MondrianGuiDef.Hierarchy)((Object)parent)).relation = relationObj;
                } else if (parent instanceof MondrianGuiDef.Closure) {
                    ((MondrianGuiDef.Closure)((Object)parent)).table = relationObj;
                } else if (parent instanceof MondrianGuiDef.Join) {
                    int indexOfChild = tree.getModel().getIndexOfChild(parent, value);
                    switch (indexOfChild) {
                        case 0: {
                            ((MondrianGuiDef.Join)((Object)parent)).left = relationObj;
                            break;
                        }
                        case 1: {
                            ((MondrianGuiDef.Join)((Object)parent)).right = relationObj;
                        }
                    }
                }
                tree.setSelectionPath(parentpath.pathByAddingChild((Object)relationObj));
            }
        }
    }

    public boolean stopCellEditing() {
        this.setValueAt(this.tree);
        boolean retValue = super.stopCellEditing();
        return retValue;
    }
}

