/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.util.JRFontUtil;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRTextAttribute;

public class JRStyledText {
    private static final String PROPERTY_AWT_SUPERSCRIPT_FIX_ENABLED = "net.sf.jasperreports.awt.superscript.fix.enabled";
    private static final boolean AWT_SUPERSCRIPT_FIX_ENABLED = System.getProperty("java.version").startsWith("1.6") && JRProperties.getBooleanProperty("net.sf.jasperreports.awt.superscript.fix.enabled");
    private static final Set FONT_ATTRS = new HashSet();
    private StringBuffer sbuffer = new StringBuffer();
    private List runs = new ArrayList();
    private AttributedString attributedString = null;
    private AttributedString awtAttributedString = null;
    private Map globalAttributes;
    private Locale locale;

    public void append(String text) {
        this.sbuffer.append(text);
        this.attributedString = null;
        this.awtAttributedString = null;
    }

    public void addRun(Run run) {
        this.runs.add(run);
        this.attributedString = null;
        this.awtAttributedString = null;
    }

    public int length() {
        return this.sbuffer.length();
    }

    public String getText() {
        return this.sbuffer.toString();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public AttributedString getAttributedString() {
        if (this.attributedString == null) {
            this.attributedString = new AttributedString(this.sbuffer.toString());
            for (int i = this.runs.size() - 1; i >= 0; --i) {
                Run run = (Run)this.runs.get(i);
                if (run.startIndex == run.endIndex || run.attributes == null) continue;
                this.attributedString.addAttributes(run.attributes, run.startIndex, run.endIndex);
            }
        }
        return this.attributedString;
    }

    public AttributedString getAwtAttributedString() {
        if (this.awtAttributedString == null) {
            this.awtAttributedString = new AttributedString(this.sbuffer.toString());
            for (int i = this.runs.size() - 1; i >= 0; --i) {
                Run run = (Run)this.runs.get(i);
                if (run.startIndex == run.endIndex || run.attributes == null || run.attributes.isEmpty()) continue;
                Iterator it = run.attributes.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    AttributedCharacterIterator.Attribute attribute = (AttributedCharacterIterator.Attribute)entry.getKey();
                    if (attribute instanceof JRTextAttribute) continue;
                    Object value = entry.getValue();
                    this.awtAttributedString.addAttribute(attribute, value, run.startIndex, run.endIndex);
                }
            }
            AttributedCharacterIterator iterator = this.awtAttributedString.getIterator();
            int runLimit = 0;
            AffineTransform atrans = null;
            while (runLimit < iterator.getEndIndex() && (runLimit = iterator.getRunLimit(FONT_ATTRS)) <= iterator.getEndIndex()) {
                Map<AttributedCharacterIterator.Attribute, Object> attrs = iterator.getAttributes();
                Font awtFont = JRFontUtil.getAwtFontFromBundles((String)attrs.get(TextAttribute.FAMILY), (TextAttribute.WEIGHT_BOLD.equals(attrs.get(TextAttribute.WEIGHT)) ? 1 : 0) | (TextAttribute.POSTURE_OBLIQUE.equals(attrs.get(TextAttribute.POSTURE)) ? 2 : 0), ((Float)attrs.get(TextAttribute.SIZE)).intValue(), this.locale);
                if (awtFont != null) {
                    Integer superscript;
                    if (AWT_SUPERSCRIPT_FIX_ENABLED && atrans != null) {
                        double y = atrans.getTranslateY();
                        atrans = new AffineTransform();
                        atrans.translate(0.0, -y);
                        awtFont = awtFont.deriveFont(atrans);
                        atrans = null;
                    }
                    if (TextAttribute.SUPERSCRIPT_SUPER.equals(superscript = (Integer)attrs.get(TextAttribute.SUPERSCRIPT))) {
                        atrans = new AffineTransform();
                        atrans.scale(0.6666666666666666, 0.6666666666666666);
                        atrans.translate(0.0, (float)(-awtFont.getSize()) / 2.0f);
                        awtFont = awtFont.deriveFont(atrans);
                    } else if (TextAttribute.SUPERSCRIPT_SUB.equals(superscript)) {
                        atrans = new AffineTransform();
                        atrans.scale(0.6666666666666666, 0.6666666666666666);
                        atrans.translate(0.0, (float)awtFont.getSize() / 2.0f);
                        awtFont = awtFont.deriveFont(atrans);
                    }
                    this.awtAttributedString.addAttribute(TextAttribute.FONT, awtFont, iterator.getIndex(), runLimit);
                }
                iterator.setIndex(runLimit);
            }
        }
        return this.awtAttributedString;
    }

    public List getRuns() {
        return this.runs;
    }

    public void setGlobalAttributes(Map attributes) {
        this.globalAttributes = attributes;
        this.addRun(new Run(attributes, 0, this.length()));
    }

    public Map getGlobalAttributes() {
        return this.globalAttributes;
    }

    static {
        FONT_ATTRS.add(TextAttribute.FAMILY);
        FONT_ATTRS.add(TextAttribute.WEIGHT);
        FONT_ATTRS.add(TextAttribute.POSTURE);
        FONT_ATTRS.add(TextAttribute.SIZE);
        FONT_ATTRS.add(TextAttribute.SUPERSCRIPT);
    }

    public static class Run {
        public Map attributes = null;
        public int startIndex = 0;
        public int endIndex = 0;

        public Run(Map attributes, int startIndex, int endIndex) {
            this.attributes = attributes;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
        }
    }
}

