/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.actions;

import com.jaspersoft.ireport.JrxmlDataObject;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import java.io.File;
import javax.swing.JOptionPane;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class ReplaceFileAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(ReplaceFileAction.class, (String)"CTL_ReplaceFileAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        if (!(activatedNodes[0] instanceof ResourceNode)) {
            return;
        }
        ResourceNode node = (ResourceNode)activatedNodes[0];
        if (((ResourceNode)activatedNodes[0]).getRepositoryObject() instanceof RepositoryFile) {
            JrxmlDataObject dobject;
            JrxmlVisualView view;
            final RepositoryFile rf = (RepositoryFile)((ResourceNode)activatedNodes[0]).getRepositoryObject();
            String reportUnitUri = null;
            if (activatedNodes[0].getParentNode() instanceof ResourceNode && ((ResourceNode)activatedNodes[0].getParentNode()).getResourceDescriptor().getWsType().equals("reportUnit")) {
                reportUnitUri = ((ResourceNode)activatedNodes[0].getParentNode()).getResourceDescriptor().getUriString();
            }
            if ((view = IReportManager.getInstance().getActiveVisualView()) != null && view.getLookup() != null && (dobject = (JrxmlDataObject)view.getLookup().lookup(JrxmlDataObject.class)) != null) {
                final String fileName = FileUtil.toFile((FileObject)dobject.getPrimaryFile()).getPath();
                final String ruUri = reportUnitUri;
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            rf.getServer().getWSClient().modifyReportUnitResource(ruUri, rf.getDescriptor(), new File(fileName));
                            Mutex.EVENT.readAccess(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getString("repositoryExplorer.message.fileUpdated", "File succesfully updated."), JasperServerManager.getString("repositoryExplorer.message.operationResult", "Operation result"), 1);
                                }
                            });
                        }
                        catch (Exception ex) {
                            final String msg = ex.getMessage();
                            Mutex.EVENT.readAccess(new Runnable(){

                                public void run() {
                                    JOptionPane.showMessageDialog(Misc.getMainFrame(), JasperServerManager.getFormattedString("messages.error.3", "Error:\n {0}", new Object[]{msg}), "Operation result", 0);
                                }
                            });
                            ex.printStackTrace();
                        }
                    }
                });
                t.start();
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        JrxmlDataObject dobject;
        JrxmlVisualView view;
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        return activatedNodes[0] instanceof ResourceNode && ((ResourceNode)activatedNodes[0]).getResourceDescriptor().getWsType().equals("jrxml") && (view = IReportManager.getInstance().getActiveVisualView()) != null && view.getLookup() != null && (dobject = (JrxmlDataObject)view.getLookup().lookup(JrxmlDataObject.class)) != null;
    }
}

