/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties.charts;

import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.properties.ByteProperty;
import com.jaspersoft.ireport.locale.I18n;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.base.JRBaseChartPlot;
import org.jfree.chart.plot.PlotOrientation;

public final class OrientationProperty
extends ByteProperty {
    public static final Byte ORIENTATION_HORIZONTAL = new Byte(0);
    public static final Byte ORIENTATION_VERTICAL = new Byte(1);
    private final JRBaseChartPlot plot;

    public OrientationProperty(JRBaseChartPlot plot) {
        super(plot);
        this.plot = plot;
    }

    public String getName() {
        return "orientation";
    }

    public String getDisplayName() {
        return I18n.getString("Chart_orientation");
    }

    public String getShortDescription() {
        return I18n.getString("Chart_orientation.desc");
    }

    public List getTagList() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        tags.add(new Tag(ORIENTATION_VERTICAL, I18n.getString("Chart_orientation.Vertical")));
        tags.add(new Tag(ORIENTATION_HORIZONTAL, I18n.getString("Chart_orientation.Horizontal")));
        return tags;
    }

    public Byte getByte() {
        if (this.plot.getOrientation() == null) {
            return ORIENTATION_VERTICAL;
        }
        if (this.plot.getOrientation().equals((Object)PlotOrientation.HORIZONTAL)) {
            return ORIENTATION_HORIZONTAL;
        }
        return ORIENTATION_VERTICAL;
    }

    public Byte getOwnByte() {
        return this.getByte();
    }

    public Byte getDefaultByte() {
        return ORIENTATION_VERTICAL;
    }

    public void setByte(Byte position) {
        if (position.equals(ORIENTATION_VERTICAL)) {
            this.plot.setOrientation(PlotOrientation.VERTICAL);
        } else {
            this.plot.setOrientation(PlotOrientation.HORIZONTAL);
        }
    }
}

