/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.actions.AlignWithSupport;
import com.jaspersoft.ireport.designer.undo.AggregatedUndoableEdit;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.AlignWithMoveDecorator;
import org.netbeans.api.visual.action.AlignWithWidgetCollector;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportAlignWithMoveStrategyProvider
extends AlignWithSupport
implements MoveStrategy,
MoveProvider {
    private boolean outerBounds;
    private boolean moveEnabled = false;
    private boolean snapToGrid = false;
    private int gridSize = 13;
    List<ObjectPropertyUndoableEdit> undoEdits = null;

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public boolean isOuterBounds() {
        return this.outerBounds;
    }

    public void setOuterBounds(boolean outerBounds) {
        this.outerBounds = outerBounds;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    public ReportAlignWithMoveStrategyProvider(AlignWithWidgetCollector collector, LayerWidget interractionLayer, AlignWithMoveDecorator decorator, boolean outerBounds) {
        super(collector, interractionLayer, decorator);
        this.outerBounds = outerBounds;
    }

    public Point locationSuggested(Widget widget, Point originalLocation, Point suggestedLocation) {
        if (!this.moveEnabled) {
            if (Math.abs(suggestedLocation.x - originalLocation.x) > 5 || Math.abs(suggestedLocation.y - originalLocation.y) > 5) {
                this.moveEnabled = true;
            } else {
                return originalLocation;
            }
        }
        if (IReportManager.getPreferences().getBoolean("noMagnetic", false)) {
            return suggestedLocation;
        }
        Point widgetLocation = widget.getLocation();
        Rectangle widgetBounds = this.outerBounds ? widget.getBounds() : widget.getClientArea();
        Rectangle bounds = widget.convertLocalToScene(widgetBounds);
        bounds.translate(suggestedLocation.x - widgetLocation.x, suggestedLocation.y - widgetLocation.y);
        Insets insets = widget.getBorder().getInsets();
        if (!this.outerBounds) {
            suggestedLocation.x += insets.left;
            suggestedLocation.y += insets.top;
        }
        Point point = new Point(suggestedLocation);
        if (this.isSnapToGrid()) {
            point = this.snapToGrid(point, this.getGridSize());
            point.x += insets.left;
            point.y += insets.top;
        } else {
            point = super.locationSuggested(widget, bounds, point, true, true, true, true);
        }
        if (!this.outerBounds) {
            point.x -= insets.left;
            point.y -= insets.top;
        }
        return widget.getParentWidget().convertSceneToLocal(point);
    }

    public void movementStarted(Widget widget) {
        this.moveEnabled = false;
        this.undoEdits = new ArrayList<ObjectPropertyUndoableEdit>();
        List selectedElements = ((AbstractReportObjectScene)widget.getScene()).getSelectionLayer().getChildren();
        for (Widget w : selectedElements) {
            if (!w.isVisible()) continue;
            JRDesignElementWidget dew = ((SelectionWidget)w).getRealWidget();
            this.undoEdits.add(new ObjectPropertyUndoableEdit(dew.getElement(), "X", Integer.TYPE, new Integer(dew.getElement().getX()), new Integer(dew.getElement().getX())));
            this.undoEdits.add(new ObjectPropertyUndoableEdit(dew.getElement(), "Y", Integer.TYPE, new Integer(dew.getElement().getY()), new Integer(dew.getElement().getY())));
        }
        this.show();
    }

    public void movementFinished(Widget widget) {
        for (int i = 0; i < this.undoEdits.size(); ++i) {
            ObjectPropertyUndoableEdit edit = this.undoEdits.get(i);
            if (edit.getNewValue() == null && edit.getOldValue() == null) {
                this.undoEdits.remove(edit);
                --i;
                continue;
            }
            if (edit.getNewValue() == null || edit.getOldValue() == null || !edit.getNewValue().equals(edit.getOldValue())) continue;
            this.undoEdits.remove(edit);
            --i;
        }
        if (this.undoEdits.size() > 0) {
            AggregatedUndoableEdit masterEdit = new AggregatedUndoableEdit("Move");
            for (int i = 0; i < this.undoEdits.size(); ++i) {
                ObjectPropertyUndoableEdit edit = this.undoEdits.get(i);
                masterEdit.concatenate(edit);
            }
            System.out.flush();
            IReportManager.getInstance().addUndoableEdit(masterEdit);
        }
        this.hide();
    }

    public Point getOriginalLocation(Widget widget) {
        return ActionFactory.createDefaultMoveProvider().getOriginalLocation(widget);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNewLocation(Widget widget, Point location) {
        Point p = widget.getPreferredLocation();
        Point delta = new Point(location);
        delta.translate(-p.x, -p.y);
        if (delta.x == 0 && delta.y == 0) {
            return;
        }
        List selectedElements = ((AbstractReportObjectScene)widget.getScene()).getSelectionLayer().getChildren();
        ArrayList<Widget> changedWidgets = new ArrayList<Widget>();
        for (Widget w : selectedElements) {
            JRDesignElementWidget dew;
            if (!w.isVisible() || changedWidgets.contains(dew = ((SelectionWidget)w).getRealWidget())) continue;
            Point loc = w.getPreferredLocation();
            loc.translate(delta.x, delta.y);
            w.setPreferredLocation(loc);
            Point dewloc = dew.getPreferredLocation();
            dewloc.translate(delta.x, delta.y);
            dewloc = dew.convertLocalToModelLocation(dewloc);
            boolean b = dew.setChanging(true);
            try {
                dew.getElement().setX(dewloc.x);
                dew.getElement().setY(dewloc.y);
                this.findEdit(dew.getElement(), "X").setNewValue(dewloc.x);
                this.findEdit(dew.getElement(), "Y").setNewValue(dewloc.y);
            }
            finally {
                dew.setChanging(b);
            }
            dew.updateBounds();
            if (dew.getElement() instanceof JRDesignFrame) {
                this.updateChildren((JRDesignFrame)dew.getElement(), (AbstractReportObjectScene)dew.getScene(), changedWidgets);
            }
            changedWidgets.add(dew);
        }
    }

    private ObjectPropertyUndoableEdit findEdit(Object obj, String property) {
        for (ObjectPropertyUndoableEdit edit : this.undoEdits) {
            if (edit.getObject() != obj || !edit.getProperty().equals(property)) continue;
            return edit;
        }
        return null;
    }

    private void updateChildren(JRDesignFrame parent, AbstractReportObjectScene scene, ArrayList<Widget> changedWidgets) {
        JRElement[] elements = parent.getElements();
        for (int i = 0; i < elements.length; ++i) {
            JRDesignElementWidget w = (JRDesignElementWidget)scene.findWidget(elements[i]);
            if (changedWidgets.contains(w)) continue;
            w.updateBounds();
            w.getSelectionWidget().updateBounds();
            if (elements[i] instanceof JRDesignFrame) {
                this.updateChildren((JRDesignFrame)elements[i], scene, changedWidgets);
            }
            changedWidgets.add(w);
        }
    }
}

