/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenHierarchyUpdate;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.inc.TokenChangeInfo;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.EmbeddingPresence;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EmbeddingContainer<T extends TokenId> {
    private AbstractToken<T> token;
    private int cachedModCount;
    private final TokenList<?> rootTokenList;
    private AbstractToken<?> rootToken;
    private int tokenStartOffset;
    private EmbeddedTokenList<?> firstEmbeddedTokenList;
    private int offsetShiftFromRootToken;
    private EmbeddedTokenList<?> defaultEmbeddedTokenList;
    private static boolean checkStatusUpdatedThrowingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> EmbeddedTokenList<ET> embeddedTokenList(TokenList<T> tokenList, int n, Language<ET> language) {
        EmbeddingPresence embeddingPresence;
        AbstractToken<T> abstractToken;
        EmbeddingContainer<T> embeddingContainer;
        Object object;
        Object object2 = tokenList.tokenOrEmbeddingContainer(n);
        if (object2.getClass() == EmbeddingContainer.class) {
            object = (EmbeddingContainer<T>)object2;
            embeddingContainer = object;
            abstractToken = embeddingContainer.token();
            embeddingPresence = null;
        } else {
            embeddingContainer = null;
            object = (AbstractToken)object2;
            abstractToken = object;
            embeddingPresence = LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).embeddingPresence(abstractToken.id());
            if (embeddingPresence == EmbeddingPresence.NONE) {
                return null;
            }
        }
        Object object3 = object = tokenList.root();
        synchronized (object3) {
            EmbeddedTokenList<?> embeddedTokenList;
            EmbeddedTokenList<?> embeddedTokenList2;
            if (embeddingContainer != null) {
                embeddingContainer.updateStatusImpl();
                embeddedTokenList2 = null;
                for (embeddedTokenList = embeddingContainer.firstEmbeddedTokenList(); embeddedTokenList != null; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
                    if (language == null || embeddedTokenList.languagePath().innerLanguage() == language) {
                        EmbeddedTokenList<?> embeddedTokenList3 = embeddedTokenList;
                        return embeddedTokenList3;
                    }
                    embeddedTokenList2 = embeddedTokenList;
                }
                if (embeddingContainer.defaultEmbeddedTokenList() != null) {
                    return null;
                }
            } else {
                embeddedTokenList2 = null;
            }
            embeddedTokenList = tokenList.languagePath();
            LanguageHierarchy languageHierarchy = LexerUtilsConstants.innerLanguageHierarchy((LanguagePath)((Object)embeddedTokenList));
            LanguageEmbedding<?> languageEmbedding = LexerUtilsConstants.findEmbedding(languageHierarchy, abstractToken, (LanguagePath)((Object)embeddedTokenList), tokenList.inputAttributes());
            if (embeddingPresence == null) {
                embeddingPresence = LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).embeddingPresence(abstractToken.id());
            }
            if (languageEmbedding != null) {
                CharSequence charSequence;
                if (embeddingPresence == EmbeddingPresence.CACHED_FIRST_QUERY) {
                    LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).setEmbeddingPresence(abstractToken.id(), EmbeddingPresence.ALWAYS_QUERY);
                }
                if ((charSequence = abstractToken.text()) == null || languageEmbedding.startSkipLength() + languageEmbedding.endSkipLength() > charSequence.length()) {
                    return null;
                }
                if (embeddingContainer == null) {
                    embeddingContainer = new EmbeddingContainer<T>(abstractToken, (TokenList<?>)object);
                    tokenList.wrapToken(n, embeddingContainer);
                }
                LanguagePath languagePath = LanguagePath.get(embeddedTokenList, languageEmbedding.language());
                EmbeddedTokenList embeddedTokenList4 = new EmbeddedTokenList(embeddingContainer, languagePath, languageEmbedding, null);
                embeddingContainer.addEmbeddedTokenList(embeddedTokenList2, embeddedTokenList4, true);
                return language == null || language == languageEmbedding.language() ? embeddedTokenList4 : null;
            }
            if (embeddingPresence == EmbeddingPresence.CACHED_FIRST_QUERY) {
                LexerUtilsConstants.innerLanguageOperation(tokenList.languagePath()).setEmbeddingPresence(abstractToken.id(), EmbeddingPresence.NONE);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean createEmbedding(TokenList<T> tokenList, int n, Language<ET> language, int n2, int n3, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        TokenList<?> tokenList2;
        Object object4;
        Object object5;
        TokenHierarchyOperation<?, ?> tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
        if (tokenHierarchyOperation == null) {
            return false;
        }
        tokenHierarchyOperation.ensureWriteLocked();
        TokenList<?> tokenList3 = tokenList.root();
        Object object6 = tokenList.tokenOrEmbeddingContainer(n);
        TokenList<?> tokenList4 = tokenList3;
        synchronized (tokenList4) {
            if (object6.getClass() == EmbeddingContainer.class) {
                object4 = object5 = (EmbeddingContainer)object6;
                for (tokenList2 = ((EmbeddingContainer)object4).firstEmbeddedTokenList(); tokenList2 != null; tokenList2 = tokenList2.nextEmbeddedTokenList()) {
                    if (language != tokenList2.languagePath().innerLanguage()) continue;
                    return false;
                }
                object3 = ((EmbeddingContainer)object4).token();
            } else {
                object5 = (AbstractToken)object6;
                object3 = object5;
                if (((AbstractToken)object3).isFlyweight()) {
                    return false;
                }
                object4 = new EmbeddingContainer<T>(object3, tokenList3);
                tokenList.wrapToken(n, (EmbeddingContainer<T>)object4);
            }
        }
        tokenList2 = tokenList3;
        synchronized (tokenList2) {
            if (n2 + n3 > ((AbstractToken)object3).length()) {
                return false;
            }
            object5 = LanguageEmbedding.create(language, n2, n3, bl);
            object2 = tokenList.languagePath();
            object = LanguagePath.get((LanguagePath)object2, language);
            tokenHierarchyOperation.addLanguagePath((LanguagePath)object);
            tokenList4 = new EmbeddedTokenList((EmbeddingContainer<?>)object4, (LanguagePath)object, (LanguageEmbedding<?>)object5, ((EmbeddingContainer)object4).firstEmbeddedTokenList());
            ((EmbeddingContainer)object4).addEmbeddedTokenList(null, (EmbeddedTokenList<?>)tokenList4, false);
        }
        int n4 = ((EmbeddingContainer)object4).tokenStartOffset();
        object2 = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING_CREATED, n4, 0, "", 0);
        ((TokenHierarchyEventInfo)object2).setMaxAffectedEndOffset(n4 + ((AbstractToken)object3).length());
        object = new TokenChangeInfo<T>(tokenList);
        ((TokenChangeInfo)object).setIndex(n);
        ((TokenChangeInfo)object).setOffset(n4);
        ((TokenHierarchyEventInfo)object2).setTokenChangeInfo((TokenChangeInfo<?>)object);
        TokenChangeInfo tokenChangeInfo = new TokenChangeInfo(tokenList4);
        tokenChangeInfo.setIndex(0);
        tokenChangeInfo.setOffset(n4 + ((LanguageEmbedding)object5).startSkipLength());
        ((TokenChangeInfo)object).addEmbeddedChange(tokenChangeInfo);
        TokenListList tokenListList = tokenHierarchyOperation.existingTokenListList(((EmbeddedTokenList)tokenList4).languagePath());
        if (tokenListList != null) {
            new TokenHierarchyUpdate((TokenHierarchyEventInfo)object2).updateCreateEmbedding((EmbeddedTokenList<?>)tokenList4);
        } else if (((LanguageEmbedding)object5).joinSections()) {
            tokenListList = tokenHierarchyOperation.tokenListList(((EmbeddedTokenList)tokenList4).languagePath());
        }
        tokenHierarchyOperation.fireTokenHierarchyChanged((TokenHierarchyEventInfo)object2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends TokenId, ET extends TokenId> boolean removeEmbedding(TokenList<T> tokenList, int n, Language<ET> language) {
        TokenHierarchyOperation<?, ?> tokenHierarchyOperation = tokenList.tokenHierarchyOperation();
        if (tokenHierarchyOperation == null) {
            return false;
        }
        tokenHierarchyOperation.ensureWriteLocked();
        TokenList<?> tokenList2 = tokenList.root();
        Object object = tokenList.tokenOrEmbeddingContainer(n);
        TokenList<?> tokenList3 = tokenList2;
        synchronized (tokenList3) {
            if (object.getClass() == EmbeddingContainer.class) {
                EmbeddingContainer<T> embeddingContainer;
                EmbeddingContainer<T> embeddingContainer2 = embeddingContainer = (EmbeddingContainer<T>)object;
                embeddingContainer2.updateStatusImpl();
                EmbeddedTokenList<?> embeddedTokenList = null;
                for (EmbeddedTokenList<T> embeddedTokenList2 = embeddingContainer2.firstEmbeddedTokenList(); embeddedTokenList2 != null; embeddedTokenList2 = embeddedTokenList2.nextEmbeddedTokenList()) {
                    if (language != embeddedTokenList2.languagePath().innerLanguage()) continue;
                    embeddingContainer2.removeEmbeddedTokenList(embeddedTokenList, embeddedTokenList2);
                    embeddingContainer2 = new EmbeddingContainer<T>(embeddingContainer2);
                    embeddingContainer2.addEmbeddedTokenList(null, embeddedTokenList2, false);
                    embeddedTokenList2.setEmbeddingContainer(embeddingContainer2);
                    embeddingContainer2.invalidateChildren();
                    int n2 = embeddingContainer2.tokenStartOffset();
                    TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(tokenHierarchyOperation, TokenHierarchyEventType.EMBEDDING_REMOVED, n2, 0, "", 0);
                    tokenHierarchyEventInfo.setMaxAffectedEndOffset(n2 + embeddingContainer2.token().length());
                    TokenChangeInfo<T> tokenChangeInfo = new TokenChangeInfo<T>(tokenList);
                    tokenChangeInfo.setIndex(n);
                    tokenChangeInfo.setOffset(n2);
                    tokenHierarchyEventInfo.setTokenChangeInfo(tokenChangeInfo);
                    EmbeddedTokenList<T> embeddedTokenList3 = embeddedTokenList2;
                    TokenChangeInfo tokenChangeInfo2 = new TokenChangeInfo(embeddedTokenList3);
                    tokenChangeInfo2.setIndex(0);
                    tokenChangeInfo2.setOffset(n2 + embeddedTokenList2.embedding().startSkipLength());
                    tokenChangeInfo.addEmbeddedChange(tokenChangeInfo2);
                    TokenListList tokenListList = tokenHierarchyOperation.existingTokenListList(embeddedTokenList2.languagePath());
                    if (tokenListList != null) {
                        new TokenHierarchyUpdate(tokenHierarchyEventInfo).updateRemoveEmbedding(embeddedTokenList2);
                    }
                    tokenHierarchyOperation.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
                    return true;
                }
            }
        }
        return false;
    }

    EmbeddingContainer(AbstractToken<T> abstractToken, TokenList<?> tokenList) {
        this.token = abstractToken;
        this.rootTokenList = tokenList;
        this.rootToken = abstractToken;
        this.cachedModCount = -2;
        this.updateStatusImpl();
    }

    EmbeddingContainer(EmbeddingContainer<T> embeddingContainer) {
        this(embeddingContainer.token(), embeddingContainer.rootTokenList());
    }

    private void invalidate() {
        this.rootToken = null;
        this.cachedModCount = -2;
    }

    void invalidateChildren() {
        for (EmbeddedTokenList<?> embeddedTokenList = this.firstEmbeddedTokenList; embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
            for (int i = embeddedTokenList.tokenCountCurrent() - 1; i >= 0; --i) {
                Object object = embeddedTokenList.tokenOrEmbeddingContainerUnsync(i);
                if (object.getClass() != EmbeddingContainer.class) continue;
                ((EmbeddingContainer)object).invalidateChildren();
            }
        }
    }

    public int cachedModCount() {
        return this.cachedModCount;
    }

    public void checkStatusUpdated() {
        if (this.cachedModCount != -2 && this.cachedModCount != this.rootTokenList.modCount() && !checkStatusUpdatedThrowingException) {
            checkStatusUpdatedThrowingException = true;
            String string = "!!!INTERNAL ERROR!!! Status not updated on " + this + "\nin token hierarchy\n" + this.rootTokenList.tokenHierarchyOperation();
            checkStatusUpdatedThrowingException = false;
            throw new IllegalStateException(string);
        }
    }

    public AbstractToken<T> token() {
        return this.token;
    }

    public void reinit(AbstractToken<T> abstractToken) {
        this.token = abstractToken;
        TokenList<T> tokenList = abstractToken.tokenList();
        assert (tokenList != null);
        this.rootToken = tokenList.getClass() == EmbeddedTokenList.class ? ((EmbeddedTokenList)tokenList).rootToken() : abstractToken;
        this.updateStatusImpl();
    }

    public TokenList<?> rootTokenList() {
        return this.rootTokenList;
    }

    public AbstractToken<?> rootToken() {
        return this.rootToken;
    }

    public int tokenStartOffset() {
        return this.tokenStartOffset;
    }

    public int rootTokenOffsetShift() {
        return this.offsetShiftFromRootToken;
    }

    public char charAt(int n) {
        return this.rootToken.charAt(this.offsetShiftFromRootToken + n);
    }

    public EmbeddedTokenList<?> firstEmbeddedTokenList() {
        return this.firstEmbeddedTokenList;
    }

    public void addEmbeddedTokenList(EmbeddedTokenList<?> embeddedTokenList, EmbeddedTokenList<?> embeddedTokenList2, boolean bl) {
        if (embeddedTokenList != null) {
            embeddedTokenList2.setNextEmbeddedTokenList(embeddedTokenList.nextEmbeddedTokenList());
            embeddedTokenList.setNextEmbeddedTokenList(embeddedTokenList2);
        } else {
            embeddedTokenList2.setNextEmbeddedTokenList(this.firstEmbeddedTokenList);
            this.firstEmbeddedTokenList = embeddedTokenList2;
        }
        if (bl) {
            this.defaultEmbeddedTokenList = embeddedTokenList2;
        }
    }

    public EmbeddedTokenList<?> removeEmbeddedTokenList(EmbeddedTokenList<?> embeddedTokenList, EmbeddedTokenList<?> embeddedTokenList2) {
        EmbeddedTokenList<?> embeddedTokenList3 = embeddedTokenList2.nextEmbeddedTokenList();
        if (embeddedTokenList != null) {
            embeddedTokenList.setNextEmbeddedTokenList(embeddedTokenList3);
        } else {
            this.firstEmbeddedTokenList = embeddedTokenList3;
        }
        embeddedTokenList2.setNextEmbeddedTokenList(null);
        if (this.defaultEmbeddedTokenList == embeddedTokenList2) {
            this.defaultEmbeddedTokenList = null;
        }
        return embeddedTokenList3;
    }

    public EmbeddedTokenList<?> defaultEmbeddedTokenList() {
        return this.defaultEmbeddedTokenList;
    }

    public boolean isRemoved() {
        return this.rootToken == null;
    }

    public void updateStatusAndInvalidate() {
        this.updateStatusImpl();
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateStatus() {
        TokenList<?> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            return this.updateStatusImpl() != null;
        }
    }

    public AbstractToken<?> updateStatusImpl() {
        if (this.rootToken == null) {
            return null;
        }
        int n = this.rootTokenList.modCount();
        if (this.cachedModCount != n) {
            this.cachedModCount = n;
            TokenList<T> tokenList = this.token.tokenList();
            if (tokenList == null) {
                this.rootToken = null;
            } else if (tokenList.getClass() == EmbeddedTokenList.class) {
                EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)tokenList;
                this.rootToken = embeddedTokenList.embeddingContainer().updateStatusImpl();
                this.tokenStartOffset = embeddedTokenList.childTokenOffsetNoUpdate(this.token.rawOffset());
                EmbeddingContainer<?> embeddingContainer = embeddedTokenList.embeddingContainer();
                this.offsetShiftFromRootToken = this.tokenStartOffset - embeddingContainer.tokenStartOffset() + embeddingContainer.rootTokenOffsetShift();
            } else {
                this.rootToken = this.token;
                this.tokenStartOffset = this.token.offset(null);
                this.offsetShiftFromRootToken = 0;
            }
        }
        return this.rootToken;
    }
}

